/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.InputStream;
import java.util.HashMap;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.Token;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntList;

public final class Scanner
implements ErrorConstants {
    private static final boolean debug = false;
    private Tok currentToken;
    private boolean isFirstTokenOnLine;
    private boolean save_comments;
    private Context ctx;
    public InputBuffer input;
    private static final HashMap<String, Integer> reservedWord = new HashMap(64);
    public int state;
    private int level;
    private int inXML = 0;
    private IntList states;
    private IntList levels;

    private void init(Context cx, boolean save_comments) {
        this.ctx = cx;
        this.state = 0;
        this.level = 0;
        this.inXML = 0;
        this.states = new IntList();
        this.levels = new IntList();
        this.save_comments = save_comments;
        this.currentToken = new Tok();
    }

    public Scanner(Context cx, InputStream in, String encoding, String origin) {
        this(cx, in, encoding, origin, true);
    }

    public Scanner(Context cx, InputStream in, String encoding, String origin, boolean save_comments) {
        this.init(cx, save_comments);
        cx.input = this.input = new InputBuffer(in, encoding, origin);
    }

    public Scanner(Context cx, String in, String origin) {
        this(cx, in, origin, true);
    }

    public Scanner(Context cx, String in, String origin, boolean save_comments) {
        this.init(cx, save_comments);
        cx.input = this.input = new InputBuffer(in, origin);
    }

    public Scanner(Context cx, InputBuffer input) {
        this.init(cx, true);
        this.input = input;
        cx.input = input;
    }

    private char nextchar() {
        return (char)this.input.nextchar();
    }

    public void retract() {
        this.input.retract();
    }

    private int pos() {
        return this.input.textPos();
    }

    private void mark() {
        this.input.textMark();
    }

    private final int makeToken(int id, String text) {
        this.currentToken.id = id;
        this.currentToken.text = text;
        return id;
    }

    private final int makeToken(int id) {
        this.currentToken.id = id;
        this.currentToken.text = null;
        return id;
    }

    public String getCurrentTokenText() {
        if (this.currentToken.text == null) {
            this.error("Scanner internal: current token not a pseudo-terminal");
        }
        return this.currentToken.text;
    }

    public String getCurrentTokenTextOrTypeText(int id) {
        if (this.currentToken.text != null) {
            return this.currentToken.text;
        }
        return Token.getTokenClassName(id);
    }

    public String getCurrentStringTokenText(boolean[] is_single_quoted) {
        String fulltext;
        if (this.currentToken.id != -120 || this.currentToken.text == null) {
            this.error("internal: string token expected.");
        }
        is_single_quoted[0] = (fulltext = this.currentToken.text).charAt(0) == '\'';
        String enclosedText = fulltext.substring(1, fulltext.length() - 1);
        return enclosedText;
    }

    private void error(int kind, String arg) {
        StringBuilder out = new StringBuilder();
        String origin = this.input.origin;
        int errPos = this.input.positionOfMark();
        int ln = this.input.getLnNum(errPos);
        int col = this.input.getColPos(errPos);
        String msg = (ContextStatics.useVerboseErrors ? "[Compiler] Error #" + kind + ": " : "") + this.ctx.errorString(kind);
        int nextLoc = Context.replaceStringArg(out, msg, 0, arg);
        if (nextLoc != -1) {
            out.append(msg.substring(nextLoc, msg.length()));
        }
        this.ctx.localizedError(origin, ln, col, out.toString(), this.input.getLineText(errPos), kind);
        this.skiperror(kind);
    }

    private void error(String msg) {
        this.ctx.internalError(msg);
        this.error(1093, msg);
    }

    private void error(int kind) {
        this.error(kind, "");
    }

    private void skiperror() {
        this.skiperror(1093);
    }

    private void skiperror(int kind) {
        char nc;
        switch (kind) {
            case 1093: {
                return;
            }
            case 1094: 
            case 1095: {
                char nc2;
                while ((nc2 = this.nextchar()) != '\'' && nc2 != '\u0000') {
                }
                return;
            }
        }
        while ((nc = this.nextchar()) != ';' && nc != '\n' && nc != '\r' && nc != '\u0000') {
        }
    }

    public boolean followsLineTerminator() {
        return this.isFirstTokenOnLine;
    }

    public void pushState() {
        this.states.add(this.state);
        this.levels.add(this.level);
        this.state = 0;
        this.level = 0;
        ++this.inXML;
    }

    public void popState() {
        this.state = this.states.removeLast();
        this.level = this.levels.removeLast();
        if (this.inXML > 0) {
            --this.inXML;
        }
    }

    private StringBuilder getDocTextBuffer(String doctagname) {
        StringBuilder doctextbuf = new StringBuilder();
        doctextbuf.append("<").append(doctagname).append("><![CDATA[");
        return doctextbuf;
    }

    public void clearUnusedBuffers() {
        this.input.clearUnusedBuffers();
        this.input = null;
    }

    /*
     * Unable to fully structure code
     */
    public int nexttoken(boolean resetState) {
        doctagname = "description";
        doctextbuf = null;
        startofxml = this.pos();
        blockcommentbuf = null;
        regexp_flags = 0;
        maybe_reserved = false;
        c = '\u0000';
        if (resetState) {
            this.isFirstTokenOnLine = false;
        }
        block217: while (true) {
            switch (this.state) {
                case 0: {
                    c = this.nextchar();
                    this.mark();
                    switch (c) {
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            maybe_reserved = true;
                        }
                        case '$': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': {
                            this.state = 4;
                            continue block217;
                        }
                        case '\uffef': {
                            if (this.nextchar() == '\uffffffbb' && this.nextchar() == '\uffffffbf') {
                                this.state = 0;
                                continue block217;
                            }
                            this.state = -1;
                            continue block217;
                        }
                        case '@': {
                            return this.makeToken(-28);
                        }
                        case '\"': 
                        case '\'': {
                            startquote = c;
                            needs_escape = false;
                            while ((c = this.nextchar()) != startquote) {
                                if (c == '\\') {
                                    needs_escape = true;
                                    c = this.nextchar();
                                    if (c == '\r') {
                                        c = this.nextchar();
                                    }
                                    if (c != '\n') continue;
                                    continue;
                                }
                                if (c == '\r' || c == '\n') {
                                    if (startquote == '\'') {
                                        this.error(1094);
                                        break;
                                    }
                                    this.error(1095);
                                    break;
                                }
                                if (c != '\u0000') continue;
                                this.error(1097);
                                return this.makeToken(-1);
                            }
                            return this.makeToken(-120, this.input.copyReplaceStringEscapes(needs_escape));
                        }
                        case '-': {
                            switch (this.nextchar()) {
                                case '-': {
                                    return this.makeToken(-3);
                                }
                                case '=': {
                                    return this.makeToken(-50);
                                }
                            }
                            this.retract();
                            return this.makeToken(-2);
                        }
                        case '!': {
                            if (this.nextchar() == '=') {
                                if (this.nextchar() == '=') {
                                    return this.makeToken(-6);
                                }
                                this.retract();
                                return this.makeToken(-5);
                            }
                            this.retract();
                            return this.makeToken(-4);
                        }
                        case '%': {
                            switch (this.nextchar()) {
                                case '=': {
                                    return this.makeToken(-8);
                                }
                            }
                            this.retract();
                            return this.makeToken(-7);
                        }
                        case '&': {
                            c = this.nextchar();
                            if (c == '=') {
                                return this.makeToken(-12);
                            }
                            if (c == '&') {
                                if (this.nextchar() == '=') {
                                    return this.makeToken(-11);
                                }
                                this.retract();
                                return this.makeToken(-10);
                            }
                            this.retract();
                            return this.makeToken(-9);
                        }
                        case '#': {
                            if (Features.HAS_HASHPRAGMAS) {
                                return this.makeToken(-111);
                            }
                            this.state = -1;
                            continue block217;
                        }
                        case '(': {
                            return this.makeToken(-13);
                        }
                        case ')': {
                            return this.makeToken(-14);
                        }
                        case '*': {
                            if (this.nextchar() == '=') {
                                return this.makeToken(-16);
                            }
                            this.retract();
                            return this.makeToken(-15);
                        }
                        case ',': {
                            return this.makeToken(-17);
                        }
                        case '.': {
                            this.state = 1;
                            continue block217;
                        }
                        case '/': {
                            this.state = 3;
                            continue block217;
                        }
                        case ':': {
                            if (this.nextchar() == ':') {
                                return this.makeToken(-25);
                            }
                            this.retract();
                            return this.makeToken(-24);
                        }
                        case ';': {
                            return this.makeToken(-26);
                        }
                        case '?': {
                            return this.makeToken(-27);
                        }
                        case '[': {
                            return this.makeToken(-29);
                        }
                        case ']': {
                            return this.makeToken(-30);
                        }
                        case '^': {
                            if (this.nextchar() == '=') {
                                return this.makeToken(-34);
                            }
                            this.retract();
                            return this.makeToken(-31);
                        }
                        case '{': {
                            return this.makeToken(-35);
                        }
                        case '|': {
                            c = this.nextchar();
                            if (c == '=') {
                                return this.makeToken(-39);
                            }
                            if (c == '|') {
                                if (this.nextchar() == '=') {
                                    return this.makeToken(-38);
                                }
                                this.retract();
                                return this.makeToken(-37);
                            }
                            this.retract();
                            return this.makeToken(-36);
                        }
                        case '}': {
                            return this.makeToken(-40);
                        }
                        case '~': {
                            return this.makeToken(-41);
                        }
                        case '+': {
                            c = this.nextchar();
                            if (c == '+') {
                                return this.makeToken(-43);
                            }
                            if (c == '=') {
                                return this.makeToken(-44);
                            }
                            this.retract();
                            return this.makeToken(-42);
                        }
                        case '<': {
                            switch (this.nextchar()) {
                                case '<': {
                                    if (this.nextchar() == '=') {
                                        return this.makeToken(-47);
                                    }
                                    this.retract();
                                    return this.makeToken(-46);
                                }
                                case '=': {
                                    return this.makeToken(-48);
                                }
                                case '/': {
                                    return this.makeToken(-127);
                                }
                                case '!': {
                                    this.state = 25;
                                    continue block217;
                                }
                                case '?': {
                                    this.state = 28;
                                    continue block217;
                                }
                            }
                            this.retract();
                            return this.makeToken(-45);
                        }
                        case '=': {
                            if (this.nextchar() == '=') {
                                if (this.nextchar() == '=') {
                                    return this.makeToken(-52);
                                }
                                this.retract();
                                return this.makeToken(-51);
                            }
                            this.retract();
                            return this.makeToken(-49);
                        }
                        case '>': {
                            this.state = 0;
                            switch (this.nextchar()) {
                                case '>': {
                                    switch (this.nextchar()) {
                                        case '>': {
                                            if (this.nextchar() == '=') {
                                                return this.makeToken(-58);
                                            }
                                            this.retract();
                                            return this.makeToken(-57);
                                        }
                                        case '=': {
                                            return this.makeToken(-56);
                                        }
                                    }
                                    this.retract();
                                    return this.makeToken(-55);
                                }
                                case '=': {
                                    return this.makeToken(-54);
                                }
                            }
                            this.retract();
                            return this.makeToken(-53);
                        }
                        case '0': {
                            this.state = 5;
                            continue block217;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block217;
                        }
                        case '\t': 
                        case '\u000b': 
                        case '\f': 
                        case ' ': 
                        case '\u0085': 
                        case '\u00a0': {
                            continue block217;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            continue block217;
                        }
                        case '\u0000': {
                            return this.makeToken(-1);
                        }
                    }
                    switch (this.input.nextcharClass(c, true)) {
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\b': 
                        case '\u0012': 
                        case '\u0013': {
                            maybe_reserved = false;
                            this.state = 4;
                            continue block217;
                        }
                        case '\n': 
                        case '\r': 
                        case '\u000e': {
                            continue block217;
                        }
                        case '\u000b': 
                        case '\f': {
                            this.isFirstTokenOnLine = true;
                            continue block217;
                        }
                    }
                    this.state = -1;
                    continue block217;
                }
                case 4: {
                    v0 = needs_escape = c == '\\';
                    block219: while (true) {
                        if ((c = this.nextchar()) >= 'a' && c <= 'z') {
                            continue;
                        }
                        if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$' || c == '_') {
                            maybe_reserved = false;
                            continue;
                        }
                        if (c > '\u007f') ** GOTO lbl231
                        if (c == '\\') ** GOTO lbl230
                        this.retract();
                        ** GOTO lbl238
lbl230:
                        // 1 sources

                        needs_escape = true;
lbl231:
                        // 2 sources

                        switch (this.input.nextcharClass(c, false)) {
                            case '\u0001': 
                            case '\u0002': 
                            case '\u0003': 
                            case '\u0004': 
                            case '\u0005': 
                            case '\u0007': 
                            case '\b': 
                            case '\u0012': 
                            case '\u0013': 
                            case '\u0014': {
                                maybe_reserved = false;
                                this.input.nextcharClass(c, true);
                                continue block219;
                            }
                        }
                        break;
                    }
                    this.retract();
lbl238:
                    // 2 sources

                    this.state = 0;
                    s = this.input.copyReplaceUnicodeEscapes(needs_escape);
                    if (maybe_reserved && (i = Scanner.reservedWord.get(s)) != null) {
                        return this.makeToken(i);
                    }
                    return this.makeToken(-117, s);
                }
                case 5: {
                    switch (this.nextchar()) {
                        case 'X': 
                        case 'x': {
                            switch (this.nextchar()) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    this.state = 10;
                                    continue block217;
                                }
                            }
                            this.state = 0;
                            this.error(1093);
                            continue block217;
                        }
                        case '.': {
                            this.state = 7;
                            continue block217;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block217;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block217;
                        }
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeToken(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-118, this.input.copy());
                }
                case 10: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            this.state = 10;
                            continue block217;
                        }
                        case 'i': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeToken(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-118, this.input.copy());
                }
                case 1: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 7;
                            continue block217;
                        }
                        case '.': {
                            this.state = 0;
                            if (this.nextchar() == '.') {
                                return this.makeToken(-20);
                            }
                            this.retract();
                            return this.makeToken(-19);
                        }
                        case '<': {
                            this.state = 0;
                            return this.makeToken(-21);
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-18);
                }
                case 6: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block217;
                        }
                        case '.': {
                            this.state = 7;
                            continue block217;
                        }
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeToken(-118, this.input.copy());
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block217;
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-118, this.input.copy());
                }
                case 7: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 7;
                            continue block217;
                        }
                        case 'd': 
                        case 'm': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeToken(-118, this.input.copy());
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block217;
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-118, this.input.copy());
                }
                case 8: {
                    switch (this.nextchar()) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 9;
                            continue block217;
                        }
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block217;
                }
                case 9: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 9;
                            continue block217;
                        }
                        case 'd': 
                        case 'm': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeToken(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-118, this.input.copy());
                }
                case 3: {
                    c = this.nextchar();
                    switch (c) {
                        case '/': {
                            this.state = 0;
                            do {
                                if ((c = this.nextchar()) == '\u0000') continue block217;
                            } while (c != '\r' && c != '\n');
                            this.isFirstTokenOnLine = true;
                            if (!this.save_comments) continue block217;
                            this.retract();
                            return this.makeToken(-131, this.input.copyReplaceUnicodeEscapes());
                        }
                        case '*': {
                            if (!this.save_comments) {
                                while ((c = this.nextchar()) != '\u0000') {
                                    if (c == '\r' || c == '\n') {
                                        this.isFirstTokenOnLine = true;
                                    }
                                    if (c != '*') continue;
                                    c = this.nextchar();
                                    if (c == '/') break;
                                    this.retract();
                                }
                                this.state = 0;
                                continue block217;
                            }
                            if (blockcommentbuf == null) {
                                blockcommentbuf = new StringBuilder();
                            }
                            blockcommentbuf.append("/*");
                            this.state = 13;
                            continue block217;
                        }
                        case '>': {
                            if (this.inXML <= 0) break;
                            this.state = 0;
                            return this.makeToken(-126);
                        }
                    }
                    lb = this.currentToken.id;
                    if (lb == -117 || lb == -118 || lb == -14 || lb == -40 || lb == -30) {
                        this.state = 0;
                        if (c == '=') {
                            return this.makeToken(-23);
                        }
                        this.retract();
                        return this.makeToken(-22);
                    }
                    this.state = 11;
                    this.retract();
                    continue block217;
                }
                case 11: {
                    switch (this.nextchar()) {
                        case '\\': {
                            this.nextchar();
                            continue block217;
                        }
                        case '/': {
                            regexp_flags = 0;
                            this.state = 12;
                            continue block217;
                        }
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    this.state = 11;
                    continue block217;
                }
                case 12: {
                    c = this.nextchar();
                    switch (c) {
                        case 'g': {
                            if (!(regexp_flags & true)) {
                                regexp_flags = (char)(regexp_flags | 1);
                                continue block217;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                        case 'i': {
                            if ((regexp_flags & 2) == 0) {
                                regexp_flags = (char)(regexp_flags | 2);
                                continue block217;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                        case 'm': {
                            if ((regexp_flags & 4) == 0) {
                                regexp_flags = (char)(regexp_flags | 4);
                                continue block217;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                        case 's': {
                            if ((regexp_flags & 8) == 0) {
                                regexp_flags = (char)(regexp_flags | 8);
                                continue block217;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                        case 'x': {
                            if ((regexp_flags & 16) == 0) {
                                regexp_flags = (char)(regexp_flags | 16);
                                continue block217;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        this.error(1093);
                        this.state = 0;
                        continue block217;
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeToken(-119, this.input.copyReplaceUnicodeEscapes());
                }
                case 25: {
                    switch (this.nextchar()) {
                        case '[': {
                            if (this.nextchar() != 'C' || this.nextchar() != 'D' || this.nextchar() != 'A' || this.nextchar() != 'T' || this.nextchar() != 'A' || this.nextchar() != '[') break;
                            this.state = 26;
                            continue block217;
                        }
                        case '-': {
                            if (this.nextchar() != '-') break;
                            this.state = 27;
                            continue block217;
                        }
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block217;
                }
                case 26: {
                    switch (this.nextchar()) {
                        case ']': {
                            if (this.nextchar() != ']' || this.nextchar() != '>') break;
                            this.state = 0;
                            return this.makeToken(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                        }
                        case '\u0000': {
                            this.error(1093);
                            this.state = 0;
                        }
                    }
                    continue block217;
                }
                case 27: {
                    while ((c = this.nextchar()) != '-' && c != '\u0000') {
                    }
                    if (c == '-' && this.nextchar() != '-') continue block217;
                    if (this.nextchar() == '>') {
                        this.state = 0;
                        return this.makeToken(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block217;
                }
                case 28: {
                    while ((c = this.nextchar()) != '?' && c != '\u0000') {
                    }
                    if (c == '?' && this.nextchar() == '>') {
                        this.state = 0;
                        return this.makeToken(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                    }
                    if (c != '\u0000') continue block217;
                    this.error(1093);
                    this.state = 0;
                    continue block217;
                }
                case 29: {
                    switch (this.nextchar()) {
                        case '<': 
                        case '{': {
                            this.retract();
                            xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos());
                            if (xmltext != null) {
                                this.state = 0;
                                return this.makeToken(-125, xmltext);
                            }
                            switch (this.nextchar()) {
                                case '<': {
                                    switch (this.nextchar()) {
                                        case '/': {
                                            this.state = 0;
                                            return this.makeToken(-127);
                                        }
                                        case '!': {
                                            this.state = 25;
                                            continue block217;
                                        }
                                        case '?': {
                                            this.state = 28;
                                            continue block217;
                                        }
                                    }
                                    this.retract();
                                    this.state = 0;
                                    return this.makeToken(-45);
                                }
                                case '{': {
                                    this.state = 0;
                                    return this.makeToken(-35);
                                }
                            }
                        }
                        case '\u0000': {
                            this.state = 0;
                            return this.makeToken(-1);
                        }
                    }
                    continue block217;
                }
                case 22: {
                    switch (this.nextchar()) {
                        case '{': {
                            return this.makeToken(-123, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() - 1));
                        }
                        case '<': {
                            if (this.nextchar() == '/') {
                                --this.level;
                                this.nextchar();
                                this.mark();
                                this.retract();
                                this.state = 24;
                                continue block217;
                            }
                            ++this.level;
                            this.state = 22;
                            continue block217;
                        }
                        case '/': {
                            if (this.nextchar() != '>') continue block217;
                            --this.level;
                            if (this.level != 0) continue block217;
                            this.state = 0;
                            return this.makeToken(-122, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() + 1));
                        }
                        case '\u0000': {
                            this.retract();
                            this.error(1100);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    continue block217;
                }
                case 24: {
                    c = this.nextchar();
                    if (Character.isJavaIdentifierPart(c) || c == ':') continue block217;
                    switch (c) {
                        case '{': {
                            xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() - 1);
                            return this.makeToken(-123, xmltext);
                        }
                        case '>': {
                            this.retract();
                            this.nextchar();
                            if (this.level == 0) {
                                xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() + 1);
                                this.state = 0;
                                return this.makeToken(-122, xmltext);
                            }
                            this.state = 22;
                            continue block217;
                        }
                    }
                    this.state = 22;
                    continue block217;
                }
                case 13: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            if (this.nextchar() == '/') {
                                this.state = 0;
                                return this.makeToken(-130, new String());
                            }
                            this.retract();
                            this.state = 16;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                        }
                    }
                    this.state = 14;
                    continue block217;
                }
                case 16: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            this.state = 17;
                            continue block217;
                        }
                        case '@': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            if (doctagname.length() > 0) {
                                doctextbuf.append("]]></").append(doctagname).append(">");
                            }
                            doctagname = "";
                            this.state = 18;
                            continue block217;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            doctextbuf.append('\n');
                            this.state = 16;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    if (doctextbuf == null) {
                        doctextbuf = this.getDocTextBuffer(doctagname);
                    }
                    doctextbuf.append(c);
                    this.state = 16;
                    continue block217;
                }
                case 17: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '/': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            if (doctagname.length() > 0) {
                                doctextbuf.append("]]></").append(doctagname).append(">");
                            }
                            doctext = doctextbuf.toString();
                            this.state = 0;
                            return this.makeToken(-129, doctext);
                        }
                        case '*': {
                            this.state = 17;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    this.state = 16;
                    continue block217;
                }
                case 18: {
                    c = this.nextchar();
                    switch (c) {
                        case '*': {
                            this.state = 17;
                            continue block217;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            while ((c = this.nextchar()) == ' ' || c == '\t') {
                            }
                            this.retract();
                            if (doctagname.length() > 0) {
                                doctextbuf.append("\n<").append(doctagname).append("><![CDATA[");
                            }
                            this.state = 16;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    doctagname = doctagname + c;
                    continue block217;
                }
                case 19: {
                    switch (this.nextchar()) {
                        case '*': {
                            this.state = 17;
                            continue block217;
                        }
                        case '@': {
                            this.state = 18;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    this.state = 16;
                    continue block217;
                }
                case 14: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            this.state = 15;
                            continue block217;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            this.state = 14;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    this.state = 14;
                    continue block217;
                }
                case 15: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '/': {
                            this.state = 0;
                            blocktext = blockcommentbuf.toString();
                            return this.makeToken(-130, blocktext);
                        }
                        case '*': {
                            this.state = 15;
                            continue block217;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block217;
                        }
                    }
                    this.state = 14;
                    continue block217;
                }
                case -1: {
                    this.error(1093);
                    this.skiperror();
                    this.state = 0;
                    continue block217;
                }
            }
            break;
        }
        this.error("invalid scanner state");
        this.state = 0;
        return this.makeToken(-1);
    }

    static {
        reservedWord.put("as", -60);
        reservedWord.put("break", -61);
        reservedWord.put("case", -62);
        reservedWord.put("catch", -63);
        reservedWord.put("class", -64);
        reservedWord.put("const", -65);
        reservedWord.put("continue", -66);
        reservedWord.put("default", -68);
        reservedWord.put("delete", -69);
        reservedWord.put("do", -70);
        reservedWord.put("else", -71);
        reservedWord.put("extends", -73);
        reservedWord.put("false", -74);
        reservedWord.put("finally", -76);
        reservedWord.put("for", -77);
        reservedWord.put("function", -78);
        reservedWord.put("get", -79);
        reservedWord.put("if", -81);
        reservedWord.put("implements", -82);
        reservedWord.put("import", -83);
        reservedWord.put("in", -84);
        reservedWord.put("include", -85);
        reservedWord.put("instanceof", -86);
        reservedWord.put("interface", -87);
        reservedWord.put("is", -88);
        reservedWord.put("namespace", -89);
        reservedWord.put("new", -92);
        reservedWord.put("null", -93);
        reservedWord.put("package", -94);
        reservedWord.put("private", -95);
        reservedWord.put("protected", -96);
        reservedWord.put("public", -97);
        reservedWord.put("return", -98);
        reservedWord.put("set", -99);
        reservedWord.put("super", -101);
        reservedWord.put("switch", -102);
        reservedWord.put("this", -104);
        reservedWord.put("throw", -105);
        reservedWord.put("true", -108);
        reservedWord.put("try", -109);
        reservedWord.put("typeof", -110);
        reservedWord.put("use", -111);
        reservedWord.put("var", -112);
        reservedWord.put("void", -113);
        reservedWord.put("while", -115);
        reservedWord.put("with", -116);
    }

    private class Tok {
        int id;
        String text;

        private Tok() {
        }
    }
}

