/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.Token;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntList;
import macromedia.asc.util.ObjectList;

public final class Scanner
implements ErrorConstants {
    private static final boolean debug = false;
    private static int token_count = 0;
    private static final int slashdiv_context = 1;
    private static final int slashregexp_context = 2;
    private Token currentToken;
    private int currentTokenId;
    private IntList slash_context = new IntList();
    private boolean isFirstTokenOnLine;
    private boolean save_comments;
    private Context ctx;
    public InputBuffer input;
    private static final ConcurrentHashMap<String, Integer> reservedWord = new ConcurrentHashMap(64);
    public int state;
    public int level;
    public IntList states;
    public IntList levels;
    public ObjectList<IntList> slashcontexts;

    private void init(Context cx, boolean save_comments) {
        this.ctx = cx;
        this.state = 0;
        this.level = 0;
        this.slash_context.add(2);
        this.states = new IntList();
        this.levels = new IntList();
        this.slashcontexts = new ObjectList();
        this.save_comments = save_comments;
        this.currentToken = new Token(0, "");
        this.currentTokenId = 0;
    }

    public Scanner(Context cx, InputStream in, String encoding, String origin) {
        this(cx, in, encoding, origin, true);
    }

    public Scanner(Context cx, InputStream in, String encoding, String origin, boolean save_comments) {
        this.init(cx, save_comments);
        cx.input = this.input = new InputBuffer(in, encoding, origin);
    }

    public Scanner(Context cx, String in, String origin) {
        this(cx, in, origin, true);
    }

    public Scanner(Context cx, String in, String origin, boolean save_comments) {
        this.init(cx, save_comments);
        cx.input = this.input = new InputBuffer(in, origin);
    }

    public Scanner(Context cx, InputBuffer input) {
        this.init(cx, true);
        this.input = input;
        cx.input = input;
    }

    private char nextchar() {
        return (char)this.input.nextchar();
    }

    public void retract() {
        this.input.retract();
    }

    private int pos() {
        return this.input.textPos();
    }

    private void mark() {
        this.input.textMark();
    }

    public void enterSlashDivContext() {
        this.slash_context.add(1);
    }

    public void exitSlashDivContext() {
        this.slash_context.removeLast();
    }

    public void enterSlashRegExpContext() {
        this.slash_context.add(2);
    }

    public void exitSlashRegExpContext() {
        this.slash_context.removeLast();
    }

    private boolean isSlashDivContext() {
        return this.slash_context.last() == 1;
    }

    private int makeTokenInstance(int token_class, String lexeme) {
        this.currentToken.set(token_class, lexeme);
        this.currentTokenId = ++token_count;
        return token_count;
    }

    public int getCurrentTokenClass(int token_id) {
        if (token_id < 0) {
            return token_id;
        }
        return this.currentToken.getTokenClass();
    }

    public String getCurrentTokenText(int token_id) {
        if (token_id < 0) {
            return Token.getTokenClassName(token_id);
        }
        if (token_id != this.currentTokenId) {
            this.error("Scanner internal: token id does not match current token id");
        }
        return this.currentToken.getTokenText();
    }

    public String getCurrentStringTokenText(int token_id, boolean[] is_single_quoted) {
        if (token_id < 0) {
            is_single_quoted[0] = false;
            return Token.getTokenClassName(token_id);
        }
        String fulltext = this.currentToken.getTokenSource();
        is_single_quoted[0] = fulltext.charAt(0) == '\'';
        String enclosedText = fulltext.substring(1, fulltext.length() - 1);
        return enclosedText;
    }

    private void error(int kind, String arg) {
        StringBuilder out = new StringBuilder();
        String origin = this.input.origin;
        int errPos = this.input.positionOfMark();
        int ln = this.input.getLnNum(errPos);
        int col = this.input.getColPos(errPos);
        String msg = (ContextStatics.useVerboseErrors ? "[Compiler] Error #" + kind + ": " : "") + this.ctx.errorString(kind);
        int nextLoc = Context.replaceStringArg(out, msg, 0, arg);
        if (nextLoc != -1) {
            out.append(msg.substring(nextLoc, msg.length()));
        }
        this.ctx.localizedError(origin, ln, col, out.toString(), this.input.getLineText(errPos), kind);
        this.skiperror(kind);
    }

    private void error(String msg) {
        this.ctx.internalError(msg);
        this.error(1093, msg);
    }

    private void error(int kind) {
        this.error(kind, "");
    }

    private void skiperror() {
        this.skiperror(1093);
    }

    private void skiperror(int kind) {
        char nc;
        switch (kind) {
            case 1093: {
                return;
            }
            case 1094: 
            case 1095: {
                char nc2;
                while ((nc2 = this.nextchar()) != '\'' && nc2 != '\u0000') {
                }
                return;
            }
        }
        while ((nc = this.nextchar()) != ';' && nc != '\n' && nc != '\r' && nc != '\u0000') {
        }
    }

    public boolean followsLineTerminator() {
        return this.isFirstTokenOnLine;
    }

    public void pushState() {
        this.states.add(this.state);
        this.levels.add(this.level);
        IntList temp = new IntList(this.slash_context);
        this.slashcontexts.add(temp);
        this.state = 0;
        this.level = 0;
        this.slash_context.clear();
        this.enterSlashRegExpContext();
    }

    public void popState() {
        this.exitSlashRegExpContext();
        if (this.slash_context.size() != 0) assert (false);
        this.state = this.states.removeLast();
        this.level = this.levels.removeLast();
        this.slash_context = this.slashcontexts.removeLast();
    }

    private StringBuilder getDocTextBuffer(String doctagname) {
        StringBuilder doctextbuf = new StringBuilder();
        doctextbuf.append("<").append(doctagname).append("><![CDATA[");
        return doctextbuf;
    }

    public void clearUnusedBuffers() {
        this.input.clearUnusedBuffers();
        this.input = null;
    }

    /*
     * Unable to fully structure code
     */
    public int nexttoken(boolean resetState) {
        doctagname = "description";
        doctextbuf = null;
        startofxml = this.pos();
        blockcommentbuf = null;
        regexp_flags = 0;
        maybe_reserved = false;
        c = '\u0000';
        if (resetState) {
            this.isFirstTokenOnLine = false;
        }
        block224: while (true) {
            switch (this.state) {
                case 0: {
                    c = this.nextchar();
                    this.mark();
                    switch (c) {
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            maybe_reserved = true;
                        }
                        case '$': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': {
                            this.state = 4;
                            continue block224;
                        }
                        case '\uffef': {
                            if (this.nextchar() == '\uffffffbb' && this.nextchar() == '\uffffffbf') {
                                this.state = 0;
                                continue block224;
                            }
                            this.state = -1;
                            continue block224;
                        }
                        case '@': {
                            return -28;
                        }
                        case '\"': 
                        case '\'': {
                            startquote = c;
                            needs_escape = false;
                            while ((c = this.nextchar()) != startquote) {
                                if (c == '\\') {
                                    needs_escape = true;
                                    c = this.nextchar();
                                    if (c == '\r') {
                                        c = this.nextchar();
                                    }
                                    if (c != '\n') continue;
                                    continue;
                                }
                                if (c == '\r' || c == '\n') {
                                    if (startquote == '\'') {
                                        this.error(1094);
                                        break;
                                    }
                                    this.error(1095);
                                    break;
                                }
                                if (c != '\u0000') continue;
                                this.error(1097);
                                return -1;
                            }
                            return this.makeTokenInstance(-120, this.input.copyReplaceStringEscapes(needs_escape));
                        }
                        case '-': {
                            switch (this.nextchar()) {
                                case '-': {
                                    return -3;
                                }
                                case '=': {
                                    return -50;
                                }
                            }
                            this.retract();
                            return -2;
                        }
                        case '!': {
                            if (this.nextchar() == '=') {
                                if (this.nextchar() == '=') {
                                    return -6;
                                }
                                this.retract();
                                return -5;
                            }
                            this.retract();
                            return -4;
                        }
                        case '%': {
                            switch (this.nextchar()) {
                                case '=': {
                                    return -8;
                                }
                            }
                            this.retract();
                            return -7;
                        }
                        case '&': {
                            c = this.nextchar();
                            if (c == '=') {
                                return -12;
                            }
                            if (c == '&') {
                                if (this.nextchar() == '=') {
                                    return -11;
                                }
                                this.retract();
                                return -10;
                            }
                            this.retract();
                            return -9;
                        }
                        case '#': {
                            if (Features.HAS_HASHPRAGMAS) {
                                return -111;
                            }
                            this.state = -1;
                            continue block224;
                        }
                        case '(': {
                            return -13;
                        }
                        case ')': {
                            return -14;
                        }
                        case '*': {
                            if (this.nextchar() == '=') {
                                return -16;
                            }
                            this.retract();
                            return -15;
                        }
                        case ',': {
                            return -17;
                        }
                        case '.': {
                            this.state = 1;
                            continue block224;
                        }
                        case '/': {
                            this.state = 3;
                            continue block224;
                        }
                        case ':': {
                            if (this.nextchar() == ':') {
                                return -25;
                            }
                            this.retract();
                            return -24;
                        }
                        case ';': {
                            return -26;
                        }
                        case '?': {
                            return -27;
                        }
                        case '[': {
                            return -29;
                        }
                        case ']': {
                            return -30;
                        }
                        case '^': {
                            if (this.nextchar() == '=') {
                                return -34;
                            }
                            this.retract();
                            return -31;
                        }
                        case '{': {
                            return -35;
                        }
                        case '|': {
                            c = this.nextchar();
                            if (c == '=') {
                                return -39;
                            }
                            if (c == '|') {
                                if (this.nextchar() == '=') {
                                    return -38;
                                }
                                this.retract();
                                return -37;
                            }
                            this.retract();
                            return -36;
                        }
                        case '}': {
                            return -40;
                        }
                        case '~': {
                            return -41;
                        }
                        case '+': {
                            c = this.nextchar();
                            if (c == '+') {
                                return -43;
                            }
                            if (c == '=') {
                                return -44;
                            }
                            this.retract();
                            return -42;
                        }
                        case '<': {
                            if (this.isSlashDivContext()) {
                                switch (this.nextchar()) {
                                    case '<': {
                                        if (this.nextchar() == '=') {
                                            return -47;
                                        }
                                        this.retract();
                                        return -46;
                                    }
                                    case '=': {
                                        return -48;
                                    }
                                    case '/': {
                                        return -127;
                                    }
                                    case '!': {
                                        this.state = 25;
                                        continue block224;
                                    }
                                    case '?': {
                                        this.state = 28;
                                        continue block224;
                                    }
                                }
                            } else {
                                switch (this.nextchar()) {
                                    case '/': {
                                        return -127;
                                    }
                                    case '!': {
                                        this.state = 25;
                                        continue block224;
                                    }
                                    case '?': {
                                        this.state = 28;
                                        continue block224;
                                    }
                                }
                            }
                            this.retract();
                            return -45;
                        }
                        case '=': {
                            if (this.nextchar() == '=') {
                                if (this.nextchar() == '=') {
                                    return -52;
                                }
                                this.retract();
                                return -51;
                            }
                            this.retract();
                            return -49;
                        }
                        case '>': {
                            this.state = 0;
                            if (this.isSlashDivContext()) {
                                switch (this.nextchar()) {
                                    case '>': {
                                        switch (this.nextchar()) {
                                            case '>': {
                                                if (this.nextchar() == '=') {
                                                    return -58;
                                                }
                                                this.retract();
                                                return -57;
                                            }
                                            case '=': {
                                                return -56;
                                            }
                                        }
                                        this.retract();
                                        return -55;
                                    }
                                    case '=': {
                                        return -54;
                                    }
                                }
                                this.retract();
                            }
                            return -53;
                        }
                        case '0': {
                            this.state = 5;
                            continue block224;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block224;
                        }
                        case '\t': 
                        case '\u000b': 
                        case '\f': 
                        case ' ': 
                        case '\u0085': 
                        case '\u00a0': {
                            continue block224;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            continue block224;
                        }
                        case '\u0000': {
                            return -1;
                        }
                    }
                    switch (this.input.nextcharClass(c, true)) {
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\b': 
                        case '\u0012': 
                        case '\u0013': {
                            maybe_reserved = false;
                            this.state = 4;
                            continue block224;
                        }
                        case '\n': 
                        case '\r': 
                        case '\u000e': {
                            continue block224;
                        }
                        case '\u000b': 
                        case '\f': {
                            this.isFirstTokenOnLine = true;
                            continue block224;
                        }
                    }
                    this.state = -1;
                    continue block224;
                }
                case 4: {
                    v0 = needs_escape = c == '\\';
                    block226: while (true) {
                        if ((c = this.nextchar()) >= 'a' && c <= 'z') {
                            continue;
                        }
                        if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$' || c == '_') {
                            maybe_reserved = false;
                            continue;
                        }
                        if (c > '\u007f') ** GOTO lbl243
                        if (c == '\\') ** GOTO lbl242
                        this.retract();
                        ** GOTO lbl250
lbl242:
                        // 1 sources

                        needs_escape = true;
lbl243:
                        // 2 sources

                        switch (this.input.nextcharClass(c, false)) {
                            case '\u0001': 
                            case '\u0002': 
                            case '\u0003': 
                            case '\u0004': 
                            case '\u0005': 
                            case '\u0007': 
                            case '\b': 
                            case '\u0012': 
                            case '\u0013': 
                            case '\u0014': {
                                maybe_reserved = false;
                                this.input.nextcharClass(c, true);
                                continue block226;
                            }
                        }
                        break;
                    }
                    this.retract();
lbl250:
                    // 2 sources

                    this.state = 0;
                    s = this.input.copyReplaceUnicodeEscapes(needs_escape);
                    if (maybe_reserved && (i = Scanner.reservedWord.get(s)) != null) {
                        return i;
                    }
                    return this.makeTokenInstance(-117, s);
                }
                case 5: {
                    switch (this.nextchar()) {
                        case 'X': 
                        case 'x': {
                            switch (this.nextchar()) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    this.state = 10;
                                    continue block224;
                                }
                            }
                            this.state = 0;
                            this.error(1093);
                            continue block224;
                        }
                        case '.': {
                            this.state = 7;
                            continue block224;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block224;
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block224;
                        }
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeTokenInstance(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-118, this.input.copy());
                }
                case 10: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            this.state = 10;
                            continue block224;
                        }
                        case 'i': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeTokenInstance(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-118, this.input.copy());
                }
                case 1: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 7;
                            continue block224;
                        }
                        case '.': {
                            this.state = 0;
                            if (this.nextchar() == '.') {
                                return -20;
                            }
                            this.retract();
                            return -19;
                        }
                        case '<': {
                            this.state = 0;
                            return -21;
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return -18;
                }
                case 6: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 6;
                            continue block224;
                        }
                        case '.': {
                            this.state = 7;
                            continue block224;
                        }
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 'u': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeTokenInstance(-118, this.input.copy());
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block224;
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-118, this.input.copy());
                }
                case 7: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 7;
                            continue block224;
                        }
                        case 'd': 
                        case 'm': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeTokenInstance(-118, this.input.copy());
                        }
                        case 'E': 
                        case 'e': {
                            this.state = 8;
                            continue block224;
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-118, this.input.copy());
                }
                case 8: {
                    switch (this.nextchar()) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 9;
                            continue block224;
                        }
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block224;
                }
                case 9: {
                    switch (this.nextchar()) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.state = 9;
                            continue block224;
                        }
                        case 'd': 
                        case 'm': {
                            if (!this.ctx.statics.es4_numerics) {
                                this.retract();
                            }
                            this.state = 0;
                            return this.makeTokenInstance(-118, this.input.copy());
                        }
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-118, this.input.copy());
                }
                case 3: {
                    c = this.nextchar();
                    switch (c) {
                        case '/': {
                            this.state = 0;
                            do {
                                if ((c = this.nextchar()) == '\u0000') continue block224;
                            } while (c != '\r' && c != '\n');
                            this.isFirstTokenOnLine = true;
                            if (!this.save_comments) continue block224;
                            this.retract();
                            return this.makeTokenInstance(-131, this.input.copyReplaceUnicodeEscapes());
                        }
                        case '*': {
                            if (!this.save_comments) {
                                while ((c = this.nextchar()) != '\u0000') {
                                    if (c == '\r' || c == '\n') {
                                        this.isFirstTokenOnLine = true;
                                    }
                                    if (c != '*') continue;
                                    c = this.nextchar();
                                    if (c == '/') break;
                                    this.retract();
                                }
                                this.state = 0;
                                continue block224;
                            }
                            if (blockcommentbuf == null) {
                                blockcommentbuf = new StringBuilder();
                            }
                            blockcommentbuf.append("/*");
                            this.state = 13;
                            continue block224;
                        }
                    }
                    if (this.isSlashDivContext()) {
                        this.state = 0;
                        if (c == '>') {
                            return -126;
                        }
                        if (c == '=') {
                            return -23;
                        }
                        this.retract();
                        return -22;
                    }
                    this.state = 11;
                    this.retract();
                    continue block224;
                }
                case 11: {
                    switch (this.nextchar()) {
                        case '\\': {
                            this.nextchar();
                            continue block224;
                        }
                        case '/': {
                            regexp_flags = 0;
                            this.state = 12;
                            continue block224;
                        }
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    this.state = 11;
                    continue block224;
                }
                case 12: {
                    c = this.nextchar();
                    switch (c) {
                        case 'g': {
                            if (!(regexp_flags & true)) {
                                regexp_flags = (char)(regexp_flags | 1);
                                continue block224;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                        case 'i': {
                            if ((regexp_flags & 2) == 0) {
                                regexp_flags = (char)(regexp_flags | 2);
                                continue block224;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                        case 'm': {
                            if ((regexp_flags & 4) == 0) {
                                regexp_flags = (char)(regexp_flags | 4);
                                continue block224;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                        case 's': {
                            if ((regexp_flags & 8) == 0) {
                                regexp_flags = (char)(regexp_flags | 8);
                                continue block224;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                        case 'x': {
                            if ((regexp_flags & 16) == 0) {
                                regexp_flags = (char)(regexp_flags | 16);
                                continue block224;
                            }
                            this.error(1093);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        this.error(1093);
                        this.state = 0;
                        continue block224;
                    }
                    this.retract();
                    this.state = 0;
                    return this.makeTokenInstance(-119, this.input.copyReplaceUnicodeEscapes());
                }
                case 25: {
                    switch (this.nextchar()) {
                        case '[': {
                            if (this.nextchar() != 'C' || this.nextchar() != 'D' || this.nextchar() != 'A' || this.nextchar() != 'T' || this.nextchar() != 'A' || this.nextchar() != '[') break;
                            this.state = 26;
                            continue block224;
                        }
                        case '-': {
                            if (this.nextchar() != '-') break;
                            this.state = 27;
                            continue block224;
                        }
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block224;
                }
                case 26: {
                    switch (this.nextchar()) {
                        case ']': {
                            if (this.nextchar() != ']' || this.nextchar() != '>') break;
                            this.state = 0;
                            return this.makeTokenInstance(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                        }
                        case '\u0000': {
                            this.error(1093);
                            this.state = 0;
                        }
                    }
                    continue block224;
                }
                case 27: {
                    while ((c = this.nextchar()) != '-' && c != '\u0000') {
                    }
                    if (c == '-' && this.nextchar() != '-') continue block224;
                    if (this.nextchar() == '>') {
                        this.state = 0;
                        return this.makeTokenInstance(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                    }
                    this.error(1093);
                    this.state = 0;
                    continue block224;
                }
                case 28: {
                    while ((c = this.nextchar()) != '?' && c != '\u0000') {
                    }
                    if (c == '?' && this.nextchar() == '>') {
                        this.state = 0;
                        return this.makeTokenInstance(-124, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos()));
                    }
                    if (this.nextchar() != '\u0000') continue block224;
                    this.error(1093);
                    this.state = 0;
                    continue block224;
                }
                case 29: {
                    switch (this.nextchar()) {
                        case '<': 
                        case '{': {
                            this.retract();
                            xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos());
                            if (xmltext != null) {
                                this.state = 0;
                                return this.makeTokenInstance(-125, xmltext);
                            }
                            switch (this.nextchar()) {
                                case '<': {
                                    switch (this.nextchar()) {
                                        case '/': {
                                            this.state = 0;
                                            return -127;
                                        }
                                        case '!': {
                                            this.state = 25;
                                            continue block224;
                                        }
                                        case '?': {
                                            this.state = 28;
                                            continue block224;
                                        }
                                    }
                                    this.retract();
                                    this.state = 0;
                                    return -45;
                                }
                                case '{': {
                                    this.state = 0;
                                    return -35;
                                }
                            }
                        }
                        case '\u0000': {
                            this.state = 0;
                            return -1;
                        }
                    }
                    continue block224;
                }
                case 22: {
                    switch (this.nextchar()) {
                        case '{': {
                            return this.makeTokenInstance(-123, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() - 1));
                        }
                        case '<': {
                            switch (this.nextchar()) {
                                case '/': {
                                    --this.level;
                                    this.nextchar();
                                    this.mark();
                                    this.retract();
                                    this.state = 24;
                                    continue block224;
                                }
                            }
                            ++this.level;
                            this.state = 22;
                            continue block224;
                        }
                        case '/': {
                            if (this.nextchar() != '>') continue block224;
                            --this.level;
                            if (this.level != 0) continue block224;
                            this.state = 0;
                            return this.makeTokenInstance(-122, this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() + 1));
                        }
                        case '\u0000': {
                            this.retract();
                            this.error(1100);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    continue block224;
                }
                case 24: {
                    c = this.nextchar();
                    if (Character.isJavaIdentifierPart(c) || c == ':') continue block224;
                    switch (c) {
                        case '{': {
                            xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() - 1);
                            return this.makeTokenInstance(-123, xmltext);
                        }
                        case '>': {
                            this.retract();
                            this.nextchar();
                            if (this.level == 0) {
                                xmltext = this.input.substringReplaceUnicodeEscapes(startofxml, this.pos() + 1);
                                this.state = 0;
                                return this.makeTokenInstance(-122, xmltext);
                            }
                            this.state = 22;
                            continue block224;
                        }
                    }
                    this.state = 22;
                    continue block224;
                }
                case 13: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            if (this.nextchar() == '/') {
                                this.state = 0;
                                return this.makeTokenInstance(-130, new String());
                            }
                            this.retract();
                            this.state = 16;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                        }
                    }
                    this.state = 14;
                    continue block224;
                }
                case 16: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            this.state = 17;
                            continue block224;
                        }
                        case '@': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            if (doctagname.length() > 0) {
                                doctextbuf.append("]]></").append(doctagname).append(">");
                            }
                            doctagname = "";
                            this.state = 18;
                            continue block224;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            doctextbuf.append('\n');
                            this.state = 16;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    if (doctextbuf == null) {
                        doctextbuf = this.getDocTextBuffer(doctagname);
                    }
                    doctextbuf.append(c);
                    this.state = 16;
                    continue block224;
                }
                case 17: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '/': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            if (doctagname.length() > 0) {
                                doctextbuf.append("]]></").append(doctagname).append(">");
                            }
                            doctext = doctextbuf.toString();
                            this.state = 0;
                            return this.makeTokenInstance(-129, doctext);
                        }
                        case '*': {
                            this.state = 17;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    this.state = 16;
                    continue block224;
                }
                case 18: {
                    c = this.nextchar();
                    switch (c) {
                        case '*': {
                            this.state = 17;
                            continue block224;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (doctextbuf == null) {
                                doctextbuf = this.getDocTextBuffer(doctagname);
                            }
                            while ((c = this.nextchar()) == ' ' || c == '\t') {
                            }
                            this.retract();
                            if (doctagname.length() > 0) {
                                doctextbuf.append("\n<").append(doctagname).append("><![CDATA[");
                            }
                            this.state = 16;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    doctagname = doctagname + c;
                    continue block224;
                }
                case 19: {
                    switch (this.nextchar()) {
                        case '*': {
                            this.state = 17;
                            continue block224;
                        }
                        case '@': {
                            this.state = 18;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    this.state = 16;
                    continue block224;
                }
                case 14: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '*': {
                            this.state = 15;
                            continue block224;
                        }
                        case '\n': 
                        case '\r': {
                            this.isFirstTokenOnLine = true;
                            this.state = 14;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    this.state = 14;
                    continue block224;
                }
                case 15: {
                    c = this.nextchar();
                    blockcommentbuf.append(c);
                    switch (c) {
                        case '/': {
                            this.state = 0;
                            blocktext = blockcommentbuf.toString();
                            return this.makeTokenInstance(-130, blocktext);
                        }
                        case '*': {
                            this.state = 15;
                            continue block224;
                        }
                        case '\u0000': {
                            this.error(1204);
                            this.state = 0;
                            continue block224;
                        }
                    }
                    this.state = 14;
                    continue block224;
                }
                case -1: {
                    this.error(1093);
                    this.skiperror();
                    this.state = 0;
                    continue block224;
                }
            }
            break;
        }
        this.error("invalid scanner state");
        this.state = 0;
        return -1;
    }

    static {
        reservedWord.put("as", -60);
        reservedWord.put("break", -61);
        reservedWord.put("case", -62);
        reservedWord.put("catch", -63);
        reservedWord.put("class", -64);
        reservedWord.put("const", -65);
        reservedWord.put("continue", -66);
        reservedWord.put("default", -68);
        reservedWord.put("delete", -69);
        reservedWord.put("do", -70);
        reservedWord.put("else", -71);
        reservedWord.put("extends", -73);
        reservedWord.put("false", -74);
        reservedWord.put("finally", -76);
        reservedWord.put("for", -77);
        reservedWord.put("function", -78);
        reservedWord.put("get", -79);
        reservedWord.put("if", -81);
        reservedWord.put("implements", -82);
        reservedWord.put("import", -83);
        reservedWord.put("in", -84);
        reservedWord.put("include", -85);
        reservedWord.put("instanceof", -86);
        reservedWord.put("interface", -87);
        reservedWord.put("is", -88);
        reservedWord.put("namespace", -89);
        reservedWord.put("new", -92);
        reservedWord.put("null", -93);
        reservedWord.put("package", -94);
        reservedWord.put("private", -95);
        reservedWord.put("protected", -96);
        reservedWord.put("public", -97);
        reservedWord.put("return", -98);
        reservedWord.put("set", -99);
        reservedWord.put("super", -101);
        reservedWord.put("switch", -102);
        reservedWord.put("this", -104);
        reservedWord.put("throw", -105);
        reservedWord.put("true", -108);
        reservedWord.put("try", -109);
        reservedWord.put("typeof", -110);
        reservedWord.put("use", -111);
        reservedWord.put("var", -112);
        reservedWord.put("void", -113);
        reservedWord.put("while", -115);
        reservedWord.put("with", -116);
    }
}

