/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import adobe.abc.GlobalOptimizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import macromedia.abc.AbcParser;
import macromedia.abc.Optimizer;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.CompilerPlug;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.IncludeInfo;
import macromedia.asc.embedding.LintEvaluator;
import macromedia.asc.embedding.SwfMaker;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.NodePrinter;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConfigurationEvaluator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements ErrorConstants {
    static int ref_count = 0;
    private static final String newline = System.getProperty("line.separator");
    static int col_counter = 0;

    static void init() {
        if (ref_count == 0) {
            TypeValue.init();
            ObjectValue.init();
        }
        ++ref_count;
    }

    static void print_byte(byte b) {
        if (col_counter % 16 == 0) {
            System.out.print("\n\t");
        }
        System.out.print(Integer.toHexString(b));
        ++col_counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compile(Context cx, ObjectValue global, InputStream in, String filename, String file_encoding, ObjectList<IncludeInfo> includes, String swf_options, String avmplus_exe, ObjectList<CompilerPlug> plugs, boolean emit_doc_info, boolean show_parsetrees, boolean show_bytes, boolean show_flow, boolean lint_mode, boolean emit_metadata, boolean save_comment_nodes, boolean emit_debug_info, ObjectList<String> import_filespecs) {
        MetaDataEvaluator printer;
        ProgramNode second = null;
        ObjectList<ImportNode> imports = new ObjectList<ImportNode>();
        for (String filespec : import_filespecs) {
            Context cx2 = new Context(cx.statics);
            BufferedInputStream import_in = null;
            try {
                if (filespec.endsWith(".abc")) {
                    second = new AbcParser(cx2, filespec).parseAbc();
                    if (second == null) {
                        cx.error(-1, 1111, filespec);
                    }
                } else {
                    import_in = new BufferedInputStream(new FileInputStream(filespec));
                    cx2.setPath(new File(filespec).getAbsoluteFile().getParent());
                    second = new Parser(cx2, import_in, filespec, null, emit_doc_info, save_comment_nodes).parseProgram();
                }
            }
            catch (IOException ex) {
                cx.error(-1, 1063, filespec);
            }
            finally {
                if (import_in != null) {
                    try {
                        import_in.close();
                    }
                    catch (IOException ex) {}
                }
            }
            NodeFactory nodeFactory = cx2.getNodeFactory();
            imports.push_back(nodeFactory.Import(cx2, nodeFactory.literalString(filespec, 0), second));
            cx2.getNodeFactory().pkg_defs.clear();
        }
        cx.setPath(new File(filename).getAbsoluteFile().getParent());
        ProgramNode node = new Parser(cx, in, filename, file_encoding, emit_doc_info, save_comment_nodes).parseProgram();
        node.imports = imports;
        ObjectList<ProgramNode> nodes = new ObjectList<ProgramNode>();
        if (includes != null) {
            for (IncludeInfo iinfo : includes) {
                Context cx2 = new Context(cx.statics);
                ProgramNode node2 = new Parser(cx2, iinfo.script, iinfo.name, iinfo.encoding, emit_doc_info, save_comment_nodes).parseProgram();
                nodes.add(node2);
            }
        }
        cx.pushScope(global);
        if (includes != null && includes.size() > 0) {
            ObjectList<Node> stmts = node.statements.items;
            for (int i = nodes.size() - 1; i >= 0; --i) {
                Context cx2 = ((ProgramNode)nodes.get((int)i)).cx;
                NodeFactory nodeFactory = cx2.getNodeFactory();
                String name = ((IncludeInfo)includes.get((int)i)).name;
                LiteralStringNode first = nodeFactory.literalString(name, 0);
                IncludeDirectiveNode idn = nodeFactory.includeDirective(cx2, first, (ProgramNode)nodes.get(i));
                StatementListNode istmts = nodeFactory.statementList(null, idn);
                ObjectList<Node> items = istmts.items;
                stmts.addAll(0, items);
            }
        }
        node.pkgdefs.clear();
        node.pkgdefs.addAll(cx.getNodeFactory().pkg_defs);
        if (show_parsetrees && cx.errorCount() == 0) {
            Compiler.printParseTrees(cx.scriptName(), node, cx, ".p");
            return;
        }
        if (cx.errorCount() == 0) {
            ConfigurationEvaluator ce = new ConfigurationEvaluator();
            node.evaluate(cx, ce);
        }
        if (cx.errorCount() == 0) {
            FlowGraphEmitter flowem = new FlowGraphEmitter(cx, filename, show_flow);
            FlowAnalyzer flower = new FlowAnalyzer(flowem);
            node.evaluate(cx, flower);
            node.evaluate(cx, flower);
        }
        if (cx.errorCount() == 0 && emit_metadata) {
            printer = new MetaDataEvaluator(emit_debug_info);
            node.evaluate(cx, printer);
        }
        if (cx.errorCount() == 0) {
            ConstantEvaluator analyzer = new ConstantEvaluator(cx);
            node.evaluate(cx, analyzer);
        }
        if (cx.errorCount() == 0 && emit_doc_info) {
            printer = new MetaDataEvaluator();
            node.evaluate(cx, printer);
            StringBuilder out = new StringBuilder();
            out.append("<asdoc>").append(newline);
            ObjectList<DocCommentNode> comments = printer.doccomments;
            int numComments = comments.size();
            DefinitionNode prev = null;
            for (int x = 0; x < numComments; ++x) {
                DocCommentNode d = (DocCommentNode)comments.get(x);
                d.emit(cx, out);
                prev = d.def;
            }
            out.append(newline).append("</asdoc>").append(newline);
            FilterOutputStream warningOut = null;
            try {
                String outName = cx.scriptName() + ".xml";
                warningOut = new BufferedOutputStream(new FileOutputStream(new File(cx.path(), outName)));
                warningOut.write(out.toString().getBytes());
                ((BufferedOutputStream)warningOut).flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (warningOut != null) {
                    try {
                        warningOut.close();
                        System.err.println("wrote .xml doc file: " + cx.path() + "/" + cx.scriptName() + ".xml");
                    }
                    catch (IOException ex) {}
                }
            }
            return;
        }
        if (lint_mode && cx.errorCount() == 0) {
            LintEvaluator evaluator = new LintEvaluator(cx, filename, (String)null);
            node.evaluate(cx, evaluator);
            evaluator.logWarnings(cx);
            evaluator.clear();
        }
        if (cx.errorCount() == 0) {
            Emitter emitter = cx.getEmitter();
            CodeGenerator generator = new CodeGenerator(emitter);
            node.evaluate(cx, generator);
        }
        cx.popScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean doCompile(InputStream in, String pathspec, String scriptname, String filename, String encoding, String swf_options, String avmplus_exe, ObjectList<IncludeInfo> includes, ObjectList<String> import_filespecs, ObjectList<String> use_namespaces, String language, ObjectList<ConfigVar> configs, ObjectList<CompilerPlug> plugs, CompilerHandler handler, boolean emit_doc_info, boolean emit_debug_info, boolean show_instructions, boolean show_machinecode, boolean show_linenums, boolean show_parsetrees, boolean show_bytes, boolean show_flow, boolean lint_mode, boolean use_static_semantics, boolean emit_metadata, boolean save_comment_nodes, int dialect, int target, boolean optimize, ObjectList<ConfigVar> optimizer_configs) {
        String ver;
        Compiler.init();
        ContextStatics statics = new ContextStatics();
        statics.handler = handler;
        statics.use_static_semantics = use_static_semantics;
        statics.dialect = dialect;
        statics.setAbcVersion(target);
        if (use_namespaces != null) {
            statics.use_namespaces.addAll(use_namespaces);
        }
        if ((ver = System.getProperty("java.version", "noVersion")).indexOf("1.4") >= 0) {
            statics.es4_numerics = false;
        }
        Context cx = new Context(statics);
        cx.setLanguage(language);
        cx.setPath(pathspec);
        cx.setScriptName(scriptname);
        ActionBlockEmitter emitter = new ActionBlockEmitter(cx, scriptname, new StringPrintWriter(), new StringPrintWriter(), show_instructions, show_machinecode, show_linenums, emit_debug_info);
        cx.setEmitter(emitter);
        cx.setHandler(handler);
        cx.config_vars = configs;
        GlobalBuilder globalBuilder = new GlobalBuilder();
        ObjectValue global = new ObjectValue(cx, globalBuilder, null);
        Compiler.compile(cx, global, in, filename, encoding, includes, swf_options, avmplus_exe, plugs, emit_doc_info, show_parsetrees, show_bytes, show_flow, lint_mode, emit_metadata, save_comment_nodes, emit_debug_info, import_filespecs);
        int error_count = Compiler.status(cx);
        if (error_count == 1) {
            System.err.println();
            System.err.println("1 error found");
        } else if (error_count > 1) {
            System.err.println();
            System.err.println(error_count + " errors found");
        } else if (!show_parsetrees && !emit_doc_info) {
            if (show_instructions) {
                Compiler.printIL(cx, scriptname, emitter);
            }
            if (error_count == 0 && !show_parsetrees) {
                ByteList bytes = new ByteList();
                emitter.emit(bytes);
                if (bytes.size() != 0) {
                    if (optimize) {
                        bytes = Optimizer.optimize(bytes);
                    }
                    if (optimizer_configs != null) {
                        try {
                            byte[] optimized_abc = GlobalOptimizer.optimize(bytes.toByteArray(), filename, optimizer_configs, import_filespecs);
                            bytes.clear();
                            bytes.addAll(optimized_abc);
                        }
                        catch (Exception ex) {
                            System.err.println("Unable to optimize due to:");
                            ex.printStackTrace();
                        }
                    }
                    FilterOutputStream code_out = null;
                    try {
                        code_out = new BufferedOutputStream(new FileOutputStream(new File(pathspec, scriptname + ".abc")));
                        code_out.write(bytes.toByteArray());
                        ((BufferedOutputStream)code_out).flush();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (code_out != null) {
                            try {
                                code_out.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                    System.err.println();
                    if (swf_options.length() == 0 && !ContextStatics.useSanityStyleErrors) {
                        System.err.println(scriptname + ".abc, " + bytes.size() + " bytes written");
                    }
                    if (avmplus_exe != null) {
                        Compiler.createProjector(avmplus_exe, pathspec, scriptname, bytes);
                    }
                    if (swf_options.length() != 0) {
                        Compiler.makeSwf(cx, bytes, swf_options, pathspec, scriptname);
                    }
                    if (emitter.native_method_count > 0) {
                        Compiler.printNative(cx, scriptname, emitter, bytes.toByteArray(false));
                    }
                }
            }
        }
        statics.clear();
        Compiler.fini();
        return error_count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void makeSwf(Context cx, ByteList bytes, String swf_options, String pathspec, String scriptname) {
        SwfMaker swfMaker = new SwfMaker();
        if (cx.abcVersion(1)) {
            swfMaker.swf_version = 10;
        }
        if (!swfMaker.EncodeABC(bytes, swf_options)) {
            System.err.println("ERROR: invalid -swf options, should be classname,width,height");
        } else {
            FilterOutputStream swf_out = null;
            try {
                swf_out = new BufferedOutputStream(new FileOutputStream(new File(pathspec, scriptname + ".swf")));
                swf_out.write(swfMaker.buffer.toByteArray());
                ((BufferedOutputStream)swf_out).flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (swf_out != null) {
                    try {
                        swf_out.close();
                    }
                    catch (IOException ex) {}
                }
            }
            System.err.println(scriptname + ".swf, " + swfMaker.buffer.size() + " bytes written");
        }
    }

    static boolean doCompile(CompilerPlug mainplug, ObjectList<CompilerPlug> plugs, boolean show_instructions, boolean show_machinecode, boolean show_linenums, boolean show_parsetrees, boolean show_bytes, boolean show_flow) throws Exception {
        if (mainplug != null) {
            InputStream in;
            File f = new File(mainplug.filename.trim());
            if (f.exists()) {
                in = new BufferedInputStream(new FileInputStream(f));
            } else {
                byte[] buf = new byte[]{0};
                in = new ByteArrayInputStream(buf);
            }
            if (in != null) {
                mainplug.in = in;
            }
        }
        for (CompilerPlug plug : plugs) {
            InputStream in;
            File f = new File(plug.filename.trim());
            if (f.exists()) {
                in = new BufferedInputStream(new FileInputStream(f));
            } else {
                byte[] buf = new byte[]{0};
                in = new ByteArrayInputStream(buf);
            }
            if (in == null) continue;
            plug.in = in;
        }
        CompilerHandler handler = null;
        if (handler == null) {
            handler = mainplug.handler;
        }
        return Compiler.doCompile(mainplug.in, mainplug.pathspec, mainplug.scriptname, mainplug.filename, mainplug.file_encoding, mainplug.swf_options, mainplug.avmplus_exe, mainplug.includes, mainplug.import_filespecs, mainplug.use_namespaces, mainplug.language, mainplug.configs, plugs, handler, mainplug.emit_doc_info, mainplug.emit_debug_info, show_instructions, show_machinecode, show_linenums, show_parsetrees, show_bytes, show_flow, mainplug.lint_mode, mainplug.use_static_semantics, mainplug.emit_metadata, mainplug.save_comment_nodes, mainplug.dialect, mainplug.target, mainplug.optimize, mainplug.optimizer_configs);
    }

    static boolean doCompile(CompilerPlug mainplug) {
        return Compiler.doCompile(mainplug.in, mainplug.pathspec, mainplug.scriptname, mainplug.filename, mainplug.file_encoding, mainplug.swf_options, mainplug.avmplus_exe, mainplug.includes, mainplug.import_filespecs, mainplug.use_namespaces, mainplug.language, mainplug.configs, new ObjectList<CompilerPlug>(), mainplug.handler, mainplug.emit_doc_info, mainplug.emit_debug_info, false, false, false, false, false, false, mainplug.lint_mode, mainplug.use_static_semantics, mainplug.emit_metadata, mainplug.save_comment_nodes, mainplug.dialect, mainplug.target, mainplug.optimize, mainplug.optimizer_configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createProjector(String avmplus_exe, String pathspec, String scriptname, ByteList bytes) {
        BufferedInputStream exe_in = null;
        FilterOutputStream exe_out = null;
        int bytesWritten = 0;
        try {
            exe_in = new BufferedInputStream(new FileInputStream(new File(avmplus_exe)));
            int abc_length = bytes.size();
            int avmplus_exe_length = exe_in.available();
            byte[] avmplus_exe_bytes = new byte[avmplus_exe_length];
            exe_in.read(avmplus_exe_bytes);
            exe_out = new BufferedOutputStream(new FileOutputStream(new File(pathspec, scriptname + ".exe")));
            exe_out.write(avmplus_exe_bytes);
            bytesWritten += avmplus_exe_bytes.length;
            exe_out.write(bytes.toByteArray());
            bytesWritten += abc_length;
            byte[] header = new byte[]{86, 52, 18, -6, (byte)(abc_length & 0xFF), (byte)(abc_length >> 8 & 0xFF), (byte)(abc_length >> 16 & 0xFF), (byte)(abc_length >> 24 & 0xFF)};
            exe_out.write(header);
            bytesWritten += 8;
            ((BufferedOutputStream)exe_out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (exe_in != null) {
                try {
                    exe_in.close();
                }
                catch (IOException ex) {}
            }
            if (exe_out != null) {
                try {
                    exe_out.close();
                }
                catch (IOException ex) {}
            }
        }
        System.err.println(scriptname + ".exe, " + bytesWritten + " bytes written");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printIL(Context cx, String scriptname, ActionBlockEmitter emitter) {
        if (Compiler.status(cx) == 0) {
            OutputStreamWriter out = null;
            String str = emitter.il_str();
            try {
                out = new FileWriter(new File(cx.path(), scriptname + ".il"));
                out.write(str);
                out.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printNative(Context cx, String scriptname, ActionBlockEmitter emitter, byte[] bytes) {
        if (Compiler.status(cx) == 0) {
            String str = emitter.header_str();
            int count = bytes.length;
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(new File(cx.path(), scriptname + ".h")));
                out.write(str);
                out.println("extern const int " + scriptname + "_abc_length;");
                out.println("extern const int " + scriptname + "_abc_method_count;");
                out.println("extern const int " + scriptname + "_abc_class_count;");
                out.println("extern const int " + scriptname + "_abc_script_count;");
                out.println("extern const unsigned char " + scriptname + "_abc_data[];");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            out = null;
            try {
                out = new PrintWriter(new FileWriter(new File(cx.path(), scriptname + ".cpp")));
                out.println("const int " + scriptname + "_abc_length = " + count + ";");
                out.println("const int " + scriptname + "_abc_method_count = " + emitter.native_method_count + ";");
                out.println("const int " + scriptname + "_abc_class_count = " + emitter.native_class_count + ";");
                out.println("const int " + scriptname + "_abc_script_count = " + emitter.native_package_count + ";");
                out.println("const unsigned char " + scriptname + "_abc_data[" + count + "] = {");
                for (int i = 0; i < count; ++i) {
                    int b = 0xFF & bytes[i];
                    out.print("0x");
                    if (b < 16) {
                        out.print('0');
                    }
                    out.print(Integer.toHexString(b));
                    if (i + 1 < count) {
                        out.print(',');
                    }
                    if ((i + 1) % 16 == 0) {
                        out.println();
                        continue;
                    }
                    out.print(' ');
                }
                out.println("};");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    static int status(Context cx) {
        return cx.errorCount();
    }

    static void fini() {
        if (--ref_count == 0) {
            ObjectValue.clear();
            TypeValue.clear();
        }
    }

    static void printParseTrees(String scriptname, Node node, Context cx, String ext) {
        if (Compiler.status(cx) == 0) {
            PrintWriter out;
            try {
                out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(cx.path(), scriptname + ext)), "UTF-8")), true);
            }
            catch (IOException ex) {
                out = new PrintWriter(System.out, true);
            }
            NodePrinter printer = new NodePrinter(out);
            node.evaluate(cx, printer);
            out.flush();
            out.close();
        }
    }

    static void DetectFileImports(InputStream script, String scriptname, String filename, String classpath, CompilerHandler handler) {
    }

    static ProgramNode parseAbcFile(Context cx, String fixed_filespec) throws IOException {
        AbcParser p = new AbcParser(cx, fixed_filespec);
        return p.parseAbc();
    }
}

