/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import macromedia.abc.ByteArray;
import macromedia.abc.ByteArrayPool;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.Visitor;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntegerPool;

public class Encoder
implements Visitor {
    private ConstantPool pool;
    private int majorVersion;
    private int minorVersion;
    private int poolIndex;
    private int opcodePass;
    private int exPass;
    private boolean disableDebugging;
    private boolean removeMetadata;
    private boolean peepHole;
    private HashSet<String> keep_metadata = new HashSet();
    private BytecodeBuffer2 methodInfo;
    private ByteArrayPool2 metadataInfo;
    private BytecodeBuffer2 classInfo;
    private BytecodeBuffer2 scriptInfo;
    private BytecodeBuffer2 methodBodies;
    private BytecodeBuffer3 opcodes;
    private BytecodeBuffer exceptions;
    private BytecodeBuffer currentBuffer;
    private ConstantPool[] pools;
    static final int W = 8;
    int[] window = new int[8];
    int window_size = 0;
    int head = 0;
    boolean reachable = true;

    public Encoder(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.poolIndex = 0;
        this.peepHole = false;
        this.disableDebugging = false;
        this.removeMetadata = false;
    }

    public void enablePeepHole() {
        this.peepHole = true;
    }

    public void disableDebugging() {
        this.disableDebugging = true;
        this.pool.history.disableDebugging();
    }

    public void removeMetadata() {
        this.removeMetadata = true;
    }

    public void addMetadataToKeep(String meta_name) {
        this.keep_metadata.add(meta_name);
    }

    public void addConstantPools(ConstantPool[] pools) {
        this.pools = pools;
        this.pool = ConstantPool.merge(pools);
        if (this.disableDebugging) {
            this.pool.history.disableDebugging();
        }
    }

    public void test() {
        int size = this.pools.length;
        for (int i = 0; i < size; ++i) {
        }
    }

    public void configure(Decoder[] decoders) {
        int i;
        int estimatedSize = 0;
        int total = 0;
        int[] sizes = new int[decoders.length];
        int size = sizes.length;
        for (i = 0; i < size; ++i) {
            estimatedSize += decoders[i].methodInfo.estimatedSize;
            sizes[i] = decoders[i].methodInfo.size();
            total += sizes[i];
        }
        this.methodInfo = new BytecodeBuffer2(estimatedSize, sizes);
        this.methodInfo.writeU32(total);
        estimatedSize = 0;
        total = 0;
        sizes = new int[decoders.length];
        size = sizes.length;
        for (i = 0; i < size; ++i) {
            estimatedSize += decoders[i].metadataInfo.estimatedSize;
            sizes[i] = decoders[i].metadataInfo.size();
            total += sizes[i];
        }
        this.metadataInfo = new ByteArrayPool2(sizes);
        estimatedSize = 0;
        total = 0;
        sizes = new int[decoders.length];
        size = sizes.length;
        for (i = 0; i < size; ++i) {
            estimatedSize += decoders[i].classInfo.estimatedSize;
            sizes[i] = decoders[i].classInfo.size();
            total += sizes[i];
        }
        this.classInfo = new BytecodeBuffer2(estimatedSize, sizes);
        this.classInfo.writeU32(total);
        estimatedSize = 0;
        total = 0;
        sizes = new int[decoders.length];
        size = sizes.length;
        for (i = 0; i < size; ++i) {
            estimatedSize += decoders[i].scriptInfo.estimatedSize;
            sizes[i] = decoders[i].scriptInfo.size();
            total += sizes[i];
        }
        this.scriptInfo = new BytecodeBuffer2(estimatedSize, sizes);
        this.scriptInfo.writeU32(total);
        estimatedSize = 0;
        total = 0;
        sizes = new int[decoders.length];
        size = sizes.length;
        for (i = 0; i < size; ++i) {
            estimatedSize += decoders[i].methodBodies.estimatedSize;
            sizes[i] = decoders[i].methodBodies.size();
            total += sizes[i];
        }
        this.methodBodies = new BytecodeBuffer2(estimatedSize, sizes);
        this.methodBodies.writeU32(total);
        this.opcodes = new BytecodeBuffer3(decoders, 4096);
        this.exceptions = new BytecodeBuffer(4096);
    }

    public void useConstantPool(int index) {
        this.poolIndex = index;
    }

    public byte[] toABC() {
        int size = this.pool.in.size() + this.methodInfo.size() + this.metadataInfo.size() + this.classInfo.size() + this.scriptInfo.size() + this.methodBodies.size();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        try {
            baos.write((byte)this.minorVersion);
            baos.write((byte)(this.minorVersion >> 8));
            baos.write((byte)this.majorVersion);
            baos.write((byte)(this.majorVersion >> 8));
            this.pool.writeTo(baos);
            this.methodInfo.writeTo(baos);
            this.metadataInfo.writeTo(baos);
            this.classInfo.writeTo(baos);
            this.scriptInfo.writeTo(baos);
            this.methodBodies.writeTo(baos);
        }
        catch (IOException ex) {
            return null;
        }
        return baos.toByteArray();
    }

    public void methodInfo(int returnType, int[] paramTypes, int nativeName, int flags, int[] values, int[] value_kinds, int[] param_names) {
        int optionalCount;
        int i;
        int paramCount;
        if (paramTypes == null) {
            this.methodInfo.writeU32(0L);
        } else {
            this.methodInfo.writeU32(paramTypes.length);
        }
        this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 7, returnType));
        int n = paramCount = paramTypes == null ? 0 : paramTypes.length;
        for (i = 0; i < paramCount; ++i) {
            this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 7, paramTypes[i]));
        }
        this.methodInfo.writeU32(this.disableDebugging ? 0L : (long)this.pool.history.getIndex(this.poolIndex, 4, nativeName));
        if (this.disableDebugging) {
            flags &= 0xFFFFFF7F;
        }
        this.methodInfo.writeU8(flags);
        if ((flags & 8) != 0) {
            if (values == null) {
                this.methodInfo.writeU32(0L);
            } else {
                this.methodInfo.writeU32(values.length);
            }
        }
        int n2 = optionalCount = values == null ? 0 : values.length;
        for (i = 0; i < optionalCount; ++i) {
            int kind = -1;
            switch (value_kinds[i]) {
                case 1: {
                    kind = 4;
                    break;
                }
                case 3: {
                    kind = 0;
                    break;
                }
                case 4: {
                    kind = 1;
                    break;
                }
                case 6: {
                    kind = 2;
                    break;
                }
                case 2: {
                    kind = 3;
                    break;
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    kind = 5;
                    break;
                }
                case 7: 
                case 9: 
                case 13: 
                case 14: 
                case 29: {
                    kind = 7;
                    break;
                }
                case 21: {
                    kind = 6;
                }
            }
            int newIndex = 0;
            switch (value_kinds[i]) {
                case 0: 
                case 10: 
                case 11: 
                case 12: {
                    newIndex = values[i];
                    break;
                }
                default: {
                    if (kind == -1) {
                        System.out.println("writing MethodInfo: don't know what constant type it is... " + value_kinds[i] + "," + values[i]);
                    }
                    newIndex = this.pool.history.getIndex(this.poolIndex, kind, values[i]);
                }
            }
            this.methodInfo.writeU32(newIndex);
            this.methodInfo.writeU8(value_kinds[i]);
        }
        if ((flags & 0x80) != 0 && param_names != null) {
            for (i = 0; i < param_names.length; ++i) {
                this.methodInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 4, returnType));
            }
        }
    }

    public void metadataInfo(int index, int name, int[] keys, int[] values) {
        try {
            int valueCount;
            int i;
            int keyCount;
            String s = this.pools[this.poolIndex].getString(name);
            if (this.removeMetadata && !this.keep_metadata.contains(s)) {
                return;
            }
            BytecodeBuffer b = new BytecodeBuffer(6);
            b.writeU32(this.pool.history.getIndex(this.poolIndex, 4, name));
            if (keys == null) {
                b.writeU32(0L);
            } else {
                b.writeU32(keys.length);
            }
            int n = keyCount = keys == null ? 0 : keys.length;
            for (i = 0; i < keyCount; ++i) {
                b.writeU32(this.pool.history.getIndex(this.poolIndex, 4, keys[i]));
            }
            int n2 = valueCount = values == null ? 0 : values.length;
            for (i = 0; i < valueCount; ++i) {
                b.writeU32(this.pool.history.getIndex(this.poolIndex, 4, values[i]));
            }
            this.metadataInfo.addByteArray(this.poolIndex, index, b);
        }
        catch (DecoderException ex) {
            // empty catch block
        }
    }

    public void startInstance(int name, int superName, boolean isDynamic, boolean isFinal, boolean isInterface, int[] interfaces, int iinit, int protectedNamespace) {
        int interfaceCount;
        this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
        this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 7, superName));
        int flags = 0;
        flags = isFinal ? flags | 2 : flags;
        flags = !isDynamic ? flags | 1 : flags;
        flags = isInterface ? flags | 4 : flags;
        flags = protectedNamespace != 0 ? flags | 8 : flags;
        this.classInfo.writeU8(flags);
        if (protectedNamespace != 0) {
            this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 5, protectedNamespace));
        }
        if (interfaces == null) {
            this.classInfo.writeU32(0L);
        } else {
            this.classInfo.writeU32(interfaces.length);
        }
        int n = interfaceCount = interfaces == null ? 0 : interfaces.length;
        for (int i = 0; i < interfaceCount; ++i) {
            this.classInfo.writeU32(this.pool.history.getIndex(this.poolIndex, 7, interfaces[i]));
        }
        this.classInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, iinit));
        this.currentBuffer = this.classInfo;
    }

    public void endInstance() {
        this.currentBuffer = null;
    }

    public void startClass(int name, int cinit) {
        this.classInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, cinit));
        this.currentBuffer = this.classInfo;
    }

    public void endClass() {
        this.currentBuffer = null;
    }

    public void startScript(int initID) {
        this.scriptInfo.writeU32(this.methodInfo.getIndex(this.poolIndex, initID));
        this.currentBuffer = this.scriptInfo;
    }

    public void endScript() {
        this.currentBuffer = null;
    }

    public void startMethodBody(int methodInfo, int maxStack, int maxRegs, int scopeDepth, int maxScope, int codeStart, long codeLength) {
        this.methodBodies.writeU32(this.methodInfo.getIndex(this.poolIndex, methodInfo));
        this.methodBodies.writeU32(maxStack);
        this.methodBodies.writeU32(maxRegs);
        this.methodBodies.writeU32(scopeDepth);
        this.methodBodies.writeU32(maxScope);
        this.currentBuffer = this.methodBodies;
        this.opcodePass = 1;
        this.exPass = 1;
    }

    public void endMethodBody() {
        this.currentBuffer = null;
        this.opcodes.clear();
        this.exceptions.clear();
    }

    public void startOpcodes(int methodInfo) {
    }

    public void endOpcodes() {
        if (this.opcodePass == 1) {
            this.opcodePass = 2;
        } else if (this.opcodePass == 2) {
            this.methodBodies.writeU32(this.opcodes.size());
            this.methodBodies.writeBytes(this.opcodes, 0, this.opcodes.size());
        }
    }

    public void exception(long start, long end, long target, int type, int name) {
        if (this.exPass == 2) {
            this.exceptions.writeU32(this.opcodes.getOffset(start));
            this.exceptions.writeU32(this.opcodes.getOffset(end));
            this.exceptions.writeU32(this.opcodes.getOffset(target));
            this.exceptions.writeU32(this.pool.history.getIndex(this.poolIndex, 7, type));
            if (this.minorVersion != 15) {
                this.exceptions.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
            }
        }
    }

    public void startExceptions(int exceptionCount) {
        if (this.exPass == 2) {
            this.exceptions.writeU32(exceptionCount);
        }
    }

    public void endExceptions() {
        if (this.exPass == 1) {
            ++this.exPass;
        } else if (this.exPass == 2) {
            this.methodBodies.writeBytes(this.exceptions, 0, this.exceptions.size());
        }
    }

    public void traitCount(int traitCount) {
        this.currentBuffer.writeU32(traitCount);
    }

    private void encodeMetaData(int kind, IntList metadata) {
        if ((kind >> 4 & 4) != 0) {
            int length;
            if (metadata == null) {
                this.currentBuffer.writeU32(0L);
            } else {
                this.currentBuffer.writeU32(metadata.size());
            }
            int n = length = metadata == null ? 0 : metadata.size();
            for (int i = 0; i < length; ++i) {
                this.currentBuffer.writeU32(metadata.get(i));
            }
        }
    }

    private IntList trimMetadata(int[] metadata) {
        IntList newMetadata = new IntList();
        int length = metadata != null ? metadata.length : 0;
        for (int i = 0; i < length; ++i) {
            int new_index = this.metadataInfo.getIndex(this.poolIndex, metadata[i]);
            if (new_index == -1) continue;
            newMetadata.add(new_index);
        }
        return newMetadata;
    }

    public void slotTrait(int trait_kind, int name, int slotId, int type, int value, int value_kind, int[] metadata) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
        IntList new_metadata = this.trimMetadata(metadata);
        if ((trait_kind >> 4 & 4) != 0 && new_metadata.size() == 0) {
            trait_kind &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(trait_kind);
        this.currentBuffer.writeU32(slotId);
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 7, type));
        int kind = -1;
        switch (value_kind) {
            case 1: {
                kind = 4;
                break;
            }
            case 3: {
                kind = 0;
                break;
            }
            case 4: {
                kind = 1;
                break;
            }
            case 6: {
                kind = 2;
                break;
            }
            case 2: {
                kind = 3;
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                kind = 5;
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 29: {
                kind = 7;
                break;
            }
            case 21: {
                kind = 6;
            }
        }
        int newIndex = 0;
        switch (value_kind) {
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                newIndex = value;
                break;
            }
            default: {
                if (kind == -1) {
                    System.out.println("writing slotTrait: don't know what constant type it is... " + value_kind + "," + value);
                }
                newIndex = this.pool.history.getIndex(this.poolIndex, kind, value);
            }
        }
        this.currentBuffer.writeU32(newIndex);
        if (value != 0) {
            this.currentBuffer.writeU8(value_kind);
        }
        this.encodeMetaData(trait_kind, new_metadata);
    }

    public void methodTrait(int trait_kind, int name, int dispId, int methodInfo, int[] metadata) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
        IntList new_metadata = this.trimMetadata(metadata);
        if ((trait_kind >> 4 & 4) != 0 && new_metadata.size() == 0) {
            trait_kind &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(trait_kind);
        this.currentBuffer.writeU32(dispId);
        this.currentBuffer.writeU32(this.methodInfo.getIndex(this.poolIndex, methodInfo));
        this.encodeMetaData(trait_kind, new_metadata);
    }

    public void classTrait(int kind, int name, int slotId, int classIndex, int[] metadata) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
        IntList new_metadata = this.trimMetadata(metadata);
        if ((kind >> 4 & 4) != 0 && new_metadata.size() == 0) {
            kind &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(kind);
        this.currentBuffer.writeU32(slotId);
        this.currentBuffer.writeU32(this.classInfo.getIndex(this.poolIndex, classIndex));
        this.encodeMetaData(kind, new_metadata);
    }

    public void functionTrait(int kind, int name, int slotId, int methodInfo, int[] metadata) {
        this.currentBuffer.writeU32(this.pool.history.getIndex(this.poolIndex, 7, name));
        IntList new_metadata = this.trimMetadata(metadata);
        if ((kind >> 4 & 4) != 0 && new_metadata.size() == 0) {
            kind &= 0xFFFFFFBF;
        }
        this.currentBuffer.writeU8(kind);
        this.currentBuffer.writeU32(slotId);
        this.currentBuffer.writeU32(this.methodInfo.getIndex(this.poolIndex, methodInfo));
        this.encodeMetaData(kind, new_metadata);
    }

    void clearWindow() {
        for (int i = 0; i < 8; ++i) {
            this.window[i] = 0;
        }
        this.window_size = 0;
    }

    void beginop(int opcode) {
        this.window[this.head] = this.opcodes.size();
        this.head = this.head + 1 & 7;
        if (this.window_size < 8) {
            ++this.window_size;
        }
        this.opcodes.writeU8(opcode);
    }

    int opat(int i) {
        int ip;
        if (this.peepHole && i <= this.window_size && (ip = this.window[this.head - i & 7]) < this.opcodes.size()) {
            return this.opcodes.readU8(ip);
        }
        return 0;
    }

    void setOpcodeAt(int i, int opcode) {
        int ip;
        assert (this.peepHole);
        if (i <= this.window_size && (ip = this.window[this.head - i & 7]) < this.opcodes.size()) {
            this.opcodes.writeU8(ip, opcode);
        }
    }

    int readByteAt(int i) {
        if (i <= this.window_size) {
            int ip = 1 + this.window[this.head - i & 7];
            return (byte)this.opcodes.readU8(ip);
        }
        return 0;
    }

    int readIntAt(int i) {
        if (i <= this.window_size) {
            int ip = 1 + this.window[this.head - i & 7];
            return (int)this.opcodes.readU32(ip);
        }
        return 0;
    }

    void rewind(int i) {
        int to = this.head - i & 7;
        int ip = this.window[to];
        int end = this.opcodes.size();
        this.opcodes.delete(end - ip);
        this.head = to;
        this.window_size -= i;
    }

    public void target(int oldPos) {
        if (this.opcodePass == 1) {
            this.opcodes.mapOffsets(oldPos);
            this.clearWindow();
        }
    }

    public void OP_returnvoid() {
        if (this.opcodePass == 1) {
            this.beginop(71);
        }
    }

    public void OP_returnvalue() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            if (this.opat(1) == 33) {
                this.rewind(1);
                this.OP_returnvoid();
                return;
            }
            this.beginop(72);
        }
    }

    public void OP_nop() {
        if (this.opcodePass == 1) {
            this.beginop(2);
        }
    }

    public void OP_bkpt() {
        if (this.opcodePass == 1) {
            this.beginop(1);
        }
    }

    public void OP_timestamp() {
        if (this.opcodePass == 1) {
            this.beginop(243);
        }
    }

    public void OP_debugline(int linenum) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(240);
            this.opcodes.writeU32(linenum);
        }
    }

    public void OP_bkptline() {
        if (this.opcodePass == 1) {
            this.beginop(242);
        }
    }

    public void OP_debug(int di_local, int index, int slot, int linenum) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(239);
            this.opcodes.writeU8(di_local);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 4, index));
            this.opcodes.writeU8(slot);
            this.opcodes.writeU32(linenum);
        }
    }

    public void OP_debugfile(int index) {
        if (this.opcodePass == 1 && !this.disableDebugging) {
            this.beginop(241);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 4, index));
        }
    }

    public void OP_jump(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(16);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_pushnull() {
        if (this.opcodePass == 1) {
            this.beginop(32);
        }
    }

    public void OP_pushundefined() {
        if (this.opcodePass == 1) {
            this.beginop(33);
        }
    }

    public void OP_pushstring(int index) {
        if (this.opcodePass == 1) {
            this.beginop(44);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 4, index));
        }
    }

    public void OP_pushnamespace(int index) {
        if (this.opcodePass == 1) {
            this.beginop(49);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 5, index));
        }
    }

    public void OP_pushint(int index) {
        if (this.opcodePass == 1) {
            this.beginop(45);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 0, index));
        }
    }

    public void OP_pushuint(int index) {
        if (this.opcodePass == 1) {
            this.beginop(46);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 1, index));
        }
    }

    public void OP_pushdouble(int index) {
        if (this.opcodePass == 1) {
            this.beginop(47);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 2, index));
        }
    }

    public void OP_pushdecimal(int index) {
        if (this.opcodePass == 1) {
            this.beginop(51);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 3, index));
        }
    }

    public void OP_getlocal(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 99 && this.readIntAt(1) == index) {
                this.rewind(1);
                this.OP_dup();
                this.OP_setlocal(index);
                return;
            }
            this.beginop(98);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_pushtrue() {
        if (this.opcodePass == 1) {
            this.beginop(38);
        }
    }

    public void OP_pushfalse() {
        if (this.opcodePass == 1) {
            this.beginop(39);
        }
    }

    public void OP_pushnan() {
        if (this.opcodePass == 1) {
            this.beginop(40);
        }
    }

    public void OP_pushdnan() {
        if (this.opcodePass == 1) {
            this.beginop(52);
        }
    }

    public void OP_pop() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 70: {
                    this.setOpcodeAt(1, 79);
                    return;
                }
                case 69: {
                    this.setOpcodeAt(1, 78);
                    return;
                }
            }
            this.beginop(41);
        }
    }

    public void OP_dup() {
        if (this.opcodePass == 1) {
            this.beginop(42);
        }
    }

    public void OP_swap() {
        if (this.opcodePass == 1) {
            this.beginop(43);
        }
    }

    public void OP_convert_s() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            switch (this.opat(1)) {
                case 44: 
                case 112: 
                case 133: 
                case 149: {
                    return;
                }
            }
            if (this.opat(2) == 44 && this.opat(1) == 160) {
                return;
            }
            this.beginop(112);
        }
    }

    public void OP_esc_xelem() {
        if (this.opcodePass == 1) {
            this.beginop(113);
        }
    }

    public void OP_esc_xattr() {
        if (this.opcodePass == 1) {
            this.beginop(114);
        }
    }

    public void OP_checkfilter() {
        if (this.opcodePass == 1) {
            this.beginop(120);
        }
    }

    public void OP_convert_d() {
        if (this.opcodePass == 1) {
            this.beginop(117);
        }
    }

    public void OP_convert_m() {
        if (this.opcodePass == 1) {
            this.beginop(121);
        }
    }

    public void OP_convert_m_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(121);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_convert_b() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 38: 
                case 39: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    return;
                }
            }
            this.beginop(118);
        }
    }

    public void OP_convert_o() {
        if (this.opcodePass == 1) {
            this.beginop(119);
        }
    }

    public void OP_negate() {
        if (this.opcodePass == 1) {
            this.beginop(144);
        }
    }

    public void OP_negate_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(143);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_negate_i() {
        if (this.opcodePass == 1) {
            this.beginop(196);
        }
    }

    public void OP_increment() {
        if (this.opcodePass == 1) {
            this.beginop(145);
        }
    }

    public void OP_increment_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(156);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_increment_i() {
        if (this.opcodePass == 1) {
            this.beginop(192);
        }
    }

    public void OP_inclocal(int index) {
        if (this.opcodePass == 1) {
            this.beginop(146);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_inclocal_p(int param, int index) {
        if (this.opcodePass == 1) {
            this.beginop(157);
            this.opcodes.writeU32(param);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_kill(int index) {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 71: 
                case 72: {
                    return;
                }
            }
            this.beginop(8);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_inclocal_i(int index) {
        if (this.opcodePass == 1) {
            this.beginop(194);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_decrement() {
        if (this.opcodePass == 1) {
            this.beginop(147);
        }
    }

    public void OP_decrement_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(158);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_decrement_i() {
        if (this.opcodePass == 1) {
            this.beginop(193);
        }
    }

    public void OP_declocal(int index) {
        if (this.opcodePass == 1) {
            this.beginop(148);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_declocal_p(int param, int index) {
        if (this.opcodePass == 1) {
            this.beginop(159);
            this.opcodes.writeU32(param);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_declocal_i(int index) {
        if (this.opcodePass == 1) {
            this.beginop(195);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_typeof() {
        if (this.opcodePass == 1) {
            this.beginop(149);
        }
    }

    public void OP_not() {
        if (this.opcodePass == 1) {
            this.beginop(150);
        }
    }

    public void OP_bitnot() {
        if (this.opcodePass == 1) {
            this.beginop(151);
        }
    }

    public void OP_setlocal(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 98 && this.readIntAt(2) == index && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(index);
                return;
            }
            if (this.opat(2) == 98 && this.readIntAt(2) == index && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(index);
                return;
            }
            this.beginop(99);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_add() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(160);
        }
    }

    public void OP_add_p(int param) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(181);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_add_i() {
        if (this.opcodePass == 1) {
            this.beginop(197);
        }
    }

    public void OP_subtract() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readByteAt(1) == 1) {
                this.rewind(1);
                this.OP_decrement();
                return;
            }
            this.beginop(161);
        }
    }

    public void OP_subtract_p(int param) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readByteAt(1) == 1) {
                this.rewind(1);
                this.OP_decrement_p(param);
                return;
            }
            this.beginop(182);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_subtract_i() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readIntAt(1) == 1) {
                this.rewind(1);
                this.OP_decrement_i();
                return;
            }
            this.beginop(198);
        }
    }

    public void OP_multiply() {
        if (this.opcodePass == 1) {
            this.beginop(162);
        }
    }

    public void OP_multiply_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(183);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_multiply_i() {
        if (this.opcodePass == 1) {
            this.beginop(199);
        }
    }

    public void OP_divide() {
        if (this.opcodePass == 1) {
            this.beginop(163);
        }
    }

    public void OP_divide_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(184);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_modulo() {
        if (this.opcodePass == 1) {
            this.beginop(164);
        }
    }

    public void OP_modulo_p(int param) {
        if (this.opcodePass == 1) {
            this.beginop(185);
            this.opcodes.writeU32(param);
        }
    }

    public void OP_lshift() {
        if (this.opcodePass == 1) {
            this.beginop(165);
        }
    }

    public void OP_rshift() {
        if (this.opcodePass == 1) {
            this.beginop(166);
        }
    }

    public void OP_urshift() {
        if (this.opcodePass == 1) {
            this.beginop(167);
        }
    }

    public void OP_bitand() {
        if (this.opcodePass == 1) {
            this.beginop(168);
        }
    }

    public void OP_bitor() {
        if (this.opcodePass == 1) {
            this.beginop(169);
        }
    }

    public void OP_bitxor() {
        if (this.opcodePass == 1) {
            this.beginop(170);
        }
    }

    public void OP_equals() {
        if (this.opcodePass == 1) {
            this.beginop(171);
        }
    }

    public void OP_strictequals() {
        if (this.opcodePass == 1) {
            this.beginop(172);
        }
    }

    public void OP_lookupswitch(int defaultPos, int[] casePos, int oldPos, int oldTablePos) {
        block3: {
            block2: {
                if (this.opcodePass != 1) break block2;
                this.opcodes.mapOffsets(oldPos);
                this.beginop(27);
                this.opcodes.mapOffsets(oldPos + 1);
                this.opcodes.writeS24(defaultPos);
                this.opcodes.writeU32(casePos == null || casePos.length == 0 ? 0L : (long)(casePos.length - 1));
                int size = casePos.length;
                for (int i = 0; i < size; ++i) {
                    this.opcodes.mapOffsets(oldTablePos + 3 * i);
                    this.opcodes.writeS24(casePos[i]);
                }
                break block3;
            }
            if (this.opcodePass != 2) break block3;
            this.opcodes.updateOffset(oldPos + 1, oldPos, oldPos + defaultPos);
            int size = casePos.length;
            for (int i = 0; i < size; ++i) {
                this.opcodes.updateOffset(oldTablePos + 3 * i, oldPos, oldPos + casePos[i]);
            }
        }
    }

    public void OP_iftrue(int offset, int pos) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 118) {
                this.rewind(1);
            }
            if (this.opat(1) == 38) {
                this.rewind(1);
                this.OP_jump(offset, pos);
                return;
            }
            this.beginop(17);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_iffalse(int offset, int pos) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 118) {
                this.rewind(1);
            }
            if (this.opat(2) == 172 && this.opat(1) == 150) {
                this.rewind(2);
                this.OP_ifstricteq(offset, pos);
                return;
            }
            if (this.opat(2) == 171 && this.opat(1) == 150) {
                this.rewind(2);
                this.OP_ifeq(offset, pos);
                return;
            }
            if (this.opat(1) == 150) {
                this.rewind(1);
                this.OP_iftrue(offset, pos);
                return;
            }
            if (this.opat(1) == 39) {
                this.rewind(1);
                this.OP_jump(offset, pos);
                return;
            }
            this.beginop(18);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifeq(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(19);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifne(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(20);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifstricteq(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(25);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifstrictne(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(26);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_iflt(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(21);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifle(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(22);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifgt(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(23);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifge(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(24);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_lessthan() {
        if (this.opcodePass == 1) {
            this.beginop(173);
        }
    }

    public void OP_lessequals() {
        if (this.opcodePass == 1) {
            this.beginop(174);
        }
    }

    public void OP_greaterthan() {
        if (this.opcodePass == 1) {
            this.beginop(175);
        }
    }

    public void OP_greaterequals() {
        if (this.opcodePass == 1) {
            this.beginop(176);
        }
    }

    public void OP_newobject(int size) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130 && size >= 1) {
                this.rewind(1);
            }
            this.beginop(85);
            this.opcodes.writeU32(size);
        }
    }

    public void OP_newarray(int size) {
        if (this.opcodePass == 1) {
            this.beginop(86);
            this.opcodes.writeU32(size);
        }
    }

    public void OP_getproperty(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 93 && this.readIntAt(1) == this.pool.history.getIndex(this.poolIndex, 7, index)) {
                this.rewind(1);
                this.OP_getlex(index);
                return;
            }
            this.beginop(102);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_setproperty(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(97);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_initproperty(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(104);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_getdescendants(int index) {
        if (this.opcodePass == 1) {
            this.beginop(89);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_findpropstrict(int index) {
        if (this.opcodePass == 1) {
            this.beginop(93);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_findproperty(int index) {
        if (this.opcodePass == 1) {
            this.beginop(94);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_finddef(int index) {
        if (this.opcodePass == 1) {
            this.beginop(95);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_getlex(int index) {
        if (this.opcodePass == 1) {
            this.beginop(96);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_nextname() {
        if (this.opcodePass == 1) {
            this.beginop(30);
        }
    }

    public void OP_nextvalue() {
        if (this.opcodePass == 1) {
            this.beginop(35);
        }
    }

    public void OP_hasnext() {
        if (this.opcodePass == 1) {
            this.beginop(31);
        }
    }

    public void OP_hasnext2(int objectRegister, int indexRegister) {
        if (this.opcodePass == 1) {
            this.beginop(50);
            this.opcodes.writeU32(objectRegister);
            this.opcodes.writeU32(indexRegister);
        }
    }

    public void OP_deleteproperty(int index) {
        if (this.opcodePass == 1) {
            this.beginop(106);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_setslot(int index) {
        if (this.opcodePass == 1) {
            this.beginop(109);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_getslot(int index) {
        if (this.opcodePass == 1) {
            this.beginop(108);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_setglobalslot(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(111);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_getglobalslot(int index) {
        if (this.opcodePass == 1) {
            this.beginop(110);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_call(int size) {
        if (this.opcodePass == 1) {
            this.beginop(65);
            this.opcodes.writeU32(size);
        }
    }

    public void OP_construct(int size) {
        if (this.opcodePass == 1) {
            this.beginop(66);
            this.opcodes.writeU32(size);
        }
    }

    public void OP_applytype(int size) {
        if (this.opcodePass == 1) {
            this.beginop(83);
            this.opcodes.writeU32(size);
        }
    }

    public void OP_newfunction(int id) {
        if (this.opcodePass == 1) {
            this.beginop(64);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, id));
        }
    }

    public void OP_newclass(int id) {
        if (this.opcodePass == 1) {
            this.beginop(88);
            this.opcodes.writeU32(this.classInfo.getIndex(this.poolIndex, id));
        }
    }

    public void OP_callstatic(int id, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(68);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, id));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_callmethod(int id, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(67);
            this.opcodes.writeU32(this.methodInfo.getIndex(this.poolIndex, id));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_callproperty(int index, int argc) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                this.rewind(1);
            }
            this.beginop(70);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_callproplex(int index, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(76);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_constructprop(int index, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(74);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_callsuper(int index, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(69);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_getsuper(int index) {
        if (this.opcodePass == 1) {
            this.beginop(4);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_setsuper(int index) {
        if (this.opcodePass == 1) {
            this.beginop(5);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_constructsuper(int argc) {
        if (this.opcodePass == 1) {
            this.beginop(73);
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_pushshort(int n) {
        if (this.opcodePass == 1) {
            if (this.peepHole && n >= -128 && n <= 127) {
                this.OP_pushbyte(n);
                return;
            }
            this.beginop(37);
            this.opcodes.writeU32(n);
        }
    }

    public void OP_astype(int index) {
        if (this.opcodePass == 1) {
            this.beginop(134);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_astypelate() {
        if (this.opcodePass == 1) {
            this.beginop(135);
        }
    }

    public void OP_coerce(int index) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 128 && this.readIntAt(1) == this.pool.history.getIndex(this.poolIndex, 7, index)) {
                return;
            }
            this.beginop(128);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_coerce_b() {
        if (this.opcodePass == 1) {
            this.beginop(129);
        }
    }

    public void OP_coerce_o() {
        if (this.opcodePass == 1) {
            this.beginop(137);
        }
    }

    public void OP_coerce_a() {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 130) {
                return;
            }
            this.beginop(130);
        }
    }

    public void OP_coerce_i() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 36: 
                case 37: 
                case 45: 
                case 115: 
                case 131: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 197: 
                case 198: 
                case 199: {
                    return;
                }
            }
            this.beginop(131);
        }
    }

    public void OP_coerce_u() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 116: 
                case 136: 
                case 167: {
                    return;
                }
            }
            this.beginop(136);
        }
    }

    public void OP_coerce_d() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 117: 
                case 132: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    return;
                }
            }
            this.beginop(132);
        }
    }

    public void OP_coerce_s() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 44: 
                case 112: 
                case 133: 
                case 149: {
                    return;
                }
            }
            if (this.opat(2) == 44 && this.opat(1) == 160) {
                return;
            }
            this.beginop(133);
        }
    }

    public void OP_istype(int index) {
        if (this.opcodePass == 1) {
            this.beginop(178);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
        }
    }

    public void OP_istypelate() {
        if (this.opcodePass == 1) {
            this.beginop(179);
        }
    }

    public void OP_pushbyte(int n) {
        if (this.opcodePass == 1) {
            if (this.opat(1) == 36 && this.readByteAt(1) == n || this.opat(1) == 42 && this.opat(2) == 36 && this.readByteAt(2) == n) {
                this.OP_dup();
                return;
            }
            this.beginop(36);
            this.opcodes.writeU8(n);
        }
    }

    public void OP_getscopeobject(int index) {
        if (this.opcodePass == 1) {
            this.beginop(101);
            this.opcodes.writeU8(index);
        }
    }

    public void OP_pushscope() {
        if (this.opcodePass == 1) {
            this.beginop(48);
        }
    }

    public void OP_popscope() {
        if (this.opcodePass == 1) {
            this.beginop(29);
        }
    }

    public void OP_convert_i() {
        if (this.opcodePass == 1) {
            switch (this.opat(1)) {
                case 36: 
                case 37: 
                case 45: 
                case 115: 
                case 131: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 197: 
                case 198: 
                case 199: {
                    return;
                }
            }
            this.beginop(115);
        }
    }

    public void OP_convert_u() {
        if (this.opcodePass == 1) {
            this.beginop(116);
        }
    }

    public void OP_throw() {
        if (this.opcodePass == 1) {
            this.beginop(3);
        }
    }

    public void OP_instanceof() {
        if (this.opcodePass == 1) {
            this.beginop(177);
        }
    }

    public void OP_in() {
        if (this.opcodePass == 1) {
            this.beginop(180);
        }
    }

    public void OP_dxns(int index) {
        if (this.opcodePass == 1) {
            this.beginop(6);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 4, index));
        }
    }

    public void OP_dxnslate() {
        if (this.opcodePass == 1) {
            this.beginop(7);
        }
    }

    public void OP_ifnlt(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(12);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifnle(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(13);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifngt(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(14);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_ifnge(int offset, int pos) {
        if (this.opcodePass == 1) {
            this.beginop(15);
            this.opcodes.writeS24(offset);
            this.opcodes.mapOffsets(pos);
        } else if (this.opcodePass == 2) {
            this.opcodes.updateOffset(pos + offset);
        }
    }

    public void OP_pushwith() {
        if (this.opcodePass == 1) {
            this.beginop(28);
        }
    }

    public void OP_newactivation() {
        if (this.opcodePass == 1) {
            this.beginop(87);
        }
    }

    public void OP_newcatch(int index) {
        if (this.opcodePass == 1) {
            this.beginop(90);
            this.opcodes.writeU32(index);
        }
    }

    public void OP_deldescendants() {
        if (this.opcodePass == 1) {
            this.beginop(91);
        }
    }

    public void OP_getglobalscope() {
        if (this.opcodePass == 1) {
            this.beginop(100);
        }
    }

    public void OP_getlocal0() {
        if (this.opcodePass == 1) {
            this.beginop(208);
        }
    }

    public void OP_getlocal1() {
        if (this.opcodePass == 1) {
            this.beginop(209);
        }
    }

    public void OP_getlocal2() {
        if (this.opcodePass == 1) {
            this.beginop(210);
        }
    }

    public void OP_getlocal3() {
        if (this.opcodePass == 1) {
            this.beginop(211);
        }
    }

    public void OP_setlocal0() {
        if (this.opcodePass == 1) {
            this.beginop(212);
        }
    }

    public void OP_setlocal1() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 209 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(1);
                return;
            }
            if (this.opat(2) == 209 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(1);
                return;
            }
            this.beginop(213);
        }
    }

    public void OP_setlocal2() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 210 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(2);
                return;
            }
            if (this.opat(2) == 210 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(2);
                return;
            }
            this.beginop(214);
        }
    }

    public void OP_setlocal3() {
        if (this.opcodePass == 1) {
            if (this.opat(2) == 211 && this.opat(1) == 192) {
                this.rewind(2);
                this.OP_inclocal_i(3);
                return;
            }
            if (this.opat(2) == 211 && this.opat(1) == 145) {
                this.rewind(2);
                this.OP_inclocal(3);
                return;
            }
            this.beginop(215);
        }
    }

    public void OP_label() {
        if (this.opcodePass == 1) {
            this.beginop(9);
        }
    }

    public void OP_pushconstant(int id) {
        if (this.opcodePass == 1) {
            this.beginop(34);
            this.opcodes.writeU32(id);
        }
    }

    public void OP_callsupervoid(int index, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(78);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_callpropvoid(int index, int argc) {
        if (this.opcodePass == 1) {
            this.beginop(79);
            this.opcodes.writeU32(this.pool.history.getIndex(this.poolIndex, 7, index));
            this.opcodes.writeU32(argc);
        }
    }

    public void OP_li8() {
        if (this.opcodePass == 1) {
            this.beginop(53);
        }
    }

    public void OP_li16() {
        if (this.opcodePass == 1) {
            this.beginop(54);
        }
    }

    public void OP_li32() {
        if (this.opcodePass == 1) {
            this.beginop(55);
        }
    }

    public void OP_lf32() {
        if (this.opcodePass == 1) {
            this.beginop(56);
        }
    }

    public void OP_lf64() {
        if (this.opcodePass == 1) {
            this.beginop(57);
        }
    }

    public void OP_si8() {
        if (this.opcodePass == 1) {
            this.beginop(58);
        }
    }

    public void OP_si16() {
        if (this.opcodePass == 1) {
            this.beginop(59);
        }
    }

    public void OP_si32() {
        if (this.opcodePass == 1) {
            this.beginop(60);
        }
    }

    public void OP_sf32() {
        if (this.opcodePass == 1) {
            this.beginop(61);
        }
    }

    public void OP_sf64() {
        if (this.opcodePass == 1) {
            this.beginop(62);
        }
    }

    public void OP_sxi1() {
        if (this.opcodePass == 1) {
            this.beginop(80);
        }
    }

    public void OP_sxi8() {
        if (this.opcodePass == 1) {
            this.beginop(81);
        }
    }

    public void OP_sxi16() {
        if (this.opcodePass == 1) {
            this.beginop(82);
        }
    }

    class BytecodeBuffer3
    extends BytecodeBuffer {
        Map<Integer, Integer> offsets;
        Decoder[] decoders;

        BytecodeBuffer3(Decoder[] decoders, int estimatedSize) {
            super(estimatedSize);
            this.offsets = new HashMap<Integer, Integer>();
            this.decoders = decoders;
        }

        void mapOffsets(long offset) {
            Integer oldPos = IntegerPool.getNumber((int)offset);
            Integer newPos = IntegerPool.getNumber(this.size());
            this.offsets.put(IntegerPool.getNumber(oldPos), IntegerPool.getNumber(newPos));
        }

        long getOffset(long offset) {
            Integer i = this.offsets.get(IntegerPool.getNumber((int)offset));
            if (i != null) {
                return i.intValue();
            }
            System.out.println("getOffset: can't match " + offset + " with a new offset ");
            System.out.println(this.offsets);
            return 0L;
        }

        void updateOffset(long offset) {
            Integer i = this.offsets.get(IntegerPool.getNumber((int)offset));
            Integer p = this.offsets.get(IntegerPool.getNumber(this.decoders[Encoder.this.poolIndex].pos()));
            if (i != null && p != null) {
                this.writeS24(p - 3, i - p);
            }
        }

        void updateOffset(long oldOffsetPos, long oldPos, long oldTarget) {
            Integer i = this.offsets.get(IntegerPool.getNumber((int)oldTarget));
            Integer p = this.offsets.get(IntegerPool.getNumber((int)oldPos));
            Integer s = this.offsets.get(IntegerPool.getNumber((int)oldOffsetPos));
            if (i != null && p != null && s != null) {
                this.writeS24(s, i - p);
            } else {
                if (i == null) {
                    System.out.println("updateOffset2: can't match i " + oldTarget + " with a new offset");
                }
                if (p == null) {
                    System.out.println("updateOffset2: can't match p " + oldPos + " with a new offset");
                }
                if (s == null) {
                    System.out.println("updateOffset2: can't match s " + oldOffsetPos + " with a new offset");
                }
                System.out.println(this.offsets);
            }
        }

        public void clear() {
            super.clear();
            this.offsets.clear();
        }
    }

    class BytecodeBuffer2
    extends BytecodeBuffer {
        private int[] sizes;
        int estimatedSize;

        BytecodeBuffer2(int estimatedSize, int[] sizes) {
            super(estimatedSize);
            this.sizes = sizes;
            this.estimatedSize = estimatedSize;
        }

        int getIndex(int poolIndex, int oldIndex) {
            int newIndex = 0;
            for (int i = 0; i < poolIndex; ++i) {
                newIndex += this.sizes[i];
            }
            return newIndex += oldIndex;
        }
    }

    class ByteArrayPool2
    extends ByteArrayPool {
        int size = 0;
        private int[] sizes;
        private Map<Integer, Integer> indexes;

        ByteArrayPool2(int[] sizes) {
            this.sizes = sizes;
            this.indexes = new HashMap<Integer, Integer>();
        }

        int addByteArray(int poolIndex, int oldIndex, BytecodeBuffer ba) {
            int index = this.contains(ba, 0, ba.size());
            if (index == -1) {
                index = this.store(ba, 0, ba.size());
                this.size += ba.size();
            }
            this.indexes.put(IntegerPool.getNumber(this.calcIndex(poolIndex, oldIndex)), IntegerPool.getNumber(index - 1));
            return index;
        }

        private int calcIndex(int poolIndex, int oldIndex) {
            int newIndex = 0;
            for (int i = 0; i < poolIndex; ++i) {
                newIndex += this.sizes[i];
            }
            return newIndex += oldIndex;
        }

        int getIndex(int poolIndex, int oldIndex) {
            int newIndex = this.calcIndex(poolIndex, oldIndex);
            Integer i = this.indexes.get(IntegerPool.getNumber(newIndex));
            return i != null ? i : -1;
        }

        int size() {
            return this.size;
        }

        void writeTo(BytecodeBuffer b) {
            TreeMap sortedMap = new TreeMap();
            for (Object key : this.map.keySet()) {
                Object value = this.map.get(key);
                sortedMap.put(value, key);
            }
            b.writeU32(sortedMap.size() == 0 ? 0L : (long)sortedMap.size());
            for (Integer index : sortedMap.keySet()) {
                ByteArray a = (ByteArray)sortedMap.get(index);
                b.writeBytes(a.b, a.start, a.end);
            }
        }

        void writeTo(OutputStream os) throws IOException {
            BytecodeBuffer b = new BytecodeBuffer(this.size());
            this.writeTo(b);
            b.writeTo(os);
        }
    }
}

