/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.ByteCodeFactory;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.Parser;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.APIVersions;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Block;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Decimal128Context;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context
implements ErrorConstants {
    private String parser_scanner_input_origin;
    private String qualified_origin;
    public Parser parser;
    public PrintWriter err;
    public InputBuffer input;
    public ContextStatics statics;
    public CompilerHandler handler;
    public ObjectList<ConfigVar> config_vars = new ObjectList();
    public static final byte NS_PUBLIC = 0;
    public static final byte NS_INTERNAL = 1;
    public static final byte NS_PRIVATE = 2;
    public static final byte NS_PROTECTED = 3;
    public static final byte NS_EXPLICIT = 4;
    public static final byte NS_STATIC_PROTECTED = 5;
    public static final String NS_INTERNAL_SUFFIX = "$internal";
    public static final String NS_PRIVATE_SUFFIX = "$private";
    public static final String NS_PROTECTED_SUFFIX = "$protected";
    public static final String NS_STATIC_PROTECTED_SUFFIX = "$staticprotected";
    public Decimal128Context decimal_ctx;
    public int decimalParams;
    private static int contextIds = 0;
    private int contextId;
    private TreeMap<UnresolvedNamespace, ObjectList<ObjectValue>> unresolved_namespaces;
    public ObjectList<Node> comments = new ObjectList();
    public boolean scriptAssistParsing = false;
    public boolean spaceOperators = false;
    public ObjectList<TypeInfo> def_types = new ObjectList();
    public final int MIN_API_MARK = 57344;
    public final int MAX_API_MARK = 63743;

    public Context(ContextStatics statics) {
        this.statics = statics;
        this.handler = null;
        this.qualified_origin = "";
        this.err = null;
        this.contextId = contextIds++;
        if (statics != null) {
            if (statics.nodeFactory == null) {
                statics.nodeFactory = new NodeFactory(this);
            }
            if (statics.builtins == null) {
                statics.builtins = new HashMap();
                statics.userDefined = new HashMap();
                statics.namespaces = new HashMap();
                statics.internal_namespaces = new HashMap();
                statics.protected_namespaces = new HashMap();
                statics.static_protected_namespaces = new HashMap();
                statics.private_namespaces = new HashMap();
                statics.validImports = new HashSet<String>();
            }
        }
    }

    private Context(Context origCtx) {
        this.statics = origCtx.statics;
        this.handler = origCtx.handler;
        this.err = origCtx.err;
        this.contextId = origCtx.contextId;
        this.def_types = origCtx.def_types;
        this.input = origCtx.input;
        this.parser = origCtx.parser;
        this.parser_scanner_input_origin = origCtx.parser_scanner_input_origin;
        this.qualified_origin = origCtx.qualified_origin;
        this.decimal_ctx = origCtx.decimal_ctx;
        this.decimalParams = origCtx.decimalParams;
    }

    public Context makeCopyOf() {
        return new Context(this);
    }

    public int getId() {
        return this.contextId;
    }

    public void switchToContext(Context cx) {
        this.parser_scanner_input_origin = cx.parser_scanner_input_origin;
        this.qualified_origin = cx.qualified_origin;
        this.parser = cx.parser;
        this.err = cx.err;
        this.input = cx.input;
        this.statics = cx.statics;
        this.handler = cx.handler;
        if (cx.unresolved_namespaces != null) {
            if (this.unresolved_namespaces == null) {
                this.unresolved_namespaces = cx.unresolved_namespaces;
            } else {
                ArrayList<UnresolvedNamespace> nsList = new ArrayList<UnresolvedNamespace>(cx.unresolved_namespaces.keySet());
                int size = nsList.size();
                for (int i = 0; i < size; ++i) {
                    UnresolvedNamespace ns = (UnresolvedNamespace)nsList.get(i);
                    ObjectList<ObjectValue> scopes = cx.unresolved_namespaces.get(ns);
                    if (this.unresolved_namespaces.get(ns) != null) continue;
                    this.unresolved_namespaces.put(ns, scopes);
                }
            }
        }
        this.def_types = cx.def_types;
    }

    public void setCompoundNames(ObjectList<String> compound_names) {
        this.statics.nodeFactory.init(compound_names);
    }

    public String getUniqueNamespaceName(String base, Context cx) {
        String name = base + "$" + cx.statics.ticket_count++;
        return name.intern();
    }

    public String getFileInternalNamespaceName() {
        String base = this.getErrorOrigin();
        int idx = base.lastIndexOf(File.separatorChar);
        if (idx != -1) {
            base = base.substring(idx + 1);
        }
        return this.getUniqueNamespaceName(base, this);
    }

    public String errorString(int error) {
        if (this.statics.errorCodeMap.get(error) == null) {
            ErrorConstants.AscError[] errorConsts = allErrorConstants[this.statics.languageID];
            for (int x = 0; x < 179; ++x) {
                this.statics.errorCodeMap.put(errorConsts[x].code, errorConsts[x].errorMsg);
            }
        }
        return this.statics.errorCodeMap.get(error);
    }

    public static int replaceStringArg(StringBuilder out, String templateStr, int startLoc, String arg) {
        if (startLoc == -1) {
            return -1;
        }
        int nextLoc = -1;
        int templateLen = templateStr.length();
        int substLoc = templateStr.indexOf(37, startLoc);
        if (substLoc != -1) {
            if (substLoc > startLoc) {
                out.append(templateStr.substring(startLoc, substLoc));
            }
            out.append(arg);
            nextLoc = substLoc + 2;
        } else {
            out.append(templateStr.substring(startLoc, templateLen));
        }
        return nextLoc;
    }

    public String shellErrorString(int errCode) {
        return (ContextStatics.useVerboseErrors ? "[Compiler] Error #" + errCode + ": " : "") + this.errorString(errCode);
    }

    public void error(int pos, int error) {
        this.error(pos, error, "", "", "");
    }

    public void error(int pos, int error, String arg1) {
        this.error(pos, error, arg1, "", "");
    }

    public void error(int pos, int error, String arg1, String arg2) {
        this.error(pos, error, arg1, arg2, "");
    }

    public void error(int pos, int error, String arg1, String arg2, String arg3) {
        StringBuilder out = new StringBuilder();
        if (ContextStatics.useSanityStyleErrors) {
            out.append("code=" + error + "; arg1=" + arg1 + "; arg2=" + arg2 + "; arg3=" + arg3);
        } else {
            String templateStr = this.shellErrorString(error);
            int nextLoc = Context.replaceStringArg(out, templateStr, 0, arg1);
            nextLoc = Context.replaceStringArg(out, templateStr, nextLoc, arg2);
            if ((nextLoc = Context.replaceStringArg(out, templateStr, nextLoc, arg3)) != -1) {
                out.append(templateStr.substring(nextLoc, templateStr.length()));
            }
        }
        this.localizedError(this.getErrorOrigin(), pos, out.toString(), error);
    }

    public void localizedError(int pos, String msg) {
        this.localizedError(pos, msg, -1);
    }

    public void localizedError(int pos, String msg, int code) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedError(this.getErrorOrigin(), ln, col, msg, this.getErrorLineText(pos), code);
    }

    public void localizedWarning(int pos, String msg) {
        this.localizedWarning(pos, msg, -1);
    }

    public void localizedWarning(int pos, String msg, int code) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedWarning(this.getErrorOrigin(), ln, col, msg, this.getErrorLineText(pos), code);
    }

    public void localizedError(String filename, int pos, String msg) {
        this.localizedError(filename, pos, msg, -1);
    }

    public void localizedError(String filename, int pos, String msg, int code) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedError(filename, ln, col, msg, this.getErrorLineText(pos), code);
    }

    public void localizedWarning(String filename, int pos, String msg, int code) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedWarning(filename, ln, col, msg, this.getErrorLineText(pos), code);
    }

    public void localizedError2(int pos, Object msg) {
        this.localizedError2(this.getErrorOrigin(), pos, msg);
    }

    public void localizedError2(String filename, int pos, Object msg) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedError2(filename, ln, col, msg, this.getErrorLineText(pos));
    }

    public void localizedError2(String filename, int ln, int col, Object msg, String source) {
        if (this.handler != null) {
            this.handler.error2(filename, ln, col, msg, source);
        } else if (this.statics.handler != null) {
            this.statics.handler.error2(filename, ln, col, msg, source);
        } else {
            this.missingHandler(filename, ln, col, msg, source);
        }
        ++this.statics.errCount;
    }

    public void localizedWarning2(int pos, Object msg) {
        this.localizedWarning2(this.getErrorOrigin(), pos, msg);
    }

    public void localizedWarning2(String filename, int pos, Object msg) {
        if (pos < 0) {
            pos = 0;
        }
        int ln = this.getInputLine(pos);
        int col = this.getInputCol(pos);
        this.localizedWarning2(filename, ln, col, msg, this.getErrorLineText(pos));
    }

    public void localizedWarning2(String filename, int ln, int col, Object msg, String source) {
        if (this.handler != null) {
            this.handler.warning2(filename, ln, col, msg, source);
        } else if (this.statics.handler != null) {
            this.statics.handler.warning2(filename, ln, col, msg, source);
        } else {
            this.missingHandler(filename, ln, col, msg, source);
        }
    }

    private void missingHandler(String filename, int ln, int col, Object msg, String source) {
        System.err.println(msg);
        System.err.println("   " + filename + ", Ln " + ln + ", Col " + col + ": ");
        if (source.length() > 0) {
            System.err.println("   " + source);
            System.err.println("   " + InputBuffer.getLinePointer(col));
        }
        System.err.println();
    }

    public int getInputLine(int pos) {
        int ret = -1;
        if (this.input != null) {
            ret = this.input.getLnNum(pos);
        }
        return ret;
    }

    int getInputCol(int pos) {
        int ret = -1;
        if (this.input != null) {
            ret = this.input.getColPos(pos);
        }
        return ret;
    }

    String getErrorLineText(int pos) {
        String ret = "";
        if (this.input != null) {
            ret = this.input.getLineText(pos);
        }
        return ret;
    }

    public String getErrorOrigin() {
        return this.parser_scanner_input_origin != null ? this.parser_scanner_input_origin : "";
    }

    public String getQualifiedErrorOrigin() {
        if (this.qualified_origin != null && this.qualified_origin.length() > 0) {
            return this.qualified_origin;
        }
        return this.getErrorOrigin();
    }

    public void localizedError(String filename, int ln, int col, String msg, String source) {
        this.localizedError(filename, ln, col, msg, source, -1);
    }

    public void localizedError(String filename, int ln, int col, String msg, String source, int code) {
        if (this.handler != null) {
            this.handler.error(filename, ln, col, msg, source, code);
        } else if (this.statics.handler != null) {
            this.statics.handler.error(filename, ln, col, msg, source, code);
        } else {
            this.missingHandler(filename, ln, col, msg, source);
        }
        ++this.statics.errCount;
    }

    private void localizedWarning(String filename, int ln, int col, String msg, String source, int code) {
        if (this.handler != null) {
            this.handler.warning(filename, ln, col, msg, source, code);
        } else if (this.statics.handler != null) {
            this.statics.handler.warning(filename, ln, col, msg, source, code);
        } else {
            this.missingHandler(filename, ln, col, msg, source);
        }
    }

    public void internalError(int pos, String msg) {
        this.localizedError(this.getErrorOrigin(), pos, msg, 1199);
    }

    public void internalError(String msg) {
        this.internalError(-1, msg);
    }

    public void importFile(String filename) {
        if (this.handler != null) {
            this.handler.importFile(filename);
        }
    }

    public void exit(int exitCode) {
    }

    public void setDefType(BitSet def, TypeInfo type) {
        if (BitSet.isEmpty(def)) {
            return;
        }
        int i = BitSet.nextSetBit(def, 0);
        if (i - this.def_types.size() >= 0) {
            this.def_types.resize(i + 1);
            this.def_types.set(i, type);
        } else if (this.def_types.get(i) == null) {
            this.def_types.set(i, type);
        } else if (!type.equals(this.def_types.get(i))) {
            this.def_types.set(i, type);
        }
    }

    public TypeInfo getDefType(BitSet def) {
        TypeInfo type = this.voidType().getDefaultTypeInfo();
        if (BitSet.isEmpty(def)) {
            return this.noType().getDefaultTypeInfo();
        }
        BitSet bits = def;
        int i = BitSet.nextSetBit(bits, 0);
        while (i >= 0) {
            int diff = 0;
            diff = i - this.def_types.size();
            if (diff >= 0) {
                return this.noType().getDefaultTypeInfo();
            }
            if (type != null && type.getTypeValue() == this.voidType()) {
                type = (TypeInfo)this.def_types.get(i);
            } else if (this.def_types.get(i) != null && type != null && (type.getTypeId() & ((TypeInfo)this.def_types.get(i)).getTypeId()) == 0) {
                type = this.noType().getDefaultTypeInfo();
            }
            i = BitSet.nextSetBit(bits, i + 1);
        }
        return type;
    }

    public Node coerce(Node expr, TypeInfo[] actual, TypeValue expected) {
        return this.coerce(expr, actual, expected != null ? expected.getDefaultTypeInfo() : null, false, false);
    }

    public Node coerce(Node expr, TypeInfo[] actual, TypeValue expected, boolean isExplicit) {
        return this.coerce(expr, actual, expected != null ? expected.getDefaultTypeInfo() : null, isExplicit, false);
    }

    public Node coerce(Node expr, TypeInfo[] actual, TypeInfo expected) {
        return this.coerce(expr, actual, expected, false, false);
    }

    public Node coerce(Node expr, TypeInfo[] actual, TypeInfo expected, boolean isExplicit) {
        return this.coerce(expr, actual, expected, isExplicit, false);
    }

    public Node coerce(Node expr, TypeInfo[] actual, TypeInfo expected, boolean isExplicit, boolean force) {
        if (expr instanceof ListNode) {
            ListNode list = (ListNode)expr;
            Node lastExpr = list.items.back();
            lastExpr = this.coerce(lastExpr, actual, expected, isExplicit, force);
            list.items.pop_back();
            list.items.push_back(lastExpr);
            return expr;
        }
        if (expr instanceof ConditionalExpressionNode) {
            ConditionalExpressionNode cond = (ConditionalExpressionNode)expr;
            actual[0] = cond.thenvalue != null ? cond.thenvalue.getType(this) : null;
            cond.thenexpr = this.coerce(cond.thenexpr, actual, expected, isExplicit, true);
            actual[0] = cond.elsevalue != null ? cond.elsevalue.getType(this) : null;
            cond.elseexpr = this.coerce(cond.elseexpr, actual, expected, isExplicit, true);
            return expr;
        }
        if (expr instanceof BinaryExpressionNode) {
            BinaryExpressionNode binary = (BinaryExpressionNode)expr;
            if ((binary.op == -10 || binary.op == -37) && (expected != null && expected.getTypeValue() != this.voidType() || binary.lhstype != binary.rhstype)) {
                TypeInfo expected2 = expected != null ? (expected.getTypeValue() == this.voidType() ? this.noType().getDefaultTypeInfo() : expected) : null;
                actual[0] = binary.lhstype;
                binary.lhs = this.coerce(binary.lhs, actual, expected2, isExplicit, true);
                binary.lhstype = actual[0];
                actual[0] = binary.rhstype;
                binary.rhs = this.coerce(binary.rhs, actual, expected2, isExplicit, true);
                binary.rhstype = actual[0];
                return expr;
            }
        }
        if (expected == null) {
            if (force) {
                actual[0] = this.noType().getDefaultTypeInfo();
                return this.statics.nodeFactory.coerce(expr, null, this.noType().getDefaultTypeInfo(), isExplicit);
            }
            return expr;
        }
        if (expected.getTypeValue() == this.voidType()) {
            actual[0] = expected;
            expr.voidResult();
            return expr;
        }
        if (actual[0] == null) {
            actual[0] = expected;
            return this.statics.nodeFactory.coerce(expr, null, expected, isExplicit);
        }
        if (expected == actual[0] || expected.includes(this, actual[0])) {
            return force ? this.statics.nodeFactory.coerce(expr, null, expected, isExplicit) : expr;
        }
        if (this.useStaticSemantics() && actual[0].getTypeValue() != this.nullType() && expected.getTypeValue() != this.booleanType()) {
            if (actual[0].getTypeValue().getTypeInfo(true).includes(this, expected)) {
                if (!(actual[0].getTypeValue() == this.vectorObjType() && expected.getTypeValue().baseclass == this.vectorObjType() || isExplicit || actual[0].getTypeValue() == this.noType())) {
                    this.error(expr.pos(), 1118, actual[0].getName(this).toString(), expected.getName(this).toString());
                }
            } else if (!(expected.getTypeValue() == this.stringType() && (actual[0].getTypeValue() == this.xmlType() || actual[0].getTypeValue() == this.xmlListType()) || expected.isNumeric(this) && actual[0].isNumeric(this))) {
                this.error(expr.pos(), 1067, actual[0].getName(this).toString(), expected.getName(this).toString());
            }
        }
        return force || isExplicit ? this.statics.nodeFactory.coerce(expr, actual[0], expected, isExplicit) : expr;
    }

    public int errorCount() {
        return this.statics.errCount;
    }

    private void pushStaticClassScopesHelper(TypeValue cframe) {
        if (cframe.baseclass != null) {
            this.pushStaticClassScopesHelper(cframe.baseclass);
        }
        this.pushScope(cframe);
    }

    public void pushStaticClassScopes(ClassDefinitionNode node) {
        this.pushStaticClassScopesHelper(node.cframe);
    }

    public void popStaticClassScopes(ClassDefinitionNode node) {
        TypeValue cframe = node.cframe;
        while (cframe != null) {
            this.popScope();
            cframe = cframe.baseclass;
        }
    }

    public void pushScope(ObjectValue scope) {
        if (this.statics.scopes.isEmpty()) {
            this.statics.global = scope;
        }
        this.statics.scopes.add(scope);
    }

    public void popScope() {
        this.statics.scopes.removeLast();
        if (this.statics.scopes.isEmpty()) {
            this.statics.global = null;
        }
    }

    public ObjectList<ObjectValue> getScopes() {
        return this.statics.scopes;
    }

    public ObjectList<ObjectValue> swapScopeChain(ObjectList<ObjectValue> new_scopes) {
        ObjectList<ObjectValue> old_scopes = this.statics.scopes;
        this.statics.scopes = new_scopes;
        return old_scopes;
    }

    public ObjectValue scope() {
        if (this.statics.scopes.size() > 0) {
            return this.statics.scopes.back();
        }
        return this.statics.global;
    }

    public int getScopeDepth() {
        return this.statics.scopes.size();
    }

    public ObjectValue scope(int n) {
        if (n >= 0 && n < this.statics.scopes.size()) {
            return (ObjectValue)this.statics.scopes.get(n);
        }
        return this.statics.global;
    }

    public ObjectValue globalScope() {
        return this.statics.global;
    }

    public ObjectValue builtinScope() {
        return this.statics.globalPrototype;
    }

    public void setEmitter(Emitter emitter) {
        this.statics.emitter = emitter;
    }

    public Emitter getEmitter() {
        return this.statics.emitter;
    }

    public void setPath(String pathspec) {
        this.statics.pathspec = pathspec;
    }

    public String path() {
        return this.statics.pathspec;
    }

    public void setScriptName(String scriptname) {
        this.statics.scriptname = scriptname;
    }

    public String scriptName() {
        return this.statics.scriptname;
    }

    public NodeFactory getNodeFactory() {
        if (this.statics.nodeFactory == null) {
            this.statics.nodeFactory = new NodeFactory(this);
        } else {
            this.statics.nodeFactory.setContext(this);
        }
        return this.statics.nodeFactory;
    }

    public ByteCodeFactory getByteCodeFactory() {
        if (this.statics.bytecodeFactory == null) {
            this.statics.bytecodeFactory = new ByteCodeFactory();
        }
        return this.statics.bytecodeFactory;
    }

    public void setHandler(CompilerHandler handler) {
        this.handler = handler;
        if (this.statics.handler == null) {
            this.statics.handler = handler;
        }
    }

    public void setLanguage(String language) {
        this.statics.languageID = Context.getLanguageID(language);
    }

    public static int getLanguageID(String language) {
        int langID = 0;
        if (language.equals("EN")) {
            langID = 0;
        } else if (language.equals("CN")) {
            langID = 1;
        } else if (language.equals("CS")) {
            langID = 2;
        } else if (language.equals("DK")) {
            langID = 3;
        } else if (language.equals("DE")) {
            langID = 4;
        } else if (language.equals("ES")) {
            langID = 5;
        } else if (language.equals("FI")) {
            langID = 6;
        } else if (language.equals("FR")) {
            langID = 7;
        } else if (language.equals("IT")) {
            langID = 8;
        } else if (language.equals("JP")) {
            langID = 9;
        } else if (language.equals("KR")) {
            langID = 10;
        } else if (language.equals("NO")) {
            langID = 11;
        } else if (language.equals("NL")) {
            langID = 12;
        } else if (language.equals("PL")) {
            langID = 13;
        } else if (language.equals("BR")) {
            langID = 14;
        } else if (language.equals("RU")) {
            langID = 15;
        } else if (language.equals("SE")) {
            langID = 16;
        } else if (language.equals("TR")) {
            langID = 17;
        } else if (language.equals("TW")) {
            langID = 18;
        }
        return langID;
    }

    public CompilerHandler getHandler() {
        return this.handler;
    }

    public Writer getErrOut() {
        return this.err;
    }

    public Block newBlock() {
        return new Block();
    }

    public ObjectValue publicNamespace() {
        if (this.statics._publicNamespace == null) {
            this.statics._publicNamespace = this.getNamespace("");
        }
        return this.statics._publicNamespace;
    }

    public ObjectValue AS3Namespace() {
        if (this.statics._AS3Namespace == null) {
            this.statics._AS3Namespace = this.getNamespace("");
        }
        return this.statics._AS3Namespace;
    }

    public ObjectValue anyNamespace() {
        if (this.statics._anyNamespace == null) {
            this.statics._anyNamespace = this.getNamespace("*");
        }
        return this.statics._anyNamespace;
    }

    public TypeValue noType() {
        if (this.statics._noType == null) {
            String name = "*";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._noType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 32768);
            this.statics._noType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._noType);
            this.statics.builtins.put(name, this.statics._noType);
            this.statics._noType.prototype.builder.is_dynamic = true;
        }
        return this.statics._noType;
    }

    public TypeValue objectType() {
        if (this.statics._objectType == null) {
            String name = "Object";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._objectType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 8192);
            this.statics._objectType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._objectType);
            this.statics.builtins.put(name, this.statics._objectType);
        }
        return this.statics._objectType;
    }

    public TypeValue arrayType() {
        if (this.statics._arrayType == null) {
            String name = "Array";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._arrayType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 4096);
            this.statics._arrayType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._arrayType);
            this.statics.builtins.put(name, this.statics._arrayType);
        }
        return this.statics._arrayType;
    }

    public TypeValue voidType() {
        if (this.statics._voidType == null) {
            String name = "void";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._voidType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 1024);
            this.statics._voidType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._voidType);
            this.statics._voidType.prototype.setValue("undefined");
            this.statics.builtins.put(name, this.statics._voidType);
        }
        return this.statics._voidType;
    }

    public TypeValue nullType() {
        if (this.statics._nullType == null) {
            String name = "Null";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._nullType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 16);
            this.statics._nullType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._nullType);
            this.statics._nullType.prototype.setValue("null");
            this.statics.builtins.put(name, this.statics._nullType);
        }
        return this.statics._nullType;
    }

    public TypeValue booleanType() {
        if (this.statics._booleanType == null) {
            String name = "Boolean";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._booleanType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 1);
            this.statics._booleanType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._booleanType);
            this.statics.builtins.put(name, this.statics._booleanType);
        }
        return this.statics._booleanType;
    }

    public TypeValue stringType() {
        if (this.statics._stringType == null) {
            String name = "String";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._stringType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 4);
            this.statics._stringType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._stringType);
            this.statics.builtins.put(name, this.statics._stringType);
        }
        return this.statics._stringType;
    }

    public TypeValue typeType() {
        if (this.statics._typeType == null) {
            String name = "Class";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._typeType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 128);
            this.statics._typeType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._typeType);
            this.statics.builtins.put(name, this.statics._typeType);
        }
        return this.statics._typeType;
    }

    public TypeValue functionType() {
        if (this.statics._functionType == null) {
            String name = "Function";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._functionType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 2048);
            this.statics._functionType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._functionType);
            this.statics.builtins.put(name, this.statics._functionType);
        }
        return this.statics._functionType;
    }

    public TypeValue intType() {
        if (this.statics._intType == null) {
            String name = "int";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._intType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 256);
            this.statics._intType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._intType);
            this.statics.builtins.put(name, this.statics._intType);
        }
        return this.statics._intType;
    }

    public TypeValue uintType() {
        if (this.statics._uintType == null) {
            String name = "uint";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._uintType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 512);
            this.statics._uintType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._uintType);
            this.statics.builtins.put(name, this.statics._uintType);
        }
        return this.statics._uintType;
    }

    public TypeValue numberType() {
        if (this.statics._numberType == null) {
            String name = "Number";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._numberType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 64);
            this.statics._numberType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._numberType);
            this.statics.builtins.put(name, this.statics._numberType);
        }
        return this.statics._numberType;
    }

    public TypeValue doubleType() {
        if (!this.statics.es4_numerics) {
            return this.numberType();
        }
        if (this.statics._doubleType == null) {
            String name = "double";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._doubleType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 64);
            this.statics._doubleType.baseclass = this.objectType();
            this.statics._doubleType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._doubleType);
            this.statics.builtins.put(name, this.statics._doubleType);
        }
        return this.statics._doubleType;
    }

    public TypeValue decimalType() {
        if (this.statics._decimalType == null && this.statics.es4_numerics) {
            String name = "decimal";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._decimalType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 65536);
            this.statics._decimalType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._decimalType);
            this.statics.builtins.put(name, this.statics._decimalType);
        }
        return this.statics._decimalType;
    }

    public TypeValue xmlType() {
        if (this.statics._xmlType == null) {
            String name = "XML";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._xmlType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 16384);
            this.statics._xmlType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._xmlType);
            this.statics.builtins.put(name, this.statics._xmlType);
        }
        return this.statics._xmlType;
    }

    public TypeValue regExpType() {
        if (this.statics._regExpType == null) {
            String name = "RegExp";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._regExpType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 8192);
            this.statics._regExpType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._regExpType);
            this.statics.builtins.put(name, this.statics._regExpType);
        }
        return this.statics._regExpType;
    }

    public TypeValue xmlListType() {
        if (this.statics._xmlListType == null) {
            String name = "XMLList";
            QName qname = new QName(this.publicNamespace(), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._xmlListType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 16384);
            this.statics._xmlListType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._xmlListType);
            this.statics.builtins.put(name, this.statics._xmlListType);
        }
        return this.statics._xmlListType;
    }

    public TypeValue vectorType() {
        if (this.statics._vectorType == null) {
            String name = "Vector";
            QName qname = new QName(this.getNamespace("__AS3__.vec"), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._vectorType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 8192);
            this.statics._vectorType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._vectorType);
            this.statics._vectorType.is_parameterized = true;
            this.statics.builtins.put(qname.toString(), this.statics._vectorType);
        }
        return this.statics._vectorType;
    }

    public TypeValue vectorObjType() {
        if (this.statics._vectorObjType == null) {
            String name = "Vector$object";
            QName qname = new QName(this.getNamespace("__AS3__.vec", (byte)1), name);
            ObjectValue protected_namespace = this.getNamespace(qname.toString(), (byte)3);
            ObjectValue static_protected_namespace = this.getNamespace(qname.toString(), (byte)5);
            this.statics._vectorObjType = new TypeValue(this, new ClassBuilder(qname, protected_namespace, static_protected_namespace), qname, 8192);
            this.statics._vectorObjType.prototype = new ObjectValue(this, new InstanceBuilder(qname), this.statics._vectorObjType);
            this.statics.builtins.put(qname.toString(), this.statics._vectorObjType);
        }
        return this.statics._vectorObjType;
    }

    public boolean isBuiltin(String name) {
        return this.statics.builtins.containsKey(name);
    }

    public TypeValue builtin(String name) {
        return this.statics.builtins.get(name);
    }

    public TypeValue userDefined(String name) {
        return this.statics.userDefined.get(name);
    }

    public void setUserDefined(String name, TypeValue value) {
        this.statics.userDefined.put(name, value);
    }

    int getVersion(String uri) {
        if (uri.length() == 0) {
            return -1;
        }
        int last = uri.codePointAt(uri.length() - 1);
        if (last >= 57344 && last <= 63743) {
            return last - 57344;
        }
        return -1;
    }

    String stripVersion(String uri) {
        int version = this.getVersion(uri);
        if (version >= 0) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri.intern();
    }

    public ObjectValue getNamespace(String name) {
        return this.getNamespace(name, (byte)0);
    }

    public ObjectValue getNamespace(String name, byte ns_kind) {
        HashMap<String, ObjectValue> namespace_map;
        name = this.stripVersion(name);
        assert (name == name.intern());
        switch (ns_kind) {
            case 1: {
                namespace_map = this.statics.internal_namespaces;
                break;
            }
            case 2: {
                namespace_map = this.statics.private_namespaces;
                break;
            }
            case 3: {
                namespace_map = this.statics.protected_namespaces;
                break;
            }
            case 5: {
                namespace_map = this.statics.static_protected_namespaces;
                break;
            }
            default: {
                namespace_map = this.statics.namespaces;
            }
        }
        ObjectValue val = (ObjectValue)namespace_map.get(name);
        if (val == null) {
            val = new NamespaceValue(ns_kind);
            val.setValue(name);
            val.name = name;
            assert (name == name.intern());
            namespace_map.put(name, val);
        }
        return val;
    }

    public ObjectValue getOpaqueNamespace(String name) {
        return this.getNamespace(name);
    }

    public boolean isValidImport(String name) {
        return this.statics != null ? this.statics.validImports.contains(name) : false;
    }

    public void addValidImport(String name) {
        if (this.statics.validImports == null) {
            this.statics.validImports = new HashSet<String>();
        }
        this.statics.validImports.add(name);
    }

    public boolean useStaticSemantics() {
        return this.statics.use_static_semantics;
    }

    public boolean checkVersion() {
        return this.statics.check_version;
    }

    public void pushVersion(int v) {
        if (this.checkVersion()) {
            this.statics.versions.push_back(v);
        }
    }

    public int popVersion() {
        if (this.checkVersion()) {
            int ret = this.statics.versions.pop_back();
            return ret;
        }
        return 0;
    }

    public int version() {
        return this.statics.versions.size() > 0 ? this.statics.versions.back() : 0;
    }

    public boolean dialect(int n) {
        return this.statics.dialect == n;
    }

    public boolean abcVersion(int n) {
        return this.statics.abc_version >= n;
    }

    public boolean isNamespace(String ns_name) {
        return this.statics.namespaces.containsKey(ns_name);
    }

    public boolean isNamespace(ObjectValue obj) {
        boolean isns = false;
        if (obj != null) {
            if (obj.isPrivate() && this.statics.private_namespaces.containsKey(obj.name)) {
                isns = true;
            } else if (obj.isProtected() && this.statics.protected_namespaces.containsKey(obj.name)) {
                isns = true;
            } else if (obj.isInternal() && this.statics.internal_namespaces.containsKey(obj.name)) {
                isns = true;
            } else if (this.statics.namespaces.containsKey(obj.name)) {
                isns = true;
            }
        }
        return isns;
    }

    public ObjectValue getUnresolvedNamespace(Context cx, Node node, ReferenceValue ref) {
        if (this.unresolved_namespaces == null) {
            this.unresolved_namespaces = new TreeMap(new ObjectValue.ObjectValueCompare());
        }
        for (UnresolvedNamespace ns : this.unresolved_namespaces.keySet()) {
            ReferenceValue val = ns.ref;
            if (!val.name.equals(ref.name) || val.getImmutableNamespaces().size() != ref.getImmutableNamespaces().size()) continue;
            boolean match = true;
            int size = val.getImmutableNamespaces().size();
            for (int j = 0; j < size; ++j) {
                if (((ObjectValue)val.getImmutableNamespaces().get((int)j)).name.equals(((ObjectValue)ref.getImmutableNamespaces().get((int)j)).name)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return ns;
        }
        UnresolvedNamespace ns = new UnresolvedNamespace(cx, node, ref);
        ns.name = ("__unresolved__ns__" + this.statics.unresolved_ns_count++).intern();
        ObjectList<ObjectValue> scopes = new ObjectList<ObjectValue>((Collection<ObjectValue>)this.statics.scopes);
        this.unresolved_namespaces.put(ns, scopes);
        return ns;
    }

    public void processUnresolvedNamespaces() {
        if (this.unresolved_namespaces != null) {
            ArrayList<UnresolvedNamespace> nsList = new ArrayList<UnresolvedNamespace>(this.unresolved_namespaces.keySet());
            int size = nsList.size();
            for (int i = 0; i < size; ++i) {
                UnresolvedNamespace ns = (UnresolvedNamespace)nsList.get(i);
                ObjectList<ObjectValue> temp = this.statics.scopes;
                this.statics.scopes = this.unresolved_namespaces.get(ns);
                Slot slot = ns.ref.getSlot(this);
                this.statics.scopes = temp;
                if (slot != null) {
                    ObjectValue realNamespace;
                    Value val = slot.getValue();
                    ObjectValue objectValue = realNamespace = val instanceof ObjectValue ? (ObjectValue)val : null;
                    if (realNamespace != null) {
                        this.unresolved_namespaces.remove(ns);
                        ns.name = realNamespace.name;
                        ns.ns_kind = realNamespace.getNamespaceKind();
                        ns.resolved = true;
                    }
                } else {
                    ns.cx.error(ns.node.pos(), 1004);
                }
                ns.cx = null;
                ns.node = null;
            }
            this.unresolved_namespaces.clear();
            this.unresolved_namespaces = null;
        }
    }

    public String debugName(String region_part, String name, ObjectList<String> namespace_ids, int kind) {
        String kind_part = kind == -79 ? "/get" : (kind == -99 ? "/set" : "");
        StringBuilder namespace_part = new StringBuilder(region_part.length() + name.length() + kind_part.length() + (namespace_ids != null ? namespace_ids.size() * 8 : 0));
        namespace_part.append(region_part);
        int region_part_length = region_part.length();
        if (region_part_length > 0) {
            namespace_part.append('/');
            ++region_part_length;
        }
        if (namespace_ids != null) {
            int last;
            for (int n = last = namespace_ids.size() - 1; n >= 0; --n) {
                if (namespace_ids.at(n).length() != 0 && n != last) {
                    namespace_part.append('|');
                }
                namespace_part.append(namespace_ids.at(n));
            }
        }
        if (namespace_part.length() - region_part_length > 0) {
            namespace_part.append(':');
        }
        String debug_name = namespace_part.append(name).append(kind_part).toString();
        return debug_name;
    }

    public QName computeQualifiedName(String region_part, String name, ObjectValue qualifier, int kind) {
        String kind_part = kind == -79 ? "/get" : (kind == -99 ? "/set" : "");
        String namespace_part = qualifier.name;
        byte ns_kind = qualifier.getNamespaceKind();
        return new QName(this.getNamespace(region_part.length() != 0 ? (region_part + namespace_part).intern() : namespace_part, ns_kind), kind_part.length() != 0 ? name + kind_part : name);
    }

    public ObjectList<Node> getComments() {
        return this.comments;
    }

    public String toString() {
        return super.toString();
    }

    public void setOrigin(String origin) {
        this.parser_scanner_input_origin = origin.intern();
    }

    public void setQualifiedOrigin(String qualifiedOrigin) {
        this.qualified_origin = qualifiedOrigin;
    }

    public String getConfigVarCode() {
        String code = null;
        if (this.config_vars != null && this.config_vars.size() > 0) {
            HashSet<String> namespaces = new HashSet<String>();
            StringBuilder code_buffer = new StringBuilder(this.config_vars.size() * 10);
            int size = this.config_vars.size();
            for (int i = 0; i < size; ++i) {
                ConfigVar cv = this.config_vars.at(i);
                if (!namespaces.contains(cv.ns)) {
                    namespaces.add(cv.ns);
                    code_buffer.append("config namespace " + cv.ns + ";\n");
                }
                code_buffer.append(cv.ns);
                code_buffer.append(" const ");
                code_buffer.append(cv.name + "=" + cv.value + ";\n");
            }
            code = code_buffer.toString();
        }
        return code;
    }

    public int getApiVersion() {
        return this.statics.apiVersion;
    }

    public boolean isCompatibleVersion(int v) {
        int[] cv;
        if (v < 0) {
            return true;
        }
        for (int c : cv = this.getCompatibleVersions(v)) {
            if (c != this.statics.apiVersion) continue;
            return true;
        }
        return false;
    }

    public int[] getCompatibleVersions(int v) {
        assert (v >= APIVersions.min_version_num);
        return APIVersions.versions[v - APIVersions.min_version_num];
    }

    public String[] getVersionedURIs() {
        return APIVersions.uris;
    }

    public boolean isVersionedURI(String uri) {
        if (uri == "") {
            return true;
        }
        for (String s : this.getVersionedURIs()) {
            if (uri != s) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidAPIVersion(int v) {
        return v >= APIVersions.min_version_num || v <= APIVersions.max_version_num;
    }

    static {
        for (String s : APIVersions.uris) {
            s.intern();
        }
    }
}

