/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.MethodSlot;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.NumberUsage;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.Qualifiers;
import macromedia.asc.util.Slots;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValue
extends Value
implements Comparable {
    static final String EMPTY_STRING = "".intern();
    public static ObjectValue undefinedValue;
    public static ObjectValue nullValue;
    public static ObjectValue enumerableNamespace;
    public static ObjectValue labelNamespace;
    public static ObjectValue loopLabelNamespace;
    public static ObjectValue objectPrototype;
    public static ObjectValue internalNamespace;
    public static ObjectValue intrinsicAttribute;
    public static ObjectValue intrinsicNamespace;
    public static ObjectValue staticAttribute;
    public static ObjectValue dynamicAttribute;
    public static ObjectValue finalAttribute;
    public static ObjectValue virtualAttribute;
    public static ObjectValue overrideAttribute;
    public static ObjectValue nativeAttribute;
    public Builder builder;
    public TypeInfo type;
    private String value = EMPTY_STRING;
    private NumberUsage numberUsage;
    private Names names;
    public Slots slots;
    public ObjectValue _proto_;
    public String name = EMPTY_STRING;
    public String classname = EMPTY_STRING;
    public String debug_name = EMPTY_STRING;
    ObjectList<ObjectValue> base_objs;
    private ObjectValue protected_ns;
    private ObjectValue base_protected_ns;
    private SlotIDCache slot_ids = null;
    public int method_info;
    public int var_count;
    public int method_count;
    public ObjectValue activation;
    static Slot nullSlot;
    private HashMap<TypeValue, ClassDefinitionNode> deferredClassMap;
    private boolean init_only_view = false;

    public static void NamespacesFromQualifiers(Qualifiers quals, Namespaces namespaces) {
        namespaces.clear();
        for (ObjectValue it : quals.keySet()) {
            namespaces.push_back(it);
        }
    }

    public static void init() {
        if (undefinedValue == null) {
            undefinedValue = new ObjectValue();
            nullValue = new ObjectValue();
            enumerableNamespace = new ObjectValue();
            labelNamespace = new NamespaceValue(2);
            ObjectValue.labelNamespace.name = "label namespace";
            loopLabelNamespace = new NamespaceValue(2);
            ObjectValue.loopLabelNamespace.name = "loop label namespace name";
            objectPrototype = new ObjectValue();
            internalNamespace = new ObjectValue();
            intrinsicAttribute = new ObjectValue();
            intrinsicNamespace = new ObjectValue();
            staticAttribute = new ObjectValue();
            dynamicAttribute = new ObjectValue();
            finalAttribute = new ObjectValue();
            virtualAttribute = new ObjectValue();
            overrideAttribute = new ObjectValue();
            nativeAttribute = new ObjectValue();
        }
    }

    public static void clear() {
        if (undefinedValue != null) {
            if (nullSlot.getType() != null || nullSlot.getVarIndex() != -1) {
                throw new Error();
            }
            undefinedValue = null;
            nullValue = null;
            enumerableNamespace = null;
            labelNamespace = null;
            loopLabelNamespace = null;
            objectPrototype = null;
            internalNamespace = null;
            intrinsicAttribute = null;
            intrinsicNamespace = null;
            staticAttribute = null;
            dynamicAttribute = null;
            finalAttribute = null;
            virtualAttribute = null;
            overrideAttribute = null;
            nativeAttribute = null;
        }
    }

    public ObjectValue() {
        this.builder = null;
        this.type = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.activation = null;
        this.numberUsage = null;
        this.method_info = -1;
        this.initInstance(null, null);
    }

    public ObjectValue(TypeValue type) {
        this.builder = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.numberUsage = null;
        this.activation = null;
        this.type = type != null ? type.getDefaultTypeInfo() : null;
        this.method_info = -1;
        this.initInstance(null, type);
    }

    public ObjectValue(String value, TypeValue type) {
        this.setValue(value);
        this.builder = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.numberUsage = null;
        this.activation = null;
        this.type = type != null ? type.getDefaultTypeInfo() : null;
        this.method_info = -1;
        this.initInstance(null, type);
    }

    public ObjectValue(String value, TypeInfo type) {
        this.setValue(value);
        this.builder = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.numberUsage = null;
        this.activation = null;
        this.type = type;
        this.method_info = -1;
        this.initInstance(null, type.getTypeValue());
    }

    public ObjectValue(Context cx, Builder builder, TypeValue type) {
        this.clearInstance(cx, builder, type, EMPTY_STRING, false);
    }

    public void clearInstance(Context cx, Builder builder, TypeValue type, String name, boolean save_slot_ids) {
        this.flags = 0;
        this.value = EMPTY_STRING;
        this.names = null;
        if (save_slot_ids && this.slots != null && this.slots.size() > 0) {
            this.slot_ids = new SlotIDCache(this.slots);
        }
        this.slots = null;
        this.classname = EMPTY_STRING;
        this.debug_name = EMPTY_STRING;
        this.deferredClassMap = null;
        this.base_objs = null;
        this.protected_ns = null;
        this.base_protected_ns = null;
        this.builder = builder;
        this.type = type != null ? type.getDefaultTypeInfo() : null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.numberUsage = null;
        this.activation = null;
        this.method_info = -1;
        this.initInstance(null, type);
        builder.build(cx, this);
        assert (name.intern() == name);
        this.name = name;
    }

    public void initInstance(ObjectValue protoObject, TypeValue classObject) {
        this._proto_ = protoObject;
    }

    public boolean removeName(Context cx, int kind, String name, ObjectValue qualifier) {
        if (this.names != null) {
            this.names.put(name, qualifier, Names.getTypeFromKind(kind), -1);
        }
        return true;
    }

    public boolean hasName(Context cx, int kind, String name, ObjectValue qualifier) {
        if (this.init_only_view && kind != -99) {
            return false;
        }
        boolean ret = false;
        boolean bl = ret = this.names == null ? false : this.names.containsKey(name, qualifier, Names.getTypeFromKind(kind));
        if (!this.init_only_view && !ret && this.base_objs != null) {
            if (qualifier == this.protected_ns) {
                qualifier = this.base_protected_ns;
            }
            for (int i = 0; i < this.base_objs.size() && !ret; ++i) {
                ret = this.base_objs.at(i).hasName(cx, kind, name, qualifier);
            }
        }
        return ret;
    }

    public boolean hasNameUnqualified(Context cx, String name, int kind) {
        if (this.init_only_view && kind != -99) {
            return false;
        }
        boolean ret = false;
        boolean bl = ret = this.names == null ? false : this.names.exist(name, Names.getTypeFromKind(kind));
        if (!this.init_only_view && !ret && this.base_objs != null) {
            for (int i = 0; i < this.base_objs.size() && !ret; ++i) {
                ret = this.base_objs.at(i).hasNameUnqualified(cx, name, kind);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespaces hasNames(Context cx, int kind, String name, Namespaces namespaces) {
        int i;
        int size;
        if (this.init_only_view && kind != -99) {
            return null;
        }
        ArrayList hasNamespaces = null;
        int protected_index = -1;
        boolean searched_protected = false;
        boolean matched_protected = false;
        if (this.names != null) {
            int type = Names.getTypeFromKind(kind);
            if (namespaces.size() <= 1 || this.names.containsKey(name, type)) {
                searched_protected = true;
                size = namespaces.size();
                for (i = 0; i < size; ++i) {
                    ObjectValue qual = (ObjectValue)namespaces.get(i);
                    if (this.names.containsKey(name, qual, type)) {
                        if (hasNamespaces == null) {
                            hasNamespaces = new Namespaces();
                        }
                        hasNamespaces.add(qual);
                        if (qual == this.protected_ns) {
                            matched_protected = true;
                        }
                    }
                    if (qual != this.protected_ns) continue;
                    protected_index = i;
                }
            }
        }
        if (!this.init_only_view && this.base_objs != null) {
            Namespaces temp = null;
            if (!searched_protected && this.protected_ns != null && !matched_protected) {
                size = namespaces.size();
                for (i = 0; i < size; ++i) {
                    if (this.protected_ns != namespaces.get(i)) continue;
                    protected_index = i;
                    break;
                }
            }
            if (protected_index != -1 && !matched_protected) {
                namespaces.set(protected_index, this.base_protected_ns);
            }
            try {
                for (i = 0; i < this.base_objs.size(); ++i) {
                    temp = this.base_objs.at(i).hasNames(cx, kind, name, namespaces);
                    if (temp == null) continue;
                    if (hasNamespaces == null) {
                        hasNamespaces = temp;
                        continue;
                    }
                    hasNamespaces.addAll(temp);
                }
            }
            finally {
                if (protected_index != -1 && !matched_protected) {
                    namespaces.set(protected_index, this.protected_ns);
                }
            }
        }
        return hasNamespaces;
    }

    public Slot get(Context cx, String name, ObjectValue qualifier) {
        return this.getSlot(cx, this.get(name, qualifier, 0));
    }

    private int get(String name, ObjectValue qualifier, int type) {
        int ret;
        int n = ret = this.names != null ? this.names.get(name, qualifier, type) : -1;
        if (ret == -1 && this.base_objs != null) {
            if (qualifier == this.protected_ns) {
                qualifier = this.base_protected_ns;
            }
            for (int i = 0; i < this.base_objs.size() && ret == -1; ++i) {
                ret = this.base_objs.at(i).get(name, qualifier, type);
            }
        }
        return ret;
    }

    public int defineName(Context cx, int kind, String name, ObjectValue qualifier, int slot_index) {
        if (this.names == null) {
            this.names = new Names();
        }
        if (this.hasName(cx, kind, name, qualifier)) {
            return 0;
        }
        this.names.put(name, qualifier, Names.getTypeFromKind(kind), slot_index);
        return 1;
    }

    public Names getNamesAndCreate() {
        if (this.names == null) {
            this.names = new Names();
        }
        return this.names;
    }

    public boolean defineNames(Context cx, int kind, String name, Namespaces namespaces, int slot_index) {
        if (this.names == null) {
            this.names = new Names();
        }
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            ObjectValue it = (ObjectValue)namespaces.get(i);
            this.names.put(name, it, Names.getTypeFromKind(kind), slot_index);
        }
        return true;
    }

    public final int addVariableSlot(Context cx, TypeValue type, int var_index) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        VariableSlot newSlot = new VariableSlot(type, this.nextSlotID(cx), var_index);
        newSlot.declaredBy = this;
        this.slots.put(newSlot);
        return newSlot.id;
    }

    public final int addMethodSlot(Context cx, TypeValue type) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        MethodSlot newSlot = new MethodSlot(type, this.nextSlotID(cx));
        newSlot.declaredBy = this;
        this.slots.put(newSlot);
        return newSlot.id;
    }

    private final int nextSlotID(Context cx) {
        int slot_id = this.slot_ids != null ? this.slot_ids.getNextSlotID(cx) : cx.statics.getNextSlotID();
        return slot_id;
    }

    public final void addSlot(Slot slot) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        this.slots.put(slot);
    }

    public final int addSlotImplicit(Context cx, int slot_index, int kind, TypeValue type) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).implicit(kind, index);
        return index;
    }

    public final int addSlotOverload(Context cx, int slot_index, TypeValue type, TypeValue t1) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).overload(t1, index);
        Slot slot = this.getSlot(cx, index);
        slot.addType(t1.getDefaultTypeInfo());
        return index;
    }

    public final int addSlotOverload(Context cx, int slot_index, TypeValue type, TypeValue t1, TypeValue t2) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).overload(t1, t2, index);
        Slot slot = this.getSlot(cx, index);
        slot.addType(t1.getDefaultTypeInfo());
        slot.addType(t2.getDefaultTypeInfo());
        return index;
    }

    public Slot getSlot(Context cx, int index) {
        Slot ret = null;
        if (this.slots != null) {
            ret = this.slots.getByID(index);
        }
        if (ret == null && this.base_objs != null) {
            for (int i = 0; i < this.base_objs.size() && ret == null; ++i) {
                ret = this.base_objs.at(i).getSlot(cx, index);
            }
        }
        return ret;
    }

    public int getSlotIndex(Context cx, int kind, String name, ObjectValue qualifier) {
        int index = -1;
        qualifier = qualifier != null ? qualifier : cx.publicNamespace();
        int type = Names.getTypeFromKind(kind);
        if (!this.hasNameUnqualified(cx, name, kind)) {
            if (this.proto() != null) {
                index = this.proto().getSlotIndex(cx, kind, name, qualifier);
            }
        } else {
            index = this.get(name, qualifier, type);
        }
        return index;
    }

    public int getImplicitIndex(Context cx, int slot_index, int kind) {
        Slot slot = this.getSlot(cx, slot_index);
        int index = slot != null ? slot.implies(cx, kind) : 0;
        return index != 0 ? index : slot_index;
    }

    public int getOverloadIndex(Context cx, int slot_index, TypeValue t1) {
        int index = this.getSlot(cx, slot_index).dispatch(cx, t1);
        return index != 0 ? index : slot_index;
    }

    public int getOverloadIndex(Context cx, int slot_index, TypeValue t1, TypeValue t2) {
        t1 = t1 == null ? cx.noType() : t1;
        t2 = t2 == null ? cx.noType() : t2;
        int index = this.getSlot(cx, slot_index).dispatch(cx, t1, t2);
        return index != 0 ? index : slot_index;
    }

    public int addVar(Context cx) {
        return this.var_count++;
    }

    public int addMethod(Context cx) {
        return this.method_count++;
    }

    public int getFirstSlotIndex() {
        return 0;
    }

    public ObjectValue proto() {
        return this._proto_;
    }

    @Override
    public TypeInfo getType(Context cx) {
        if (this.type != null) {
            return this.type;
        }
        return cx.noType().getDefaultTypeInfo();
    }

    public boolean isDynamic() {
        return this.builder != null ? this.builder.is_dynamic : false;
    }

    public boolean isFinal() {
        return this.builder != null ? this.builder.is_final : false;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int compareTo(Object o) {
        if (o instanceof ObjectValue) {
            return this.name.compareTo(((ObjectValue)o).name);
        }
        return -1;
    }

    public HashMap<TypeValue, ClassDefinitionNode> getDeferredClassMap() {
        if (this.deferredClassMap == null) {
            this.deferredClassMap = new HashMap();
        }
        return this.deferredClassMap;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public boolean isInterface() {
        return this.builder instanceof ClassBuilder && ((ClassBuilder)this.builder).is_interface;
    }

    public boolean canEarlyBind() {
        boolean ret = true;
        if (this.builder instanceof InstanceBuilder) {
            ret = ((InstanceBuilder)this.builder).canEarlyBind;
        }
        return ret;
    }

    public Names getNames() {
        return this.names;
    }

    public void setNumberUsage(NumberUsage usage) {
        this.numberUsage = usage;
    }

    public NumberUsage getNumberUsage() {
        return this.numberUsage;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.flags |= 1;
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean booleanValue() {
        return this.getValue().equals("true");
    }

    public void setPackage(boolean package_flag) {
        this.flags = package_flag ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public boolean isPackage() {
        return (this.flags & 8) != 0;
    }

    public void setInitOnly(boolean b) {
        this.init_only_view = b;
    }

    public boolean isInitOnly() {
        return this.init_only_view;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public byte getNamespaceKind() {
        return 0;
    }

    public boolean isConfigNS() {
        return false;
    }

    public void addBaseObj(ObjectValue base) {
        if (this.base_objs == null) {
            this.base_objs = new ObjectList(1);
        }
        if (!this.base_objs.contains(base)) {
            this.base_objs.add(base);
        }
    }

    public void setProtectedNamespaces(ObjectValue protected_ns, ObjectValue base_protected) {
        this.protected_ns = protected_ns;
        this.base_protected_ns = base_protected;
    }

    static {
        nullSlot = new MethodSlot((TypeValue)null, 0);
    }

    private static class SlotIDCache {
        private IntList slot_id_boundaries;
        private int cur_range_index = 0;
        private int cur_slot_id = -1;

        public SlotIDCache(Slots slots) {
            this.init(slots);
        }

        void init(Slots slots) {
            this.cur_range_index = 0;
            this.cur_slot_id = -1;
            if (slots != null && slots.size() > 0) {
                int lo_id = ((Slot)slots.at((int)0)).id;
                int hi_id = ((Slot)slots.at((int)(slots.size() - 1))).id;
                if (slots.size() - 1 == hi_id - lo_id) {
                    this.slot_id_boundaries = new IntList(2);
                    this.slot_id_boundaries.add(lo_id);
                    this.slot_id_boundaries.add(hi_id);
                } else {
                    this.slot_id_boundaries = new IntList(6);
                    int last_id = lo_id;
                    int start_id = lo_id;
                    int size = slots.size();
                    for (int i = 1; i < size; ++i) {
                        int id = ((Slot)slots.at((int)i)).id;
                        if (id != last_id + 1) {
                            this.slot_id_boundaries.add(start_id);
                            this.slot_id_boundaries.add(last_id);
                            start_id = id;
                        }
                        last_id = id;
                    }
                    this.slot_id_boundaries.add(start_id);
                    this.slot_id_boundaries.add(last_id);
                }
                this.cur_slot_id = this.slot_id_boundaries.at(0);
            }
        }

        public int getNextSlotID(Context cx) {
            int slot_id = -1;
            if (this.cur_slot_id > this.slot_id_boundaries.last()) {
                slot_id = cx.statics.getNextSlotID();
            }
            while (slot_id == -1 && this.cur_range_index < this.slot_id_boundaries.size() - 1) {
                int hi = this.slot_id_boundaries.at(this.cur_range_index + 1);
                if (this.cur_slot_id > hi) {
                    this.cur_range_index += 2;
                    this.cur_slot_id = this.cur_range_index < this.slot_id_boundaries.size() - 1 ? this.slot_id_boundaries.at(this.cur_range_index) : this.cur_slot_id;
                    continue;
                }
                ++this.cur_slot_id;
            }
            if (slot_id == -1) {
                slot_id = cx.statics.getNextSlotID();
            }
            return slot_id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectValueCompare
    implements Comparator<ObjectValue> {
        @Override
        public int compare(ObjectValue o1, ObjectValue o2) {
            int result = o2.name.compareTo(o1.name);
            if (result == 0) {
                result += o2.getNamespaceKind() - o1.getNamespaceKind();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

