/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.embedding.avmplus.ActivationBuilder;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.FunctionBuilder;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Context;
import macromedia.asc.util.Decimal128;
import macromedia.asc.util.IntList;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbcParser {
    private Context ctx;
    private BytecodeBuffer buf;
    private static final boolean debug = false;
    private int[] cPoolIntPositions;
    private int[] cPoolUIntPositions;
    private int[] cPoolDoublePositions;
    private int[] cPoolDecimalPositions;
    private String[] cPoolStrs;
    private int[] cPoolNsPositions;
    private int[] cPoolNsSetPositions;
    private int[] cPoolMnPositions;
    private int[] methodPositions;
    private int[] metadataPositions;
    private int[] instancePositions;
    private int[] classPositions;
    private int[] scriptPositions;
    private final Map<String, Integer> fun_names = new HashMap<String, Integer>();
    private final Map<String, ClassDefinitionNode> class_nodes = new HashMap<String, ClassDefinitionNode>();
    private final ObjectList<ObjectList<ClassDefinitionNode>> clsdefs_sets = new ObjectList();
    private final ObjectList<String> region_name_stack = new ObjectList();

    public AbcParser(Context cx, String name) throws IOException {
        this.ctx = cx;
        this.buf = new BytecodeBuffer(name);
    }

    public AbcParser(Context cx, byte[] bytes) {
        this.ctx = cx;
        this.buf = new BytecodeBuffer(bytes);
    }

    public ProgramNode parseAbc() {
        try {
            int i;
            int minor_version = this.buf.readU16();
            this.buf.readU16();
            this.scanCpool(minor_version >= 17);
            this.scanMethods();
            this.scanMetadata();
            this.scanClasses();
            this.scanScripts();
            BinaryProgramNode program = this.ctx.getNodeFactory().binaryProgram(this.ctx, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null));
            program.frame = new ObjectValue(this.ctx, new GlobalBuilder(), this.ctx.noType());
            GlobalBuilder bui = (GlobalBuilder)program.frame.builder;
            bui.is_in_package = true;
            this.ctx.pushScope(program.frame);
            this.clsdefs_sets.add(new ObjectList());
            this.region_name_stack.push_back("");
            for (i = 0; i < this.scriptPositions.length; ++i) {
                this.parseScript(i, program);
            }
            program.clsdefs = this.clsdefs_sets.last();
            for (i = 0; i < program.statements.items.size(); ++i) {
                Node def = (Node)program.statements.items.get(i);
                if (!(def instanceof ClassDefinitionNode)) continue;
                NodeFactory nf = this.ctx.getNodeFactory();
                program.statements.items.set(i, nf.emptyStatement());
            }
            this.clsdefs_sets.removeLast();
            this.region_name_stack.pop_back();
            this.ctx.popScope();
            ProgramNode prog = this.ctx.getNodeFactory().program(this.ctx, this.ctx.getNodeFactory().statementList(null, program));
            return prog;
        }
        catch (Exception t) {
            ObjectValue scope = this.ctx.scope();
            ObjectValue global = this.ctx.globalScope();
            while (scope != global) {
                this.ctx.popScope();
                scope = this.ctx.scope();
            }
            return null;
        }
    }

    void scanCpool(boolean hasDecimal) {
        int i;
        int size = this.buf.readU32();
        this.cPoolIntPositions = new int[size];
        for (i = 1; i < size; ++i) {
            this.cPoolIntPositions[i] = this.buf.pos();
            this.buf.readU32();
        }
        size = this.buf.readU32();
        this.cPoolUIntPositions = new int[size];
        for (i = 1; i < size; ++i) {
            this.cPoolUIntPositions[i] = this.buf.pos();
            this.buf.readU32();
        }
        size = this.buf.readU32();
        this.cPoolDoublePositions = new int[size];
        for (i = 1; i < size; ++i) {
            this.cPoolDoublePositions[i] = this.buf.pos();
            this.buf.readDouble();
        }
        if (hasDecimal) {
            size = this.buf.readU32();
            this.cPoolDecimalPositions = new int[size];
            for (i = 1; i < size; ++i) {
                this.cPoolDecimalPositions[i] = this.buf.pos();
                this.buf.readDouble();
                this.buf.readDouble();
            }
        } else {
            this.cPoolDecimalPositions = new int[0];
        }
        this.cPoolStrs = new String[(size = this.buf.readU32()) > 0 ? size : 1];
        this.cPoolStrs[0] = "";
        for (i = 1; i < size; ++i) {
            long length = this.buf.readU32();
            this.cPoolStrs[i] = this.buf.readString((int)length).intern();
            this.buf.skip(length);
        }
        size = this.buf.readU32();
        this.cPoolNsPositions = new int[size];
        for (i = 1; i < size; ++i) {
            this.cPoolNsPositions[i] = this.buf.pos();
            this.buf.readU8();
            this.buf.readU32();
        }
        size = this.buf.readU32();
        this.cPoolNsSetPositions = new int[size];
        for (i = 1; i < size; ++i) {
            this.cPoolNsSetPositions[i] = this.buf.pos();
            long count = this.buf.readU32();
            for (long q = 0L; q < count; ++q) {
                this.buf.readU32();
            }
        }
        size = this.buf.readU32();
        this.cPoolMnPositions = new int[size];
        block15: for (i = 1; i < size; ++i) {
            this.cPoolMnPositions[i] = this.buf.pos();
            int kind = this.buf.readU8();
            switch (kind) {
                case 7: 
                case 13: {
                    this.buf.readU32();
                    this.buf.readU32();
                    continue block15;
                }
                case 15: 
                case 16: {
                    this.buf.readU32();
                    continue block15;
                }
                case 9: 
                case 14: {
                    this.buf.readU32();
                    this.buf.readU32();
                    continue block15;
                }
                case 27: 
                case 28: {
                    this.buf.readU32();
                    continue block15;
                }
                case 29: {
                    this.buf.readU32();
                    long count = this.buf.readU32();
                    this.buf.skipEntries(count);
                    continue block15;
                }
            }
        }
    }

    void scanMethods() {
        long methodEntries = this.buf.readU32();
        this.methodPositions = new int[(int)methodEntries];
        int i = 0;
        while ((long)i < methodEntries) {
            this.methodPositions[i] = this.buf.pos();
            long paramCount = this.buf.readU32();
            this.buf.readU32();
            this.buf.skipEntries(paramCount);
            this.buf.readU32();
            int flags = this.buf.readU8();
            long optionalCount = (flags & 8) != 0 ? (long)this.buf.readU32() : 0L;
            for (long q = 0L; q < optionalCount; ++q) {
                this.buf.readU32();
                this.buf.readU8();
            }
            long paramNameCount = (flags & 0x80) != 0 ? paramCount : 0L;
            for (long q = 0L; q < paramNameCount; ++q) {
                this.buf.readU32();
            }
            ++i;
        }
    }

    void scanMetadata() {
        long metadataEntries = this.buf.readU32();
        this.metadataPositions = new int[(int)metadataEntries];
        int i = 0;
        while ((long)i < metadataEntries) {
            this.metadataPositions[i] = this.buf.pos();
            this.buf.readU32();
            long value_count = this.buf.readU32();
            this.buf.skipEntries(value_count * 2L);
            ++i;
        }
    }

    void scanClasses() {
        long classEntries = this.buf.readU32();
        this.classPositions = new int[(int)classEntries];
        this.instancePositions = new int[(int)classEntries];
        int i = 0;
        while ((long)i < classEntries) {
            this.instancePositions[i] = this.buf.pos();
            this.buf.readU32();
            this.buf.readU32();
            int flags = this.buf.readU8();
            if ((flags & 8) != 0) {
                this.buf.readU32();
            }
            long interfaces = this.buf.readU32();
            this.buf.skipEntries(interfaces);
            this.buf.readU32();
            this.skipTraits();
            ++i;
        }
        i = 0;
        while ((long)i < classEntries) {
            this.classPositions[i] = this.buf.pos();
            this.buf.readU32();
            this.skipTraits();
            ++i;
        }
    }

    void scanScripts() {
        long scriptEntries = this.buf.readU32();
        this.scriptPositions = new int[(int)scriptEntries];
        int i = 0;
        while ((long)i < scriptEntries) {
            this.scriptPositions[i] = this.buf.pos();
            this.buf.readU32();
            this.skipTraits();
            ++i;
        }
    }

    void skipTraits() {
        long count = this.buf.readU32();
        int i = 0;
        while ((long)i < count) {
            this.buf.readU32();
            int kind = this.buf.readU8();
            int tag = kind & 0xF;
            switch (tag) {
                case 0: 
                case 6: {
                    this.buf.skipEntries(2L);
                    int temp = this.buf.readU32();
                    if (temp <= 0) break;
                    this.buf.readU32();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.buf.skipEntries(2L);
                    break;
                }
                case 4: 
                case 5: {
                    this.buf.skipEntries(2L);
                    break;
                }
            }
            if ((kind >> 4 & 4) != 0) {
                long metadata = this.buf.readU32();
                this.buf.skipEntries(metadata);
            }
            ++i;
        }
    }

    DefAndSlot slotTrait(int nameID, int slotID, int typeID, int valueID, int value_kind, boolean is_const) {
        ObjectValue obj = this.ctx.scope();
        DefAndSlot ret = new DefAndSlot();
        QName qName = this.getQNameFromCPool(nameID);
        String simpleName = this.getStringFromCPool(qName.name);
        ObjectValue ns = this.getNamespace(qName.nameSpace);
        Namespaces names = new Namespaces();
        names.push_back(ns);
        TypeValue type = this.ctx.noType();
        int var_id = obj.builder.Variable(this.ctx, obj);
        int slot_id = obj.builder.ExplicitVar(this.ctx, obj, simpleName, names, type, -1, -1, var_id);
        Slot slot = obj.getSlot(this.ctx, slot_id);
        slot.setConst(is_const);
        slot.setImported(true);
        ret.slot = slot;
        IdentifierNode id = this.identifierNode(simpleName, ns);
        AttributeListNode attr = this.attributeList(false, false, false, ns, obj.builder);
        if (value_kind == 8) {
            ObjectValue nsValue = this.getNamespace(valueID);
            slot.setObjectValue(nsValue);
            slot.setConst(true);
            ret.def = this.ctx.getNodeFactory().namespaceDefinition(attr, id, this.ctx.getNodeFactory().literalString(nsValue.name));
            return ret;
        }
        MemberExpressionNode typeExpr = null;
        Object typeIdNode = null;
        if (typeID != 0) {
            QName t = this.getQNameFromCPool(typeID);
            typeExpr = this.memberExprFromName(t);
        } else {
            typeExpr = null;
        }
        Node init = this.getInitValue(valueID, value_kind);
        TypedIdentifierNode typedID = this.ctx.getNodeFactory().typedIdentifier(id, typeExpr);
        int tok = is_const ? -65 : -112;
        VariableBindingNode bind = this.ctx.getNodeFactory().variableBinding(attr, tok, typedID, init);
        bind.ref = id.ref;
        if (typeExpr != null) {
            bind.typeref = typeExpr.ref;
        }
        ret.def = (DefinitionNode)this.ctx.getNodeFactory().variableDefinition(attr, tok, this.ctx.getNodeFactory().list(null, bind));
        return ret;
    }

    private MemberExpressionNode memberExprFromName(QName q) {
        MemberExpressionNode typeExpr = null;
        macromedia.asc.semantics.QName typeName = this.getFullName(q);
        if (typeName instanceof ParameterizedName) {
            ParameterizedQName pqn = (ParameterizedQName)q;
            ParameterizedName pn = (ParameterizedName)typeName;
            NodeFactory nf = this.ctx.getNodeFactory();
            IdentifierNode baseIdNode = this.identifierNode(pn.name, pn.ns);
            ListNode list = null;
            MemberExpressionNode param_node = this.memberExprFromName(this.getQNameFromCPool(pqn.params.at(0)));
            list = nf.list(list, param_node);
            Node apply = nf.applyTypeExpr(baseIdNode, list, -1);
            typeExpr = nf.memberExpression(null, (SelectorNode)apply);
            typeExpr.ref = baseIdNode.ref;
            typeExpr.ref.addTypeParam(param_node.ref);
        } else {
            IdentifierNode typeIdNode = this.identifierNode(typeName.name, typeName.ns);
            GetExpressionNode getNode = this.ctx.getNodeFactory().getExpression(typeIdNode);
            typeExpr = this.ctx.getNodeFactory().memberExpression(null, getNode);
            typeExpr.ref = typeIdNode.ref;
        }
        return typeExpr;
    }

    private IdentifierNode identifierNode(String simpleName, ObjectValue ns) {
        IdentifierNode id = this.ctx.getNodeFactory().identifier(simpleName);
        id.ref = new ReferenceValue(this.ctx, null, id.name, ns);
        return id;
    }

    DefAndSlot methodTrait(int nameID, int dispID, int methInfo, int attrs, int kind) {
        QName methQName = this.getQNameFromCPool(nameID);
        String methName = this.getStringFromCPool(methQName.name);
        ObjectValue ns = this.getNamespace(methQName.nameSpace);
        return this.methodTrait(methName, ns, dispID, methInfo, attrs, kind);
    }

    DefAndSlot methodTrait(String methName, ObjectValue ns, int dispID, int methInfo, int attrs, int kind) {
        int functionKind;
        int method_slot;
        ObjectValue obj = this.ctx.scope();
        DefAndSlot ret = new DefAndSlot();
        boolean isFinal = (attrs & 1) != 0;
        boolean isOverride = (attrs & 2) != 0;
        Namespaces names = new Namespaces();
        names.push_back(ns);
        switch (kind) {
            case 3: {
                int method_id = obj.builder.Method(this.ctx, obj, methName, names, false);
                method_slot = obj.builder.ExplicitSet(this.ctx, obj, methName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
                break;
            }
            case 2: {
                int method_id = obj.builder.Method(this.ctx, obj, methName, names, false);
                method_slot = obj.builder.ExplicitGet(this.ctx, obj, methName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
                break;
            }
            default: {
                int method_id = obj.builder.Method(this.ctx, obj, methName, names, false);
                method_slot = obj.builder.ExplicitCall(this.ctx, obj, methName, names, this.ctx.noType(), isFinal, isOverride, -1, method_id, -1);
            }
        }
        ObjectValue funcObj = new ObjectValue(this.ctx, new FunctionBuilder(), this.ctx.functionType());
        Slot slot = obj.getSlot(this.ctx, method_slot);
        slot.setObjectValue(funcObj);
        slot.setImported(true);
        StringBuffer internal_name = new StringBuffer(methName.length() + 5);
        if (!this.fun_names.containsKey(methName)) {
            this.fun_names.put(methName, Boxing.valueOf(0));
        }
        internal_name.append(methName).append('$');
        int num = this.fun_names.get(methName);
        internal_name.append(num);
        this.fun_names.put(methName, Boxing.valueOf(++num));
        int slot_id = obj.getImplicitIndex(this.ctx, method_slot, -133);
        Slot implied_slot = obj.getSlot(this.ctx, slot_id);
        implied_slot.setImported(true);
        String n = internal_name.toString();
        implied_slot.setMethodName(n);
        slot.getObjectValue().name = n;
        ret.slot = implied_slot;
        switch (kind) {
            case 2: {
                functionKind = -79;
                break;
            }
            case 3: {
                functionKind = -99;
                break;
            }
            default: {
                functionKind = -133;
            }
        }
        int original = this.buf.pos();
        this.buf.seek(this.methodPositions[methInfo]);
        int paramCount = this.buf.readU32();
        int returnType = this.buf.readU32();
        int[] paramTypes = new int[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            paramTypes[i] = this.buf.readU32();
        }
        this.buf.readU32();
        int flags = this.buf.readU8();
        boolean needs_rest = (flags & 4) != 0 || (flags & 0x10) != 0;
        boolean has_optional = (flags & 8) != 0;
        boolean has_param_names = (flags & 0x80) != 0;
        int optional_count = 0;
        ObjectList<Node> optional_nodes = null;
        if (has_optional) {
            optional_nodes = this.parseOptionalParams();
            optional_count = optional_nodes.size();
        }
        String[] param_names = new String[paramCount + optional_count];
        if (has_param_names) {
            for (int i = 0; i < paramCount; ++i) {
                param_names[i] = this.getStringFromCPool(this.buf.readU32());
            }
        }
        this.buf.seek(original);
        MemberExpressionNode retTypeNode = null;
        if (returnType != 0) {
            QName retQName = this.getQNameFromCPool(returnType);
            retTypeNode = this.memberExprFromName(retQName);
        }
        ParameterListNode paramList = null;
        funcObj.activation = new ObjectValue(this.ctx, new ActivationBuilder(), this.ctx.noType());
        int cur_optional = 0;
        for (int i = 0; i < paramCount; ++i) {
            macromedia.asc.semantics.QName typeName = null;
            QName typeQName = null;
            if (paramTypes[i] != 0) {
                typeQName = this.getQNameFromCPool(paramTypes[i]);
                typeName = this.getFullName(typeQName);
            }
            String simple_param_name = param_names[i] != null ? param_names[i] : new StringBuffer().append("param").append(i + 1).toString().intern();
            ParameterNode param = this.parameterNode(simple_param_name, typeQName);
            paramList = this.ctx.getNodeFactory().parameterList(paramList, param);
            int var_id = funcObj.activation.builder.Variable(this.ctx, funcObj.activation);
            funcObj.activation.builder.ExplicitVar(this.ctx, funcObj.activation, simple_param_name, this.ctx.publicNamespace(), this.ctx.noType(), -1, -1, var_id);
            if (!has_optional || i < paramCount - optional_count) continue;
            param.init = (Node)optional_nodes.get(cur_optional++);
        }
        if (needs_rest) {
            ParameterNode param = this.parameterNode("rest", this.ctx.arrayType().name);
            int var_id = funcObj.activation.builder.Variable(this.ctx, funcObj.activation);
            funcObj.activation.builder.ExplicitVar(this.ctx, funcObj.activation, "rest", this.ctx.publicNamespace(), this.ctx.arrayType(), -1, -1, var_id);
            RestParameterNode restNode = this.ctx.getNodeFactory().restParameter(param, -1);
            restNode.ref = param.ref;
            restNode.typeref = param.typeref;
            paramList = this.ctx.getNodeFactory().parameterList(paramList, restNode);
            this.ctx.getNodeFactory().has_rest = false;
        }
        FunctionSignatureNode fsn = this.ctx.getNodeFactory().functionSignature(paramList, retTypeNode);
        if (retTypeNode != null) {
            fsn.typeref = retTypeNode.ref;
        }
        IdentifierNode idNode = this.identifierNode(methName, ns);
        FunctionCommonNode fcn = this.ctx.getNodeFactory().functionCommon(this.ctx, idNode, fsn, null);
        fcn.fun = funcObj;
        fcn.kind = functionKind;
        FunctionNameNode fn = this.ctx.getNodeFactory().functionName(functionKind, idNode);
        AttributeListNode attr = this.attributeList(isFinal, isOverride, false, ns, obj.builder);
        BinaryFunctionDefinitionNode fdn = this.ctx.getNodeFactory().binaryFunctionDefinition(this.ctx, attr, fn, fcn, -1);
        fn.identifier.ref = fcn.ref = new ReferenceValue(this.ctx, null, idNode.name, ns);
        ret.def = fdn;
        return ret;
    }

    private Node getInitValue(int value_index, int value_kind) {
        Node current_node;
        NodeFactory nf = this.ctx.getNodeFactory();
        switch (value_kind) {
            case 0: {
                current_node = nf.unaryExpression(-113, nf.literalNumber("0", -1), -1);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                double val = this.getNumberFromCPool(value_index, value_kind);
                current_node = nf.literalNumber(String.valueOf(val));
                break;
            }
            case 2: {
                Decimal128 dval = this.getDecimalFromCPool(value_index);
                String sval = dval.toString();
                if (this.ctx.statics.es4_numerics) {
                    sval = new StringBuffer().append(sval).append("m").toString();
                }
                current_node = nf.literalNumber(sval);
                break;
            }
            case 11: {
                current_node = nf.literalBoolean(true);
                break;
            }
            case 10: {
                current_node = nf.literalBoolean(false);
                break;
            }
            case 1: {
                current_node = nf.literalString(this.getStringFromCPool(value_index));
                break;
            }
            case 12: {
                current_node = nf.literalNull();
                break;
            }
            case 8: {
                ObjectValue ns = this.getNamespace(value_index);
                current_node = nf.literalString(ns.name);
                break;
            }
            default: {
                current_node = nf.literalString("");
            }
        }
        return current_node;
    }

    private ObjectList<Node> parseOptionalParams() {
        int optional_count = this.buf.readU32();
        ObjectList<Node> optionals = new ObjectList<Node>(optional_count);
        for (int i = 0; i < optional_count; ++i) {
            int value_index = this.buf.readU32();
            int value_kind = this.buf.readU8();
            Node current_node = this.getInitValue(value_index, value_kind);
            optionals.push_back(current_node);
        }
        return optionals;
    }

    private ParameterNode parameterNode(String simple_param_name, macromedia.asc.semantics.QName typeName) {
        IdentifierNode ident = this.identifierNode(simple_param_name, this.ctx.publicNamespace());
        IdentifierNode type_ident = null;
        MemberExpressionNode paramTypeNode = null;
        if (typeName != null) {
            type_ident = this.identifierNode(typeName.name, typeName.ns);
            GetExpressionNode getNode = this.ctx.getNodeFactory().getExpression(type_ident);
            paramTypeNode = this.ctx.getNodeFactory().memberExpression(null, getNode);
        }
        ParameterNode param = this.ctx.getNodeFactory().parameter(-112, ident, paramTypeNode);
        if (type_ident != null) {
            param.typeref = type_ident.ref;
        }
        param.ref = ident.ref;
        return param;
    }

    private ParameterNode parameterNode(String simple_param_name, QName typeName) {
        IdentifierNode ident = this.identifierNode(simple_param_name, this.ctx.publicNamespace());
        MemberExpressionNode paramTypeNode = null;
        if (typeName != null) {
            paramTypeNode = this.memberExprFromName(typeName);
        }
        ParameterNode param = this.ctx.getNodeFactory().parameter(-112, ident, paramTypeNode);
        if (paramTypeNode != null) {
            param.typeref = paramTypeNode.ref;
        }
        param.ref = ident.ref;
        return param;
    }

    AttributeListNode attributeList(boolean isFinal, boolean isOverride, boolean isDynamic, ObjectValue ns, Builder builder) {
        AttributeListNode attr = this.ctx.getNodeFactory().attributeList(this.ctx.getNodeFactory().literalString(""), null);
        attr.hasFinal = isFinal;
        attr.hasOverride = isOverride;
        attr.hasDynamic = isDynamic;
        if (builder instanceof ClassBuilder) {
            attr.hasStatic = true;
        }
        if (ns != null && (ns == this.ctx.publicNamespace() || ns.getNamespaceKind() == 0 && ns.isPackage())) {
            attr.hasPublic = true;
        } else if (ns != null && ns.isInternal()) {
            attr.hasInternal = true;
        } else if (ns != null && ns.isProtected()) {
            attr.hasProtected = true;
        } else if (ns != null && ns.isPrivate()) {
            attr.hasPrivate = true;
        } else if (ns != null) {
            if (builder.classname != null && ns == builder.classname.ns) {
                attr.hasPublic = true;
            } else {
                attr.namespaces.add(ns);
            }
        }
        return attr;
    }

    macromedia.asc.semantics.QName getFullName(QName q) {
        if (q instanceof ParameterizedQName) {
            ParameterizedQName p = (ParameterizedQName)q;
            QName base = this.getQNameFromCPool(p.name);
            macromedia.asc.semantics.QName base_qn = this.getFullName(base);
            ObjectList<macromedia.asc.semantics.QName> params = new ObjectList<macromedia.asc.semantics.QName>();
            for (int i = 0; i < p.params.size(); ++i) {
                params.add(this.getFullName(this.getQNameFromCPool(p.params.at(i))));
            }
            ParameterizedName pn = new ParameterizedName(params, base_qn.ns, base_qn.name);
            return pn;
        }
        String fullName = this.getStringFromCPool(q.name);
        ObjectValue ns = this.getNamespace(q.nameSpace);
        return this.ctx.computeQualifiedName("", fullName, ns, -133);
    }

    DefAndSlot classTrait(int nameID, int slotID, int classID) {
        ObjectValue iframe;
        TypeValue cframe;
        int flags;
        if (classID >= this.classPositions.length || classID < 0) {
            return null;
        }
        DefAndSlot ret = new DefAndSlot();
        ObjectValue obj = this.ctx.scope();
        QName classQName = this.getQNameFromCPool(nameID);
        String className = this.getStringFromCPool(classQName.name);
        ObjectValue ns = this.getNamespace(classQName.nameSpace);
        String region_name = this.region_name_stack.back();
        if (region_name.length() > 0) {
            region_name = new StringBuffer().append(region_name).append("/").toString();
            ns = this.ctx.getNamespace(new StringBuffer().append(region_name).append(ns.name).toString());
        }
        int instancePos = this.instancePositions[classID];
        int classPos = this.classPositions[classID];
        int orig = this.buf.pos();
        this.buf.seek(instancePos);
        long instanceNameID = this.buf.readU32();
        QName instanceQName = this.getQNameFromCPool((int)instanceNameID);
        macromedia.asc.semantics.QName fullName = this.getFullName(instanceQName);
        long superID = this.buf.readU32();
        boolean hasSuper = false;
        macromedia.asc.semantics.QName superName = null;
        String simpleSuperName = "";
        ObjectValue superNS = null;
        if (superID != 0L) {
            hasSuper = true;
            QName superQName = this.getQNameFromCPool((int)superID);
            superNS = this.getNamespace(superQName.nameSpace);
            superName = this.getFullName(superQName);
            simpleSuperName = this.getStringFromCPool(superQName.name);
        }
        if (((flags = this.buf.readU8()) & 8) != 0) {
            this.buf.readU32();
        }
        long interfaces = this.buf.readU32();
        ListNode interface_nodes = null;
        for (long i = 0L; i < interfaces; ++i) {
            int int_index = this.buf.readU32();
            QName intName = this.getMultinameFromCPool(int_index);
            String simpleIntName = this.getStringFromCPool(intName.name);
            Namespaces intNamespaces = this.getNamespaces(intName.nameSpace);
            IdentifierNode ident = this.ctx.getNodeFactory().identifier(simpleIntName);
            ident.ref = new ReferenceValue(this.ctx, null, simpleIntName, intNamespaces);
            GetExpressionNode getNode = this.ctx.getNodeFactory().getExpression(ident);
            MemberExpressionNode interface_node = this.ctx.getNodeFactory().memberExpression(null, getNode);
            interface_node.ref = ident.ref;
            interface_nodes = this.ctx.getNodeFactory().list(interface_nodes, interface_node);
            interface_nodes.values.push_back(ident.ref);
        }
        long methID = this.buf.readU32();
        boolean isFinal = (flags & 2) != 0;
        boolean isDynamic = (flags & 1) == 0;
        boolean isInterface = (flags & 4) != 0;
        BinaryClassDefNode cdn = null;
        IdentifierNode idNode = this.ctx.getNodeFactory().identifier(className);
        idNode.ref = new ReferenceValue(this.ctx, null, idNode.name, ns);
        AttributeListNode attr = this.attributeList(isFinal, false, isDynamic, ns, obj.builder);
        cdn = isInterface ? this.ctx.getNodeFactory().binaryInterfaceDefinition(this.ctx, attr, idNode, null, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null)) : this.ctx.getNodeFactory().binaryClassDefinition(this.ctx, attr, idNode, null, this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null));
        cdn.ref = idNode.ref;
        cdn.interfaces = interface_nodes;
        cdn.protected_namespace = this.ctx.getNamespace(fullName.toString(), (byte)3);
        cdn.static_protected_namespace = this.ctx.getNamespace(fullName.toString(), (byte)5);
        boolean is_builtin = this.ctx.isBuiltin(fullName.toString());
        if (is_builtin) {
            cdn.cframe = cframe = this.ctx.builtin(fullName.toString());
            cdn.iframe = iframe = cframe.prototype;
        } else {
            cdn.cframe = cframe = TypeValue.newTypeValue(this.ctx, new ClassBuilder(fullName, cdn.protected_namespace, cdn.static_protected_namespace), fullName, 8192);
            cdn.iframe = iframe = new ObjectValue(this.ctx, new InstanceBuilder(fullName), cframe);
            cframe.prototype = iframe;
            ((InstanceBuilder)iframe.builder).canEarlyBind = false;
            cdn.debug_name = fullName.toString();
            cdn.owns_cframe = true;
        }
        if (isInterface) {
            ((ClassBuilder)cdn.cframe.builder).is_interface = true;
        }
        cdn.cframe.builder.is_dynamic = cdn.iframe.builder.is_dynamic = isDynamic;
        cdn.cframe.builder.is_final = cdn.iframe.builder.is_final = isFinal;
        this.class_nodes.put(fullName.toString(), cdn);
        this.clsdefs_sets.last().add(cdn);
        if (hasSuper) {
            cdn.baseclass = this.ctx.getNodeFactory().literalString(superName.toString(), -1);
            if (this.ctx.isBuiltin(superName.toString())) {
                TypeValue superType;
                cframe.baseclass = superType = this.ctx.builtin(superName.toString());
                cdn.baseref = new ReferenceValue(this.ctx, null, superName.toString(), this.ctx.publicNamespace());
            } else {
                cdn.baseref = new ReferenceValue(this.ctx, null, simpleSuperName, superNS);
                cdn.baseref.getSlot(this.ctx);
            }
        } else if (cdn.cframe != this.ctx.objectType()) {
            NodeFactory nf = this.ctx.getNodeFactory();
            cdn.baseclass = nf.memberExpression(null, nf.getExpression(nf.identifier("Object")));
            cframe.baseclass = this.ctx.objectType();
        } else {
            cdn.baseclass = null;
            cframe.baseclass = null;
        }
        cframe.builder.is_final = isFinal;
        cframe.builder.is_dynamic = isDynamic;
        int var_id = obj.builder.Variable(this.ctx, obj);
        int slot_id = obj.builder.ExplicitVar(this.ctx, obj, className, ns, this.ctx.typeType(), -1, -1, var_id);
        Slot slot = obj.getSlot(this.ctx, slot_id);
        slot.setObjectValue(cframe);
        slot.setImported(true);
        slot.setConst(true);
        ret.slot = slot;
        obj.builder.ImplicitCall(this.ctx, obj, slot_id, cframe, 16, -1, -1);
        obj.builder.ImplicitConstruct(this.ctx, obj, slot_id, cframe, 16, -1, -1);
        if (isInterface) {
            ((ClassBuilder)cframe.builder).is_interface = true;
            slot.setImplNode(cdn);
        }
        this.clsdefs_sets.add(new ObjectList());
        this.region_name_stack.push_back(fullName.toString());
        this.ctx.pushStaticClassScopes(cdn);
        this.ctx.pushScope(iframe);
        StatementListNode instance_stmts = this.ctx.getNodeFactory().statementList((StatementListNode)null, (StatementListNode)null);
        this.parseTraits(null, instance_stmts);
        cdn.instanceinits = new ObjectList(instance_stmts.items.size());
        if (instance_stmts.items.size() > 0) {
            cdn.instanceinits.addAll(instance_stmts.items);
        }
        DefinitionNode iinit_node = this.methodTrait((String)"$construct", (ObjectValue)this.ctx.publicNamespace(), (int)0, (int)((int)methID), (int)0, (int)0).def;
        cdn.instanceinits.add(iinit_node);
        this.ctx.popScope();
        this.buf.seek(classPos);
        this.buf.readU32();
        this.parseTraits(null, cdn.statements);
        this.ctx.popStaticClassScopes(cdn);
        this.buf.seek(orig);
        this.clsdefs_sets.removeLast();
        this.region_name_stack.pop_back();
        ret.def = cdn;
        return ret;
    }

    void parseTraits(BinaryProgramNode node, StatementListNode statements) {
        long count = this.buf.readU32();
        for (long i = 0L; i < count; ++i) {
            long nameID = this.buf.readU32();
            int kind = this.buf.readU8();
            int tag = kind & 0xF;
            int value_kind = 0;
            DefAndSlot d = null;
            switch (tag) {
                case 0: 
                case 6: {
                    long slotID = this.buf.readU32();
                    long typeID = this.buf.readU32();
                    long valueID = this.buf.readU32();
                    if (valueID > 0L) {
                        value_kind = this.buf.readU8();
                    }
                    d = this.slotTrait((int)nameID, (int)slotID, (int)typeID, (int)valueID, value_kind, tag == 6);
                    statements.items.add(d.def);
                    if (node == null) break;
                    QName qName = this.getQNameFromCPool((int)nameID);
                    String simpleName = this.getStringFromCPool(qName.name);
                    ObjectValue ns = this.getNamespace(qName.nameSpace);
                    node.toplevelDefinitions.add(new macromedia.asc.semantics.QName(ns, simpleName));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    long dispID = this.buf.readU32();
                    long methInfo = this.buf.readU32();
                    int attrs = kind >> 4;
                    d = this.methodTrait((int)nameID, (int)dispID, (int)methInfo, attrs, tag);
                    statements.items.add(d.def);
                    if (node == null) break;
                    QName qName = this.getQNameFromCPool((int)nameID);
                    String simpleName = this.getStringFromCPool(qName.name);
                    ObjectValue ns = this.getNamespace(qName.nameSpace);
                    node.toplevelDefinitions.add(new macromedia.asc.semantics.QName(ns, simpleName));
                    break;
                }
                case 4: {
                    long slotID = this.buf.readU32();
                    long classID = this.buf.readU32();
                    d = this.classTrait((int)nameID, (int)slotID, (int)classID);
                    statements.items.add(d.def);
                    if (node == null) break;
                    QName qName = this.getQNameFromCPool((int)nameID);
                    String simpleName = this.getStringFromCPool(qName.name);
                    ObjectValue ns = this.getNamespace(qName.nameSpace);
                    node.toplevelDefinitions.add(new macromedia.asc.semantics.QName(ns, simpleName));
                    break;
                }
                case 5: {
                    this.buf.skipEntries(2L);
                    break;
                }
            }
            if ((kind >> 4 & 4) == 0) continue;
            long metadatacount = this.buf.readU32();
            int q = 0;
            while ((long)q < metadatacount) {
                long metaIndex = this.buf.readU32();
                MetaDataNode metaNode = this.parseMetadataInfo((int)metaIndex);
                if (d != null) {
                    if (d.def != null) {
                        metaNode.def = d.def;
                        d.def.addMetaDataNode(metaNode);
                        statements.items.add(metaNode);
                    }
                    if (d.slot != null && "Deprecated" == metaNode.id) {
                        d.slot.addMetadata(metaNode);
                    }
                }
                ++q;
            }
        }
    }

    void parseScript(int scriptIndex, BinaryProgramNode program) {
        if (scriptIndex < 0 || scriptIndex >= this.scriptPositions.length) {
            return;
        }
        int orig = this.buf.pos();
        this.buf.seek(this.scriptPositions[scriptIndex]);
        this.buf.readU32();
        this.parseTraits(program, program.statements);
        this.buf.seek(orig);
    }

    MetaDataNode parseMetadataInfo(int index) {
        int metaPos = this.metadataPositions[index];
        int orig = this.buf.pos();
        this.buf.seek(metaPos);
        long idIndex = this.buf.readU32();
        long valueCount = this.buf.readU32();
        MetaDataNode metaNode = this.ctx.getNodeFactory().metaData(null, -1);
        metaNode.id = this.getStringFromCPool((int)idIndex);
        if (valueCount > 0L) {
            IntList keys = new IntList((int)valueCount);
            IntList values = new IntList((int)valueCount);
            int i = 0;
            while ((long)i < valueCount) {
                keys.add(this.buf.readU32());
                ++i;
            }
            int j = 0;
            while ((long)j < valueCount) {
                values.add(this.buf.readU32());
                ++j;
            }
            metaNode.values = new Value[(int)valueCount];
            int k = 0;
            while ((long)k < valueCount) {
                int key = keys.get(k);
                int value = values.get(k);
                Value val = null;
                val = key == 0 ? new MetaDataEvaluator.KeylessValue(this.getStringFromCPool(value)) : new MetaDataEvaluator.KeyValuePair(this.getStringFromCPool(key), this.getStringFromCPool(value));
                metaNode.values[k] = val;
                ++k;
            }
        }
        this.buf.seek(orig);
        return metaNode;
    }

    String getStringFromCPool(int id) {
        return this.cPoolStrs[id];
    }

    Decimal128 getDecimalFromCPool(int id) {
        int pos = this.cPoolDecimalPositions[id];
        int orig = this.buf.pos();
        this.buf.seek(pos);
        byte[] rep = this.buf.readBytes(16);
        Decimal128 dval = new Decimal128(rep);
        this.buf.seek(orig);
        return dval;
    }

    double getNumberFromCPool(int id, int kind) {
        double ret = 0.0;
        int[] cpool = null;
        switch (kind) {
            case 3: {
                cpool = this.cPoolIntPositions;
                break;
            }
            case 4: {
                cpool = this.cPoolUIntPositions;
                break;
            }
            case 6: {
                cpool = this.cPoolDoublePositions;
            }
        }
        if (cpool != null) {
            int pos = cpool[id];
            int orig = this.buf.pos();
            this.buf.seek(pos);
            switch (kind) {
                case 3: {
                    ret = this.buf.readU32();
                    break;
                }
                case 4: {
                    ret = (long)this.buf.readU32() & 0xFFFFFFFFL;
                    break;
                }
                case 6: {
                    ret = this.buf.readDouble();
                }
            }
            this.buf.seek(orig);
        }
        return ret;
    }

    QName getQNameFromCPool(int index) {
        int orig = this.buf.pos();
        QName value = new QName();
        value.nameSpace = 0;
        value.name = 0;
        this.buf.seek(this.cPoolMnPositions[index]);
        int kind = this.buf.readU8();
        switch (kind) {
            case 7: 
            case 13: {
                value.nameSpace = this.buf.readU32();
                value.name = this.buf.readU32();
                break;
            }
            case 29: {
                int name = this.buf.readU32();
                int count = this.buf.readU32();
                IntList params = new IntList(count);
                for (int i = 0; i < count; ++i) {
                    params.add(this.buf.readU32());
                }
                value = new ParameterizedQName(name, params);
                break;
            }
        }
        this.buf.seek(orig);
        return value;
    }

    QName getMultinameFromCPool(int index) {
        int orig = this.buf.pos();
        QName value = new QName();
        value.nameSpace = 0;
        value.name = 0;
        this.buf.seek(this.cPoolMnPositions[index]);
        int kind = this.buf.readU8();
        switch (kind) {
            case 9: 
            case 14: {
                value.name = this.buf.readU32();
                value.nameSpace = this.buf.readU32();
                break;
            }
        }
        this.buf.seek(orig);
        return value;
    }

    Namespaces getNamespaces(int namespaceSetID) {
        int orig = this.buf.pos();
        this.buf.seek(this.cPoolNsSetPositions[namespaceSetID]);
        int count = this.buf.readU32();
        Namespaces val = new Namespaces(count);
        for (int i = 0; i < count; ++i) {
            val.add(this.getNamespace(this.buf.readU32()));
        }
        this.buf.seek(orig);
        return val;
    }

    ObjectValue getNamespace(int namespaceID) {
        ObjectValue ns = null;
        if (namespaceID == 0) {
            ns = this.ctx.anyNamespace();
        } else {
            int orig = this.buf.pos();
            this.buf.seek(this.cPoolNsPositions[namespaceID]);
            int kind = this.buf.readU8();
            switch (kind) {
                case 8: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()));
                    break;
                }
                case 22: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()));
                    ns.setPackage(true);
                    break;
                }
                case 24: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)3);
                    break;
                }
                case 23: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)1);
                    break;
                }
                case 5: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)2);
                    break;
                }
                case 25: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)4);
                    break;
                }
                case 26: {
                    ns = this.ctx.getNamespace(this.getStringFromCPool(this.buf.readU32()), (byte)5);
                }
            }
            this.buf.seek(orig);
        }
        return ns;
    }

    static class ParameterizedQName
    extends QName {
        IntList params;

        ParameterizedQName(int name, IntList params) {
            this.name = name;
            this.params = params;
        }
    }

    static class QName {
        int name;
        int nameSpace;

        QName() {
        }
    }

    private static class DefAndSlot {
        public DefinitionNode def;
        public Slot slot;

        private DefAndSlot() {
        }
    }
}

