/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Names;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.DependencyGraph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

public class BatchCompiler {
    private static List<File> file;
    private static List<Context> cx;
    private static List<ActionBlockEmitter> emitter;
    private static List<ProgramNode> node;
    private static List<FlowAnalyzer> fa;
    private static Set<Pair> inheritance;
    private static Set<Pair> type;
    private static ContextStatics s;

    public static void main(String[] args) throws Throwable {
        long startTime = System.currentTimeMillis();
        BatchCompiler.init(args);
        int start = 0;
        int end = file.size();
        while (start < end) {
            BatchCompiler.parse(start, end);
            BatchCompiler.fa_part1(start, end);
            BatchCompiler.resolveInheritance(start, end);
            start = end;
            end = file.size();
            if (start < end) continue;
            BatchCompiler.sortInheritance();
            BatchCompiler.fa_part2();
            BatchCompiler.resolveType();
            start = end;
            end = file.size();
            if (start < end) continue;
            BatchCompiler.importType();
            BatchCompiler.ce();
            BatchCompiler.cg();
            BatchCompiler.resolveExpression();
            start = end;
            end = file.size();
        }
        BatchCompiler.clear();
        System.err.println("Files: " + file.size() + " Time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void init(String[] args) throws Throwable {
        int i;
        TypeValue.init();
        ObjectValue.init();
        s = new ContextStatics();
        file = new ArrayList<File>(args.length);
        int length = args.length;
        for (i = 0; i < length; ++i) {
            File f = new File(args[i]);
            if (!f.exists() || !f.isFile()) continue;
            file.add(f.getCanonicalFile());
        }
        cx = new ArrayList<Context>(file.size());
        length = file.size();
        for (i = 0; i < length; ++i) {
            cx.add(new Context(s));
        }
        emitter = new ArrayList<ActionBlockEmitter>(file.size());
        length = file.size();
        for (i = 0; i < length; ++i) {
            emitter.add(new ActionBlockEmitter(cx.get(i), file.get(i).getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, false));
        }
        node = new ArrayList<ProgramNode>(file.size());
        fa = new ArrayList<FlowAnalyzer>(file.size());
        inheritance = new HashSet<Pair>();
        type = new HashSet<Pair>();
    }

    private static void parse(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).setScriptName(file.get(i).getName());
            cx.get(i).setPath(file.get(i).getParent());
            if (file.get(i).getName().endsWith(".as")) {
                node.add(new Parser(cx.get(i), new FileInputStream(file.get(i)), file.get(i).getPath(), null).parseProgram());
            } else {
                node.add(new AbcParser(cx.get(i), file.get(i).getPath()).parseAbc());
            }
            BatchCompiler.cx.get((int)i).getNodeFactory().pkg_defs.clear();
        }
    }

    private static void fa_part1(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (cx.get(i).errorCount() != 0 || BatchCompiler.node.get((int)i).state != 1) continue;
            cx.get(i).pushScope(new ObjectValue(cx.get(i), new GlobalBuilder(), null));
            FlowGraphEmitter fgEmitter = new FlowGraphEmitter(cx.get(i), file.get(i).getPath(), false);
            fa.add(new FlowAnalyzer(fgEmitter));
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveInheritance(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            Iterator<ReferenceValue> k = BatchCompiler.node.get((int)i).fa_unresolved.iterator();
            while (k.hasNext()) {
                int size;
                ReferenceValue ref = k.next();
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    Pair p;
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    int where = BatchCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !inheritance.contains(p = new Pair(i, where))) {
                        inheritance.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).fa_unresolved.clear();
        }
    }

    private static void sortInheritance() throws Throwable {
        Iterator<Pair> i = inheritance.iterator();
        while (i.hasNext()) {
            Pair p = i.next();
            if (p.processed) continue;
            fa.get(p.i);
            FlowAnalyzer.inheritSlots(BatchCompiler.node.get((int)p.where).frame, BatchCompiler.node.get((int)p.i).frame, BatchCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            p.processed = true;
        }
        final DependencyGraph<Integer> g = new DependencyGraph<Integer>();
        int length = node.size();
        for (int i2 = 0; i2 < length; ++i2) {
            String path = file.get(i2).getPath();
            g.put(path, Boxing.valueOf(i2));
            if (!g.containsVertex(path)) {
                g.addVertex(new Vertex<String>(path));
            }
            Iterator<Pair> j = inheritance.iterator();
            while (j.hasNext()) {
                Pair p = j.next();
                if (p.i != i2) continue;
                g.addDependency(path, file.get(p.where).getPath());
            }
        }
        final ArrayList tsort = new ArrayList(node.size());
        Algorithms.topologicalSort(g, new Visitor<String>(){

            @Override
            public void visit(Vertex<String> v) {
                String name = v.getWeight();
                tsort.add(g.get(name));
            }
        });
        if (node.size() > tsort.size()) {
            int length2 = node.size();
            for (int i3 = 0; i3 < length2; ++i3) {
                int j;
                for (j = 0; j < tsort.size() && (Integer)tsort.get(j) != i3; ++j) {
                }
                if (j != tsort.size()) continue;
                String path = file.get(i3).getPath();
                System.out.println(path + " in circular reference");
            }
        } else {
            int j;
            int length3;
            ArrayList<File> tempFile = new ArrayList<File>(file.size());
            ArrayList<Context> tempCX = new ArrayList<Context>(cx.size());
            ArrayList<ActionBlockEmitter> tempEmitter = new ArrayList<ActionBlockEmitter>(emitter.size());
            ArrayList<ProgramNode> tempNode = new ArrayList<ProgramNode>(node.size());
            ArrayList<FlowAnalyzer> tempFA = new ArrayList<FlowAnalyzer>(fa.size());
            int length4 = tsort.size();
            for (int i4 = 0; i4 < length4; ++i4) {
                int loc = (Integer)tsort.get(i4);
                tempFile.add(file.get(loc));
                tempCX.add(cx.get(loc));
                tempEmitter.add(emitter.get(loc));
                tempNode.add(node.get(loc));
                tempFA.add(fa.get(loc));
            }
            file = tempFile;
            cx = tempCX;
            emitter = tempEmitter;
            node = tempNode;
            fa = tempFA;
            Iterator<Pair> i5 = type.iterator();
            block6: while (i5.hasNext()) {
                Pair p = i5.next();
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block6;
                }
            }
            i5 = inheritance.iterator();
            block9: while (i5.hasNext()) {
                Pair p = i5.next();
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block9;
                }
            }
        }
    }

    private static void fa_part2() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || BatchCompiler.node.get((int)i).state != 2) continue;
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveType() throws Throwable {
        Pair p;
        int where;
        QName qname;
        int j;
        int size;
        boolean found;
        ReferenceValue ref;
        Iterator<ReferenceValue> k;
        int i;
        int length = node.size();
        for (i = 0; i < length; ++i) {
            k = BatchCompiler.node.get((int)i).ce_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = BatchCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).ce_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            k = BatchCompiler.node.get((int)i).body_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = BatchCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).body_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            k = BatchCompiler.node.get((int)i).ns_unresolved.iterator();
            while (k.hasNext()) {
                ref = k.next();
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = BatchCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).ns_unresolved.clear();
        }
    }

    private static void importType() throws Throwable {
        Iterator<Pair> i = type.iterator();
        while (i.hasNext()) {
            Pair p = i.next();
            if (p.processed) continue;
            if (!inheritance.contains(p)) {
                fa.get(p.i);
                FlowAnalyzer.inheritSlots(BatchCompiler.node.get((int)p.where).frame, BatchCompiler.node.get((int)p.i).frame, BatchCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            }
            p.processed = true;
        }
    }

    private static void ce() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            ConstantEvaluator analyzer = new ConstantEvaluator(cx.get(i));
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void cg() throws Throwable {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).pushScope(BatchCompiler.node.get((int)i).frame);
            CodeGenerator generator = new CodeGenerator(cx.get(i).getEmitter());
            node.get(i).evaluate(cx.get(i), generator);
            ByteList bytes = new ByteList();
            cx.get(i).getEmitter().emit(bytes);
            emitter.set(i, null);
            FileOutputStream out = new FileOutputStream(new File(file.get(i).getParentFile(), file.get(i).getName().substring(0, file.get(i).getName().length() - "as".length()) + "abc"));
            System.err.println(file.get(i).getName() + ": " + bytes.size());
            out.write(bytes.toByteArray());
            out.flush();
            out.close();
            cx.get(i).popScope();
        }
    }

    private static void resolveExpression() throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Iterator<ReferenceValue> k = BatchCompiler.node.get((int)i).rt_unresolved.iterator();
            while (k.hasNext()) {
                int size;
                ReferenceValue ref = k.next();
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    if (qname.ns instanceof UnresolvedNamespace && ((UnresolvedNamespace)qname.ns).resolved) {
                        found = true;
                        break;
                    }
                    int where = BatchCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " in " + file.get(i) + " not resolved");
            }
            BatchCompiler.node.get((int)i).rt_unresolved.clear();
        }
    }

    private static void clear() {
        s.clear();
        ObjectValue.clear();
        TypeValue.clear();
    }

    private static int findDefinition(QName defName) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Names names = BatchCompiler.node.get((int)i).frame.builder.getNames();
            for (int j = 0; j < 4; ++j) {
                if (!names.containsKey(defName.name, defName.ns, j)) continue;
                return i;
            }
        }
        return BatchCompiler.searchClasspath(defName);
    }

    private static int findClass(QName className) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            int size;
            int n = size = BatchCompiler.node.get((int)i).clsdefs != null ? BatchCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < size; ++j) {
                ClassDefinitionNode clsdef = (ClassDefinitionNode)BatchCompiler.node.get((int)i).clsdefs.get(j);
                if (!clsdef.cframe.builder.classname.equals(className)) continue;
                return i;
            }
        }
        return BatchCompiler.searchClasspath(className);
    }

    private static int searchClasspath(QName qname) throws Throwable {
        String path = qname.ns.name.replace('.', File.separatorChar) + File.separatorChar + qname.name;
        File f = new File(path + ".as");
        if (f.exists() && f.isFile()) {
            f = f.getCanonicalFile();
            Context context = new Context(s);
            int where = file.indexOf(f);
            if (where == -1) {
                file.add(f);
                cx.add(context);
                emitter.add(new ActionBlockEmitter(context, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, false));
                where = file.size() - 1;
            }
            return where;
        }
        return -1;
    }

    static class Pair {
        int i;
        int where;
        boolean processed;

        Pair(int i, int where) {
            this.i = i;
            this.where = where;
            this.processed = false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                return this.i == ((Pair)obj).i && this.where == ((Pair)obj).where;
            }
            return false;
        }

        public int hashCode() {
            return (17 + this.i) * 17 + this.where;
        }
    }
}

