/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Qualifiers;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Names {
    private String[] names;
    private ObjectValue[] namespaces;
    private int[] bindings;
    private int size;
    private Names delegate = EMPTY_NAMES;
    public static final int GET_NAMES = 0;
    public static final int SET_NAMES = 1;
    public static final int VAR_NAMES = 2;
    public static final int METHOD_NAMES = 3;
    public static final int LOCAL_METHOD_NAMES = 4;
    private static final int INITIAL_CAPACITY = 8;
    public static final Names EMPTY_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setDelegate(Names names) {
        names.size();
        this.delegate = names;
    }

    private int hash(String name, int type) {
        if (!$assertionsDisabled && name.intern() != name) {
            throw new Error();
        }
        return name.hashCode() * (type + 1);
    }

    private int find(String name, int type, int m) {
        String k;
        int n = 7;
        int bitmask = m - 1;
        int i = this.hash(name, type) & bitmask;
        while ((k = this.names[i]) != null && (k != name || type != (this.bindings[i] & 7))) {
            i = i + n++ & bitmask;
        }
        return i;
    }

    private int find(String name, ObjectValue namespace, int type, int m) {
        String k;
        int n = 7;
        int bitmask = m - 1;
        int i = this.hash(name, type) & bitmask;
        String namespaceName = namespace.name;
        if (!$assertionsDisabled && namespaceName != namespaceName.intern()) {
            throw new Error();
        }
        while ((k = this.names[i]) != null && (k != name || type != (this.bindings[i] & 7) || namespaceName != this.namespaces[i].name || namespace.getNamespaceKind() != this.namespaces[i].getNamespaceKind())) {
            i = i + n++ & bitmask;
        }
        return i;
    }

    public int size() {
        if (this == EMPTY_NAMES) {
            return 0;
        }
        return this.size + this.delegate.size();
    }

    private boolean isFull() {
        return 5 * (this.size + 1) >= this.capacity() * 4;
    }

    private final int capacity() {
        return this.names != null ? this.names.length : 0;
    }

    private int put(String name, ObjectValue namespace, int type) {
        int i;
        if (this.names == null) {
            this.names = new String[8];
            this.namespaces = new ObjectValue[8];
            this.bindings = new int[8];
        }
        if (this.isFull()) {
            this.grow();
        }
        if (!name.equals(this.names[i = this.find(name, namespace, type, this.capacity())])) {
            ++this.size;
            this.names[i] = name;
            this.namespaces[i] = namespace;
        }
        return i;
    }

    public void putMask(String name, ObjectValue namespace, int type) {
        int i = this.put(name, namespace, type);
        this.bindings[i] = this.bindings[i] | type;
    }

    public void put(String name, ObjectValue namespace, int type, int slot) {
        int i = this.put(name, namespace, type);
        this.bindings[i] = slot << 3 | type;
    }

    public boolean containsKey(String name, int type) {
        if (this == EMPTY_NAMES) {
            return false;
        }
        boolean hasIt = false;
        if (this.names != null) {
            int i = this.find(name, type, this.capacity());
            boolean bl = hasIt = this.names[i] != null && this.names[i] == name && (this.bindings[i] & 7) == type && this.bindings[i] >> 3 != -1;
        }
        if (!hasIt) {
            hasIt = this.delegate.containsKey(name, type);
        }
        return hasIt;
    }

    public int get(String name, ObjectValue namespace, int type) {
        if (this == EMPTY_NAMES) {
            return -1;
        }
        int index = -1;
        if (this.names != null) {
            int i = this.find(name, namespace, type, this.capacity());
            int n = index = this.names[i] == name && (this.bindings[i] & 7) == type ? this.bindings[i] >> 3 : -1;
        }
        if (index == -1) {
            index = this.delegate.get(name, namespace, type);
        }
        return index;
    }

    public Set<Map.Entry<String, Qualifiers>> entrySet(int type) {
        TreeMap<String, Qualifiers> map = new TreeMap<String, Qualifiers>();
        int n = this.capacity();
        for (int i = 0; i < n; ++i) {
            if (this.names[i] == null || (this.bindings[i] & 7) != type) continue;
            Qualifiers q = (Qualifiers)map.get(this.names[i]);
            if (q == null) {
                q = new Qualifiers();
                map.put(this.names[i], q);
            }
            q.put(this.namespaces[i], Boxing.valueOf(this.bindings[i] >> 3));
        }
        return map.entrySet();
    }

    public Qualifiers get(String name, int type) {
        String k;
        if (this == EMPTY_NAMES) {
            return null;
        }
        Qualifiers q = null;
        int m = this.capacity();
        int n = 7;
        int bitmask = m - 1;
        int i = this.hash(name, type) & bitmask;
        while ((k = this.names[i]) != null) {
            if (k == name && (this.bindings[i] & 7) == type) {
                if (q == null) {
                    q = new Qualifiers();
                }
                q.put(this.namespaces[i], Boxing.valueOf(this.bindings[i] >> 3));
            }
            i = i + n++ & bitmask;
        }
        if (q != null) {
            Qualifiers q2 = this.delegate.get(name, type);
            if (q2 != null) {
                q.putAll(q2);
            }
        } else {
            q = this.delegate.get(name, type);
        }
        return q;
    }

    public void putAll(Names names) {
        if (names == null) {
            int capacity = names.capacity();
            this.names = new String[capacity];
            this.namespaces = new ObjectValue[capacity];
            this.bindings = new int[capacity];
        }
        int n = names.capacity();
        for (int i = 0; i < n; ++i) {
            if (names.names[i] == null) continue;
            this.put(names.names[i], names.namespaces[i], names.bindings[i] & 7, names.bindings[i] >> 3);
        }
    }

    public void putAll(Names names, int type) {
        if (names == null) {
            int capacity = names.capacity();
            this.names = new String[capacity];
            this.namespaces = new ObjectValue[capacity];
            this.bindings = new int[capacity];
        }
        int n = names.capacity();
        for (int i = 0; i < n; ++i) {
            if (names.names[i] == null || (names.bindings[i] & 7) != type) continue;
            this.put(names.names[i], names.namespaces[i], names.bindings[i] & 7, names.bindings[i] >> 3);
        }
    }

    public boolean containsKey(String name, ObjectValue namespace, int type) {
        if (this == EMPTY_NAMES) {
            return false;
        }
        boolean hasIt = false;
        if (this.names != null) {
            int i = this.find(name, namespace, type, this.capacity());
            boolean bl = hasIt = this.names[i] == name && this.bindings[i] >> 3 != -1;
        }
        if (!hasIt) {
            hasIt = this.delegate.containsKey(name, namespace, type);
        }
        return hasIt;
    }

    private void grow() {
        int capacity = this.capacity() * 2;
        String[] oldNames = this.names;
        ObjectValue[] oldNamespaces = this.namespaces;
        int[] oldBindings = this.bindings;
        this.names = new String[capacity];
        this.namespaces = new ObjectValue[capacity];
        this.bindings = new int[capacity];
        int n = oldNames.length;
        for (int i = 0; i < n; ++i) {
            String oldName = oldNames[i];
            if (oldName == null) continue;
            int j = this.find(oldName, oldNamespaces[i], oldBindings[i] & 7, capacity);
            this.names[j] = oldName;
            this.namespaces[j] = oldNamespaces[i];
            this.bindings[j] = oldBindings[i];
        }
    }

    public static int getTypeFromKind(int kind) {
        switch (kind) {
            case -78: {
                return 0;
            }
            case -97: {
                return 1;
            }
            case -110: {
                return 2;
            }
        }
        return 3;
    }

    public String getName(int i) {
        return this.names[i];
    }

    public ObjectValue getNamespace(int i) {
        return this.namespaces[i];
    }

    public int getSlot(int i) {
        return this.bindings[i] >> 3;
    }

    public int getType(int i) {
        return this.bindings[i] & 7;
    }

    public int hasNext(int index) {
        int n = this.capacity();
        while (index < n) {
            if (this.names[index] != null) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    static {
        $assertionsDisabled = true;
        EMPTY_NAMES = new Names();
    }
}

