/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class BitSet {
    private long[] bits;
    private static final byte[] nextBitTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BitSet(int nbits) {
        if (nbits > 0) {
            this.bits = new long[nbits + 63 >> 6];
        }
    }

    private BitSet(BitSet s) {
        this(BitSet.size(s));
        if (BitSet.size(s) > 0) {
            System.arraycopy(s.bits, 0, this.bits, 0, this.bits.length);
        }
    }

    public static BitSet and(BitSet a, BitSet b) {
        if (BitSet.isEmpty(a) || BitSet.isEmpty(b)) {
            return null;
        }
        int minsize = BitSet.size(a) < BitSet.size(b) ? BitSet.size(a) : BitSet.size(b);
        int minlen = minsize >> 6;
        BitSet t = new BitSet(minsize);
        for (int i = 0; i < minlen; ++i) {
            t.bits[i] = a.bits[i] & b.bits[i];
        }
        return t;
    }

    private void reset(BitSet r) {
        int minlen = (BitSet.size(this) < BitSet.size(r) ? BitSet.size(this) : BitSet.size(r)) >> 6;
        for (int i = 0; i < minlen; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (r.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static BitSet or(BitSet a, BitSet b) {
        BitSet t;
        block6: {
            int i;
            int minlen;
            block5: {
                if (BitSet.isEmpty(a)) {
                    return b;
                }
                if (BitSet.isEmpty(b)) {
                    return a;
                }
                minlen = (BitSet.size(a) < BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
                int maxlen = (BitSet.size(a) > BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
                t = new BitSet(maxlen << 6);
                for (i = 0; i < minlen; ++i) {
                    t.bits[i] = a.bits[i] | b.bits[i];
                }
                if (a.bits == null || a.bits.length <= minlen) break block5;
                for (i = a.bits.length - 1; i >= minlen; --i) {
                    t.bits[i] = a.bits[i];
                }
                break block6;
            }
            if (b.bits == null || b.bits.length <= minlen) break block6;
            for (i = b.bits.length - 1; i >= minlen; --i) {
                t.bits[i] = b.bits[i];
            }
        }
        return t;
    }

    private void set(BitSet s) {
        if (BitSet.size(s) > BitSet.size(this)) {
            long[] b = new long[BitSet.size(s) >> 6];
            if (this.bits != null) {
                System.arraycopy(this.bits, 0, b, 0, this.bits.length);
            }
            this.bits = b;
        }
        if (s != null && s.bits != null) {
            for (int i = s.bits.length - 1; i >= 0; --i) {
                int n = i;
                this.bits[n] = this.bits[n] | s.bits[i];
            }
        }
    }

    public static BitSet set(BitSet target, BitSet s) {
        if (BitSet.size(s) > 0) {
            if (target == null) {
                target = new BitSet(BitSet.size(s));
            }
            target.set(s);
        }
        return target;
    }

    public static BitSet reset_set(BitSet target, BitSet r, BitSet s) {
        if (target != null) {
            target.reset(r);
        }
        if (s != null) {
            if (target == null) {
                target = new BitSet(BitSet.size(s));
            }
            target.set(s);
        }
        return target;
    }

    public static BitSet xor(BitSet a, BitSet b) {
        BitSet t;
        block6: {
            int i;
            int minlen;
            block5: {
                if (BitSet.isEmpty(a)) {
                    return b;
                }
                if (BitSet.isEmpty(b)) {
                    return a;
                }
                minlen = (BitSet.size(a) < BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
                int maxlen = (BitSet.size(a) > BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
                t = new BitSet(maxlen << 6);
                for (i = 0; i < minlen; ++i) {
                    t.bits[i] = a.bits[i] ^ b.bits[i];
                }
                if (a.bits == null || a.bits.length <= minlen) break block5;
                for (i = a.bits.length - 1; i >= minlen; --i) {
                    t.bits[i] = a.bits[i];
                }
                break block6;
            }
            if (b.bits == null || b.bits.length <= minlen) break block6;
            for (i = b.bits.length - 1; i >= minlen; --i) {
                t.bits[i] = b.bits[i];
            }
        }
        return t;
    }

    public static boolean isEmpty(BitSet b) {
        return b == null || b.isEmpty();
    }

    private boolean isEmpty() {
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    private static int size(BitSet s) {
        return s != null && s.bits != null ? s.bits.length << 6 : 0;
    }

    private boolean get(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new Error();
        }
        int i = index >> 6;
        return this.bits != null && i < this.bits.length && (this.bits[i] & 1L << (index & 0x3F)) != 0L;
    }

    public static boolean get(BitSet b, int index) {
        return b != null && b.get(index);
    }

    public static BitSet set(BitSet target, int index, boolean value) {
        if (!$assertionsDisabled && index < 0) {
            throw new Error();
        }
        int i = index >> 6;
        if (index >= BitSet.size(target)) {
            if (target == null) {
                target = new BitSet(index + 1);
            }
            long[] b = new long[i + 1];
            if (target.bits != null) {
                System.arraycopy(target.bits, 0, b, 0, target.bits.length);
            }
            target.bits = b;
        }
        if (value) {
            int n = i;
            target.bits[n] = target.bits[n] | 1L << (index & 0x3F);
        } else {
            int n = i;
            target.bits[n] = target.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return target;
    }

    public static BitSet copy(BitSet s) {
        return s != null && !s.isEmpty() ? new BitSet(s) : null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        return BitSet.equals(this, (BitSet)obj);
    }

    public static boolean equals(BitSet a, BitSet b) {
        int i;
        int minlen = (BitSet.size(a) < BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
        for (i = 0; i < minlen; ++i) {
            if (a.bits[i] == b.bits[i]) continue;
            return false;
        }
        if (a != null && a.bits != null) {
            for (i = a.bits.length - 1; i >= minlen; --i) {
                if (a.bits[i] == 0L) continue;
                return false;
            }
        }
        if (b != null && b.bits != null) {
            for (i = b.bits.length - 1; i >= minlen; --i) {
                if (b.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        if (this.bits != null) {
            for (int i = this.bits.length - 1; i >= 0; --i) {
                h = (int)((long)h ^ this.bits[i]);
            }
        }
        return h;
    }

    public static int and_count(BitSet a, BitSet b) {
        int minlen = (BitSet.size(a) < BitSet.size(b) ? BitSet.size(a) : BitSet.size(b)) >> 6;
        int sum = 0;
        for (int i = 0; i < minlen; ++i) {
            sum += BitSet.bitCount(a.bits[i] & b.bits[i]);
        }
        return sum;
    }

    public static int count(BitSet s) {
        int sum = 0;
        if (s != null && s.bits != null) {
            for (int i = s.bits.length - 1; i >= 0; --i) {
                sum += BitSet.bitCount(s.bits[i]);
            }
        }
        return sum;
    }

    private static int bitCount(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("{");
        if (this.bits != null) {
            int n = this.bits.length << 6;
            for (int i = 0; i < n; ++i) {
                if ((this.bits[i >> 6] & 1L << (i & 0x3F)) == 0L) continue;
                if (b.length() > 1) {
                    b.append(", ");
                }
                b.append(i);
            }
        }
        b.append('}');
        return b.toString();
    }

    public static int nextSetBitOld(BitSet s, int i) {
        if (!$assertionsDisabled && i < 0) {
            throw new Error();
        }
        if (s != null && s.bits != null) {
            int n = s.bits.length << 6;
            while (i < n) {
                if ((s.bits[i >> 6] & 1L << (i & 0x3F)) != 0L) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int nextSetBit(BitSet s, int i) {
        int n;
        int j;
        if (!$assertionsDisabled && i < 0) {
            throw new Error();
        }
        if (s != null && s.bits != null && (j = i >> 6) < (n = s.bits.length)) {
            long value = s.bits[j];
            value &= (1L << (i & 0x3F)) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            while (true) {
                if (value != 0L) {
                    if ((value & 0xFFFFFFFFL) != 0L) {
                        if ((value & 0xFFFFL) != 0L) {
                            if ((value & 0xFFL) != 0L) {
                                return nextBitTable[(int)(value & 0xFFL)] + (j << 6);
                            }
                            return nextBitTable[(int)(value >> 8 & 0xFFL)] + 8 + (j << 6);
                        }
                        if ((value & 0xFF0000L) != 0L) {
                            return nextBitTable[(int)(value >> 16 & 0xFFL)] + 16 + (j << 6);
                        }
                        return nextBitTable[(int)(value >> 24 & 0xFFL)] + 24 + (j << 6);
                    }
                    if ((value & 0xFFFF00000000L) != 0L) {
                        if ((value & 0xFF00000000L) != 0L) {
                            return nextBitTable[(int)(value >> 32 & 0xFFL)] + 32 + (j << 6);
                        }
                        return nextBitTable[(int)(value >> 40 & 0xFFL)] + 40 + (j << 6);
                    }
                    if ((value & 0xFF000000000000L) != 0L) {
                        return nextBitTable[(int)(value >> 48 & 0xFFL)] + 48 + (j << 6);
                    }
                    return nextBitTable[(int)(value >> 56 & 0xFFL)] + 56 + (j << 6);
                }
                if (++j >= n) break;
                value = s.bits[j];
            }
        }
        return -1;
    }

    static {
        $assertionsDisabled = true;
        nextBitTable = new byte[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    }
}

