/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Slot {
    public static final int PUSH_none = 0;
    public static final int PUSH_env = 1;
    public static final int PUSH_this = 2;
    public static final int PUSH_opd1 = 4;
    public static final int PUSH_opd2 = 8;
    public static final int PUSH_args = 16;
    public static final int PUSH_size = 32;
    public static final int CALL_Empty = 0;
    public static final int CALL_Unary = 20;
    public static final int CALL_ThisUnary = 22;
    public static final int CALL_Binary = 12;
    public static final int CALL_Method = 16;
    public static final int CALL_ThisMethod = 18;
    public static final int CALL_Closure = 51;
    public static final int CALL_Args = 16;
    public static final int CALL_ThisArgs = 18;
    public static final int CALL_EnvThisArgs = 51;
    public static final int DISPATCH_final = 0;
    public static final int DISPATCH_virtual = 1;
    public static final int DISP_undefined = 1;
    public static final int DISP_CallProperty = 2;
    public static final int DISP_ConstructProperty = 3;
    public static final int DISP_CallClosure = 4;
    public static final int DISP_ConstructClosure = 5;
    public static final int DISP_CallPropLex = 6;
    public static final int DISP_CallFinal = 0;
    public static final int THIS_undefined = 0;
    public static final int THIS_Global = 1;
    public static final int THIS_Scope = 2;
    public static final int THIS_Base = 3;
    public static final int THIS_Temp = 4;
    public static final int THIS_None = 5;
    public static final int PARAM_Required = 0;
    public static final int PARAM_Optional = 1;
    public static final int PARAM_Rest = 2;
    public static final int PARAM_Void = 3;
    private static final int FINAL_Flag = 1;
    private static final int OVERRIDE_Flag = 2;
    private static final int CONST_Flag = 4;
    private static final int IMPORTED_Flag = 8;
    private static final int INTRINSIC_Flag = 16;
    private static final int NEEDS_INIT_Flag = 32;
    private static final int METHOD_Flag = 64;
    private static final int CALL_SEQUENCE_Mask = 65280;
    private static final int DISPATCH_KIND_Mask = 0xFF0000;
    private static final int CALL_SEQUENCE_Shift = 8;
    private static final int DISPATCH_KIND_Shift = 16;
    private int flags = 2;
    protected static final int AUX_OverriddenSlot = 0;
    protected static final int AUX_EmbeddedData = 1;
    protected static final int AUX_MetaData = 2;
    protected static final int AUX_BaseNode = 3;
    protected static final int AUX_ImplNode = 4;
    protected static final int AUX_UnaryOverloads = 5;
    protected static final int AUX_BinaryOverloads = 6;
    protected static final int AUX_DebugName = 7;
    protected static final int AUX_ImplicitCall = 8;
    protected static final int AUX_ImplicitConstruct = 9;
    protected static final int AUX_MethodName = 10;
    private Object[] auxDataItems = null;
    public int id;
    public ObjectValue declaredBy;
    private BitSet def_bits;
    private Value value;
    private TypeValue type;
    private ObjectList<TypeValue> types;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void setAuxData(int type, Object value) {
        Object[] newData;
        if (this.auxDataItems != null) {
            for (int i = 0; i < this.auxDataItems.length; i += 2) {
                if ((Integer)this.auxDataItems[i] != type) continue;
                this.auxDataItems[i + 1] = value;
                return;
            }
        }
        if (this.auxDataItems != null) {
            newData = new Object[this.auxDataItems.length + 2];
            System.arraycopy(this.auxDataItems, 0, newData, 0, this.auxDataItems.length);
        } else {
            newData = new Object[2];
        }
        newData[newData.length - 2] = IntegerPool.getNumber(type);
        newData[newData.length - 1] = value;
        this.auxDataItems = newData;
    }

    protected final Object getAuxData(int type) {
        if (this.auxDataItems != null) {
            for (int i = 0; i < this.auxDataItems.length; i += 2) {
                if ((Integer)this.auxDataItems[i] != type) continue;
                return this.auxDataItems[i + 1];
            }
        }
        return null;
    }

    public Slot(TypeValue type, int id) {
        this.type = type;
        this.id = id;
        this.setCallSequence(22);
        this.setDispatchKind(0);
    }

    public final boolean isCompatible(TypeValue t1, TypeValue t2) {
        return t1 != null && t2 != null && (t1.getTypeId() & t2.getTypeId()) != 0;
    }

    public final void addDefBits(BitSet mask) {
        this.setDefBits(BitSet.set(this.getDefBits(), mask));
    }

    public final void implicit(int kind, int slot_index) {
        switch (kind) {
            case -131: {
                this.setAuxData(8, IntegerPool.getNumber(slot_index));
                break;
            }
            case -90: {
                this.setAuxData(9, IntegerPool.getNumber(slot_index));
                break;
            }
            default: {
                if ($assertionsDisabled) break;
                throw new Error();
            }
        }
    }

    public final int implies(Context cx, int kind) {
        Integer value = null;
        switch (kind) {
            case -131: {
                value = (Integer)this.getAuxData(8);
                break;
            }
            case -90: {
                value = (Integer)this.getAuxData(9);
                break;
            }
            default: {
                if ($assertionsDisabled) break;
                throw new Error();
            }
        }
        return value != null ? value : 0;
    }

    public final void overload(TypeValue t1, int slot_index) {
        Overload unary_overloads = this.getUnaryOverloads();
        if (unary_overloads == null) {
            unary_overloads = new Overload(this);
            this.setUnaryOverloads(unary_overloads);
        }
        unary_overloads.put(t1, Boxing.valueOf(slot_index));
    }

    public final void overload(TypeValue t1, TypeValue t2, int slot_index) {
        Overload o = new Overload(this);
        o.put(t2, Boxing.valueOf(slot_index));
        Map<TypeValue, Overload> binary_overloads = this.getBinaryOverloads();
        if (binary_overloads == null) {
            binary_overloads = new HashMap<TypeValue, Overload>();
            this.setBinaryOverloads(binary_overloads);
        }
        binary_overloads.put(t1, o);
    }

    public final int dispatch(Context cx, TypeValue t1) {
        boolean found = false;
        int value = 0;
        Overload unary_overloads = this.getUnaryOverloads();
        if (unary_overloads != null) {
            for (TypeValue t : unary_overloads.keySet()) {
                if (t.equals(t1)) {
                    return (Integer)unary_overloads.get(t);
                }
                if (!this.isCompatible(t, t1)) continue;
                if (!found) {
                    found = true;
                    value = (Integer)unary_overloads.get(t);
                    continue;
                }
                return 0;
            }
        }
        return value;
    }

    public final int dispatch(Context cx, TypeValue t1, TypeValue t2) {
        Overload o;
        Map<TypeValue, Overload> binary_overloads = this.getBinaryOverloads();
        if (binary_overloads != null) {
            for (TypeValue i : binary_overloads.keySet()) {
                if (i == null || t1 == null) {
                    cx.internalError("internal type error");
                }
                if (!this.isCompatible(i, t1)) continue;
                Overload overload = binary_overloads.get(i);
                for (TypeValue j : overload.keySet()) {
                    if (!this.isCompatible(j, t2)) continue;
                    return (Integer)overload.get(j);
                }
            }
        }
        Overload overload = o = binary_overloads == null ? null : binary_overloads.get(t1);
        if (o == null) {
            o = new Overload(this);
            o.put(t2, Boxing.valueOf(0));
            if (binary_overloads == null) {
                binary_overloads = new HashMap<TypeValue, Overload>();
                this.setBinaryOverloads(binary_overloads);
            }
            binary_overloads.put(t1, o);
        } else if (o.get(t2) == null) {
            o.put(t2, Boxing.valueOf(0));
        }
        return (Integer)binary_overloads.get(t1).get(t2);
    }

    public final void attrs(int call_seq, int method_id) {
        this.setCallSequence((byte)call_seq);
        this.setMethodID(method_id);
    }

    public final void addMetadata(MetaDataNode meta) {
        if (this.getMetadata() == null) {
            this.setMetadata(new ArrayList<MetaDataNode>());
        }
        this.getMetadata().add(meta);
    }

    public final boolean isFinal() {
        return (this.flags & 1) != 0;
    }

    public final void setFinal(boolean is_final) {
        this.flags = is_final ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public final boolean isOverride() {
        return (this.flags & 2) != 0;
    }

    public final void setOverride(boolean is_override) {
        this.flags = is_override ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public final boolean isConst() {
        return (this.flags & 4) != 0;
    }

    public final void setConst(boolean is_const) {
        this.flags = is_const ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public final boolean isImported() {
        return (this.flags & 8) != 0;
    }

    public final void setImported(boolean is_imported) {
        this.flags = is_imported ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public final boolean isIntrinsic() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean needsInit() {
        return (this.flags & 0x20) != 0;
    }

    public final void setNeedsInit(boolean needs_init) {
        this.flags = needs_init ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public final void setIntrinsic(boolean is_intrinsic) {
        this.flags = is_intrinsic ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public final int getCallSequence() {
        return (this.flags & 0xFF00) >> 8;
    }

    public final void setCallSequence(int call_seq) {
        this.flags &= 0xFFFF00FF;
        this.flags |= call_seq << 8;
    }

    public final int getDispatchKind() {
        return (this.flags & 0xFF0000) >> 16;
    }

    public final void setDispatchKind(int dispatch_kind) {
        this.flags &= 0xFF00FFFF;
        this.flags |= dispatch_kind << 16;
    }

    public final void setBaseNode(Node base_node) {
        this.setAuxData(3, base_node);
    }

    public final Node getBaseNode() {
        return (Node)this.getAuxData(3);
    }

    public final void setImplNode(Node impl_node) {
        this.setAuxData(4, impl_node);
    }

    public final Node getImplNode() {
        return (Node)this.getAuxData(4);
    }

    public final void setMetadata(ArrayList<MetaDataNode> metadata) {
        this.setAuxData(2, metadata);
    }

    public final ArrayList<MetaDataNode> getMetadata() {
        return (ArrayList)this.getAuxData(2);
    }

    public final void setEmbeddedData(Object embeddedData) {
        this.setAuxData(1, embeddedData);
    }

    public final Object getEmbeddedData() {
        return this.getAuxData(1);
    }

    public final void setOverriddenSlot(Slot overriddenSlot) {
        this.setAuxData(0, overriddenSlot);
    }

    public final Slot getOverriddenSlot() {
        return (Slot)this.getAuxData(0);
    }

    private final void setUnaryOverloads(Overload unary_overloads) {
        this.setAuxData(5, unary_overloads);
    }

    private final Overload getUnaryOverloads() {
        return (Overload)this.getAuxData(5);
    }

    private final void setBinaryOverloads(Map<TypeValue, Overload> binary_overloads) {
        this.setAuxData(6, binary_overloads);
    }

    private final Map<TypeValue, Overload> getBinaryOverloads() {
        return (Map)this.getAuxData(6);
    }

    public final void setObjectValue(ObjectValue objectValue) {
        this.setValue(objectValue);
    }

    public final ObjectValue getObjectValue() {
        return (ObjectValue)this.getValue();
    }

    public ObjectValue getInitializerValue() {
        return (ObjectValue)this.getValue();
    }

    public void setDebugName(String debug_name) {
        this.setAuxData(7, debug_name);
    }

    public String getDebugName() {
        String value = (String)this.getAuxData(7);
        return value != null ? value : "";
    }

    public boolean isGetter() {
        return (this.flags & 0x40) == 0;
    }

    public void setGetter(boolean isGetter) {
        this.flags = !isGetter ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    public abstract void setVarIndex(int var1);

    public abstract int getVarIndex();

    public abstract void setMethodID(int var1);

    public abstract int getMethodID();

    public abstract void setMethodName(String var1);

    public abstract String getMethodName();

    public abstract void setTypeRef(ReferenceValue var1);

    public abstract ReferenceValue getTypeRef();

    public abstract void setDeclStyles(ByteList var1);

    public abstract ByteList getDeclStyles();

    public abstract void addDeclStyle(int var1);

    public void setType(TypeValue type) {
        this.type = type;
    }

    public TypeValue getType() {
        return this.type;
    }

    public void setTypes(ObjectList<TypeValue> types) {
        this.types = types;
    }

    public ObjectList<TypeValue> getTypes() {
        return this.types;
    }

    public void addType(TypeValue type) {
        if (this.types == null) {
            this.types = new ObjectList(2);
        }
        this.types.push_back(type);
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public void setDefBits(BitSet def_bits) {
        this.def_bits = def_bits;
    }

    public BitSet getDefBits() {
        return this.def_bits;
    }

    static {
        $assertionsDisabled = true;
    }

    /*
     * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Overload
    extends HashMap<TypeValue, Integer> {
        final /* synthetic */ Slot this$0;

        /*
         * WARNING - void declaration
         */
        Overload(Slot slot) {
            void arg0;
            this.this$0 = arg0;
        }
    }
}

