/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.MethodSlot;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Context;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.Qualifiers;
import macromedia.asc.util.Slots;
import macromedia.asc.util.Values;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectValue
extends Value
implements Comparable {
    public static ObjectValue undefinedValue;
    public static ObjectValue nullValue;
    public static ObjectValue enumerableNamespace;
    public static ObjectValue labelNamespace;
    public static ObjectValue loopLabelNamespace;
    public static ObjectValue objectPrototype;
    public static ObjectValue internalNamespace;
    public static ObjectValue intrinsicAttribute;
    public static ObjectValue intrinsicNamespace;
    public static ObjectValue staticAttribute;
    public static ObjectValue dynamicAttribute;
    public static ObjectValue finalAttribute;
    public static ObjectValue virtualAttribute;
    public static ObjectValue overrideAttribute;
    public static ObjectValue nativeAttribute;
    public Builder builder;
    public TypeValue type;
    private String value = "";
    private Names names;
    public Slots slots;
    private Values values;
    public ObjectValue _proto_;
    public String name = "";
    public String classname = "";
    public String debug_name = "";
    public Names baseMethodNames;
    public int method_info;
    public int var_count;
    public int method_count;
    public ObjectValue activation;
    static Slot nullSlot;
    private HashMap<TypeValue, ClassDefinitionNode> deferredClassMap;

    public static void NamespacesFromQualifiers(Qualifiers quals, Namespaces namespaces) {
        namespaces.clear();
        for (ObjectValue it : quals.keySet()) {
            namespaces.push_back(it);
        }
    }

    public static void init() {
        if (undefinedValue == null) {
            undefinedValue = new ObjectValue();
            nullValue = new ObjectValue();
            enumerableNamespace = new ObjectValue();
            labelNamespace = new NamespaceValue(2);
            ObjectValue.labelNamespace.name = "label namespace";
            loopLabelNamespace = new NamespaceValue(2);
            ObjectValue.loopLabelNamespace.name = "loop label namespace name";
            objectPrototype = new ObjectValue();
            internalNamespace = new ObjectValue();
            intrinsicAttribute = new ObjectValue();
            intrinsicNamespace = new ObjectValue();
            staticAttribute = new ObjectValue();
            dynamicAttribute = new ObjectValue();
            finalAttribute = new ObjectValue();
            virtualAttribute = new ObjectValue();
            overrideAttribute = new ObjectValue();
            nativeAttribute = new ObjectValue();
        }
    }

    public static void clear() {
        if (undefinedValue != null) {
            if (nullSlot.getType() != null || nullSlot.getVarIndex() != -1) {
                throw new Error();
            }
            undefinedValue = null;
            nullValue = null;
            enumerableNamespace = null;
            labelNamespace = null;
            loopLabelNamespace = null;
            objectPrototype = null;
            internalNamespace = null;
            intrinsicAttribute = null;
            intrinsicNamespace = null;
            staticAttribute = null;
            dynamicAttribute = null;
            finalAttribute = null;
            virtualAttribute = null;
            overrideAttribute = null;
            nativeAttribute = null;
        }
    }

    public ObjectValue() {
        this.builder = null;
        this.type = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.activation = null;
        this.method_info = -1;
        this.initInstance(null, null);
    }

    public ObjectValue(TypeValue type) {
        this.builder = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.activation = null;
        this.type = type;
        this.method_info = -1;
        this.initInstance(null, type);
    }

    public ObjectValue(String value, TypeValue type) {
        this.setValue(value);
        this.builder = null;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.activation = null;
        this.type = type;
        this.method_info = -1;
        this.initInstance(null, type);
    }

    public ObjectValue(Context cx, Builder builder, TypeValue type) {
        this.clearInstance(cx, builder, type, "");
    }

    protected void clearInstance(Context cx, Builder builder, TypeValue type, String name) {
        this.flags = 0;
        this.value = "";
        this.names = null;
        this.slots = null;
        this.values = null;
        this.classname = "";
        this.debug_name = "";
        this.baseMethodNames = null;
        this.deferredClassMap = null;
        this.builder = builder;
        this.type = type;
        this._proto_ = null;
        this.var_count = 0;
        this.method_count = 0;
        this.activation = null;
        this.method_info = -1;
        this.initInstance(null, type);
        builder.build(cx, this);
        this.name = name;
    }

    public void initInstance(ObjectValue protoObject, TypeValue classObject) {
        this._proto_ = protoObject;
    }

    public boolean removeName(Context cx, int kind, String name, ObjectValue qualifier) {
        if (this.names != null) {
            this.names.put(name, qualifier, Names.getTypeFromKind(kind), -1);
        }
        return true;
    }

    public boolean hasName(Context cx, int kind, String name, ObjectValue qualifier) {
        return this.names == null ? false : this.names.containsKey(name, qualifier, Names.getTypeFromKind(kind));
    }

    public boolean hasNameUnqualified(Context cx, String name, int kind) {
        return this.names == null ? false : this.names.get(name, Names.getTypeFromKind(kind)) != null;
    }

    public Namespaces hasNames(Context cx, int kind, String name, Namespaces namespaces) {
        if (this.names == null) {
            return null;
        }
        int type = Names.getTypeFromKind(kind);
        if (namespaces.size() > 1 && !this.names.containsKey(name, type)) {
            return null;
        }
        ArrayList hasNamespaces = null;
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            ObjectValue qual = (ObjectValue)namespaces.get(i);
            if (!this.names.containsKey(name, qual, type)) continue;
            if (hasNamespaces == null) {
                hasNamespaces = new Namespaces();
            }
            hasNamespaces.add(qual);
        }
        return hasNamespaces;
    }

    public Slot get(Context cx, String name, ObjectValue qualifier) {
        return this.getSlot(cx, this.names.get(name, qualifier, 0));
    }

    public void setVar(Context cx, int var_index, Value val) {
        if (var_index >= 0) {
            if (this.values == null) {
                this.values = new Values();
            }
            while (var_index >= this.values.size()) {
                this.values.add(null);
            }
            this.values.add(var_index, val);
        }
    }

    public Value getVar(Context cx, int var_index) {
        if (this.values != null && var_index >= 0 && var_index < this.values.size()) {
            return (Value)this.values.get(var_index);
        }
        return null;
    }

    public int defineName(Context cx, int kind, String name, ObjectValue qualifier, int slot_index) {
        if (this.names == null) {
            this.names = new Names();
        }
        if (this.names.containsKey(name, qualifier, Names.getTypeFromKind(kind))) {
            return 0;
        }
        this.names.put(name, qualifier, Names.getTypeFromKind(kind), slot_index);
        return 1;
    }

    public Names getNamesAndCreate() {
        if (this.names == null) {
            this.names = new Names();
        }
        return this.names;
    }

    public boolean defineNames(Context cx, int kind, String name, Namespaces namespaces, int slot_index) {
        if (this.names == null) {
            this.names = new Names();
        }
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            ObjectValue it = (ObjectValue)namespaces.get(i);
            this.names.put(name, it, Names.getTypeFromKind(kind), slot_index);
        }
        return true;
    }

    public final int addVariableSlot(Context cx, TypeValue type, int var_index) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        VariableSlot newSlot = new VariableSlot(type, cx.statics.getNextSlotID(), var_index);
        newSlot.declaredBy = this;
        this.slots.put(newSlot);
        return newSlot.id;
    }

    public final int addMethodSlot(Context cx, TypeValue type) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        MethodSlot newSlot = new MethodSlot(type, cx.statics.getNextSlotID());
        newSlot.declaredBy = this;
        this.slots.put(newSlot);
        return newSlot.id;
    }

    public final void addSlot(Slot slot) {
        if (this.slots == null) {
            this.slots = new Slots();
        }
        this.slots.put(slot);
    }

    public final int addSlotImplicit(Context cx, int slot_index, int kind, TypeValue type) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).implicit(kind, index);
        return index;
    }

    public final int addSlotOverload(Context cx, int slot_index, TypeValue type, TypeValue t1) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).overload(t1, index);
        Slot slot = this.getSlot(cx, index);
        slot.addType(t1);
        return index;
    }

    public final int addSlotOverload(Context cx, int slot_index, TypeValue type, TypeValue t1, TypeValue t2) {
        int index = this.addMethodSlot(cx, type);
        this.getSlot(cx, slot_index).overload(t1, t2, index);
        Slot slot = this.getSlot(cx, index);
        slot.addType(t1);
        slot.addType(t2);
        return index;
    }

    public final Slot getSlot(Context cx, int index) {
        if (this.slots != null) {
            return this.slots.getByID(index);
        }
        return null;
    }

    public int getSlotIndex(Context cx, int kind, String name, ObjectValue qualifier) {
        int index = -1;
        qualifier = qualifier != null ? qualifier : cx.publicNamespace();
        int type = Names.getTypeFromKind(kind);
        if (this.names == null || !this.names.containsKey(name, type)) {
            if (this.proto() != null) {
                index = this.proto().getSlotIndex(cx, kind, name, qualifier);
            }
        } else {
            index = this.names.get(name, qualifier, type);
        }
        return index;
    }

    public int getImplicitIndex(Context cx, int slot_index, int kind) {
        Slot slot = this.getSlot(cx, slot_index);
        int index = slot != null ? slot.implies(cx, kind) : 0;
        return index != 0 ? index : slot_index;
    }

    public int getOverloadIndex(Context cx, int slot_index, TypeValue t1) {
        int index = this.getSlot(cx, slot_index).dispatch(cx, t1);
        return index != 0 ? index : slot_index;
    }

    public int getOverloadIndex(Context cx, int slot_index, TypeValue t1, TypeValue t2) {
        t1 = t1 == null ? cx.noType() : t1;
        t2 = t2 == null ? cx.noType() : t2;
        int index = this.getSlot(cx, slot_index).dispatch(cx, t1, t2);
        return index != 0 ? index : slot_index;
    }

    public int addVar(Context cx) {
        return this.var_count++;
    }

    public int addMethod(Context cx) {
        return this.method_count++;
    }

    public int getFirstSlotIndex() {
        return 0;
    }

    public ObjectValue proto() {
        return this._proto_;
    }

    @Override
    public TypeValue getType(Context cx) {
        if (this.type != null) {
            return this.type;
        }
        return cx.noType();
    }

    public boolean isDynamic() {
        return this.builder != null ? this.builder.is_dynamic : false;
    }

    public boolean isFinal() {
        return this.builder != null ? this.builder.is_final : false;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int compareTo(Object o) {
        if (o instanceof ObjectValue) {
            return this.name.compareTo(((ObjectValue)o).name);
        }
        return -1;
    }

    public HashMap<TypeValue, ClassDefinitionNode> getDeferredClassMap() {
        if (this.deferredClassMap == null) {
            this.deferredClassMap = new HashMap();
        }
        return this.deferredClassMap;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public boolean isInterface() {
        return this.builder instanceof ClassBuilder && ((ClassBuilder)this.builder).is_interface;
    }

    public boolean canEarlyBind() {
        boolean ret = true;
        if (this.builder instanceof InstanceBuilder) {
            ret = ((InstanceBuilder)this.builder).canEarlyBind;
        }
        return ret;
    }

    public Names getNames() {
        return this.names;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.flags |= 1;
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean booleanValue() {
        return this.getValue().equals("true");
    }

    public void setPackage(boolean package_flag) {
        this.flags = package_flag ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public boolean isPackage() {
        return (this.flags & 8) != 0;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public byte getNamespaceKind() {
        return 0;
    }

    static {
        nullSlot = new MethodSlot(null, 0);
    }

    /*
     * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectValueCompare
    implements Comparator<ObjectValue> {
        @Override
        public int compare(ObjectValue o1, ObjectValue o2) {
            int result = o2.name.compareTo(o1.name);
            if (result == 0) {
                result += o2.getNamespaceKind() - o1.getNamespaceKind();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

