/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class PackageIdentifiersNode
extends Node {
    protected static final int IS_DEFINITION_FLAG = 1;
    public ObjectList<IdentifierNode> list = new ObjectList(5);
    public String pkg_part;
    public String def_part;

    public PackageIdentifiersNode(IdentifierNode item, int pos, boolean isDefinition) {
        super(pos);
        this.list.add(item);
        if (isDefinition) {
            this.flags |= 1;
        }
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    int size() {
        return this.list.size();
    }

    public int pos() {
        return this.list.size() != 0 ? this.list.last().pos() : 0;
    }

    public String toString() {
        return "PackageIdentifiers";
    }

    void clearIdentifierString() {
        if (this.pkg_part != null) {
            this.pkg_part = null;
        }
        if (this.def_part != null) {
            this.def_part = null;
        }
    }

    public String toIdentifierString() {
        if (this.pkg_part == null) {
            boolean isDefinition = (this.flags & 1) != 0;
            StringBuffer buf = new StringBuffer();
            int len = this.list.size();
            for (int x = 0; x < len; ++x) {
                IdentifierNode item = (IdentifierNode)this.list.get(x);
                if (x == len - 1 && isDefinition) {
                    this.def_part = "";
                    if ("*".equals(item.name)) continue;
                    this.def_part = item.name;
                    continue;
                }
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(item.toIdentifierString());
            }
            this.pkg_part = buf.toString();
        }
        return this.pkg_part;
    }
}

