/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class MemberExpressionNode
extends Node {
    public Node base;
    public SelectorNode selector;
    public ReferenceValue ref = null;

    public MemberExpressionNode(Node base, SelectorNode selector, int pos) {
        super(pos);
        this.base = base;
        this.selector = selector;
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public void voidResult() {
        this.selector.voidResult();
    }

    public boolean isMemberExpression() {
        return true;
    }

    public boolean isIndexedMemberExpression() {
        return this.selector.getMode() == -28;
    }

    public BitSet getGenBits() {
        return this.selector.getGenBits();
    }

    public BitSet getKillBits() {
        return this.selector.getKillBits();
    }

    public String toString() {
        return "MemberExpression";
    }

    public boolean isAttribute() {
        return this.selector.isAttribute();
    }

    public boolean isLabel() {
        return this.base == null && this.selector.isGetExpression() && !(this.selector.expr instanceof QualifiedIdentifierNode);
    }

    public boolean isAny() {
        return this.selector.isAny();
    }

    public boolean hasAttribute(String name) {
        return this.base == null && this.selector.hasAttribute(name);
    }

    public StringBuffer toCanonicalString(Context cx, StringBuffer buf) {
        Slot s = this.ref.getSlot(cx, -78);
        buf.append(s == null || s.getDebugName().length() == 0 ? this.ref.name : s.getDebugName());
        return buf;
    }

    public boolean hasSideEffect() {
        return this.selector.hasSideEffect();
    }

    public boolean isLValue() {
        return this.selector.isLValue();
    }
}

