/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.ByteArrayPool;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.MultiNamePool;
import macromedia.abc.NSPool;
import macromedia.abc.NSSPool;

final class IndexHistory {
    public int total;
    public int duplicate;
    public int totalBytes;
    public int duplicateBytes;
    private ConstantPool[] pools;
    private int[] poolSizes;
    private int[] map;
    private ByteArrayPool intP;
    private ByteArrayPool uintP;
    private ByteArrayPool doubleP;
    private ByteArrayPool stringP;
    private ByteArrayPool nsP;
    private ByteArrayPool nssP;
    private ByteArrayPool mnP;
    private BytecodeBuffer in4;
    private BytecodeBuffer in5;
    private BytecodeBuffer in6;
    private boolean disableDebuggingInfo = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    IndexHistory(ConstantPool[] pools) {
        this.pools = pools;
        this.poolSizes = new int[pools.length];
        int size = 0;
        int preferredSize = 0;
        int length = pools.length;
        for (int i = 0; i < length; ++i) {
            this.poolSizes[i] = i == 0 ? 0 : size;
            size += pools[i].size();
            preferredSize += pools[i].mnEnd - pools[i].strEnd;
        }
        this.map = new int[size];
        this.in4 = new BytecodeBuffer(preferredSize);
        this.in5 = new BytecodeBuffer(preferredSize);
        this.in6 = new BytecodeBuffer(preferredSize);
        this.intP = new ByteArrayPool();
        this.uintP = new ByteArrayPool();
        this.doubleP = new ByteArrayPool();
        this.stringP = new ByteArrayPool();
        this.nsP = new NSPool();
        this.nssP = new NSSPool();
        this.mnP = new MultiNamePool();
        this.total = 0;
        this.duplicate = 0;
        this.totalBytes = 0;
        this.duplicateBytes = 0;
    }

    void disableDebugging() {
        this.disableDebuggingInfo = true;
    }

    public int getIndex(int poolIndex, int kind, int index) {
        if (index == 0) {
            return 0;
        }
        int newIndex = this.calculateIndex(poolIndex, kind, index);
        if (this.map[newIndex] == 0) {
            this.decodeOnDemand(poolIndex, kind, index, newIndex);
        }
        return this.map[newIndex];
    }

    public void writeTo(BytecodeBuffer b) {
        this.intP.writeTo(b);
        this.uintP.writeTo(b);
        this.doubleP.writeTo(b);
        this.stringP.writeTo(b);
        this.nsP.writeTo(b);
        this.nssP.writeTo(b);
        this.mnP.writeTo(b);
    }

    private final int calculateIndex(int poolIndex, int kind, int oldIndex) {
        int index = this.poolSizes[poolIndex];
        if (kind > 0) {
            index += this.pools[poolIndex].intpositions.length == 0 ? 0 : this.pools[poolIndex].intpositions.length - 1;
        }
        if (kind > 1) {
            index += this.pools[poolIndex].uintpositions.length == 0 ? 0 : this.pools[poolIndex].uintpositions.length - 1;
        }
        if (kind > 2) {
            index += this.pools[poolIndex].doublepositions.length == 0 ? 0 : this.pools[poolIndex].doublepositions.length - 1;
        }
        if (kind > 3) {
            index += this.pools[poolIndex].strpositions.length == 0 ? 0 : this.pools[poolIndex].strpositions.length - 1;
        }
        if (kind > 4) {
            index += this.pools[poolIndex].nspositions.length == 0 ? 0 : this.pools[poolIndex].nspositions.length - 1;
        }
        if (kind > 5) {
            index += this.pools[poolIndex].nsspositions.length == 0 ? 0 : this.pools[poolIndex].nsspositions.length - 1;
        }
        if (kind > 6) {
            index += this.pools[poolIndex].mnpositions.length == 0 ? 0 : this.pools[poolIndex].mnpositions.length - 1;
        }
        return index += oldIndex - 1;
    }

    private final void decodeOnDemand(int poolIndex, int kind, int j, int j2) {
        int pos;
        int end;
        ConstantPool pool = this.pools[poolIndex];
        ByteArrayPool baPool = null;
        BytecodeBuffer poolIn = null;
        int[] positions = null;
        int length = 0;
        int endPos = 0;
        if (kind == 0) {
            positions = pool.intpositions;
            length = positions.length;
            endPos = pool.intEnd;
            baPool = this.intP;
            poolIn = pool.in;
        } else if (kind == 1) {
            positions = pool.uintpositions;
            length = positions.length;
            endPos = pool.uintEnd;
            baPool = this.uintP;
            poolIn = pool.in;
        } else if (kind == 2) {
            positions = pool.doublepositions;
            length = positions.length;
            endPos = pool.doubleEnd;
            baPool = this.doubleP;
            poolIn = pool.in;
        } else if (kind == 3) {
            positions = pool.strpositions;
            length = positions.length;
            endPos = pool.strEnd;
            baPool = this.stringP;
            poolIn = pool.in;
        } else if (kind == 4) {
            positions = pool.nspositions;
            length = positions.length;
            endPos = pool.nsEnd;
            baPool = this.nsP;
            poolIn = pool.in;
        } else if (kind == 5) {
            positions = pool.nsspositions;
            length = positions.length;
            endPos = pool.nssEnd;
            baPool = this.nssP;
            poolIn = pool.in;
        } else if (kind == 6) {
            positions = pool.mnpositions;
            length = positions.length;
            endPos = pool.mnEnd;
            baPool = this.mnP;
            poolIn = pool.in;
        }
        int start = positions[j];
        int n = end = j != length - 1 ? positions[j + 1] : endPos;
        if (kind == 4) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in4.size();
            int nsKind = poolIn.readU8();
            this.in4.writeU8(nsKind);
            switch (nsKind) {
                case 5: {
                    if (this.disableDebuggingInfo) {
                        this.in4.writeU32(0L);
                        break;
                    }
                }
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int index = (int)poolIn.readU32();
                    int newIndex = this.getIndex(poolIndex, 3, index);
                    this.in4.writeU32(newIndex);
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new Error();
                }
            }
            poolIn.seek(originalPos);
            end = this.in4.size();
            poolIn = this.in4;
        } else if (kind == 5) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in5.size();
            int count = (int)poolIn.readU32();
            this.in5.writeU32(count);
            for (int k = 0; k < count; ++k) {
                int index = (int)poolIn.readU32();
                int newIndex = this.getIndex(poolIndex, 4, index);
                this.in5.writeU32(newIndex);
            }
            poolIn.seek(originalPos);
            end = this.in5.size();
            poolIn = this.in5;
        } else if (kind == 6) {
            pos = positions[j];
            int originalPos = poolIn.pos();
            poolIn.seek(pos);
            start = this.in6.size();
            int constKind = poolIn.readU8();
            this.in6.writeU8(constKind);
            switch (constKind) {
                case 7: 
                case 13: {
                    int namespaceIndex = (int)poolIn.readU32();
                    int newNamespaceIndex = this.getIndex(poolIndex, 4, namespaceIndex);
                    this.in6.writeU32(newNamespaceIndex);
                    int nameIndex = (int)poolIn.readU32();
                    int newNameIndex = this.getIndex(poolIndex, 3, nameIndex);
                    this.in6.writeU32(newNameIndex);
                    break;
                }
                case 9: 
                case 14: {
                    int nameIndex = (int)poolIn.readU32();
                    int newNameIndex = this.getIndex(poolIndex, 3, nameIndex);
                    this.in6.writeU32(newNameIndex);
                    int namespace_set = (int)poolIn.readU32();
                    int newNamespace_set = this.getIndex(poolIndex, 5, namespace_set);
                    this.in6.writeU32(newNamespace_set);
                    break;
                }
                case 15: 
                case 16: {
                    int index = (int)poolIn.readU32();
                    int newIndex = this.getIndex(poolIndex, 3, index);
                    this.in6.writeU32(newIndex);
                    break;
                }
                case 17: 
                case 18: {
                    break;
                }
                case 27: 
                case 28: {
                    int namespace_set = (int)poolIn.readU32();
                    int newNamespace_set = this.getIndex(poolIndex, 5, namespace_set);
                    this.in6.writeU32(newNamespace_set);
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new Error();
                }
            }
            poolIn.seek(originalPos);
            end = this.in6.size();
            poolIn = this.in6;
        }
        int newIndex = baPool.contains(poolIn, start, end);
        if (newIndex == -1) {
            newIndex = baPool.store(poolIn, start, end);
        } else {
            ++this.duplicate;
            this.duplicateBytes += end - start;
        }
        ++this.total;
        this.totalBytes += end - start;
        if (j != 0) {
            this.map[j2] = newIndex;
        }
    }

    static {
        $assertionsDisabled = true;
    }
}

