/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.UCharacterProperty;
import com.adobe.agl.text.Replaceable;
import com.adobe.agl.text.Transliterator;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.util.ULocale;

class LowercaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Lower";
    private ULocale loc;
    private char[] buffer = new char[10];
    private static final UCharacterProperty m_charppty_ = UCharacterProperty.getInstance();

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new LowercaseTransliterator(ULocale.US);
            }
        });
        Transliterator.registerSpecialInverse("Lower", "Upper", true);
    }

    public LowercaseTransliterator(ULocale loc) {
        super(_ID, null);
        this.loc = loc;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int textPos = offsets.start;
        if (textPos >= offsets.limit) {
            return;
        }
        UCharacterIterator original = UCharacterIterator.getInstance(text);
        int limit = offsets.limit;
        while (textPos < limit) {
            original.setIndex(textPos);
            int cp = original.currentCodePoint();
            int oldLen = UTF16.getCharCount(cp);
            int newLen = m_charppty_.toLowerCase(this.loc, cp, original, this.buffer);
            if (newLen >= 0) {
                text.replace(textPos, textPos + oldLen, this.buffer, 0, newLen);
                if (newLen != oldLen) {
                    textPos += newLen;
                    offsets.limit += newLen - oldLen;
                    offsets.contextLimit += newLen - oldLen;
                    continue;
                }
            }
            textPos += oldLen;
        }
        offsets.start = offsets.limit;
    }
}

