/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.UConverter;
import com.adobe.agl.impl.UConverterFromUnicodeArgs;
import com.adobe.agl.impl.UConverterSharedData;
import com.adobe.agl.impl.UConverterSharedData_MBCS;
import com.adobe.agl.impl.UConverterStaticData;
import com.adobe.agl.impl.UConverterToUnicodeArgs;
import com.adobe.agl.impl.UConverterUTF;
import com.adobe.agl.impl.UConverterUTF16;

public class UConverterSharedData_ISO2022
extends UConverterSharedData {
    protected static final char missingCharMarker = '\uffff';
    protected static final byte[] SHIFT_IN_STR;
    protected static final byte[] SHIFT_OUT_STR;
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected static final byte H_TAB = 9;
    protected static final byte V_TAB = 11;
    protected static final byte SPACE = 32;
    protected static final byte INVALID_STATE = -1;
    protected static final byte ASCII = 0;
    protected static final byte SS2_STATE = 16;
    protected static final byte SS3_STATE = 17;
    protected static final byte ISO8859_1 = 1;
    protected static final byte ISO8859_7 = 2;
    protected static final byte JISX201 = 3;
    protected static final byte JISX208 = 4;
    protected static final byte JISX212 = 5;
    protected static final byte GB2312 = 6;
    protected static final byte KSC5601 = 7;
    protected static final byte HWKANA_7BIT = 8;
    protected static final byte GB2312_1 = 1;
    protected static final byte ISO_IR_165 = 2;
    protected static final byte CNS_11643 = 3;
    protected static final byte CNS_11643_0 = 32;
    protected static final byte CNS_11643_1 = 33;
    protected static final byte CNS_11643_2 = 34;
    protected static final byte CNS_11643_3 = 35;
    protected static final byte CNS_11643_4 = 36;
    protected static final byte CNS_11643_5 = 37;
    protected static final byte CNS_11643_6 = 38;
    protected static final byte CNS_11643_7 = 39;
    protected static final short[] jpCharsetMasks;
    protected static final byte ASCII1 = 0;
    protected static final byte LATIN1 = 1;
    protected static final byte SBCS = 2;
    protected static final byte DBCS = 3;
    protected static final byte MBCS = 4;
    protected static final byte HWKANA = 5;
    protected static final long UCNV_OPTIONS_VERSION_MASK = 15L;
    protected static final byte UCNV_2022_MAX_CONVERTERS = 10;
    protected static final byte ESC_2022 = 27;
    protected static final byte INVALID_2022 = -1;
    protected static final byte VALID_NON_TERMINAL_2022 = 0;
    protected static final byte VALID_TERMINAL_2022 = 1;
    protected static final byte VALID_MAYBE_TERMINAL_2022 = 2;
    protected static final byte[] normalize_esq_chars_2022;
    protected static final byte MAX_STATES_2022 = 74;
    protected static final int[] escSeqStateTable_Key_2022;
    protected static final byte[] escSeqStateTable_Value_2022;
    protected static final byte ISO_2022_JP = 1;
    protected static final byte ISO_2022_KR = 2;
    protected static final byte ISO_2022_CN = 3;
    protected static final byte[] nextStateToUnicodeJP;
    protected static final byte[] nextStateToUnicodeCN;
    private static final byte[] jpCharsetPref;
    private static final byte[][] escSeqChars;
    private static final int[] escSeqCharsLen;
    private static final byte[] GB_2312_80_STR;
    private static final byte[] ISO_IR_165_STR;
    private static final byte[] CNS_11643_1992_Plane_1_STR;
    private static final byte[] CNS_11643_1992_Plane_2_STR;
    private static final byte[] CNS_11643_1992_Plane_3_STR;
    private static final byte[] CNS_11643_1992_Plane_4_STR;
    private static final byte[] CNS_11643_1992_Plane_5_STR;
    private static final byte[] CNS_11643_1992_Plane_6_STR;
    private static final byte[] CNS_11643_1992_Plane_7_STR;
    private static final byte[][] escSeqCharsCN;
    private UConverterSharedData_ISO2022 actualConverter = null;
    public static UConverterStaticData _ISO2022StaticData;
    public static UConverterSharedData_ISO2022 _ISO2022Data;
    public static UConverterStaticData _ISO2022JPStaticData;
    public static UConverterSharedData_ISO2022 _ISO2022JPData;
    public static UConverterStaticData _ISO2022KRStaticData;
    public static UConverterSharedData_ISO2022 _ISO2022KRData;
    public static UConverterStaticData _ISO2022CNStaticData;
    public static UConverterSharedData_ISO2022 _ISO2022CNData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UConverterSharedData_ISO2022(int structSize_, int referenceCounter_, UConverterStaticData staticData_, boolean sharedDataCached_, long toUnicodeStatus_) {
        super(structSize_, referenceCounter_, staticData_, sharedDataCached_, toUnicodeStatus_);
    }

    public UConverterSharedData_ISO2022() {
        super(100, 1, null, false, 0L);
    }

    protected void doOpen(UConverter cnv, String name, String locale, long options, int[] pErrorCode) {
        this._ISO2022Open(cnv, name, locale, options, pErrorCode);
    }

    protected void doToUnicode(UConverterToUnicodeArgs args, int[] pErrorCode) {
        if (args.converter.sharedData == _ISO2022JPData) {
            UConverterSharedData_ISO2022.UConverter_toUnicode_ISO_2022_JP_OFFSETS_LOGIC(args, pErrorCode);
        } else if (args.converter.sharedData == _ISO2022KRData) {
            UConverterSharedData_ISO2022.UConverter_toUnicode_ISO_2022_KR_OFFSETS_LOGIC(args, pErrorCode);
        } else if (args.converter.sharedData == _ISO2022CNData) {
            UConverterSharedData_ISO2022.UConverter_toUnicode_ISO_2022_CN_OFFSETS_LOGIC(args, pErrorCode);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void doFromUnicode(UConverterFromUnicodeArgs args, int[] pErrorCode) {
        if (args.converter.sharedData == _ISO2022JPData) {
            UConverterSharedData_ISO2022.UConverter_fromUnicode_ISO_2022_JP_OFFSETS_LOGIC(args, pErrorCode);
        } else if (args.converter.sharedData == _ISO2022KRData) {
            UConverterSharedData_ISO2022.UConverter_fromUnicode_ISO_2022_KR_OFFSETS_LOGIC(args, pErrorCode);
        } else if (args.converter.sharedData == _ISO2022CNData) {
            UConverterSharedData_ISO2022.UConverter_fromUnicode_ISO_2022_CN_OFFSETS_LOGIC(args, pErrorCode);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected static boolean IS_JP_DBCS(byte cs) {
        return 4 <= cs && cs <= 7;
    }

    protected static short CSM(byte cs) {
        return (short)(1 << cs);
    }

    protected static void setInitialStateToUnicodeKR(UConverter converter, UConverterDataISO2022 myConverterData) {
        if (myConverterData.version == 1) {
            UConverter cnv = myConverterData.currentConverter;
            cnv.toUnicodeStatus = 0L;
            cnv.mode = 0;
            cnv.toULength = 0;
        }
    }

    protected static void setInitialStateFromUnicodeKR(UConverter converter, UConverterDataISO2022 myConverterData) {
        if (converter.charErrorBufferLength == 0) {
            if (!$assertionsDisabled && converter.charErrorBufferArray.length < 4) {
                throw new AssertionError();
            }
            converter.charErrorBufferLength = (byte)4;
            converter.charErrorBufferBegin = 0;
            converter.charErrorBufferArray[0] = 27;
            converter.charErrorBufferArray[1] = 36;
            converter.charErrorBufferArray[2] = 41;
            converter.charErrorBufferArray[3] = 67;
        }
        if (myConverterData.version == 1) {
            UConverter cnv = myConverterData.currentConverter;
            cnv.fromUChar32 = 0;
            cnv.fromUnicodeStatus = 1L;
        }
    }

    private void _ISO2022Open(UConverter cnv, String name, String locale, long options, int[] errorCode) {
        String myLocale = "      ";
        cnv.extraInfo = new UConverterDataISO2022();
        if (cnv.extraInfo != null) {
            UConverterDataISO2022 myConverterData = (UConverterDataISO2022)cnv.extraInfo;
            myConverterData.currentConverter = null;
            myConverterData.currentType = 0;
            myConverterData.key = 0;
            cnv.fromUnicodeStatus = 0L;
            if (locale != null) {
                myLocale = locale + myLocale;
            }
            myConverterData.version = 0;
            int version = (int)(options & 0xFL);
            if (!(myLocale.charAt(0) != 'j' || myLocale.charAt(1) != 'a' && myLocale.charAt(1) != 'p' || myLocale.charAt(2) != '_' && myLocale.charAt(2) != ' ')) {
                if ((jpCharsetMasks[version] & UConverterSharedData_ISO2022.CSM((byte)2)) != 0) {
                    myConverterData.myConverterArray[2] = UConverter.ucnv_loadSharedData("ISO8859_7", null, errorCode);
                }
                myConverterData.myConverterArray[3] = UConverter.ucnv_loadSharedData("JISX0201", null, errorCode);
                myConverterData.myConverterArray[4] = UConverter.ucnv_loadSharedData("jisx-208", null, errorCode);
                if ((jpCharsetMasks[version] & UConverterSharedData_ISO2022.CSM((byte)5)) != 0) {
                    myConverterData.myConverterArray[5] = UConverter.ucnv_loadSharedData("jisx-212", null, errorCode);
                }
                if ((jpCharsetMasks[version] & UConverterSharedData_ISO2022.CSM((byte)6)) != 0) {
                    myConverterData.myConverterArray[6] = UConverter.ucnv_loadSharedData("ibm-5478", null, errorCode);
                }
                if ((jpCharsetMasks[version] & UConverterSharedData_ISO2022.CSM((byte)7)) != 0) {
                    myConverterData.myConverterArray[7] = UConverter.ucnv_loadSharedData("ksc_5601", null, errorCode);
                }
                cnv.sharedData = _ISO2022JPData;
                myConverterData.locale = "ja";
                myConverterData.version = version;
                myConverterData.name = "ISO_2022,locale=ja,version=";
                myConverterData.name = myConverterData.name + (char)(myConverterData.version + 48);
            } else if (!(myLocale.charAt(0) != 'k' || myLocale.charAt(1) != 'o' && myLocale.charAt(1) != 'r' || myLocale.charAt(2) != '_' && myLocale.charAt(2) != ' ')) {
                if ((options & 0xFL) == 1L) {
                    myConverterData.version = 1;
                    myConverterData.currentConverter = UConverter.ucnv_open("icu-internal-25546", errorCode);
                    if (ErrorCode.isFailure(errorCode[0])) {
                        UConverterSharedData_ISO2022._ISO2022Close(cnv);
                        return;
                    }
                    myConverterData.name = "ISO_2022,locale=ko,version=1";
                    System.arraycopy(myConverterData.currentConverter.subCharArray, myConverterData.currentConverter.subCharBegin, cnv.subCharArray, cnv.subCharBegin, 4);
                    cnv.subCharLen = myConverterData.currentConverter.subCharLen;
                } else {
                    myConverterData.currentConverter = UConverter.ucnv_open("ibm-949", errorCode);
                    if (ErrorCode.isFailure(errorCode[0])) {
                        UConverterSharedData_ISO2022._ISO2022Close(cnv);
                        return;
                    }
                    myConverterData.version = 0;
                    myConverterData.name = "ISO_2022,locale=ko,version=0";
                }
                UConverterSharedData_ISO2022.setInitialStateToUnicodeKR(cnv, myConverterData);
                UConverterSharedData_ISO2022.setInitialStateFromUnicodeKR(cnv, myConverterData);
                cnv.sharedData = _ISO2022KRData;
                myConverterData.locale = "ko";
            } else if ((myLocale.charAt(0) == 'z' && myLocale.charAt(1) == 'h' || myLocale.charAt(0) == 'c' && myLocale.charAt(1) == 'n') && (myLocale.charAt(2) == '_' || myLocale.charAt(2) == ' ')) {
                myConverterData.myConverterArray[1] = UConverter.ucnv_loadSharedData("ibm-5478", null, errorCode);
                if (version == 1) {
                    myConverterData.myConverterArray[2] = UConverter.ucnv_loadSharedData("iso-ir-165", null, errorCode);
                }
                myConverterData.myConverterArray[3] = UConverter.ucnv_loadSharedData("cns-11643-1992", null, errorCode);
                cnv.sharedData = _ISO2022CNData;
                myConverterData.locale = "cn";
                if ((options & 0xFL) == 1L) {
                    myConverterData.version = 1;
                    myConverterData.name = "ISO_2022,locale=zh,version=1";
                } else {
                    myConverterData.name = "ISO_2022,locale=zh,version=0";
                    myConverterData.version = 0;
                }
            } else {
                errorCode[0] = 16;
                return;
            }
            cnv.maxBytesPerUChar = cnv.sharedData.staticData.maxBytesPerChar;
            if (ErrorCode.isFailure(errorCode[0])) {
                UConverterSharedData_ISO2022._ISO2022Close(cnv);
            }
        } else {
            errorCode[0] = 7;
        }
    }

    private static void _ISO2022Close(UConverter converter) {
        UConverterDataISO2022 myData = (UConverterDataISO2022)converter.extraInfo;
        UConverterSharedData[] array = myData.myConverterArray;
        if (converter.extraInfo != null) {
            for (int i = 0; i < 10; ++i) {
                if (array[i] == null) continue;
                UConverter.ucnv_unloadSharedDataIfReady(array[i]);
            }
            myData.currentConverter.ucnv_close();
            if (!converter.isExtraLocal) {
                converter.extraInfo = null;
            }
        }
    }

    private static final String _ISO2022getName(UConverter cnv) {
        if (cnv.extraInfo != null) {
            UConverterDataISO2022 myData = (UConverterDataISO2022)cnv.extraInfo;
            return myData.name;
        }
        return null;
    }

    protected static byte getKey_2022(byte c, int[] key, int[] offset) {
        int mid;
        int low = 0;
        int hi = 74;
        int oldmid = 0;
        int togo = normalize_esq_chars_2022[c & 0xFF];
        if (togo == 0) {
            key[0] = 0;
            offset[0] = 0;
            return -1;
        }
        togo = (key[0] << 5) + togo;
        while (hi != low && (mid = hi + low >> 1) != oldmid) {
            if (escSeqStateTable_Key_2022[mid] > togo) {
                hi = mid;
            } else if (escSeqStateTable_Key_2022[mid] < togo) {
                low = mid;
            } else {
                key[0] = togo;
                offset[0] = mid;
                return escSeqStateTable_Value_2022[mid];
            }
            oldmid = mid;
        }
        key[0] = 0;
        offset[0] = 0;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void changeState_2022(UConverter _this, byte[] sourceArray, int[] sourceIndex, int sourceLimit, byte var, int[] err) {
        UConverterDataISO2022 myData2022 = (UConverterDataISO2022)_this.extraInfo;
        int[] key = new int[]{myData2022.key};
        int[] offset = new int[1];
        int value = 0;
        block24: while (sourceIndex[0] < sourceLimit) {
            int n = sourceIndex[0];
            sourceIndex[0] = n + 1;
            byte c = sourceArray[n];
            byte by = _this.toULength;
            _this.toULength = (byte)(by + 1);
            _this.toUBytesArray[by] = c;
            value = UConverterSharedData_ISO2022.getKey_2022(c, key, offset);
            switch (value) {
                case 0: {
                    break;
                }
                case 1: {
                    key[0] = 0;
                    break block24;
                }
                case -1: {
                    break block24;
                }
                case 2: {
                    value = 1;
                    key[0] = 0;
                    break block24;
                }
            }
        }
        myData2022.key = key[0];
        if (value == 0) {
            return;
        }
        if (value == -1) {
            err[0] = 18;
            return;
        }
        block6 : switch (var) {
            case 1: {
                byte tempState = nextStateToUnicodeJP[offset[0]];
                switch (tempState) {
                    case -1: {
                        err[0] = 19;
                        break block6;
                    }
                    case 16: {
                        if (myData2022.toU2022State.cs[2] != 0) {
                            if (myData2022.toU2022State.g < 2) {
                                myData2022.toU2022State.prevG = myData2022.toU2022State.g;
                            }
                            myData2022.toU2022State.g = (byte)2;
                            break block6;
                        }
                        err[0] = 18;
                        break block6;
                    }
                    case 1: 
                    case 2: {
                        if ((jpCharsetMasks[myData2022.version] & UConverterSharedData_ISO2022.CSM(tempState)) == 0) {
                            err[0] = 19;
                            break block6;
                        }
                        myData2022.toU2022State.cs[2] = tempState;
                        break block6;
                    }
                }
                if ((jpCharsetMasks[myData2022.version] & UConverterSharedData_ISO2022.CSM(tempState)) == 0) {
                    err[0] = 19;
                    break;
                }
                myData2022.toU2022State.cs[0] = tempState;
                break;
            }
            case 3: {
                byte tempState = nextStateToUnicodeCN[offset[0]];
                switch (tempState) {
                    case -1: {
                        err[0] = 19;
                        break block6;
                    }
                    case 16: {
                        if (myData2022.toU2022State.cs[2] != 0) {
                            if (myData2022.toU2022State.g < 2) {
                                myData2022.toU2022State.prevG = myData2022.toU2022State.g;
                            }
                            myData2022.toU2022State.g = (byte)2;
                            break block6;
                        }
                        err[0] = 18;
                        break block6;
                    }
                    case 17: {
                        if (myData2022.toU2022State.cs[3] != 0) {
                            if (myData2022.toU2022State.g < 2) {
                                myData2022.toU2022State.prevG = myData2022.toU2022State.g;
                            }
                            myData2022.toU2022State.g = (byte)3;
                            break block6;
                        }
                        err[0] = 18;
                        break block6;
                    }
                    case 2: {
                        if (myData2022.version == 0) {
                            err[0] = 19;
                            break block6;
                        }
                    }
                    case 1: 
                    case 33: {
                        myData2022.toU2022State.cs[1] = tempState;
                        break block6;
                    }
                    case 34: {
                        myData2022.toU2022State.cs[2] = tempState;
                        break block6;
                    }
                }
                if (myData2022.version == 0) {
                    err[0] = 19;
                    break;
                }
                myData2022.toU2022State.cs[3] = tempState;
                break;
            }
            case 2: {
                if (offset[0] == 48) break;
                err[0] = 19;
                break;
            }
            default: {
                err[0] = 18;
            }
        }
        if (ErrorCode.isSuccess(err[0])) {
            _this.toULength = 0;
        }
    }

    protected static int getEndOfBuffer_2022(byte[] sourceArray, int sourceBegin, int sourceLimit, boolean flush) {
        int sourceIndex;
        for (sourceIndex = sourceBegin; sourceIndex < sourceLimit && sourceArray[sourceIndex] != 27; ++sourceIndex) {
        }
        return sourceIndex;
    }

    protected static void MBCS_FROM_UCHAR32_ISO2022(UConverterSharedData sharedData, int c, long[] value, boolean useFallback, int[] length, int outputType) {
        if (c < 65536 || (sharedData.mbcs.unicodeMask & 1) != 0) {
            int fromUnicodeBytesIndex;
            byte[] fromUnicodeBytes;
            int myValue;
            char[] table = sharedData.mbcs.fromUnicodeTable;
            int stage2Entry = UConverterSharedData_MBCS.MBCS_STAGE_2_FROM_U(table, c);
            length[0] = outputType == 1 ? ((myValue = UConverterSharedData_MBCS.MBCS_VALUE_2_FROM_STAGE_2(sharedData.mbcs.fromUnicodeBytes, stage2Entry, c)) <= 255 ? 1 : 2) : ((myValue = (fromUnicodeBytes = sharedData.mbcs.fromUnicodeBytes)[fromUnicodeBytesIndex = UConverterSharedData_MBCS.MBCS_POINTER_3_FROM_STAGE_2(null, stage2Entry, c)] << 16 & 0xFF0000 | fromUnicodeBytes[fromUnicodeBytesIndex + 1] << 8 & 0xFF00 | fromUnicodeBytes[fromUnicodeBytesIndex + 2] & 0xFF) <= 255 ? 1 : (myValue <= 65535 ? 2 : 3));
            if ((stage2Entry & 1 << 16 + (c & 0xF)) != 0 || UConverter.FROM_U_USE_FALLBACK(useFallback, c) && myValue != 0) {
                value[0] = myValue;
                return;
            }
        }
        length[0] = 0;
    }

    protected static void MBCS_SINGLE_FROM_UCHAR32(UConverterSharedData sharedData, int c, int[] retval, boolean useFallback) {
        if (c >= 65536 && (sharedData.mbcs.unicodeMask & 1) == 0) {
            retval[0] = 65535;
            return;
        }
        char[] table = sharedData.mbcs.fromUnicodeTable;
        int value = UConverterSharedData_MBCS.MBCS_SINGLE_RESULT_FROM_U(table, sharedData.mbcs.fromUnicodeBytes, c);
        value = (useFallback ? value >= 2048 : value >= 3072) ? (value &= 0xFF) : -1;
        retval[0] = value & 0xFFFF;
    }

    protected static void toUnicodeCallback(UConverter cnv, int sourceChar, int targetUniChar, int[] err) {
        if (sourceChar > 255) {
            cnv.toUBytesArray[0] = (byte)(sourceChar >> 8);
            cnv.toUBytesArray[1] = (byte)sourceChar;
            cnv.toULength = (byte)2;
        } else {
            cnv.toUBytesArray[0] = (byte)sourceChar;
            cnv.toULength = (byte)2;
        }
        err[0] = targetUniChar == 65534 ? 10 : 12;
    }

    protected static void _ISO_2022_WriteSub(UConverterFromUnicodeArgs args, int offsetIndex, int[] err) {
        UConverter cnv = args.converter;
        UConverterDataISO2022 myConverterData = (UConverterDataISO2022)cnv.extraInfo;
        ISO2022State pFromU2022State = myConverterData.fromU2022State;
        int bufferIndex = 0;
        byte[] buffer = new byte[8];
        byte[] subcharArray = cnv.subCharArray;
        int subcharBegin = cnv.subCharBegin;
        byte length = cnv.subCharLen;
        bufferIndex = 0;
        switch (myConverterData.locale.charAt(0)) {
            case 'j': {
                byte cs;
                if (pFromU2022State.g == 1) {
                    pFromU2022State.g = 0;
                    buffer[bufferIndex++] = 15;
                }
                if ((cs = pFromU2022State.cs[0]) != 0 && cs != 3) {
                    pFromU2022State.cs[0] = 0;
                    buffer[bufferIndex++] = 27;
                    buffer[bufferIndex++] = 40;
                    buffer[bufferIndex++] = 66;
                }
                buffer[bufferIndex++] = subcharArray[subcharBegin + 0];
                break;
            }
            case 'c': {
                if (pFromU2022State.g != 0) {
                    pFromU2022State.g = 0;
                    buffer[bufferIndex++] = 15;
                }
                buffer[bufferIndex++] = subcharArray[subcharBegin + 0];
                break;
            }
            case 'k': {
                if (myConverterData.version == 0) {
                    if (length == 1) {
                        if (args.converter.fromUnicodeStatus != 0L) {
                            args.converter.fromUnicodeStatus = 0L;
                            buffer[bufferIndex++] = 15;
                        }
                        buffer[bufferIndex++] = subcharArray[subcharBegin + 0];
                        break;
                    }
                    if (args.converter.fromUnicodeStatus == 0L) {
                        args.converter.fromUnicodeStatus = 1L;
                        buffer[bufferIndex++] = 14;
                    }
                    buffer[bufferIndex++] = subcharArray[subcharBegin + 0];
                    buffer[bufferIndex++] = subcharArray[subcharBegin + 1];
                    break;
                }
                args.converter = myConverterData.currentConverter;
                System.arraycopy(subcharArray, subcharBegin, myConverterData.currentConverter.subCharArray, myConverterData.currentConverter.subCharBegin, 4);
                myConverterData.currentConverter.subCharLen = length;
                myConverterData.currentConverter.fromUChar32 = cnv.fromUChar32;
                UConverter.ucnv_cbFromUWriteSub(args, 0, err);
                cnv.fromUChar32 = myConverterData.currentConverter.fromUChar32;
                if (err[0] == 15) {
                    if (myConverterData.currentConverter.charErrorBufferLength > 0) {
                        System.arraycopy(myConverterData.currentConverter.charErrorBufferArray, myConverterData.currentConverter.charErrorBufferBegin, cnv.charErrorBufferArray, cnv.charErrorBufferBegin, myConverterData.currentConverter.charErrorBufferLength);
                    }
                    cnv.charErrorBufferLength = myConverterData.currentConverter.charErrorBufferLength;
                    myConverterData.currentConverter.charErrorBufferLength = 0;
                }
                args.converter = cnv;
                return;
            }
        }
        UConverter.ucnv_cbFromUWriteBytes(args, buffer, 0, bufferIndex, offsetIndex, err);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void UConverter_fromUnicode_ISO_2022_JP_OFFSETS_LOGIC(UConverterFromUnicodeArgs args, int[] err) {
        int outLen;
        byte[] targetArray = args.targetArray;
        int targetIndex = args.targetBegin;
        int targetLimit = args.targetLimit;
        char[] sourceArray = args.sourceArray;
        int sourceIndex = args.sourceBegin;
        int sourceLimit = args.sourceLimit;
        int[] offsetsArray = args.offsetsArray;
        int offsetsIndex = args.offsetsBegin;
        byte[] buffer = new byte[8];
        byte[] choices = new byte[10];
        int targetValue = 0;
        boolean goto_getTrail = false;
        UConverterDataISO2022 converterData = (UConverterDataISO2022)args.converter.extraInfo;
        ISO2022State pFromU2022State = converterData.fromU2022State;
        boolean useFallback = args.converter.useFallback;
        int choiceCount = 0;
        int sourceChar = args.converter.fromUChar32;
        if (sourceChar != 0 && targetIndex < targetLimit) {
            goto_getTrail = true;
        }
        while (goto_getTrail || sourceIndex < sourceLimit) {
            int len;
            byte g;
            int i;
            byte cs;
            if (goto_getTrail || targetIndex < targetLimit) {
                block42: {
                    if (!goto_getTrail) {
                        sourceChar = sourceArray[sourceIndex++];
                    }
                    if (goto_getTrail || UConverterUTF.U_IS_SURROGATE(sourceChar)) {
                        if (goto_getTrail || UConverterUTF.U_IS_SURROGATE_LEAD(sourceChar)) {
                            goto_getTrail = false;
                            if (sourceIndex < sourceLimit) {
                                char trail = (char)(sourceArray[sourceIndex] & 0xFF);
                                if (UConverterUTF16.U16_IS_TRAIL(trail)) {
                                    ++sourceIndex;
                                    sourceChar = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)sourceChar, trail);
                                    args.converter.fromUChar32 = 0;
                                    break block42;
                                } else {
                                    err[0] = 12;
                                    args.converter.fromUChar32 = sourceChar;
                                    break;
                                }
                            }
                            args.converter.fromUChar32 = sourceChar;
                            break;
                        }
                        err[0] = 12;
                        args.converter.fromUChar32 = sourceChar;
                        break;
                    }
                }
                if (choiceCount == 0) {
                    short csm = jpCharsetMasks[converterData.version];
                    choiceCount = 0;
                    if (converterData.version == 3 || converterData.version == 4) {
                        int n = choiceCount++;
                        cs = 8;
                        choices[n] = 8;
                        csm = (short)(csm & ~UConverterSharedData_ISO2022.CSM(cs));
                    }
                    choices[choiceCount++] = cs = pFromU2022State.cs[0];
                    csm = (short)(csm & ~UConverterSharedData_ISO2022.CSM(cs));
                    cs = pFromU2022State.cs[2];
                    if (cs != 0) {
                        choices[choiceCount++] = cs;
                        csm = (short)(csm & ~UConverterSharedData_ISO2022.CSM(cs));
                    }
                    for (i = 0; i < jpCharsetPref.length; ++i) {
                        cs = jpCharsetPref[i];
                        if ((UConverterSharedData_ISO2022.CSM(cs) & csm) == 0) continue;
                        choices[choiceCount++] = cs;
                        csm = (short)(csm & ~UConverterSharedData_ISO2022.CSM(cs));
                    }
                }
                g = 0;
                cs = 0;
                len = 0;
            } else {
                err[0] = 15;
                break;
            }
            block12: for (i = 0; i < choiceCount && len == 0; ++i) {
                cs = choices[i];
                switch (cs) {
                    case 0: {
                        if (sourceChar > 127) continue block12;
                        targetValue = sourceChar;
                        len = 1;
                        continue block12;
                    }
                    case 1: {
                        if (128 > sourceChar || sourceChar > 255) continue block12;
                        targetValue = sourceChar - 128;
                        len = 1;
                        g = 2;
                        continue block12;
                    }
                    case 8: {
                        if (65439 - sourceChar > 62) continue block12;
                        targetValue = sourceChar - 65344;
                        len = 1;
                        if (converterData.version == 3) {
                            pFromU2022State.cs[1] = cs;
                            g = 1;
                            continue block12;
                        }
                        if (converterData.version != 4) continue block12;
                        targetValue += 128;
                        byte cs0 = pFromU2022State.cs[0];
                        if (UConverterSharedData_ISO2022.IS_JP_DBCS(cs0)) {
                            cs = 3;
                            continue block12;
                        }
                        cs = cs0;
                        continue block12;
                    }
                    case 3: {
                        int[] targetValueLocal = new int[]{targetValue};
                        UConverterSharedData_ISO2022.MBCS_SINGLE_FROM_UCHAR32(converterData.myConverterArray[cs], sourceChar, targetValueLocal, useFallback);
                        targetValue = targetValueLocal[0];
                        if (targetValue > 127) continue block12;
                        len = 1;
                        continue block12;
                    }
                    case 2: {
                        int[] targetValueLocal = new int[]{targetValue};
                        UConverterSharedData_ISO2022.MBCS_SINGLE_FROM_UCHAR32(converterData.myConverterArray[cs], sourceChar, targetValueLocal, useFallback);
                        targetValue = targetValueLocal[0];
                        if (128 > targetValue || targetValue > 255) continue block12;
                        targetValue -= 128;
                        len = 1;
                        g = 2;
                        continue block12;
                    }
                    default: {
                        long[] targetValueLocal = new long[]{targetValue};
                        int[] lenLocal = new int[]{len};
                        UConverterSharedData_ISO2022.MBCS_FROM_UCHAR32_ISO2022(converterData.myConverterArray[cs], sourceChar, targetValueLocal, useFallback, lenLocal, 1);
                        targetValue = (int)targetValueLocal[0];
                        len = lenLocal[0];
                        if (len == 2) continue block12;
                        len = 0;
                    }
                }
            }
            if (len <= 0) {
                err[0] = 10;
                args.converter.fromUChar32 = sourceChar;
                break;
            }
            outLen = 0;
            if (pFromU2022State.g == 1 && g == 0) {
                buffer[outLen++] = 15;
                pFromU2022State.g = 0;
            }
            if (cs != pFromU2022State.cs[g]) {
                int escLen = escSeqCharsLen[cs];
                System.arraycopy(escSeqChars[cs], 0, buffer, 0, escLen);
                outLen += escLen;
                pFromU2022State.cs[g] = cs;
                choiceCount = 0;
            }
            if (g != pFromU2022State.g) {
                switch (g) {
                    case 1: {
                        buffer[outLen++] = 14;
                        pFromU2022State.g = 1;
                        break;
                    }
                    default: {
                        buffer[outLen++] = 27;
                        buffer[outLen++] = 78;
                    }
                }
            }
            if (len == 1) {
                buffer[outLen++] = (byte)targetValue;
            } else {
                buffer[outLen++] = (byte)(targetValue >> 8);
                buffer[outLen++] = (byte)targetValue;
            }
            if (sourceChar == 13 || sourceChar == 10) {
                pFromU2022State.cs[2] = 0;
                choiceCount = 0;
            }
            if (outLen == 1) {
                targetArray[targetIndex++] = buffer[0];
                if (offsetsArray == null) continue;
                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                continue;
            }
            if (outLen == 2 && targetIndex + 2 <= targetLimit) {
                targetArray[targetIndex++] = buffer[0];
                targetArray[targetIndex++] = buffer[1];
                if (offsetsArray == null) continue;
                int sourceIndexLocal = sourceIndex - args.sourceBegin - UConverterUTF16.U16_LENGTH(sourceChar);
                offsetsArray[offsetsIndex++] = sourceIndexLocal;
                offsetsArray[offsetsIndex++] = sourceIndexLocal;
                continue;
            }
            int[] targetIndexLocal = new int[]{targetIndex};
            int[] offsetsIndexLocal = new int[]{offsetsIndex};
            UConverter.ucnv_fromUWriteBytes(args.converter, buffer, 0, outLen, targetArray, targetIndexLocal, targetLimit, offsetsArray, offsetsIndexLocal, sourceIndex - args.sourceBegin - UConverterUTF16.U16_LENGTH(sourceChar), err);
            targetIndex = targetIndexLocal[0];
            offsetsIndex = offsetsIndexLocal[0];
            if (!ErrorCode.isFailure(err[0])) continue;
        }
        if (ErrorCode.isSuccess(err[0]) && (pFromU2022State.g != 0 || pFromU2022State.cs[0] != 0) && args.flush && sourceIndex >= sourceLimit && args.converter.fromUChar32 == 0) {
            int sourceIndexLocal;
            outLen = 0;
            if (pFromU2022State.g != 0) {
                buffer[outLen++] = 15;
                pFromU2022State.g = 0;
            }
            if (pFromU2022State.cs[0] != 0) {
                int escLen = escSeqCharsLen[0];
                System.arraycopy(escSeqChars[0], 0, buffer, outLen, escLen);
                outLen += escLen;
                pFromU2022State.cs[0] = 0;
            }
            if ((sourceIndexLocal = sourceIndex - args.sourceBegin) > 0) {
                if (UConverterUTF16.U16_IS_TRAIL(args.sourceArray[--sourceIndexLocal]) && (sourceIndexLocal == 0 || UConverterUTF16.U16_IS_LEAD(args.sourceArray[sourceIndexLocal - 1]))) {
                    --sourceIndexLocal;
                }
            } else {
                sourceIndexLocal = -1;
            }
            int[] targetIndexLocal = new int[]{targetIndex};
            int[] offsetsIndexLocal = new int[]{offsetsIndex};
            UConverter.ucnv_fromUWriteBytes(args.converter, buffer, 0, outLen, targetArray, targetIndexLocal, targetLimit, offsetsArray, offsetsIndexLocal, sourceIndexLocal, err);
            targetIndex = targetIndexLocal[0];
            offsetsIndex = offsetsIndexLocal[0];
        }
        args.sourceBegin = sourceIndex;
        args.targetBegin = targetIndex;
    }

    private static void UConverter_toUnicode_ISO_2022_JP_OFFSETS_LOGIC(UConverterToUnicodeArgs args, int[] err) {
        byte cs;
        int[] mySourceIndexLocal;
        byte[] tempBuf = new byte[3];
        byte[] mySourceArray = args.sourceArray;
        int mySourceIndex = args.sourceBegin;
        char[] myTargetArray = args.targetArray;
        int myTargetIndex = args.targetBegin;
        int mySourceLimit = args.sourceLimit;
        int targetUniChar = 0;
        int mySourceChar = 0;
        UConverterDataISO2022 myData = (UConverterDataISO2022)args.converter.extraInfo;
        ISO2022State pToU2022State = myData.toU2022State;
        if (myData.key != 0) {
            mySourceIndexLocal = new int[]{mySourceIndex};
            UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)1, err);
            mySourceIndex = mySourceIndexLocal[0];
            if (ErrorCode.isFailure(err[0])) {
                args.targetBegin = myTargetIndex;
                args.sourceBegin = mySourceIndex;
                return;
            }
        } else if (args.converter.toULength == 1 && mySourceIndex < mySourceLimit && myTargetIndex < args.targetLimit) {
            mySourceChar = args.converter.toUBytesArray[0];
            args.converter.toULength = 0;
            cs = pToU2022State.cs[pToU2022State.g];
            tempBuf[0] = (byte)mySourceChar;
            char trailByte = (char)(mySourceArray[mySourceIndex++] & 0xFF);
            tempBuf[1] = (byte)trailByte;
            mySourceChar = mySourceChar << 8 | trailByte & 0xFF;
            targetUniChar = ((UConverterSharedData_MBCS)myData.myConverterArray[cs]).ucnv_MBCSSimpleGetNextUChar(myData.myConverterArray[cs], tempBuf, 0, 2, false);
            if (targetUniChar < 65534) {
                if (args.offsetsArray != null) {
                    args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                }
                myTargetArray[myTargetIndex++] = (char)targetUniChar;
            } else if (targetUniChar > 65535) {
                myTargetArray[myTargetIndex] = (char)(55296 + (char)((targetUniChar -= 65536) >> 10));
                if (args.offsetsArray != null) {
                    args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                }
                if (++myTargetIndex < args.targetLimit) {
                    myTargetArray[myTargetIndex] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                    if (args.offsetsArray != null) {
                        args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    ++myTargetIndex;
                } else {
                    byte by = args.converter.UCharErrorBufferLength;
                    args.converter.UCharErrorBufferLength = (byte)(by + 1);
                    args.converter.UCharErrorBufferArray[by] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                }
            } else {
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
            }
        }
        block13: while (mySourceIndex < mySourceLimit) {
            targetUniChar = 65535;
            if (myTargetIndex < args.targetLimit) {
                mySourceChar = mySourceArray[mySourceIndex++] & 0xFF;
                block0 : switch (mySourceChar) {
                    case 15: {
                        if (myData.version != 3) break;
                        pToU2022State.g = 0;
                        continue block13;
                    }
                    case 14: {
                        if (myData.version != 3) break;
                        pToU2022State.cs[1] = 8;
                        pToU2022State.g = 1;
                        continue block13;
                    }
                    case 27: {
                        mySourceIndexLocal = new int[]{--mySourceIndex};
                        UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)1, err);
                        mySourceIndex = mySourceIndexLocal[0];
                        if (!ErrorCode.isFailure(err[0])) continue block13;
                        args.targetBegin = myTargetIndex;
                        args.sourceBegin = mySourceIndex;
                        return;
                    }
                    case 10: 
                    case 13: {
                        if (pToU2022State.cs[0] != 0 && pToU2022State.cs[0] != 3) {
                            pToU2022State.cs[0] = 0;
                        }
                        pToU2022State.cs[2] = 0;
                        pToU2022State.g = 0;
                    }
                    default: {
                        cs = pToU2022State.cs[pToU2022State.g];
                        if ((mySourceChar & 0xFF) - 161 <= 62 && myData.version == 4 && !UConverterSharedData_ISO2022.IS_JP_DBCS(cs)) {
                            targetUniChar = mySourceChar + 65216;
                            if (pToU2022State.g < 2) break;
                            pToU2022State.g = pToU2022State.prevG;
                            break;
                        }
                        switch (cs) {
                            case 0: {
                                if (mySourceChar > 127) break block0;
                                targetUniChar = mySourceChar;
                                break block0;
                            }
                            case 1: {
                                if (mySourceChar <= 127) {
                                    targetUniChar = mySourceChar + 128;
                                }
                                pToU2022State.g = pToU2022State.prevG;
                                break block0;
                            }
                            case 2: {
                                if (mySourceChar <= 127) {
                                    targetUniChar = ((UConverterSharedData_MBCS)myData.myConverterArray[cs])._MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(mySourceChar + 128);
                                }
                                pToU2022State.g = pToU2022State.prevG;
                                break block0;
                            }
                            case 3: {
                                if (mySourceChar > 127) break block0;
                                targetUniChar = ((UConverterSharedData_MBCS)myData.myConverterArray[cs])._MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(mySourceChar);
                                break block0;
                            }
                            case 8: {
                                if ((mySourceChar - 33 & 0xFF) > 62) break block0;
                                targetUniChar = mySourceChar + 65344;
                                break block0;
                            }
                            default: {
                                if (mySourceIndex < mySourceLimit) {
                                    tempBuf[0] = (byte)mySourceChar;
                                    char trailByte = (char)(mySourceArray[mySourceIndex++] & 0xFF);
                                    tempBuf[1] = (byte)trailByte;
                                    mySourceChar = mySourceChar << 8 | trailByte & 0xFF;
                                    targetUniChar = ((UConverterSharedData_MBCS)myData.myConverterArray[cs]).ucnv_MBCSSimpleGetNextUChar(myData.myConverterArray[cs], tempBuf, 0, 2, false);
                                    break block0;
                                }
                                args.converter.toUBytesArray[0] = (byte)mySourceChar;
                                args.converter.toULength = 1;
                                break block13;
                            }
                        }
                    }
                }
                if (targetUniChar < 65534) {
                    if (args.offsetsArray != null) {
                        args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    myTargetArray[myTargetIndex++] = (char)targetUniChar;
                    continue;
                }
                if (targetUniChar > 65535) {
                    myTargetArray[myTargetIndex] = (char)(55296 + (char)((targetUniChar -= 65536) >> 10));
                    if (args.offsetsArray != null) {
                        args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    if (++myTargetIndex < args.targetLimit) {
                        myTargetArray[myTargetIndex] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                        if (args.offsetsArray != null) {
                            args.offsetsArray[myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                        }
                        ++myTargetIndex;
                        continue;
                    }
                    byte by = args.converter.UCharErrorBufferLength;
                    args.converter.UCharErrorBufferLength = (byte)(by + 1);
                    args.converter.UCharErrorBufferArray[by] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                    continue;
                }
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
                break;
            }
            err[0] = 15;
            break;
        }
        args.targetBegin = myTargetIndex;
        args.sourceBegin = mySourceIndex;
    }

    private static void UConverter_fromUnicode_ISO_2022_KR_OFFSETS_LOGIC_IBM(UConverterFromUnicodeArgs args, int[] err) {
        UConverter saveConv = args.converter;
        UConverterDataISO2022 myConverterData = (UConverterDataISO2022)saveConv.extraInfo;
        args.converter = myConverterData.currentConverter;
        myConverterData.currentConverter.fromUChar32 = saveConv.fromUChar32;
        ((UConverterSharedData_MBCS)args.converter.sharedData).ucnv_MBCSFromUnicodeWithOffsets(args, err);
        saveConv.fromUChar32 = myConverterData.currentConverter.fromUChar32;
        if (err[0] == 15) {
            if (myConverterData.currentConverter.charErrorBufferLength > 0) {
                System.arraycopy(myConverterData.currentConverter.charErrorBufferArray, myConverterData.currentConverter.charErrorBufferBegin, saveConv.charErrorBufferArray, saveConv.charErrorBufferBegin, myConverterData.currentConverter.charErrorBufferLength);
            }
            saveConv.charErrorBufferLength = myConverterData.currentConverter.charErrorBufferLength;
            myConverterData.currentConverter.charErrorBufferLength = 0;
        }
        args.converter = saveConv;
    }

    private static void UConverter_fromUnicode_ISO_2022_KR_OFFSETS_LOGIC(UConverterFromUnicodeArgs args, int[] err) {
        boolean isTargetByteDBCS;
        char[] sourceArray = args.sourceArray;
        int sourceIndex = args.sourceBegin;
        int sourceLimit = args.sourceLimit;
        byte[] targetArray = args.targetArray;
        int targetIndex = args.targetBegin;
        int targetLimit = args.targetLimit;
        int[] offsetsArray = args.offsetsArray;
        int offsetsIndex = args.offsetsBegin;
        int targetByteUnit = 0;
        int sourceChar = 0;
        int length = 0;
        UConverterDataISO2022 converterData = (UConverterDataISO2022)args.converter.extraInfo;
        if (converterData.version == 1) {
            UConverterSharedData_ISO2022.UConverter_fromUnicode_ISO_2022_KR_OFFSETS_LOGIC_IBM(args, err);
            return;
        }
        UConverterSharedData sharedData = converterData.currentConverter.sharedData;
        boolean useFallback = args.converter.useFallback;
        boolean oldIsTargetByteDBCS = isTargetByteDBCS = args.converter.fromUnicodeStatus != 0L;
        isTargetByteDBCS = args.converter.fromUnicodeStatus != 0L;
        sourceChar = args.converter.fromUChar32;
        if (sourceChar != 0 && targetIndex < targetLimit) {
            if (sourceIndex < sourceLimit) {
                char trail = sourceArray[sourceIndex];
                if (UConverterUTF16.U16_IS_TRAIL(trail)) {
                    ++sourceIndex;
                    sourceChar = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)sourceChar, trail);
                    err[0] = 10;
                } else {
                    err[0] = 12;
                }
            }
            args.converter.fromUChar32 = sourceChar;
            args.converter.fromUnicodeStatus = isTargetByteDBCS ? 1L : 0L;
        } else {
            while (sourceIndex < sourceLimit) {
                targetByteUnit = 65535;
                if (targetIndex < args.targetLimit) {
                    sourceChar = sourceArray[sourceIndex++];
                    long[] targetByteUnitLocal = new long[]{targetByteUnit};
                    int[] lengthLocal = new int[]{length};
                    UConverterSharedData_ISO2022.MBCS_FROM_UCHAR32_ISO2022(sharedData, sourceChar, targetByteUnitLocal, useFallback, lengthLocal, 1);
                    targetByteUnit = (int)targetByteUnitLocal[0];
                    length = lengthLocal[0];
                    if (length > 2 || length == 0 || (targetByteUnit & 0x8080) != 32896 && length == 2) {
                        targetByteUnit = 65535;
                    }
                    if (targetByteUnit != 65535) {
                        oldIsTargetByteDBCS = isTargetByteDBCS;
                        boolean bl = isTargetByteDBCS = targetByteUnit > 255;
                        if (oldIsTargetByteDBCS != isTargetByteDBCS) {
                            targetArray[targetIndex++] = isTargetByteDBCS ? 14 : 15;
                            if (offsetsArray != null) {
                                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                            }
                        }
                        if (targetByteUnit <= 255) {
                            if (targetIndex < targetLimit) {
                                targetArray[targetIndex++] = (byte)targetByteUnit;
                                if (offsetsArray == null) continue;
                                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                                continue;
                            }
                            byte by = args.converter.charErrorBufferLength;
                            args.converter.charErrorBufferLength = (byte)(by + 1);
                            args.converter.charErrorBufferArray[by] = (byte)targetByteUnit;
                            err[0] = 15;
                            continue;
                        }
                        if (targetIndex < targetLimit) {
                            targetArray[targetIndex++] = (byte)((targetByteUnit >> 8) - 128);
                            if (offsetsArray != null) {
                                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                            }
                            if (targetIndex < targetLimit) {
                                targetArray[targetIndex++] = (byte)(targetByteUnit - 128);
                                if (offsetsArray == null) continue;
                                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                                continue;
                            }
                            byte by = args.converter.charErrorBufferLength;
                            args.converter.charErrorBufferLength = (byte)(by + 1);
                            args.converter.charErrorBufferArray[by] = (byte)(targetByteUnit - 128);
                            err[0] = 15;
                            continue;
                        }
                        byte by = args.converter.charErrorBufferLength;
                        args.converter.charErrorBufferLength = (byte)(by + 1);
                        args.converter.charErrorBufferArray[by] = (byte)((targetByteUnit >> 8) - 128);
                        byte by2 = args.converter.charErrorBufferLength;
                        args.converter.charErrorBufferLength = (byte)(by2 + 1);
                        args.converter.charErrorBufferArray[by2] = (byte)(targetByteUnit - 128);
                        err[0] = 15;
                        continue;
                    }
                    if (UConverterUTF.U_IS_SURROGATE(sourceChar)) {
                        if (UConverterUTF.U_IS_SURROGATE_LEAD(sourceChar)) {
                            if (sourceIndex < sourceLimit) {
                                char trail = sourceArray[sourceIndex];
                                if (UConverterUTF16.U16_IS_TRAIL(trail)) {
                                    ++sourceIndex;
                                    sourceChar = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)sourceChar, trail);
                                    err[0] = 10;
                                } else {
                                    err[0] = 12;
                                }
                            } else {
                                err[0] = 0;
                            }
                        } else {
                            err[0] = 12;
                        }
                    } else {
                        err[0] = 10;
                    }
                    args.converter.fromUChar32 = sourceChar;
                    args.converter.fromUnicodeStatus = isTargetByteDBCS ? 1L : 0L;
                    break;
                }
                err[0] = 15;
                break;
            }
        }
        if (ErrorCode.isSuccess(err[0]) && isTargetByteDBCS && args.flush && sourceIndex >= sourceLimit && args.converter.fromUChar32 == 0) {
            isTargetByteDBCS = false;
            int sourceIndex2 = sourceIndex - args.sourceBegin;
            if (sourceIndex2 > 0) {
                if (UConverterUTF16.U16_IS_TRAIL(args.sourceArray[--sourceIndex2]) && (sourceIndex2 == 0 || UConverterUTF16.U16_IS_LEAD(args.sourceArray[sourceIndex + sourceIndex2 - 1]))) {
                    --sourceIndex2;
                }
            } else {
                sourceIndex2 = -1;
            }
            int[] targetIndexLocal = new int[]{targetIndex};
            int[] offsetsIndexLocal = new int[]{offsetsIndex};
            UConverter.ucnv_fromUWriteBytes(args.converter, SHIFT_IN_STR, 0, 1, targetArray, targetIndexLocal, targetLimit, offsetsArray, offsetsIndexLocal, sourceIndex2, err);
            targetIndex = targetIndexLocal[0];
            offsetsIndex = offsetsIndexLocal[0];
        }
        args.sourceBegin = sourceIndex;
        args.targetBegin = targetIndex;
        args.converter.fromUnicodeStatus = isTargetByteDBCS ? 1L : 0L;
    }

    private static UConverterToUnicodeArgs cloneReferences(UConverterToUnicodeArgs src) {
        UConverterToUnicodeArgs dst = new UConverterToUnicodeArgs();
        dst.converter = src.converter;
        dst.flush = src.flush;
        dst.sourceArray = src.sourceArray;
        dst.sourceBegin = src.sourceBegin;
        dst.sourceLimit = src.sourceLimit;
        dst.targetArray = src.targetArray;
        dst.targetBegin = src.targetBegin;
        dst.targetLimit = src.targetLimit;
        dst.offsetsArray = src.offsetsArray;
        dst.offsetsBegin = src.offsetsBegin;
        return dst;
    }

    private static void UConverter_toUnicode_ISO_2022_KR_OFFSETS_LOGIC_IBM(UConverterToUnicodeArgs args, int[] err) {
        int[] sourceBeginLocal;
        UConverterDataISO2022 myData = (UConverterDataISO2022)args.converter.extraInfo;
        UConverterToUnicodeArgs subArgs = UConverterSharedData_ISO2022.cloneReferences(args);
        int sourceStart = args.sourceBegin;
        if (myData.key != 0) {
            sourceBeginLocal = new int[]{args.sourceBegin};
            UConverterSharedData_ISO2022.changeState_2022(args.converter, args.sourceArray, sourceBeginLocal, args.sourceLimit, (byte)2, err);
            args.sourceBegin = sourceBeginLocal[0];
        }
        while (ErrorCode.isSuccess(err[0]) && args.sourceBegin < args.sourceLimit) {
            subArgs.sourceArray = args.sourceArray;
            subArgs.sourceBegin = args.sourceBegin;
            subArgs.sourceLimit = UConverterSharedData_ISO2022.getEndOfBuffer_2022(args.sourceArray, args.sourceBegin, args.sourceLimit, args.flush);
            if (subArgs.sourceBegin != subArgs.sourceLimit) {
                if (args.converter.toULength > 0) {
                    System.arraycopy(args.converter.toUBytesArray, args.converter.toUBytesBegin, subArgs.converter.toUBytesArray, subArgs.converter.toUBytesBegin, args.converter.toULength);
                }
                subArgs.converter.toULength = args.converter.toULength;
                ((UConverterSharedData_MBCS)subArgs.converter.sharedData).ucnv_MBCSToUnicodeWithOffsets(subArgs, err);
                if (args.offsetsArray != null && sourceStart != args.sourceBegin) {
                    int[] offsetsArray = args.offsetsArray;
                    int offsetsIndex = args.offsetsBegin;
                    char[] targetArray = args.targetArray;
                    int delta = args.sourceBegin - sourceStart;
                    for (int targetIndex = args.targetBegin; targetIndex < subArgs.targetBegin; ++targetIndex) {
                        if (offsetsArray[offsetsIndex] >= 0) {
                            offsetsIndex += delta;
                        }
                        ++offsetsIndex;
                    }
                }
                args.sourceBegin = subArgs.sourceBegin;
                args.targetBegin = subArgs.targetBegin;
                args.offsetsBegin = subArgs.offsetsBegin;
                if (subArgs.converter.toULength > 0) {
                    System.arraycopy(subArgs.converter.toUBytesArray, subArgs.converter.toUBytesBegin, args.converter.toUBytesArray, args.converter.toUBytesBegin, subArgs.converter.toULength);
                }
                args.converter.toULength = subArgs.converter.toULength;
                if (err[0] == 15) {
                    if (subArgs.converter.UCharErrorBufferLength > 0) {
                        System.arraycopy(subArgs.converter.UCharErrorBufferArray, subArgs.converter.UCharErrorBufferBegin, args.converter.UCharErrorBufferArray, args.converter.UCharErrorBufferBegin, subArgs.converter.UCharErrorBufferLength);
                    }
                    args.converter.UCharErrorBufferLength = subArgs.converter.UCharErrorBufferLength;
                    subArgs.converter.UCharErrorBufferLength = 0;
                }
            }
            if (ErrorCode.isFailure(err[0]) || args.sourceBegin == args.sourceLimit) {
                return;
            }
            sourceBeginLocal = new int[]{args.sourceBegin};
            UConverterSharedData_ISO2022.changeState_2022(args.converter, args.sourceArray, sourceBeginLocal, args.sourceLimit, (byte)2, err);
            args.sourceBegin = sourceBeginLocal[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void UConverter_toUnicode_ISO_2022_KR_OFFSETS_LOGIC(UConverterToUnicodeArgs args, int[] err) {
        int[] mySourceIndexLocal;
        byte[] tempBuf = new byte[2];
        byte[] mySourceArray = args.sourceArray;
        int mySourceIndex = args.sourceBegin;
        char[] myTargetArray = args.targetArray;
        int myTargetIndex = args.targetBegin;
        int mySourceLimit = args.sourceLimit;
        int targetUniChar = 0;
        char mySourceChar = '\u0000';
        UConverterDataISO2022 myData = (UConverterDataISO2022)args.converter.extraInfo;
        if (myData.version == 1) {
            UConverterSharedData_ISO2022.UConverter_toUnicode_ISO_2022_KR_OFFSETS_LOGIC_IBM(args, err);
            return;
        }
        UConverterSharedData sharedData = myData.currentConverter.sharedData;
        boolean useFallback = args.converter.useFallback;
        if (myData.key != 0) {
            mySourceIndexLocal = new int[]{mySourceIndex};
            UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)2, err);
            mySourceIndex = mySourceIndexLocal[0];
            if (ErrorCode.isFailure(err[0])) {
                args.targetBegin = myTargetIndex;
                args.sourceBegin = mySourceIndex;
                return;
            }
        } else if (args.converter.toULength == 1 && mySourceIndex < mySourceLimit && myTargetIndex < args.targetLimit) {
            mySourceChar = (char)(args.converter.toUBytesArray[0] & 0xFF);
            args.converter.toULength = 0;
            byte trailByte = mySourceArray[mySourceIndex++];
            tempBuf[0] = (byte)(mySourceChar + 128);
            tempBuf[1] = (byte)(trailByte + 128);
            targetUniChar = ((mySourceChar = (char)(mySourceChar << 8 | trailByte & 0xFF)) & 0x8080) == 0 ? ((UConverterSharedData_MBCS)sharedData).ucnv_MBCSSimpleGetNextUChar(sharedData, tempBuf, 0, 2, useFallback) : 65535;
            if (targetUniChar < 65534) {
                if (args.offsetsArray != null) {
                    args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= '\u00ff' ? 1 : 2);
                }
                myTargetArray[myTargetIndex++] = (char)targetUniChar;
            } else {
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
            }
        }
        while (mySourceIndex < mySourceLimit) {
            if (myTargetIndex < args.targetLimit) {
                block18: {
                    if ((mySourceChar = (char)(mySourceArray[mySourceIndex++] & 0xFF)) == '\u000f') {
                        myData.toU2022State.g = 0;
                        continue;
                    }
                    if (mySourceChar == '\u000e') {
                        myData.toU2022State.g = 1;
                        continue;
                    }
                    if (mySourceChar == '\u001b') {
                        mySourceIndexLocal = new int[]{--mySourceIndex};
                        UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)2, err);
                        mySourceIndex = mySourceIndexLocal[0];
                        if (!ErrorCode.isFailure(err[0])) continue;
                        args.targetBegin = myTargetIndex;
                        args.sourceBegin = mySourceIndex;
                        return;
                    }
                    if (myData.toU2022State.g == 1) {
                        if (mySourceIndex < mySourceLimit) {
                            byte trailByte = mySourceArray[mySourceIndex++];
                            tempBuf[0] = (byte)(mySourceChar + 128);
                            tempBuf[1] = (byte)(trailByte + 128);
                            targetUniChar = ((mySourceChar = (char)(mySourceChar << 8 | trailByte & 0xFF)) & 0x8080) == 0 ? ((UConverterSharedData_MBCS)sharedData).ucnv_MBCSSimpleGetNextUChar(sharedData, tempBuf, 0, 2, useFallback) : 65535;
                            break block18;
                        } else {
                            args.converter.toUBytesArray[0] = (byte)(mySourceChar & 0xFF);
                            args.converter.toULength = 1;
                            break;
                        }
                    }
                    targetUniChar = ((UConverterSharedData_MBCS)sharedData).ucnv_MBCSSimpleGetNextUChar(sharedData, mySourceArray, mySourceIndex - 1, 1, useFallback);
                }
                if (targetUniChar < 65534) {
                    if (args.offsetsArray != null) {
                        args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= '\u00ff' ? 1 : 2);
                    }
                    myTargetArray[myTargetIndex++] = (char)targetUniChar;
                    continue;
                }
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
                break;
            }
            err[0] = 15;
            break;
        }
        args.targetBegin = myTargetIndex;
        args.sourceBegin = mySourceIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void UConverter_fromUnicode_ISO_2022_CN_OFFSETS_LOGIC(UConverterFromUnicodeArgs args, int[] err) {
        int sourceIndex2;
        byte[] targetArray = args.targetArray;
        int targetIndex = args.targetBegin;
        int targetLimit = args.targetLimit;
        char[] sourceArray = args.sourceArray;
        int sourceIndex = args.sourceBegin;
        int sourceLimit = args.sourceLimit;
        int[] offsetsArray = args.offsetsArray;
        int offsetsIndex = args.offsetsBegin;
        byte[] buffer = new byte[8];
        byte[] choices = new byte[3];
        int targetValue = 0;
        boolean goto_getTrail = false;
        UConverterDataISO2022 converterData = (UConverterDataISO2022)args.converter.extraInfo;
        ISO2022State pFromU2022State = converterData.fromU2022State;
        boolean useFallback = args.converter.useFallback;
        int choiceCount = 0;
        int sourceChar = args.converter.fromUChar32;
        if (sourceChar != 0 && targetIndex < targetLimit) {
            goto_getTrail = true;
        }
        while (goto_getTrail || sourceIndex < sourceLimit) {
            int len;
            block44: {
                byte cs;
                byte g;
                block45: {
                    block42: {
                        block43: {
                            block41: {
                                if (!goto_getTrail && targetIndex >= targetLimit) break block42;
                                if (!goto_getTrail) {
                                    sourceChar = sourceArray[sourceIndex++];
                                }
                                if (goto_getTrail || UConverterUTF.U_IS_SURROGATE(sourceChar)) {
                                    if (goto_getTrail || UConverterUTF.U_IS_SURROGATE_LEAD(sourceChar)) {
                                        goto_getTrail = false;
                                        if (sourceIndex < sourceLimit) {
                                            char trail = sourceArray[sourceIndex];
                                            if (UConverterUTF16.U16_IS_TRAIL(trail)) {
                                                ++sourceIndex;
                                                sourceChar = UConverterUTF16.U16_GET_SUPPLEMENTARY((char)sourceChar, trail);
                                                args.converter.fromUChar32 = 0;
                                                break block41;
                                            } else {
                                                err[0] = 12;
                                                args.converter.fromUChar32 = sourceChar;
                                                break;
                                            }
                                        }
                                        args.converter.fromUChar32 = sourceChar;
                                        break;
                                    }
                                    err[0] = 12;
                                    args.converter.fromUChar32 = sourceChar;
                                    break;
                                }
                            }
                            if (sourceChar > 127) break block43;
                            if (pFromU2022State.g == 0) {
                                buffer[0] = (byte)sourceChar;
                                len = 1;
                            } else {
                                buffer[0] = 15;
                                buffer[1] = (byte)sourceChar;
                                len = 2;
                                pFromU2022State.g = 0;
                                choiceCount = 0;
                            }
                            if (sourceChar == 13 || sourceChar == 10) {
                                pFromU2022State.reset();
                                choiceCount = 0;
                            }
                            break block44;
                        }
                        if (choiceCount == 0) {
                            choices[0] = pFromU2022State.cs[1];
                            if (choices[0] == 0) {
                                choices[0] = 1;
                            }
                            if (converterData.version == 0) {
                                choices[1] = choices[0] == 1 ? 33 : 1;
                                choiceCount = 2;
                            } else {
                                switch (choices[0]) {
                                    case 1: {
                                        choices[1] = 33;
                                        choices[2] = 2;
                                        break;
                                    }
                                    case 2: {
                                        choices[1] = 1;
                                        choices[2] = 33;
                                        break;
                                    }
                                    default: {
                                        choices[1] = 1;
                                        choices[2] = 2;
                                    }
                                }
                                choiceCount = 3;
                            }
                        }
                        g = 0;
                        cs = 0;
                        len = 0;
                        break block45;
                    }
                    err[0] = 15;
                    break;
                }
                for (int i = 0; i < choiceCount && len == 0; ++i) {
                    int[] lenLocal;
                    long[] targetValueLocal;
                    cs = choices[i];
                    if (cs <= 0) continue;
                    if (cs > 32) {
                        UConverterSharedData cnv = converterData.myConverterArray[3];
                        targetValueLocal = new long[]{targetValue};
                        lenLocal = new int[]{len};
                        UConverterSharedData_ISO2022.MBCS_FROM_UCHAR32_ISO2022(cnv, sourceChar, targetValueLocal, useFallback, lenLocal, 2);
                        targetValue = (int)targetValueLocal[0];
                        len = lenLocal[0];
                        if (len != 3) continue;
                        cs = (byte)(32 + (targetValue >> 16) - 128);
                        len = 2;
                        if (cs == 33) {
                            g = 1;
                            continue;
                        }
                        if (cs == 34) {
                            g = 2;
                            continue;
                        }
                        if (converterData.version == 1) {
                            g = 3;
                            continue;
                        }
                        len = 0;
                        continue;
                    }
                    UConverterSharedData cnv = converterData.myConverterArray[cs];
                    targetValueLocal = new long[]{targetValue};
                    lenLocal = new int[]{len};
                    UConverterSharedData_ISO2022.MBCS_FROM_UCHAR32_ISO2022(cnv, sourceChar, targetValueLocal, useFallback, lenLocal, 1);
                    targetValue = (int)targetValueLocal[0];
                    len = lenLocal[0];
                    g = 1;
                }
                if (len > 0) {
                    len = 0;
                    if (cs != pFromU2022State.cs[g]) {
                        if (cs < 3) {
                            System.arraycopy(escSeqCharsCN[cs], 0, buffer, 0, 4);
                        } else {
                            System.arraycopy(escSeqCharsCN[3 + (cs - 33)], 0, buffer, 0, 4);
                        }
                        len = 4;
                        pFromU2022State.cs[g] = cs;
                        if (g == 1) {
                            choiceCount = 0;
                        }
                    }
                    if (g != pFromU2022State.g) {
                        switch (g) {
                            case 1: {
                                buffer[len++] = 14;
                                pFromU2022State.g = 1;
                                break;
                            }
                            case 2: {
                                buffer[len++] = 27;
                                buffer[len++] = 78;
                                break;
                            }
                            default: {
                                buffer[len++] = 27;
                                buffer[len++] = 79;
                            }
                        }
                    }
                    buffer[len++] = (byte)(targetValue >> 8);
                    buffer[len++] = (byte)targetValue;
                } else {
                    err[0] = 10;
                    args.converter.fromUChar32 = sourceChar;
                    break;
                }
            }
            if (len == 1) {
                targetArray[targetIndex++] = buffer[0];
                if (offsetsArray == null) continue;
                offsetsArray[offsetsIndex++] = sourceIndex - args.sourceBegin - 1;
                continue;
            }
            if (len == 2 && targetIndex + 2 <= targetLimit) {
                targetArray[targetIndex++] = buffer[0];
                targetArray[targetIndex++] = buffer[1];
                if (offsetsArray == null) continue;
                sourceIndex2 = sourceIndex - args.sourceBegin - UConverterUTF16.U16_LENGTH(sourceChar);
                offsetsArray[offsetsIndex++] = sourceIndex2;
                offsetsArray[offsetsIndex++] = sourceIndex2;
                continue;
            }
            int[] targetIndexLocal = new int[]{targetIndex};
            int[] offsetsIndexLocal = new int[]{offsetsIndex};
            UConverter.ucnv_fromUWriteBytes(args.converter, buffer, 0, len, targetArray, targetIndexLocal, targetLimit, offsetsArray, offsetsIndexLocal, sourceIndex - args.sourceBegin - UConverterUTF16.U16_LENGTH(sourceChar), err);
            targetIndex = targetIndexLocal[0];
            offsetsIndex = offsetsIndexLocal[0];
            if (!ErrorCode.isFailure(err[0])) continue;
        }
        if (ErrorCode.isSuccess(err[0]) && pFromU2022State.g != 0 && args.flush && sourceIndex >= sourceLimit && args.converter.fromUChar32 == 0) {
            pFromU2022State.g = 0;
            sourceIndex2 = sourceIndex - args.sourceBegin;
            if (sourceIndex2 > 0) {
                if (UConverterUTF16.U16_IS_TRAIL(args.sourceArray[args.sourceBegin + --sourceIndex2]) && (sourceIndex2 == 0 || UConverterUTF16.U16_IS_LEAD(args.sourceArray[args.sourceBegin + sourceIndex2 - 1]))) {
                    --sourceIndex2;
                }
            } else {
                sourceIndex2 = -1;
            }
            int[] targetIndexLocal = new int[]{targetIndex};
            int[] offsetsIndexLocal = new int[]{offsetsIndex};
            UConverter.ucnv_fromUWriteBytes(args.converter, SHIFT_IN_STR, 0, 1, targetArray, targetIndexLocal, targetLimit, offsetsArray, offsetsIndexLocal, sourceIndex2, err);
            targetIndex = targetIndexLocal[0];
            offsetsIndex = offsetsIndexLocal[0];
        }
        args.sourceBegin = sourceIndex;
        args.targetBegin = targetIndex;
    }

    private static void UConverter_toUnicode_ISO_2022_CN_OFFSETS_LOGIC(UConverterToUnicodeArgs args, int[] err) {
        int tempBufLen;
        UConverterSharedData cnv;
        byte trailByte;
        byte tempState;
        int[] mySourceIndexLocal;
        byte[] tempBuf = new byte[3];
        byte[] mySourceArray = args.sourceArray;
        int mySourceIndex = args.sourceBegin;
        char[] myTargetArray = args.targetArray;
        int myTargetIndex = args.targetBegin;
        int mySourceLimit = args.sourceLimit;
        int targetUniChar = 0;
        int mySourceChar = 0;
        UConverterDataISO2022 myData = (UConverterDataISO2022)args.converter.extraInfo;
        ISO2022State pToU2022State = myData.toU2022State;
        if (myData.key != 0) {
            mySourceIndexLocal = new int[]{mySourceIndex};
            UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)3, err);
            mySourceIndex = mySourceIndexLocal[0];
            if (ErrorCode.isFailure(err[0])) {
                args.targetBegin = myTargetIndex;
                args.sourceBegin = mySourceIndex;
                return;
            }
        } else if (args.converter.toULength == 1 && mySourceIndex < mySourceLimit && myTargetIndex < args.targetLimit) {
            mySourceChar = args.converter.toUBytesArray[0];
            args.converter.toULength = 0;
            tempState = pToU2022State.cs[pToU2022State.g];
            trailByte = mySourceArray[mySourceIndex++];
            if (tempState > 32) {
                cnv = myData.myConverterArray[3];
                tempBuf[0] = (byte)(128 + (tempState - 32));
                tempBuf[1] = (byte)mySourceChar;
                tempBuf[2] = trailByte;
                tempBufLen = 3;
            } else {
                cnv = myData.myConverterArray[tempState];
                tempBuf[0] = (byte)mySourceChar;
                tempBuf[1] = trailByte;
                tempBufLen = 2;
            }
            mySourceChar = mySourceChar << 8 | trailByte & 0xFF;
            if (pToU2022State.g >= 2) {
                pToU2022State.g = pToU2022State.prevG;
            }
            if ((targetUniChar = ((UConverterSharedData_MBCS)cnv).ucnv_MBCSSimpleGetNextUChar(cnv, tempBuf, 0, tempBufLen, false)) < 65534) {
                if (args.offsetsArray != null) {
                    args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                }
                myTargetArray[myTargetIndex++] = (char)targetUniChar;
            } else if (targetUniChar > 65535) {
                myTargetArray[myTargetIndex] = (char)(55296 + (char)((targetUniChar -= 65536) >> 10));
                if (args.offsetsArray != null) {
                    args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                }
                if (++myTargetIndex < args.targetLimit) {
                    myTargetArray[myTargetIndex] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                    if (args.offsetsArray != null) {
                        args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    ++myTargetIndex;
                } else {
                    byte by = args.converter.UCharErrorBufferLength;
                    args.converter.UCharErrorBufferLength = (byte)(by + 1);
                    args.converter.UCharErrorBufferArray[by] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                }
            } else {
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
            }
        }
        block6: while (mySourceIndex < mySourceLimit) {
            targetUniChar = 65535;
            if (myTargetIndex < args.targetLimit) {
                mySourceChar = mySourceArray[mySourceIndex++];
                switch (mySourceChar) {
                    case 15: {
                        pToU2022State.g = 0;
                        continue block6;
                    }
                    case 14: {
                        if (pToU2022State.cs[1] == 0) break;
                        pToU2022State.g = 1;
                        continue block6;
                    }
                    case 27: {
                        mySourceIndexLocal = new int[]{--mySourceIndex};
                        UConverterSharedData_ISO2022.changeState_2022(args.converter, mySourceArray, mySourceIndexLocal, mySourceLimit, (byte)3, err);
                        mySourceIndex = mySourceIndexLocal[0];
                        if (!ErrorCode.isFailure(err[0])) continue block6;
                        args.targetBegin = myTargetIndex;
                        args.sourceBegin = mySourceIndex;
                        return;
                    }
                    case 10: 
                    case 13: {
                        pToU2022State.reset();
                    }
                    default: {
                        if (pToU2022State.g != 0) {
                            if (mySourceIndex < mySourceLimit) {
                                trailByte = mySourceArray[mySourceIndex++];
                                tempState = pToU2022State.cs[pToU2022State.g];
                                if (tempState > 32) {
                                    cnv = myData.myConverterArray[3];
                                    tempBuf[0] = (byte)(128 + (tempState - 32));
                                    tempBuf[1] = (byte)mySourceChar;
                                    tempBuf[2] = trailByte;
                                    tempBufLen = 3;
                                } else {
                                    cnv = myData.myConverterArray[tempState];
                                    tempBuf[0] = (byte)mySourceChar;
                                    tempBuf[1] = trailByte;
                                    tempBufLen = 2;
                                }
                                mySourceChar = mySourceChar << 8 | trailByte & 0xFF;
                                if (pToU2022State.g >= 2) {
                                    pToU2022State.g = pToU2022State.prevG;
                                }
                                targetUniChar = ((UConverterSharedData_MBCS)cnv).ucnv_MBCSSimpleGetNextUChar(cnv, tempBuf, 0, tempBufLen, false);
                                break;
                            }
                            args.converter.toUBytesArray[0] = (byte)(mySourceChar & 0xFF);
                            args.converter.toULength = 1;
                            break block6;
                        }
                        if (mySourceChar > 127) break;
                        targetUniChar = (char)mySourceChar;
                    }
                }
                if (targetUniChar < 65534) {
                    if (args.offsetsArray != null) {
                        args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    myTargetArray[myTargetIndex++] = (char)targetUniChar;
                    continue;
                }
                if (targetUniChar > 65535) {
                    myTargetArray[myTargetIndex] = (char)(55296 + (char)((targetUniChar -= 65536) >> 10));
                    if (args.offsetsArray != null) {
                        args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                    }
                    if (++myTargetIndex < args.targetLimit) {
                        myTargetArray[myTargetIndex] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                        if (args.offsetsArray != null) {
                            args.offsetsArray[args.offsetsBegin + myTargetIndex - args.targetBegin] = mySourceIndex - args.sourceBegin - (mySourceChar <= 255 ? 1 : 2);
                        }
                        ++myTargetIndex;
                        continue;
                    }
                    byte by = args.converter.UCharErrorBufferLength;
                    args.converter.UCharErrorBufferLength = (byte)(by + 1);
                    args.converter.UCharErrorBufferArray[by] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                    continue;
                }
                UConverterSharedData_ISO2022.toUnicodeCallback(args.converter, mySourceChar, targetUniChar, err);
                break;
            }
            err[0] = 15;
            break;
        }
        args.targetBegin = myTargetIndex;
        args.sourceBegin = mySourceIndex;
    }

    static {
        $assertionsDisabled = !UConverterSharedData_ISO2022.class.desiredAssertionStatus();
        SHIFT_IN_STR = new byte[]{15};
        SHIFT_OUT_STR = new byte[]{14};
        jpCharsetMasks = new short[]{(short)(UConverterSharedData_ISO2022.CSM((byte)0) | UConverterSharedData_ISO2022.CSM((byte)3) | UConverterSharedData_ISO2022.CSM((byte)4) | UConverterSharedData_ISO2022.CSM((byte)8)), (short)(UConverterSharedData_ISO2022.CSM((byte)0) | UConverterSharedData_ISO2022.CSM((byte)3) | UConverterSharedData_ISO2022.CSM((byte)4) | UConverterSharedData_ISO2022.CSM((byte)8) | UConverterSharedData_ISO2022.CSM((byte)5)), (short)(UConverterSharedData_ISO2022.CSM((byte)0) | UConverterSharedData_ISO2022.CSM((byte)3) | UConverterSharedData_ISO2022.CSM((byte)4) | UConverterSharedData_ISO2022.CSM((byte)8) | UConverterSharedData_ISO2022.CSM((byte)5) | UConverterSharedData_ISO2022.CSM((byte)6) | UConverterSharedData_ISO2022.CSM((byte)7) | UConverterSharedData_ISO2022.CSM((byte)1) | UConverterSharedData_ISO2022.CSM((byte)2)), (short)(UConverterSharedData_ISO2022.CSM((byte)0) | UConverterSharedData_ISO2022.CSM((byte)3) | UConverterSharedData_ISO2022.CSM((byte)4) | UConverterSharedData_ISO2022.CSM((byte)8) | UConverterSharedData_ISO2022.CSM((byte)5) | UConverterSharedData_ISO2022.CSM((byte)6) | UConverterSharedData_ISO2022.CSM((byte)7) | UConverterSharedData_ISO2022.CSM((byte)1) | UConverterSharedData_ISO2022.CSM((byte)2)), (short)(UConverterSharedData_ISO2022.CSM((byte)0) | UConverterSharedData_ISO2022.CSM((byte)3) | UConverterSharedData_ISO2022.CSM((byte)4) | UConverterSharedData_ISO2022.CSM((byte)8) | UConverterSharedData_ISO2022.CSM((byte)5) | UConverterSharedData_ISO2022.CSM((byte)6) | UConverterSharedData_ISO2022.CSM((byte)7) | UConverterSharedData_ISO2022.CSM((byte)1) | UConverterSharedData_ISO2022.CSM((byte)2))};
        normalize_esq_chars_2022 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 29, 0, 2, 24, 26, 27, 0, 3, 23, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 28, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        escSeqStateTable_Key_2022 = new int[]{1, 34, 36, 39, 55, 57, 60, 61, 1093, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1109, 1154, 1157, 1160, 1161, 1176, 1178, 1179, 1254, 1257, 1768, 1773, 1957, 35105, 36933, 36936, 36937, 36938, 36939, 36940, 36942, 36943, 36944, 36945, 36946, 36947, 36948, 37640, 37642, 37644, 37646, 37711, 37744, 37745, 37746, 37747, 37748, 40133, 40136, 40138, 40139, 40140, 40141, 1123363, 35947624, 35947625, 35947626, 35947627, 35947629, 35947630, 35947631, 35947635, 35947636, 35947638};
        escSeqStateTable_Value_2022 = new byte[]{0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        nextStateToUnicodeJP = new byte[]{-1, -1, -1, -1, -1, 16, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 3, 8, 3, -1, -1, -1, 4, 6, 4, -1, -1, -1, -1, -1, 1, 2, 4, -1, -1, -1, -1, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        nextStateToUnicodeCN = new byte[]{-1, -1, -1, -1, -1, 16, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 2, 33, 34, 35, 36, 37, 38, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        jpCharsetPref = new byte[]{0, 3, 1, 2, 4, 5, 6, 7, 8};
        escSeqChars = new byte[][]{{27, 40, 66}, {27, 46, 65}, {27, 46, 70}, {27, 40, 74}, {27, 36, 66}, {27, 36, 40, 68}, {27, 36, 65}, {27, 36, 40, 67}, {27, 40, 73}};
        escSeqCharsLen = new int[]{3, 3, 3, 3, 3, 4, 3, 4, 3};
        GB_2312_80_STR = new byte[]{27, 36, 41, 65};
        ISO_IR_165_STR = new byte[]{27, 36, 41, 69};
        CNS_11643_1992_Plane_1_STR = new byte[]{27, 36, 41, 71};
        CNS_11643_1992_Plane_2_STR = new byte[]{27, 36, 42, 72};
        CNS_11643_1992_Plane_3_STR = new byte[]{27, 36, 43, 73};
        CNS_11643_1992_Plane_4_STR = new byte[]{27, 36, 43, 74};
        CNS_11643_1992_Plane_5_STR = new byte[]{27, 36, 43, 75};
        CNS_11643_1992_Plane_6_STR = new byte[]{27, 36, 43, 76};
        CNS_11643_1992_Plane_7_STR = new byte[]{27, 36, 43, 77};
        escSeqCharsCN = new byte[][]{SHIFT_IN_STR, GB_2312_80_STR, ISO_IR_165_STR, CNS_11643_1992_Plane_1_STR, CNS_11643_1992_Plane_2_STR, CNS_11643_1992_Plane_3_STR, CNS_11643_1992_Plane_4_STR, CNS_11643_1992_Plane_5_STR, CNS_11643_1992_Plane_6_STR, CNS_11643_1992_Plane_7_STR};
        _ISO2022StaticData = new UConverterStaticData(100, "ISO_2022", 2022, 0, 10, 1, 3, new byte[]{26, 0, 0, 0}, 1, 0, 0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        _ISO2022Data = new UConverterSharedData_ISO2022(100, -1, _ISO2022StaticData, false, 0L);
        _ISO2022JPStaticData = new UConverterStaticData(100, "ISO_2022_JP", 0, 0, 10, 1, 6, new byte[]{26, 0, 0, 0}, 1, 0, 0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        _ISO2022JPData = new UConverterSharedData_ISO2022(100, -1, _ISO2022JPStaticData, false, 0L);
        _ISO2022KRStaticData = new UConverterStaticData(100, "ISO_2022_KR", 0, 0, 10, 1, 3, new byte[]{26, 0, 0, 0}, 1, 0, 0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        _ISO2022KRData = new UConverterSharedData_ISO2022(100, -1, _ISO2022KRStaticData, false, 0L);
        _ISO2022CNStaticData = new UConverterStaticData(100, "ISO_2022_CN", 0, 0, 10, 2, 8, new byte[]{26, 0, 0, 0}, 1, 0, 0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        _ISO2022CNData = new UConverterSharedData_ISO2022(100, -1, _ISO2022CNStaticData, false, 0L);
    }

    protected static final class UConverterDataISO2022 {
        public UConverter currentConverter;
        public byte currentType;
        public ISO2022State toU2022State;
        public ISO2022State fromU2022State;
        public UConverterSharedData[] myConverterArray;
        public int key;
        public int version;
        public String locale;
        public String name;

        public UConverterDataISO2022() {
            this.reset();
        }

        public void reset() {
            this.currentConverter = null;
            this.currentType = 0;
            this.toU2022State = new ISO2022State();
            this.fromU2022State = new ISO2022State();
            this.myConverterArray = new UConverterSharedData[10];
            this.key = 0;
            this.version = 0;
            this.locale = "";
            this.name = "";
        }
    }

    protected static final class ISO2022State {
        public byte[] cs;
        public byte g;
        public byte prevG;

        public ISO2022State() {
            this.reset();
        }

        public void reset() {
            this.cs = new byte[]{0, 0, 0, 0};
            this.g = 0;
            this.prevG = 0;
        }
    }
}

