/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUBinary;
import com.adobe.agl.impl.ICUDebug;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class NormalizerDataReader
implements ICUBinary.Authenticate {
    private static final boolean debug = ICUDebug.enabled("NormalizerDataReader");
    private DataInputStream dataInputStream;
    private byte[] unicodeVersion;
    private static final byte[] DATA_FORMAT_ID = new byte[]{78, 111, 114, 109};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{2, 2, 5, 2};

    protected NormalizerDataReader(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("Bytes in inputStream " + inputStream.available());
        }
        this.unicodeVersion = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        if (debug) {
            System.out.println("Bytes left in inputStream " + inputStream.available());
        }
        this.dataInputStream = new DataInputStream(inputStream);
        if (debug) {
            System.out.println("Bytes left in dataInputStream " + this.dataInputStream.available());
        }
    }

    protected int[] readIndexes(int length) throws IOException {
        int[] indexes = new int[length];
        for (int i = 0; i < length; ++i) {
            indexes[i] = this.dataInputStream.readInt();
        }
        return indexes;
    }

    protected void read(byte[] normBytes, byte[] fcdBytes, byte[] auxBytes, char[] extraData, char[] combiningTable, Object[] canonStartSets) throws IOException {
        int i;
        this.dataInputStream.read(normBytes);
        for (i = 0; i < extraData.length; ++i) {
            extraData[i] = this.dataInputStream.readChar();
        }
        for (i = 0; i < combiningTable.length; ++i) {
            combiningTable[i] = this.dataInputStream.readChar();
        }
        this.dataInputStream.read(fcdBytes);
        this.dataInputStream.read(auxBytes);
        int[] canonStartSetsIndexes = new int[32];
        for (int i2 = 0; i2 < canonStartSetsIndexes.length; ++i2) {
            canonStartSetsIndexes[i2] = this.dataInputStream.readChar();
        }
        char[] startSets = new char[canonStartSetsIndexes[0] - 32];
        for (int i3 = 0; i3 < startSets.length; ++i3) {
            startSets[i3] = this.dataInputStream.readChar();
        }
        char[] bmpTable = new char[canonStartSetsIndexes[1]];
        for (int i4 = 0; i4 < bmpTable.length; ++i4) {
            bmpTable[i4] = this.dataInputStream.readChar();
        }
        char[] suppTable = new char[canonStartSetsIndexes[2]];
        for (int i5 = 0; i5 < suppTable.length; ++i5) {
            suppTable[i5] = this.dataInputStream.readChar();
        }
        canonStartSets[0] = canonStartSetsIndexes;
        canonStartSets[1] = startSets;
        canonStartSets[2] = bmpTable;
        canonStartSets[3] = suppTable;
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION[0] && version[2] == DATA_FORMAT_VERSION[2] && version[3] == DATA_FORMAT_VERSION[3];
    }

    public byte[] getUnicodeVersion() {
        return this.unicodeVersion;
    }
}

