/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetDecoderICU;
import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.NativeConverter;
import com.adobe.agl.converters.UConverter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;

public final class CharsetICU
extends Charset {
    protected CharsetICU(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
        if (canonicalName.length() == 0) {
            throw new IllegalCharsetNameException(canonicalName);
        }
    }

    public CharsetDecoder newDecoder() {
        UConverter[] converterHandle = new UConverter[1];
        int ec = NativeConverter.openConverter(converterHandle, this.toString());
        if (ErrorCode.isSuccess(ec)) {
            return new CharsetDecoderICU(this, converterHandle[0]);
        }
        throw ErrorCode.getException(ec);
    }

    public CharsetEncoder newEncoder() {
        UConverter[] converterHandle = new UConverter[1];
        int ec = NativeConverter.openConverter(converterHandle, this.toString());
        if (ErrorCode.isSuccess(ec)) {
            return new CharsetEncoderICU(this, converterHandle[0]);
        }
        throw ErrorCode.getException(ec);
    }

    public boolean contains(Charset cs) {
        return false;
    }
}

