/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontImpl
implements Font {
    static final long serialVersionUID = 1L;

    @Override
    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getUnitsPerEmX();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getUnitsPerEmY();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getLineMetrics();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public Rect getCoolTypeGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeGlyphBBox(n);
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeLineMetrics();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws FontLoadingException, InvalidFontException, UnsupportedFontException {
        try {
            return this.getFontData().getCoolTypeScript();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeUnderlineMetrics();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeIdeoEmBox();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public boolean hasCoolTypeProportionalRoman() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().hasCoolTypeProportionalRoman();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public Rect getCoolTypeIcfBox() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().getCoolTypeIcfBox();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        try {
            return this.getFontData().isSymbolic();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public boolean canEmbedForEditting() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            Permission permission = this.getFontData().getEmbeddingPermission(this.wasEmbedded());
            return permission != Permission.RESTRICTED && permission != Permission.PREVIEW_AND_PRINT;
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public boolean canEmbedForPrintAndPreview() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.getFontData().getEmbeddingPermission(this.wasEmbedded()) != Permission.RESTRICTED;
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public Subset createSubset() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.getFontData().createSubset();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    public FontData getFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData();
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public SWFFont4Description getSWFFont4Description() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getSWFFont4Description(this.wasEmbedded());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public SWFFontDescription getSWFFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getSWFFontDescription(this.wasEmbedded());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public PDFFontDescription getPDFFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getPDFFontDescription(this);
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public XDCFontDescription getXDCFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return this.retrieveFontData().getXDCFontDescription(this);
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (PostscriptFontDescription[])this.getFontDescription(PostscriptFontDescription[].class.getSimpleName());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public CSS20FontDescription[] getCSS20FontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CSS20FontDescription[])this.getFontDescription(CSS20FontDescription[].class.getSimpleName());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public CSS20FontDescription getPreferredCSS20FontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CSS20FontDescription)this.getFontDescription(CSS20FontDescription.class.getSimpleName());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getFXGFontDescription(null, null);
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getFXGFontDescription(platform, null);
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            FXGFontDescription[] fXGFontDescriptionArray = (FXGFontDescription[])this.getFontDescription(FXGFontDescription[].class.getSimpleName());
            if (platform == null && uLocale == null) {
                return fXGFontDescriptionArray;
            }
            int n = 0;
            for (int i = 0; i < fXGFontDescriptionArray.length; ++i) {
                if (platform != null && platform != fXGFontDescriptionArray[i].getPlatform() || uLocale != null && uLocale != fXGFontDescriptionArray[i].getLocale()) continue;
                ++n;
            }
            FXGFontDescription[] fXGFontDescriptionArray2 = new FXGFontDescription[n];
            n = 0;
            for (int i = 0; i < fXGFontDescriptionArray.length; ++i) {
                if (platform != null && platform != fXGFontDescriptionArray[i].getPlatform() || uLocale != null && uLocale != fXGFontDescriptionArray[i].getLocale()) continue;
                fXGFontDescriptionArray2[n++] = fXGFontDescriptionArray[i];
            }
            return fXGFontDescriptionArray2;
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getPlatformFontDescription(null, null);
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return this.getPlatformFontDescription(platform, null);
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            PlatformFontDescription[] platformFontDescriptionArray = (PlatformFontDescription[])this.getFontDescription(PlatformFontDescription[].class.getSimpleName());
            if (platform == null && uLocale == null) {
                return platformFontDescriptionArray;
            }
            int n = 0;
            for (int i = 0; i < platformFontDescriptionArray.length; ++i) {
                if (platform != null && platform != platformFontDescriptionArray[i].getPlatform() || uLocale != null && uLocale != platformFontDescriptionArray[i].getLocale()) continue;
                ++n;
            }
            PlatformFontDescription[] platformFontDescriptionArray2 = new PlatformFontDescription[n];
            n = 0;
            for (int i = 0; i < platformFontDescriptionArray.length; ++i) {
                if (platform != null && platform != platformFontDescriptionArray[i].getPlatform() || uLocale != null && uLocale != platformFontDescriptionArray[i].getLocale()) continue;
                platformFontDescriptionArray2[n++] = platformFontDescriptionArray[i];
            }
            return platformFontDescriptionArray2;
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        try {
            return (CacheSupportInfo)this.getFontDescription(CacheSupportInfo.class.getSimpleName());
        }
        catch (InvalidFontException invalidFontException) {
            invalidFontException.initFont(this);
            throw invalidFontException;
        }
        catch (UnsupportedFontException unsupportedFontException) {
            unsupportedFontException.initFont(this);
            throw unsupportedFontException;
        }
    }

    private Object getFontDescription(String string) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontDescription[] fontDescriptionArray = this.getCachedFontDescription(string);
        if (fontDescriptionArray == null) {
            if (string.equals("CacheSupportInfo")) {
                fontDescriptionArray = this.retrieveFontData().getCacheSupportInfo();
            } else if (string.equals("CSS20FontDescription")) {
                fontDescriptionArray = this.retrieveFontData().getPreferredCSS20FontDescription();
            } else if (string.equals("CSS20FontDescription[]")) {
                fontDescriptionArray = this.retrieveFontData().getCSS20FontDescription();
            } else if (string.equals("FXGFontDescription[]")) {
                fontDescriptionArray = this.retrieveFontData().getFXGFontDescription(null, null);
            } else if (string.equals("PlatformFontDescription[]")) {
                fontDescriptionArray = this.retrieveFontData().getPlatformFontDescription(null, null);
            } else if (string.equals("PostscriptFontDescription[]")) {
                fontDescriptionArray = this.retrieveFontData().getPostscriptFontDescription();
            } else {
                throw new RuntimeException("Undefined font description class");
            }
            if (fontDescriptionArray != null) {
                this.setCachedFontDescription(string, fontDescriptionArray);
            }
        }
        return fontDescriptionArray;
    }

    public abstract String getCanonicalPath();

    public abstract long getLength();

    public abstract long getLastModified();

    public abstract Object getCachedFontDescription(String var1);

    public abstract Map<String, Object> getCachedFontDescriptionMap();

    public abstract void setCachedFontDescription(String var1, Object var2);

    public boolean wasEmbedded() {
        return false;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    protected abstract FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException;
}

