/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.postscript;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public final class PSNameFontDatabase
implements PSNameResolver {
    static final long serialVersionUID = 1L;
    private HashMap psFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private final FamilyNameNormalizer normalizer;

    public PSNameFontDatabase() {
        this(new PassThroughFamilyNameNormalizer());
    }

    public PSNameFontDatabase(FamilyNameNormalizer familyNameNormalizer) {
        this.psFonts = new HashMap();
        if (familyNameNormalizer == null) {
            familyNameNormalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = familyNameNormalizer;
    }

    public PSNameFontDatabase(PSNameFontDatabase pSNameFontDatabase) {
        this.psFonts = (HashMap)pSNameFontDatabase.psFonts.clone();
        this.normalizer = pSNameFontDatabase.normalizer;
    }

    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        PostscriptFontDescription[] postscriptFontDescriptionArray = font.getPostscriptFontDescription();
        for (int i = 0; i < postscriptFontDescriptionArray.length; ++i) {
            this.addFont(postscriptFontDescriptionArray[i], font);
        }
    }

    public void addFont(PostscriptFontDescription postscriptFontDescription, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        String string = this.normalizer.normalize(postscriptFontDescription.getPSName());
        Font font2 = (Font)this.psFonts.get(string);
        if (font2 != null) {
            Font font3;
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (font3 = IntelligentResolver.choosePreferredFont(font2, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == font2) {
                return;
            }
        }
        this.psFonts.put(string, font);
    }

    public boolean isEmpty() {
        return this.psFonts.isEmpty();
    }

    public Font findFont(PostscriptFontDescription postscriptFontDescription) {
        return this.findFont(postscriptFontDescription.getPSName());
    }

    public Font findFont(String string) {
        return (Font)this.psFonts.get(this.normalizer.normalize(string));
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority fontResolutionPriority) {
        FontResolutionPriority fontResolutionPriority2 = this.resolutionPriority;
        this.resolutionPriority = fontResolutionPriority;
        return fontResolutionPriority2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.psFonts.equals(((PSNameFontDatabase)object).psFonts);
    }

    public int hashCode() {
        return this.psFonts.hashCode();
    }

    public String toString() {
        TreeSet treeSet = new TreeSet();
        Object object = this.psFonts.keySet().iterator();
        while (object.hasNext()) {
            treeSet.add(object.next());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("priority = ");
        ((StringBuffer)object).append(this.resolutionPriority.toString());
        ((StringBuffer)object).append("; PS names = ");
        String string = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append((String)iterator.next());
            string = ", ";
        }
        return ((StringBuffer)object).toString();
    }
}

