/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.platform;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.fontmanagement.Platform;

public final class PlatformFontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final Platform platform;
    private final ULocale locale;
    private final String platformFamilyName;

    public PlatformFontDescription(Platform platform, ULocale uLocale, String string) {
        if (platform == null || uLocale == null || string == null) {
            throw new NullPointerException("Platform, Locale, and Platform Name must not be null");
        }
        this.platform = platform;
        this.locale = uLocale;
        this.platformFamilyName = string;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getPlatformName() {
        return this.platformFamilyName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.locale.hashCode();
        n = 31 * n + this.platform.hashCode();
        n = 31 * n + this.platformFamilyName.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PlatformFontDescription)) {
            return false;
        }
        PlatformFontDescription platformFontDescription = (PlatformFontDescription)object;
        if (this.locale == null ? platformFontDescription.locale != null : !this.locale.equals((Object)platformFontDescription.locale)) {
            return false;
        }
        if (this.platform == null ? platformFontDescription.platform != null : !this.platform.equals(platformFontDescription.platform)) {
            return false;
        }
        return !(this.platformFamilyName == null ? platformFontDescription.platformFamilyName != null : !this.platformFamilyName.equals(platformFontDescription.platformFamilyName));
    }

    public String toString() {
        return new String("[" + this.platform + ", " + this.locale + "] - " + this.platformFamilyName);
    }
}

