/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.VerticalOriginFetcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public final class Vorg
extends Table
implements VerticalOriginFetcher {
    protected Vorg(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    int getDefaultVOrigin() throws InvalidFontException {
        return this.data.getint16(4);
    }

    public int getVOrigin(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(6);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 + n2) / 2;
            int n5 = this.data.getuint16(8 + 4 * n4);
            if (n < n5) {
                n2 = n4;
                continue;
            }
            if (n5 < n) {
                n3 = n4 + 1;
                continue;
            }
            return this.data.getint16(8 + 4 * n4 + 2);
        }
        return this.getDefaultVOrigin();
    }

    static void subsetAndStream(Subset subset, Map map, VerticalOriginFetcher verticalOriginFetcher) throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        int n3;
        int n4 = subset.getNumGlyphs();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = subset.getFullGid(n3);
            nArray[n3] = verticalOriginFetcher.getVOrigin(n2);
        }
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray);
        n3 = nArray[0];
        n2 = 1;
        int n5 = 1;
        for (n = 1; n < n4; ++n) {
            if (nArray[n] == nArray[n - 1]) {
                if (++n5 <= n2) continue;
                n2 = n5;
                n3 = nArray[n];
                continue;
            }
            n5 = 1;
        }
        n = 0;
        for (int i = 0; i < n4; ++i) {
            if (nArray[i] == n3) continue;
            ++n;
        }
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(8 + 4 * n);
        oTByteArrayBuilder.setuint16(0, 1);
        oTByteArrayBuilder.setuint16(2, 0);
        oTByteArrayBuilder.setint16(4, n3);
        oTByteArrayBuilder.setuint16(6, n);
        int n6 = 0;
        for (int i = 0; i < nArray2.length && n6 < n; ++i) {
            if (nArray2[i] == n3) continue;
            oTByteArrayBuilder.setuint16(8 + n6 * 4, i);
            oTByteArrayBuilder.setuint16(8 + n6 * 4 + 2, nArray2[i]);
            ++n6;
        }
        map.put(new Integer(1448038983), oTByteArrayBuilder);
    }

    void stream(Map map) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1448038983), oTByteArrayBuilder);
    }
}

