/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFScaler;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.cff.Type2GlyphBBoxCalculator;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public abstract class CFFFont
extends FontData {
    protected final StringIndex stringIndex;
    protected final CharStrings globalSubrs;
    protected final String name;
    protected final Dict topDict;

    CFFFont(StringIndex stringIndex, CharStrings charStrings, Dict dict, String string, byte[] byArray) throws UnsupportedFontException, InvalidFontException {
        super(byArray);
        this.stringIndex = stringIndex;
        this.globalSubrs = charStrings;
        this.topDict = dict;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public abstract Matrix getFontMatrix();

    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        return 1.0 / this.getFontMatrix().a;
    }

    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        return 1.0 / this.getFontMatrix().d;
    }

    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        return !this.isFixedPitch();
    }

    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException {
        ROS rOS = this.getROS();
        CoolTypeScript coolTypeScript = CoolTypeScript.fromWellKnownROS(rOS);
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        coolTypeScript = CoolTypeScript.fromAnyROS(rOS);
        if (coolTypeScript != null) {
            return coolTypeScript;
        }
        return CoolTypeScript.ROMAN;
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        double d = this.getCoolTypeCapHeight();
        if (Double.isNaN(d)) {
            return null;
        }
        double d2 = this.getUnitsPerEmX();
        double d3 = this.getUnitsPerEmY();
        double d4 = -(d3 - d) / 2.0;
        return new Rect(0.0, d4, d2, d4 + d3);
    }

    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            Rect rect = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (rect != null) {
                return rect;
            }
            rect = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (rect != null) {
                return rect;
            }
        } else {
            Rect rect = this.getCoolTypeIdeoEmBoxFromCapHeight();
            if (rect != null) {
                return rect;
            }
        }
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * d2, d, 0.88 * d2);
    }

    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getCoolTypeIdeoEmBox();
        Rect rect2 = this.getCoolTypeIcfBoxFromTypicalCharacter(rect);
        if (rect2 != null) {
            return rect2;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(rect);
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeUnderlineMetrics(this.getCoolTypeUnitsPerEm(), this.getUnitsPerEmY());
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics(double d, double d2) throws UnsupportedFontException, InvalidFontException {
        double d3 = this.topDict.get(Dict.NumbersKey.UnderlinePosition, true).getFirstValueAsDouble();
        double d4 = this.topDict.get(Dict.NumbersKey.UnderlineThickness, true).getFirstValueAsDouble();
        return new UnderlineMetrics(d3 * d2 / d, d4 * d2 / d);
    }

    public abstract int getGlyphForChar(int var1) throws InvalidFontException, UnsupportedFontException;

    public abstract double getHorizontalAdvance(int var1) throws InvalidFontException, UnsupportedFontException;

    public abstract String getGlyphName(int var1) throws InvalidFontException, UnsupportedFontException;

    public abstract void getGlyphOutline(int var1, OutlineConsumer var2) throws InvalidFontException, UnsupportedFontException;

    public abstract void getOutline(int var1, Type2OutlineParser var2, OutlineConsumer var3) throws InvalidFontException, UnsupportedFontException;

    public Rect getGlyphBBox(int n) throws UnsupportedFontException, InvalidFontException {
        Matrix matrix = new Matrix(this.getUnitsPerEmX(), 0.0, 0.0, this.getUnitsPerEmY(), 0.0, 0.0);
        return new Type2GlyphBBoxCalculator(matrix).calculateBBox(this, n);
    }

    public abstract int getGlyphCid(int var1) throws InvalidFontException, UnsupportedFontException;

    public Scaler getScaler(ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        if (scanConverter == null) {
            scanConverter = new CScan(false, 1.0, true);
        }
        return new CFFScaler(this, scanConverter);
    }

    public abstract double getStemVForGlyph(int var1) throws InvalidFontException;

    abstract double getItalicAngle();

    abstract Rect getRawFontBBox();

    abstract int[] getXUID();

    abstract String getNotice();

    abstract String getCopyright();

    abstract String getFullName();

    abstract Integer getFSType();

    abstract int getFirstChar() throws InvalidFontException, UnsupportedFontException;

    abstract int getLastChar() throws InvalidFontException, UnsupportedFontException;

    abstract OrigFontType getOrigFontType();

    Permission getEmbeddingPermissionGivenFT(boolean bl, OrigFontType origFontType) {
        Integer n = this.getFSType();
        if (n != null) {
            return EmbeddingPermission.interpretFSType(n);
        }
        OrigFontType origFontType2 = this.getOrigFontType();
        if (origFontType2 == OrigFontType.kTYPE1 || origFontType2 == null && origFontType == OrigFontType.kTYPE1) {
            return EmbeddingPermission.getType1DefaultPermission(this.getNotice(), this.getName());
        }
        if (bl) {
            return EmbeddingPermission.getDefaultWasEmbeddedPermission();
        }
        if (origFontType2 == OrigFontType.kCID || origFontType2 == null && origFontType == OrigFontType.kCID) {
            return EmbeddingPermission.getCIDDefaultPermission(this.getXUID());
        }
        if (origFontType2 == OrigFontType.kTRUETYPE) {
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return EmbeddingPermission.getOCFDefaultPermission();
    }

    public Set getCSSFamilyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getPreferredCSSFamilyName();
        if (string != null) {
            hashSet.add(string);
        }
        return hashSet;
    }

    public String getPreferredCSSFamilyName() {
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.FamilyName, false);
        return stringValue != null ? stringValue.value : this.name;
    }

    public boolean isCSSStyleNormal() {
        return !this.isCSSStyleItalic();
    }

    public boolean isFixedPitch() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.isFixedPitch, true);
        return numbersValue != null && numbersValue.getFirstValueAsDouble() != 0.0;
    }

    public boolean isCSSStyleItalic() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.ItalicAngle, true);
        return numbersValue != null && numbersValue.getFirstValueAsDouble() != 0.0;
    }

    public boolean isCSSStyleOblique() {
        return this.isCSSStyleItalic();
    }

    public boolean isCSSVariantNormal() {
        return !this.isCSSVariantSmallCaps();
    }

    public boolean isCSSVariantSmallCaps() {
        String string;
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.FullName, true);
        String string2 = string = stringValue != null ? stringValue.value : this.name;
        if (string == null) {
            return false;
        }
        return NameHeuristics.fullNameIndicatesSmallCaps(string);
    }

    public int getCSSWeight() {
        String string;
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.Weight, true);
        if (stringValue != null) {
            return NameHeuristics.weightNameToWeight(stringValue.value);
        }
        stringValue = this.topDict.get(Dict.StringKey.FullName, true);
        String string2 = string = stringValue != null ? stringValue.value : this.name;
        if (string != null) {
            return NameHeuristics.fullNameToWeight(string);
        }
        return 400;
    }

    public CSS20Attribute.CSSStretchValue getCSSStretchValue() {
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.FullName, true);
        String string = stringValue != null ? stringValue.value : this.name;
        Dict.StringValue stringValue2 = this.topDict.get(Dict.StringKey.FamilyName, true);
        if (string != null) {
            return NameHeuristics.fullNameToWidth(string, stringValue2 != null ? stringValue2.value : null);
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException {
        return new CacheSupportInfo(this.getClass().getSimpleName(), this.getNumGlyphs(), true);
    }

    public PostscriptFontDescription[] getPostscriptFontDescription() {
        String string = this.getName();
        if (this.name != null) {
            return new PostscriptFontDescription[]{new PostscriptFontDescription(string)};
        }
        return new PostscriptFontDescription[0];
    }

    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        return new FXGFontDescription[0];
    }

    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        return new PlatformFontDescription[0];
    }

    public abstract ROS getROS();

    public SWFFontDescription getSWFFontDescription(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return new CFFSWFFont3Description(bl);
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, outputStream, bl, null);
    }

    public abstract void stream(OutputStream var1, Integer var2) throws InvalidFontException, UnsupportedFontException, IOException;

    public abstract void subsetAndStream(Subset var1, OutputStream var2, boolean var3, Integer var4) throws InvalidFontException, UnsupportedFontException, IOException;

    abstract CharStrings getCharStrings();

    abstract CharStrings getLocalSubrsForFD(int var1);

    abstract int getNumFDs();

    abstract double getDefaultWidthForFD(int var1);

    abstract double getNominalWidthForFD(int var1);

    abstract int getFDForGlyph(int var1) throws InvalidFontException;

    CharStrings createSubsetCharstringIndex(Subset subset, boolean bl) throws InvalidFontException, UnsupportedFontException {
        Type2CStringGenerator type2CStringGenerator = new Type2CStringGenerator(subset.getNumGlyphs(), this.getNumFDs(), bl);
        Type2OutlineParser type2OutlineParser = new Type2OutlineParser(true);
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int n = subset.getFullGid(i);
            int n2 = this.getFDForGlyph(n);
            type2CStringGenerator.newGlyph(i, n2, this.getDefaultWidthForFD(n2), this.getNominalWidthForFD(n2));
            type2OutlineParser.parse(this.getCharStrings(), n, this.getLocalSubrsForFD(n2), this.globalSubrs, type2CStringGenerator, Matrix.IDENTITY_MATRIX, this instanceof NameKeyedFont ? (NameKeyedFont)this : null);
        }
        return type2CStringGenerator.getCharstringIndex();
    }

    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        return null;
    }

    public SWFFont4Description getSWFFont4Description(boolean bl) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    protected abstract class CFFFontXDCFontDescription
    extends XDCFontDescription {
        protected CFFFontXDCFontDescription() {
        }

        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getROS();
        }

        public boolean pdfFontIsTrueType() {
            return false;
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getName();
        }

        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            Set set = CFFFont.this.getCSSFamilyNames();
            if (!set.isEmpty()) {
                return (String)set.iterator().next();
            }
            return null;
        }

        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getNumGlyphs();
        }

        public int getGlyphCid(int n) throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getGlyphCid(n);
        }

        public String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getGlyphName(n);
        }

        public double getStemV() throws UnsupportedFontException, InvalidFontException {
            int n = CFFFont.this.getGlyphForChar(108);
            if (n == 0) {
                n = CFFFont.this.getGlyphForChar(73);
            }
            if (n == 0) {
                return 0.0;
            }
            return CFFFont.this.getStemVForGlyph(n) * 1000.0 / CFFFont.this.getUnitsPerEmX();
        }

        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            Rect rect = CFFFont.this.getRawFontBBox();
            if (rect == null) {
                return null;
            }
            return rect.applyMatrix(CFFFont.this.getFontMatrix().multiply(1000.0));
        }

        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double d = CFFFont.this.getCoolTypeCapHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * (1000.0 / CFFFont.this.getUnitsPerEmY());
        }

        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double d = CFFFont.this.getCoolTypeXHeight();
            if (Double.isNaN(d)) {
                return 0.0;
            }
            return d * (1000.0 / CFFFont.this.getUnitsPerEmY());
        }

        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getItalicAngle();
        }

        public double getAdvance(int n) throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getHorizontalAdvance(n) * 1000.0 / CFFFont.this.getUnitsPerEmX();
        }

        public String getBase14Name() {
            return null;
        }

        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int n = CFFFont.this.getGlyphForChar(108);
            int n2 = CFFFont.this.getGlyphForChar(73);
            return CFFFont.this.isSerifFont(n, n2, this.getItalicAngle());
        }

        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                int n = CFFFont.this.getGlyphForChar(104);
                int n2 = CFFFont.this.getGlyphForChar(120);
                if (n2 != 0) {
                    Rect rect = CFFFont.this.getGlyphBBox(n2);
                    return CFFFont.this.isSmallCapFont(n, rect.ymax);
                }
            }
            return false;
        }

        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int n = CFFFont.this.getGlyphForChar(75);
            int n2 = CFFFont.this.getGlyphForChar(107);
            return CFFFont.this.isAllCapFont(n, n2);
        }

        public abstract CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException;
    }

    private class CFFSWFFont3Description
    implements SWFFontDescription {
        private final boolean wasEmbedded;
        private final LineMetrics metrics;

        CFFSWFFont3Description(boolean bl) throws UnsupportedFontException, InvalidFontException {
            this.wasEmbedded = bl;
            this.metrics = CFFFont.this.getCoolTypeLineMetrics();
        }

        public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getGlyphForChar(c) != 0;
        }

        public double getHorizontalAdvance(char c) throws UnsupportedFontException, InvalidFontException {
            int n = CFFFont.this.getGlyphForChar(c);
            return CFFFont.this.getHorizontalAdvance(n);
        }

        public void getOutline(char c, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
            int n = CFFFont.this.getGlyphForChar(c);
            CFFFont.this.getGlyphOutline(n, outlineConsumer);
        }

        public double getEmScale() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getUnitsPerEmX();
        }

        public double getAscent() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.ascender * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        public double getDescent() throws InvalidFontException, UnsupportedFontException {
            return -this.metrics.descender * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        public double getLineGap() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.linegap * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        public String getCopyright() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getCopyright();
        }

        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getName();
        }

        public String getTrademark() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getNotice();
        }

        public String getFamily() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getPreferredCSSFamilyName();
        }

        public String getFullName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getFullName();
        }

        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getNumGlyphs();
        }

        public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
            Permission permission = CFFFont.this.getEmbeddingPermission(this.wasEmbedded);
            if (permission.equals(Permission.ILLEGAL_VALUE)) {
                return Permission.EDITABLE;
            }
            return permission;
        }

        public boolean isBold() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getCSSWeight() >= 700;
        }

        public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.isCSSStyleItalic();
        }

        public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getFirstChar();
        }

        public int getLastChar() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getLastChar();
        }

        public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
            return null;
        }
    }
}

