/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.opentype.HmtxRaw;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.util.Map;

public final class Hmtx
extends Table {
    protected final int numberOfHMetrics;
    protected final HmtxRaw hmtx;

    protected Hmtx(HmtxRaw hmtxRaw, int n) {
        this.hmtx = hmtxRaw;
        this.numberOfHMetrics = n;
    }

    public int getLeftSideBearing(int n) throws InvalidFontException {
        return this.hmtx.getLeftSideBearing(n, this.numberOfHMetrics);
    }

    public int getHorizontalAdvance(int n) throws InvalidFontException {
        return this.hmtx.getHorizontalAdvance(n, this.numberOfHMetrics);
    }

    public void subsetAndStream(Subset subset, Map map) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(subset.getNumGlyphs() * 4);
        int n = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int n2 = subset.getFullGid(i);
            oTByteArrayBuilder.setuint16(n, this.getHorizontalAdvance(n2));
            oTByteArrayBuilder.setint16(n + 2, this.getLeftSideBearing(n2));
            n += 4;
        }
        map.put(new Integer(1752003704), oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.hmtx.getDataAsByteArray();
        map.put(new Integer(1752003704), oTByteArrayBuilder);
    }
}

