/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.SyntheticFont;
import java.io.IOException;

final class FontSet {
    protected final CFFByteArray data;
    protected final Header header;
    protected final NameIndex nameIndex;
    protected final Index topDictIndex;
    protected final StringIndex stringIndex;
    protected final CharStrings globalSubrs;
    public final CFFFont[] fonts;

    public FontSet(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        int n;
        this.data = new CFFByteArray(fontByteArray);
        if (fontByteArray.getSize() < 4) {
            throw new InvalidFontException("CFFFontSet too small");
        }
        int n2 = 0;
        this.header = new Header(this.data, n2);
        n2 += this.header.size();
        int n3 = this.header.getMajorVersion();
        if (n3 != 1) {
            throw new UnsupportedFontException("CFFFontSet major version " + n3 + " not supported");
        }
        this.nameIndex = new NameIndex(this.data, n2);
        this.topDictIndex = new Index(this.data, n2 += this.nameIndex.size());
        this.stringIndex = new StringIndex(this.data, n2 += this.topDictIndex.size());
        this.globalSubrs = new CharStrings(this.data, n2 += this.stringIndex.size());
        this.fonts = new CFFFont[this.nameIndex.getCount()];
        Dict[] dictArray = new Dict[this.nameIndex.getCount()];
        int[] nArray = new int[this.nameIndex.getCount()];
        for (n = 0; n < this.fonts.length; ++n) {
            String string = this.nameIndex.getNthName(n);
            if (string.charAt(0) == '\u0000') continue;
            Dict dict = new Dict(this.data, this.topDictIndex.offsetOf(n), this.topDictIndex.sizeOf(n), this.stringIndex);
            Dict.ROSValue rOSValue = dict.get(Dict.Key.ROS, false);
            if (rOSValue != null) {
                this.fonts[n] = new CIDKeyedFont(this.stringIndex, this.globalSubrs, string, dict, this.data, null);
                continue;
            }
            Dict.IntegerValue integerValue = dict.get(Dict.Key.SyntheticBase, false);
            if (integerValue != null) {
                dictArray[n] = dict;
                nArray[n] = integerValue.value;
                continue;
            }
            this.fonts[n] = new NameKeyedFont(this.stringIndex, this.globalSubrs, string, dict, this.data, null);
        }
        for (n = 0; n < this.fonts.length; ++n) {
            if (dictArray[n] == null) continue;
            this.fonts[n] = new SyntheticFont(this.stringIndex, this.fonts[nArray[n]], this.nameIndex.getNthName(n), dictArray[n], this.data, null);
        }
    }
}

