/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Glyf;
import com.adobe.fontengine.font.opentype.Hmtx;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.List;

final class TTParser {
    List points = new ArrayList();
    List endPoints = new ArrayList();
    public static final int EXACT_PATH = 1;
    public static final int APPROX_PATH = 2;

    TTParser() {
    }

    private void getSimpleGlyph(Glyf glyf, int n, int n2) throws InvalidFontException {
        int n3;
        int n4;
        int n5;
        if (n2 == 0) {
            return;
        }
        int n6 = this.points.size();
        int n7 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = glyf.glyf.data.getuint16(n);
            n += 2;
            if (n4 < n7) {
                throw new InvalidGlyphException("endpoints in a simple TT glyph must be increasing");
            }
            n7 = n4;
            this.endPoints.add(new Integer(n4 + n6));
        }
        n5 = (Integer)this.endPoints.get(this.endPoints.size() - 1) + 1 - n6;
        n += glyf.glyf.data.getuint16(n) + 2;
        for (n4 = 0; n4 < n5; ++n4) {
            Coord coord = new Coord();
            this.points.add(coord);
            coord.flags = glyf.glyf.data.getuint8(n++);
            if ((coord.flags & 8) == 0) continue;
            int n8 = coord.flags;
            int n9 = glyf.glyf.data.getuint8(n++);
            while (n9-- > 0) {
                coord = new Coord();
                this.points.add(coord);
                coord.flags = n8;
                ++n4;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            Coord coord = (Coord)this.points.get(n3 + n6);
            if ((coord.flags & 2) != 0) {
                n4 = (coord.flags & 0x10) == 0 ? (int)((short)(n4 - glyf.glyf.data.getuint8(n++))) : (int)((short)(n4 + glyf.glyf.data.getuint8(n++)));
            } else if ((coord.flags & 0x10) == 0) {
                n4 = (short)(n4 + glyf.glyf.data.getint16(n));
                n += 2;
            }
            coord.x = n4;
        }
        n3 = 0;
        for (int i = 0; i < n5; ++i) {
            Coord coord = (Coord)this.points.get(i + n6);
            if ((coord.flags & 4) != 0) {
                n3 = (coord.flags & 0x20) == 0 ? (int)((short)(n3 - glyf.glyf.data.getuint8(n++))) : (int)((short)(n3 + glyf.glyf.data.getuint8(n++)));
            } else if ((coord.flags & 0x20) == 0) {
                n3 = (short)(n3 + glyf.glyf.data.getint16(n));
                n += 2;
            }
            coord.y = n3;
        }
    }

    private int getCompositeGlyph(Glyf glyf, int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = n2;
        while (true) {
            double d;
            double d2;
            int n4;
            int n5;
            boolean bl;
            Matrix matrix = null;
            int n6 = glyf.glyf.data.getuint16(n);
            int n7 = glyf.glyf.data.getuint16(n += 2);
            n += 2;
            boolean bl2 = bl = (n6 & 2) != 0;
            if ((n6 & 1) != 0) {
                if (bl) {
                    n5 = glyf.glyf.data.getint16(n);
                    n4 = glyf.glyf.data.getint16(n + 2);
                } else {
                    n5 = glyf.glyf.data.getuint16(n);
                    n4 = glyf.glyf.data.getuint16(n + 2);
                }
                n += 4;
            } else {
                if (bl) {
                    n5 = glyf.glyf.data.getint8(n);
                    n4 = glyf.glyf.data.getint8(n + 1);
                } else {
                    n5 = glyf.glyf.data.getuint8(n);
                    n4 = glyf.glyf.data.getuint8(n + 1);
                }
                n += 2;
            }
            if ((n6 & 8) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                n += 2;
                matrix = new Matrix(d2, 0.0, 0.0, d2, 0.0, 0.0);
            } else if ((n6 & 0x80) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                double d3 = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                double d4 = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                d = (double)glyf.glyf.data.getint16(n += 2) / 16384.0;
                n += 2;
                matrix = new Matrix(d2, d3, d4, d, 0.0, 0.0);
            } else if ((n6 & 0x40) != 0) {
                d2 = (double)glyf.glyf.data.getint16(n) / 16384.0;
                d = (double)glyf.glyf.data.getint16(n + 2) / 16384.0;
                matrix = new Matrix(d2, 0.0, 0.0, d, 0.0, 0.0);
                n += 4;
            }
            if ((n6 & 0x200) != 0) {
                n3 = n7;
            }
            int n8 = this.points.size();
            int n9 = n;
            n = glyf.getGlyphLocation(n7);
            if (glyf.getGlyphLocation(n7 + 1) != n) {
                int n10;
                Coord coord;
                int n11 = glyf.glyf.data.getint16(n);
                n += 10;
                if (n11 < 0) {
                    n3 = this.getCompositeGlyph(glyf, n, n7);
                } else {
                    this.getSimpleGlyph(glyf, n, n11);
                }
                if (!bl) {
                    coord = (Coord)this.points.get(n5);
                    Coord coord2 = (Coord)this.points.get(n4 + n8);
                    n5 = coord.x - coord2.x;
                    n4 = coord.y - coord2.y;
                }
                if (matrix != null) {
                    for (n10 = n8; n10 < this.points.size(); ++n10) {
                        coord = (Coord)this.points.get(n10);
                        int n12 = coord.x;
                        coord.x = (int)Math.round(matrix.applyToXYGetX(coord.x, coord.y) + (double)n5);
                        coord.y = (int)Math.round(matrix.applyToXYGetY(n12, coord.y) + (double)n4);
                    }
                } else if (n5 != 0 || n4 != 0) {
                    for (n10 = n8; n10 < this.points.size(); ++n10) {
                        coord = (Coord)this.points.get(n10);
                        coord.x += n5;
                        coord.y += n4;
                    }
                }
            }
            if ((n6 & 0x20) == 0) {
                return n3;
            }
            n = n9;
        }
    }

    private void adjustPointsBySideBearing(int n, Hmtx hmtx, int n2) throws InvalidFontException {
        int n3 = hmtx.getLeftSideBearing(n);
        int n4 = n3 - n2;
        if (n4 != 0) {
            for (Coord coord : this.points) {
                coord.x += n4;
            }
        }
    }

    private void addCurve(Coord[] coordArray, OutlineConsumer outlineConsumer) {
        outlineConsumer.curveto(Math.round((double)(coordArray[0].x + 2 * coordArray[1].x) / 3.0), Math.round((double)(coordArray[0].y + 2 * coordArray[1].y) / 3.0), Math.round((double)(2 * coordArray[1].x + coordArray[2].x) / 3.0), Math.round((double)(2 * coordArray[1].y + coordArray[2].y) / 3.0), coordArray[2].x, coordArray[2].y);
    }

    private boolean combinePair(Coord[] coordArray, OutlineConsumer outlineConsumer) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = coordArray[3].y - coordArray[1].y;
        double d6 = coordArray[1].x - coordArray[3].x;
        if ((d5 != 0.0 || coordArray[1].y != coordArray[2].y) && (d6 != 0.0 || coordArray[1].x != coordArray[2].x) && (d4 = d5 * d5 + d6 * d6) != 0.0 && (d3 = d5 * (double)(coordArray[2].x - coordArray[1].x) + d6 * (double)(coordArray[2].y - coordArray[1].y)) * d3 / d4 < 1.0 && d5 * (double)(coordArray[0].x - coordArray[1].x) + d6 * (double)(coordArray[0].y - coordArray[1].y) < 0.0 == d5 * (double)(coordArray[4].x - coordArray[1].x) + d6 * (double)(coordArray[4].y - coordArray[1].y) < 0.0 && (d2 = (double)((coordArray[2].x - coordArray[0].x) * (coordArray[2].x - coordArray[0].x) + (coordArray[2].y - coordArray[0].y) * (coordArray[2].y - coordArray[0].y))) <= 3.0 * (d = (double)((coordArray[4].x - coordArray[2].x) * (coordArray[4].x - coordArray[2].x) + (coordArray[4].y - coordArray[2].y) * (coordArray[4].y - coordArray[2].y))) && d <= 3.0 * d2) {
            outlineConsumer.curveto(Math.round((double)(4 * coordArray[1].x - coordArray[0].x) / 3.0), Math.round((double)(4 * coordArray[1].y - coordArray[0].y) / 3.0), Math.round((double)(4 * coordArray[3].x - coordArray[4].x) / 3.0), Math.round((double)(4 * coordArray[3].y - coordArray[4].y) / 3.0), coordArray[4].x, coordArray[4].y);
            coordArray[0].setXY(coordArray[4]);
            return true;
        }
        this.addCurve(coordArray, outlineConsumer);
        coordArray[0].setXY(coordArray[2]);
        coordArray[1].setXY(coordArray[3]);
        coordArray[2].setXY(coordArray[4]);
        return false;
    }

    private void emitContoursApproxPath(OutlineConsumer outlineConsumer) {
        int n;
        Coord[] coordArray = new Coord[6];
        for (n = 0; n < 6; ++n) {
            coordArray[n] = new Coord();
        }
        int n2 = 0;
        for (int i = 0; i < this.endPoints.size(); ++i) {
            n = (Integer)this.endPoints.get(i);
            if (n2 >= n) {
                n2 = n + 1;
                continue;
            }
            Coord coord = null;
            int n3 = 0;
            int n4 = n - n2 + 1;
            Coord coord2 = (Coord)this.points.get(n2);
            Coord coord3 = (Coord)this.points.get(n);
            int n5 = n2;
            if ((coord2.flags & 1) != 0) {
                coord = coord2;
                coordArray[0].setXY(coord);
            } else if ((coord3.flags & 1) != 0) {
                coord = coord3;
                n5 = n;
                coordArray[0].setXY(coord);
            } else {
                coord = coord3;
                n5 = n;
                ++n4;
                coordArray[0].setXYAtMidPoint(coord2, coord3);
            }
            outlineConsumer.moveto(coordArray[0].x, coordArray[0].y);
            while (n4 > 0) {
                --n4;
                if (coord == coord3) {
                    coord = coord2;
                    n5 = n2;
                } else {
                    coord = (Coord)this.points.get(++n5);
                }
                if ((coord.flags & 1) != 0) {
                    switch (n3) {
                        case 0: {
                            if (n4 <= 0) break;
                            outlineConsumer.lineto(coord.x, coord.y);
                            coordArray[0].setXY(coord);
                            break;
                        }
                        case 1: {
                            coordArray[2].setXY(coord);
                            n3 = 3;
                            break;
                        }
                        case 2: {
                            coordArray[4].setXY(coord);
                            n3 = this.combinePair(coordArray, outlineConsumer) ? 0 : 3;
                            break;
                        }
                        case 3: {
                            this.addCurve(coordArray, outlineConsumer);
                            if (n4 > 0) {
                                outlineConsumer.lineto(coord.x, coord.y);
                                coordArray[0].setXY(coord);
                            }
                            n3 = 0;
                            break;
                        }
                        case 4: {
                            coordArray[4].setXY(coord);
                            n3 = this.combinePair(coordArray, outlineConsumer) ? 0 : 3;
                        }
                    }
                    continue;
                }
                switch (n3) {
                    case 0: {
                        coordArray[1].setXY(coord);
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        coordArray[3].setXY(coord);
                        coordArray[2].setXYAtMidPoint(coordArray[1], coordArray[3]);
                        n3 = 2;
                        break;
                    }
                    case 2: {
                        coordArray[5].setXY(coord);
                        coordArray[4].setXYAtMidPoint(coordArray[3], coordArray[5]);
                        if (this.combinePair(coordArray, outlineConsumer)) {
                            coordArray[1].setXY(coordArray[5]);
                            n3 = 1;
                            break;
                        }
                        coordArray[3].setXY(coordArray[5]);
                        n3 = 4;
                        break;
                    }
                    case 3: {
                        coordArray[3].setXY(coord);
                        n3 = 4;
                        break;
                    }
                    case 4: {
                        coordArray[5].setXY(coord);
                        coordArray[4].setXYAtMidPoint(coordArray[3], coordArray[5]);
                        if (this.combinePair(coordArray, outlineConsumer)) {
                            coordArray[1].setXY(coordArray[5]);
                            n3 = 1;
                            break;
                        }
                        coordArray[3].setXY(coordArray[5]);
                        n3 = 2;
                    }
                }
            }
            switch (n3) {
                case 2: {
                    coordArray[3].setXY(coord);
                    coordArray[2].setXYAtMidPoint(coordArray[1], coordArray[3]);
                }
                case 3: 
                case 4: {
                    this.addCurve(coordArray, outlineConsumer);
                }
            }
            n2 = n + 1;
        }
        outlineConsumer.endchar();
    }

    private void emitContoursExactPath(OutlineConsumer outlineConsumer) {
        int n = 0;
        for (int i = 0; i < this.endPoints.size(); ++i) {
            int n2;
            double d = 0.0;
            double d2 = 0.0;
            int n3 = (Integer)this.endPoints.get(i);
            if (n >= n3) {
                n = n3 + 1;
                continue;
            }
            int n4 = n;
            boolean bl = true;
            Coord coord = null;
            Coord coord2 = null;
            while (bl && n4 < n3) {
                coord = (Coord)this.points.get(n4);
                if ((coord.flags & 1) != 0) {
                    outlineConsumer.moveto(coord.x, coord.y);
                    bl = false;
                    continue;
                }
                ++n4;
            }
            if (bl) {
                Coord coord3 = (Coord)this.points.get(n3);
                n4 = n;
                coord = (Coord)this.points.get(n4);
                outlineConsumer.moveto((double)(coord.x + coord3.x) / 2.0, (double)(coord.y + coord3.y) / 2.0);
                d = (double)(coord3.x + 5 * coord.x) / 6.0;
                d2 = (double)(coord3.y + 5 * coord.y) / 6.0;
            }
            int n5 = n2 = n4;
            do {
                if (n5++ == n3) {
                    n5 = n;
                }
                coord2 = (Coord)this.points.get(n5);
                if ((coord.flags & 1) != 0) {
                    if ((coord2.flags & 1) != 0) {
                        outlineConsumer.lineto(coord2.x, coord2.y);
                    } else {
                        d = coord2.x;
                        d2 = coord2.y;
                    }
                } else if ((coord2.flags & 1) != 0) {
                    outlineConsumer.curveto(d, d2, coord2.x, coord2.y);
                } else {
                    outlineConsumer.curveto(d, d2, (double)(coord.x + coord2.x) / 2.0, (double)(coord.y + coord2.y) / 2.0);
                    d = coord2.x;
                    d2 = coord2.y;
                }
                n2 = n5;
                coord = (Coord)this.points.get(n2);
            } while (n5 != n4);
            n = n3 + 1;
        }
        outlineConsumer.endchar();
    }

    private void emitContours(OutlineConsumer outlineConsumer, int n) {
        int n2 = 0;
        for (int i = 0; i < this.endPoints.size(); ++i) {
            int n3 = (Integer)this.endPoints.get(i);
            if (n2 >= n3) {
                n2 = n3 + 1;
                continue;
            }
            int n4 = n3;
            for (int j = n3 + n2 + 1 - n4; n4 > j; --n4, ++j) {
                Object e = this.points.set(j, this.points.get(n4));
                this.points.set(n4, e);
            }
            n2 = n3 + 1;
        }
        if (n == 1) {
            this.emitContoursExactPath(outlineConsumer);
        } else {
            this.emitContoursApproxPath(outlineConsumer);
        }
    }

    void parse(OpenTypeFont openTypeFont, int n, OutlineConsumer outlineConsumer, int n2) throws UnsupportedFontException, InvalidGlyphException {
        int n3;
        Glyf glyf = openTypeFont.glyf;
        this.points.clear();
        this.endPoints.clear();
        try {
            n3 = glyf.getGlyphLocation(n);
        }
        catch (InvalidFontException invalidFontException) {
            outlineConsumer.endchar();
            return;
        }
        try {
            int n4;
            int n5;
            try {
                if (glyf.getGlyphLocation(n + 1) == n3) {
                    outlineConsumer.endchar();
                    return;
                }
                n5 = glyf.glyf.data.getint16(n3);
            }
            catch (InvalidFontException invalidFontException) {
                outlineConsumer.endchar();
                return;
            }
            int n6 = n;
            n3 += 10;
            if (openTypeFont.head == null) {
                throw new InvalidFontException("OpenType font with 'glyf' table needs a 'head' table");
            }
            outlineConsumer.setMatrix(new Matrix(1.0 / (double)openTypeFont.head.getUnitsPerEm(), 0.0, 0.0, 1.0 / (double)openTypeFont.head.getUnitsPerEm(), 0.0, 0.0));
            if (n5 < 0) {
                n6 = this.getCompositeGlyph(glyf, n3, n);
                n4 = glyf.glyf.data.getint16(glyf.getGlyphLocation(n6) + 2);
            } else {
                this.getSimpleGlyph(glyf, n3, n5);
                n4 = glyf.glyf.data.getint16(n3 - 8);
            }
            this.adjustPointsBySideBearing(n6, openTypeFont.hmtx, n4);
            this.emitContours(outlineConsumer, n2);
        }
        catch (InvalidFontException invalidFontException) {
            throw new InvalidGlyphException(invalidFontException);
        }
    }

    void parse(OpenTypeFont openTypeFont, int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidGlyphException {
        this.parse(openTypeFont, n, outlineConsumer, 1);
    }

    private static class Coord {
        int x;
        int y;
        int flags;

        private Coord() {
        }

        private void setXY(Coord coord) {
            this.x = coord.x;
            this.y = coord.y;
        }

        private void setXYAtMidPoint(Coord coord, Coord coord2) {
            this.x = (int)Math.round((double)(coord.x + coord2.x) / 2.0);
            this.y = (int)Math.round((double)(coord.y + coord2.y) / 2.0);
        }

        public String toString() {
            String string = (this.flags & 1) != 0 ? "OnCurve" : "OffCurve";
            return "(" + this.x + "," + this.y + ") flags: " + string;
        }
    }
}

