/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumer2BaseImpl;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class CScan
implements ScanConverter {
    private boolean useOffset;
    private boolean horizontalProximityFill;
    private double[] slopesArray;
    private CrossBuilder crossBuilder;
    private Map scanLines;
    private int firstScanline;
    private int lastScanline;
    private Set crossesAtXMinima;
    private Set crossesAtXMaxima;
    private Set contours;
    private static final double[] slopesArrayInit = new double[]{0.0, -0.0625, -0.29289, -0.366, -0.434, -0.5};
    private static final List emptyScanline = new LinkedList();
    private ScalerDebugger outlineDebugger;

    private static int indexOfSlope(double d) {
        if (d < 0.0) {
            d = -d;
        }
        if (d > Math.tan(Math.toRadians(52.5))) {
            if (d > Math.tan(Math.toRadians(82.5))) {
                return 5;
            }
            if (d > Math.tan(Math.toRadians(67.5))) {
                return 4;
            }
            return 3;
        }
        if (d < Math.tan(Math.toRadians(7.5))) {
            return 1;
        }
        return 2;
    }

    public CScan(boolean bl, double d, boolean bl2) {
        this.useOffset = bl;
        this.horizontalProximityFill = bl2;
        this.crossBuilder = new CrossBuilder();
        this.crossBuilder.setFlatness(1.0);
        this.slopesArray = null;
        if (bl) {
            this.slopesArray = new double[slopesArrayInit.length];
            System.arraycopy(slopesArrayInit, 0, this.slopesArray, 0, slopesArrayInit.length);
            if (d > 1.0) {
                double d2 = 2.0 * d - 1.0;
                for (int i = 1; i < this.slopesArray.length; ++i) {
                    this.slopesArray[i] = Math.max(this.slopesArray[i] * d2, -1.0);
                }
            }
        }
    }

    public void setScanType(int n) {
    }

    public OutlineConsumer2 getOutlineConsumer2() {
        return this.crossBuilder;
    }

    public void getBitmap(BitmapConsumer bitmapConsumer) {
        this.buildInitialRuns();
        this.editWhiteSpace();
        this.returnBits(bitmapConsumer);
    }

    private void buildInitialRuns() {
        for (int i = this.firstScanline; i <= this.lastScanline; ++i) {
            List list = this.getScanline(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                double d;
                double d2;
                double d3 = Double.NEGATIVE_INFINITY;
                IntersectionCross intersectionCross = (IntersectionCross)iterator.next();
                IntersectionCross intersectionCross2 = (IntersectionCross)iterator.next();
                if (this.useOffset) {
                    d2 = this.slopesArray[intersectionCross.slopeIndex];
                    d = this.slopesArray[intersectionCross2.slopeIndex];
                    intersectionCross.x -= d2;
                    intersectionCross2.x += d;
                    if (intersectionCross.x >= intersectionCross2.x) {
                        intersectionCross.x = (intersectionCross.x + d2 + intersectionCross2.x - d) / 2.0;
                        intersectionCross2.x = intersectionCross.x + 1.0;
                    }
                }
                if (intersectionCross.x <= d3) {
                    intersectionCross.x = d3 + d3 / 1000.0;
                    intersectionCross2.x = intersectionCross.x + intersectionCross.x / 1000.0;
                }
                if ((d2 = (double)Math.round(intersectionCross.x)) != (d = (double)Math.round(intersectionCross2.x))) {
                    intersectionCross.xPixel = d2;
                    intersectionCross2.xPixel = d;
                } else if (this.horizontalProximityFill) {
                    intersectionCross.xPixel = Math.floor((intersectionCross.x + intersectionCross2.x) / 2.0);
                    intersectionCross2.xPixel = intersectionCross.xPixel + 1.0;
                } else {
                    intersectionCross.xPixel = d2;
                    intersectionCross2.xPixel = d;
                }
                d3 = Math.max(d3, intersectionCross2.x);
            }
        }
    }

    private void editWhiteSpace() {
    }

    private void returnBits(BitmapConsumer bitmapConsumer) {
        for (int i = this.firstScanline; i <= this.lastScanline; ++i) {
            List list = this.getScanline(i);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IntersectionCross intersectionCross = (IntersectionCross)iterator.next();
                if (!iterator.hasNext()) {
                    System.err.println("unpaired cross at y=" + i);
                    continue;
                }
                IntersectionCross intersectionCross2 = (IntersectionCross)iterator.next();
                double d = intersectionCross.xPixel;
                double d2 = intersectionCross2.xPixel;
                if (!(d < d2)) continue;
                bitmapConsumer.addRun(d, d2, i);
            }
        }
    }

    private void paintCrosses(boolean bl) {
        for (Contour contour : this.contours) {
            Iterator iterator = contour.iterator();
            while (iterator.hasNext()) {
                Cross cross = (Cross)iterator.next();
                if (bl && !(cross instanceof IntersectionCross)) continue;
                this.outlineDebugger.cscanCross(cross.x, cross.y);
            }
        }
    }

    private List getScanline(int n) {
        List list = (LinkedList)this.scanLines.get(new Integer(n));
        if (list == null) {
            list = emptyScanline;
        }
        return list;
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.outlineDebugger = scalerDebugger;
    }

    private class Contour {
        private static final int FORWARD = 1;
        private static final int BACKWARD = -1;
        private List crosses = new ArrayList();

        private Contour() {
        }

        public void add(Cross cross) {
            this.crosses.add(cross);
        }

        public IntersectionCross intersectionCrossBefore(Cross cross) {
            return this.adjacentIntersectionCross(cross, -1);
        }

        public IntersectionCross intersectionCrossAfter(Cross cross) {
            return this.adjacentIntersectionCross(cross, 1);
        }

        public Cross adjacentCross(Cross cross, int n) {
            int n2 = this.crosses.indexOf(cross);
            if ((n2 = (n2 + n) % this.crosses.size()) < 0) {
                n2 += this.crosses.size();
            }
            return (Cross)this.crosses.get(n2);
        }

        public IntersectionCross adjacentIntersectionCross(Cross cross, int n) {
            Cross cross2;
            int n2 = this.crosses.indexOf(cross);
            do {
                if ((n2 = (n2 + n) % this.crosses.size()) >= 0) continue;
                n2 += this.crosses.size();
            } while (!((cross2 = (Cross)this.crosses.get(n2)) instanceof IntersectionCross) && cross2 != cross);
            if (cross2 instanceof IntersectionCross) {
                return (IntersectionCross)cross2;
            }
            return null;
        }

        public Iterator iterator() {
            return this.crosses.iterator();
        }

        public IntersectionEdgeIterator iterateIntersectionEdges() {
            return new IntersectionEdgeIterator();
        }

        public EdgeIterator iterateEdges(Cross cross, Cross cross2) {
            return new EdgeIterator(cross, cross2);
        }

        public EdgeIterator iterateEdges() {
            return new EdgeIterator();
        }

        public class EdgeIterator {
            int cursor = 0;
            int limit;
            boolean forceHas;
            Cross first;
            Cross second;

            public EdgeIterator(Cross cross, Cross cross2) {
                this.cursor = Contour.this.crosses.indexOf(cross);
                this.limit = Contour.this.crosses.indexOf(cross2);
                this.forceHas = false;
            }

            public EdgeIterator() {
                this.cursor = 0;
                this.limit = 0;
                this.forceHas = true;
            }

            public boolean hasNext() {
                return this.forceHas || this.cursor != this.limit;
            }

            public void next() {
                this.forceHas = false;
                this.first = (Cross)Contour.this.crosses.get(this.cursor);
                this.cursor = (this.cursor + 1) % Contour.this.crosses.size();
                this.second = (Cross)Contour.this.crosses.get(this.cursor);
            }

            public Cross c1() {
                return this.first;
            }

            public Cross c2() {
                return this.second;
            }
        }

        public class IntersectionEdgeIterator {
            int cursor = 0;
            IntersectionCross first;
            IntersectionCross second;

            public IntersectionEdgeIterator() {
                while (this.cursor < Contour.this.crosses.size() && !(Contour.this.crosses.get(this.cursor) instanceof IntersectionCross)) {
                    ++this.cursor;
                }
            }

            public boolean hasNext() {
                return this.cursor < Contour.this.crosses.size();
            }

            public void next() {
                this.first = (IntersectionCross)Contour.this.crosses.get(this.cursor);
                int n = (this.cursor + 1) % Contour.this.crosses.size();
                while (!(Contour.this.crosses.get(n) instanceof IntersectionCross)) {
                    n = (n + 1) % Contour.this.crosses.size();
                }
                this.second = (IntersectionCross)Contour.this.crosses.get(n);
                ++this.cursor;
                while (this.cursor < Contour.this.crosses.size() && !(Contour.this.crosses.get(this.cursor) instanceof IntersectionCross)) {
                    ++this.cursor;
                }
            }

            public IntersectionCross c1() {
                return this.first;
            }

            public IntersectionCross c2() {
                return this.second;
            }
        }
    }

    private class CrossBuilder
    extends OutlineConsumer2BaseImpl {
        private double THRESHOLD = 127.0;
        private double epsilon;
        private static final int NO_DIR = 0;
        private static final int RIGHT_DIR = 1;
        private static final int LEFT_DIR = -1;
        private static final int VERT_DIR = 2;
        private static final int UP_DIR = 1;
        private static final int DOWN_DIR = -1;
        private static final int HORIZ_DIR = 2;
        private int vertDir;
        private int horizDir;
        private Contour contour;
        private double firstSegmentX1;
        private double firstSegmentY1;
        private double firstSegmentX2;
        private double firstSegmentY2;

        private CrossBuilder() {
        }

        public void setFlatness(double d) {
            this.epsilon = Math.max(1.220703125E-4, 1.5 * d / 4.0);
        }

        public void startOutline() {
            CScan.this.scanLines = new HashMap();
            CScan.this.firstScanline = Integer.MAX_VALUE;
            CScan.this.lastScanline = Integer.MIN_VALUE;
            CScan.this.crossesAtXMinima = new HashSet();
            CScan.this.crossesAtXMaxima = new HashSet();
            CScan.this.contours = new HashSet();
        }

        public void startContour() {
            this.contour = new Contour();
            this.vertDir = 0;
            this.horizDir = 0;
        }

        public void line(double d, double d2, double d3, double d4) {
            block9: {
                block8: {
                    if (Math.abs(d2 - Math.floor(d2) - 0.5) < 1.0E-5) {
                        d2 += d2 / 1000.0;
                    }
                    if (Math.abs(d4 - Math.floor(d4) - 0.5) < 1.0E-5) {
                        d4 += d4 / 1000.0;
                    }
                    if (this.horizDir == 0) {
                        this.firstSegmentX1 = d;
                        this.firstSegmentY1 = d2;
                        this.firstSegmentX2 = d3;
                        this.firstSegmentY2 = d4;
                        this.setDirections(d, d2, d3, d4);
                    } else {
                        this.addInflectionCrossIfNeeded(d, d2, d3, d4);
                    }
                    if (!(d2 < d4)) break block8;
                    double d5 = (d3 - d) / (d4 - d2);
                    double d6 = Math.floor(d2 + 0.5) + 0.5;
                    double d7 = d + (d6 - d2) * d5;
                    while (d6 <= d4) {
                        IntersectionCross intersectionCross = new IntersectionCross(d7, d6);
                        if (CScan.this.useOffset) {
                            intersectionCross.slopeIndex = CScan.indexOfSlope(d5);
                        }
                        this.addIntersectionCross(intersectionCross);
                        d6 += 1.0;
                        d7 += d5;
                    }
                    break block9;
                }
                if (!(d4 < d2)) break block9;
                double d8 = (d3 - d) / (d4 - d2);
                double d9 = Math.floor(d2 - 0.5) + 0.5;
                double d10 = d + (d9 - d2) * d8;
                while (d4 <= d9) {
                    IntersectionCross intersectionCross = new IntersectionCross(d10, d9);
                    if (CScan.this.useOffset) {
                        intersectionCross.slopeIndex = CScan.indexOfSlope(d8);
                    }
                    this.addIntersectionCross(intersectionCross);
                    d9 -= 1.0;
                    d10 -= d8;
                }
            }
        }

        public void quadraticCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            if ((d <= d3 && d3 <= d5 || d5 <= d3 && d3 <= d) && Math.abs(d5 - d) < this.THRESHOLD && Math.abs(d5 - d - 2.0 * (d3 - d)) <= this.epsilon && (d2 <= d4 && d4 <= d6 || d6 <= d4 && d4 <= d2) && Math.abs(d6 - d2) < this.THRESHOLD && Math.abs(d6 - d2 - 2.0 * (d4 - d2)) <= this.epsilon) {
                this.line(d, d2, d5, d6);
            } else {
                double d7 = (d3 + d) / 2.0;
                double d8 = (d4 + d2) / 2.0;
                double d9 = (d5 + d3) / 2.0;
                double d10 = (d6 + d4) / 2.0;
                double d11 = (d7 + d9) / 2.0;
                double d12 = (d8 + d10) / 2.0;
                this.quadraticCurve(d, d2, d7, d8, d11, d12);
                this.quadraticCurve(d11, d12, d9, d10, d5, d6);
            }
        }

        public void cubicCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            if ((d <= d3 && d3 <= d5 && d5 <= d7 || d7 <= d5 && d5 <= d3 && d3 <= d) && Math.abs(d7 - d) < this.THRESHOLD && Math.abs(d7 - d - 3.0 * (d3 - d)) <= this.epsilon && Math.abs(d7 - d - 3.0 * (d7 - d5)) <= this.epsilon && (d2 <= d4 && d4 <= d6 && d6 <= d8 || d8 <= d6 && d6 <= d4 && d4 <= d2) && Math.abs(d8 - d2) < this.THRESHOLD && Math.abs(d8 - d2 - 3.0 * (d4 - d2)) <= this.epsilon && Math.abs(d8 - d2 - 3.0 * (d8 - d6)) <= this.epsilon) {
                this.line(d, d2, d7, d8);
            } else {
                double d9 = (d3 + d) / 2.0;
                double d10 = (d4 + d2) / 2.0;
                double d11 = (d5 + d3) / 2.0;
                double d12 = (d6 + d4) / 2.0;
                double d13 = (d7 + d5) / 2.0;
                double d14 = (d8 + d6) / 2.0;
                double d15 = (d11 + d9) / 2.0;
                double d16 = (d12 + d10) / 2.0;
                double d17 = (d13 + d11) / 2.0;
                double d18 = (d14 + d12) / 2.0;
                double d19 = (d15 + d17) / 2.0;
                double d20 = (d16 + d18) / 2.0;
                this.cubicCurve(d, d2, d9, d10, d15, d16, d19, d20);
                this.cubicCurve(d19, d20, d17, d18, d13, d14, d7, d8);
            }
        }

        public void endContour() {
            this.addInflectionCrossIfNeeded(this.firstSegmentX1, this.firstSegmentY1, this.firstSegmentX2, this.firstSegmentY2);
            CScan.this.contours.add(this.contour);
            this.contour = null;
        }

        public void endOutline() {
        }

        private void setDirections(double d, double d2, double d3, double d4) {
            this.horizDir = d < d3 ? 1 : (d == d3 ? 2 : -1);
            this.vertDir = d2 < d4 ? 1 : (d2 == d4 ? 2 : -1);
        }

        private void addInflectionCrossIfNeeded(double d, double d2, double d3, double d4) {
            boolean bl = false;
            ExtraCross extraCross = null;
            if (bl) {
                extraCross = new ExtraCross(d, d2);
            }
            if (d < d3 && this.horizDir != 1) {
                if (this.horizDir != 0) {
                    if (extraCross == null) {
                        extraCross = new ExtraCross(d, d2);
                    }
                    CScan.this.crossesAtXMinima.add(extraCross);
                }
                this.horizDir = 1;
            } else if (d == d3 && this.horizDir != 2) {
                if (this.horizDir != 0) {
                    if (extraCross == null) {
                        extraCross = new ExtraCross(d, d2);
                    }
                    if (this.horizDir == -1) {
                        CScan.this.crossesAtXMinima.add(extraCross);
                    } else {
                        CScan.this.crossesAtXMaxima.add(extraCross);
                    }
                }
                this.horizDir = 2;
            } else if (d > d3 && this.horizDir != -1) {
                if (this.horizDir != 0) {
                    if (extraCross == null) {
                        extraCross = new ExtraCross(d, d2);
                    }
                    CScan.this.crossesAtXMaxima.add(extraCross);
                }
                this.horizDir = -1;
            }
            if (d2 < d4) {
                if (this.vertDir != 1) {
                    if (extraCross == null) {
                        extraCross = new ExtraCross(d, d2);
                    }
                    this.vertDir = 1;
                }
            } else if (d2 == d4) {
                if (this.vertDir != 2) {
                    if (extraCross == null) {
                        extraCross = new ExtraCross(d, d2);
                    }
                    this.vertDir = 2;
                }
            } else if (this.vertDir != -1) {
                if (extraCross == null) {
                    extraCross = new ExtraCross(d, d2);
                }
                this.vertDir = -1;
            }
            if (extraCross != null) {
                this.addCrossToCountour(extraCross);
            }
        }

        private void addIntersectionCross(IntersectionCross intersectionCross) {
            ListIterator<IntersectionCross> listIterator;
            int n = (int)Math.floor(intersectionCross.y);
            CScan.this.firstScanline = Math.min(CScan.this.firstScanline, n);
            CScan.this.lastScanline = Math.max(CScan.this.lastScanline, n);
            Integer n2 = new Integer(n);
            LinkedList<IntersectionCross> linkedList = (LinkedList<IntersectionCross>)CScan.this.scanLines.get(n2);
            if (linkedList == null) {
                linkedList = new LinkedList<IntersectionCross>();
                CScan.this.scanLines.put(n2, linkedList);
            }
            if (!(listIterator = linkedList.listIterator()).hasNext()) {
                linkedList.add(0, intersectionCross);
            } else {
                boolean bl = false;
                while (listIterator.hasNext()) {
                    IntersectionCross intersectionCross2 = (IntersectionCross)listIterator.next();
                    if (intersectionCross2.compareTo(intersectionCross) < 0) continue;
                    if (listIterator.hasPrevious()) {
                        listIterator.previous();
                        listIterator.add(intersectionCross);
                    } else {
                        linkedList.add(0, intersectionCross);
                    }
                    bl = true;
                    break;
                }
                if (!bl) {
                    linkedList.add(intersectionCross);
                }
            }
            this.addCrossToCountour(intersectionCross);
        }

        private void addCrossToCountour(Cross cross) {
            cross.contour = this.contour;
            this.contour.add(cross);
        }
    }

    private class ExtraCross
    extends Cross {
        public ExtraCross(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    private class IntersectionCross
    extends Cross
    implements Comparable {
        double xPixel;
        int slopeIndex;

        public IntersectionCross(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public boolean isLeftInRun() {
            List list = CScan.this.getScanline((int)Math.floor(this.y));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IntersectionCross intersectionCross = (IntersectionCross)iterator.next();
                if (intersectionCross == this) {
                    return true;
                }
                intersectionCross = (IntersectionCross)iterator.next();
                if (intersectionCross != this) continue;
                return false;
            }
            throw new RuntimeException("unpaired crosses in run at y=" + this.y);
        }

        public IntersectionCross leftInRun() {
            List list = CScan.this.getScanline((int)Math.floor(this.y));
            IntersectionCross intersectionCross = null;
            for (IntersectionCross intersectionCross2 : list) {
                if (intersectionCross2 == this) {
                    return intersectionCross;
                }
                intersectionCross = intersectionCross2;
            }
            return null;
        }

        public IntersectionCross rightInRun() {
            List list = CScan.this.getScanline((int)Math.floor(this.y));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IntersectionCross intersectionCross = (IntersectionCross)iterator.next();
                if (intersectionCross != this) continue;
                if (iterator.hasNext()) {
                    return (IntersectionCross)iterator.next();
                }
                return null;
            }
            return null;
        }

        public int compareTo(Object object) {
            IntersectionCross intersectionCross = (IntersectionCross)object;
            if (intersectionCross.x < this.x) {
                return 1;
            }
            if (intersectionCross.x == this.x) {
                return 0;
            }
            return -1;
        }
    }

    private abstract class Cross {
        double x;
        double y;
        Contour contour;

        private Cross() {
        }

        public String toString() {
            return "{" + (double)Math.round(this.x * 100.0) / 100.0 + ", " + (double)Math.round(this.y * 100.0) / 100.0 + "}";
        }
    }
}

