/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharsetUtil;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.fontmanagement.Platform;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Name
extends Table {
    private static final int UNDEFINED = -1;

    static ULocale getLocaleForLocaleID(int n, int n2) {
        LanguageCodeEntry languageCodeEntry = null;
        switch (n) {
            case 1: {
                languageCodeEntry = MacintoshLanguageCode.getCodeEntry(n2);
                break;
            }
            case 3: {
                languageCodeEntry = MicrosoftLCID.getCodeEntry(n2);
            }
        }
        if (languageCodeEntry == null) {
            return null;
        }
        return languageCodeEntry.getLocale();
    }

    protected Name(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected static String getCharsetName(int n, int n2) {
        if (n == 3) {
            switch (n2) {
                case 0: {
                    return "UTF-16BE";
                }
                case 1: {
                    return "UTF-16BE";
                }
                case 2: {
                    return "windows-932";
                }
                case 3: {
                    return "windows-936";
                }
                case 4: {
                    return "windows-950";
                }
                case 5: {
                    return "windows-949";
                }
                case 6: {
                    return "ms1361";
                }
                case 10: {
                    return "UTF-16BE";
                }
            }
            return null;
        }
        if (n == 1) {
            switch (n2) {
                case 0: {
                    return "MacRoman";
                }
                case 1: {
                    return "MacJapanese";
                }
                case 2: {
                    return "MacChineseTraditional";
                }
                case 3: {
                    return "MacKorean";
                }
                case 4: {
                    return "MacArabic";
                }
                case 5: {
                    return "MacHebrew";
                }
                case 6: {
                    return "MacGreek";
                }
                case 7: {
                    return "MacCyrillic";
                }
                case 8: {
                    return "MacSymbol";
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return null;
                }
                case 11: {
                    return null;
                }
                case 12: {
                    return null;
                }
                case 13: {
                    return null;
                }
                case 14: {
                    return null;
                }
                case 15: {
                    return null;
                }
                case 16: {
                    return null;
                }
                case 17: {
                    return null;
                }
                case 18: {
                    return null;
                }
                case 19: {
                    return null;
                }
                case 20: {
                    return null;
                }
                case 21: {
                    return "MacThai";
                }
                case 22: {
                    return null;
                }
                case 23: {
                    return null;
                }
                case 24: {
                    return null;
                }
                case 25: {
                    return "MacChineseSimplified";
                }
                case 26: {
                    return null;
                }
                case 27: {
                    return null;
                }
                case 28: {
                    return null;
                }
                case 29: {
                    return null;
                }
                case 30: {
                    return null;
                }
                case 31: {
                    return null;
                }
            }
            return null;
        }
        if (n == 0) {
            return "UTF-16BE";
        }
        return null;
    }

    static Charset getCharset(String string) {
        return CharsetUtil.forNameICU(string);
    }

    static String bytesToUnicode(byte[] byArray, int n, int n2, String string) throws InvalidFontException, UnsupportedEncodingException, CoderMalfunctionError, IllegalStateException, MalformedInputException, UnmappableCharacterException {
        Charset charset = CharsetUtil.forNameICU(string);
        return Name.bytesToUnicode(byArray, n, n2, charset);
    }

    static String bytesToUnicode(byte[] byArray, int n, int n2, Charset charset) throws InvalidFontException, UnsupportedEncodingException, CoderMalfunctionError, IllegalStateException, MalformedInputException, UnmappableCharacterException {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        int n3 = (int)Math.ceil(charsetDecoder.maxCharsPerByte());
        CharBuffer charBuffer = CharBuffer.allocate(n2 * n3);
        while ((coderResult = CharsetUtil.decodeLoop(byteBuffer, charBuffer, charsetDecoder, true)).isOverflow()) {
            charsetDecoder.reset();
            charBuffer = CharBuffer.allocate(charBuffer.capacity() * 2);
        }
        if (coderResult.isMalformed()) {
            throw new MalformedInputException(n2);
        }
        return new String(charBuffer.array(), 0, charBuffer.position());
    }

    public String getName(int n, int n2) throws InvalidFontException {
        try {
            return this.getName(3, 1, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getName(int n, int n2, int n3, int n4) throws InvalidFontException, UnsupportedEncodingException {
        String string = Name.getCharsetName(n, n2);
        Charset charset = Name.getCharset(string);
        if (charset == null) {
            throw new UnsupportedEncodingException();
        }
        int n5 = this.data.getuint16(2);
        int n6 = this.data.getuint16(4);
        for (int i = 0; i < n5; ++i) {
            try {
                if (this.data.getuint16(6 + 12 * i + 0) != n || this.data.getuint16(6 + 12 * i + 2) != n2 || this.data.getuint16(6 + 12 * i + 4) != n3 && -1 != n3 || this.data.getuint16(6 + 12 * i + 6) != n4) continue;
                int n7 = this.data.getuint16(6 + 12 * i + 8);
                int n8 = n6 + this.data.getuint16(6 + 12 * i + 10);
                return Name.bytesToUnicode(this.data.getBytes(n8, n7), 0, n7, charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            catch (CoderMalfunctionError coderMalfunctionError) {
                continue;
            }
            catch (MalformedInputException malformedInputException) {
                continue;
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasName(int n, int n2, int n3, int n4) throws InvalidFontException {
        int n5 = this.data.getuint16(2);
        for (int i = 0; i < n5; ++i) {
            if (this.data.getuint16(6 + 12 * i + 0) != n && -1 != n || this.data.getuint16(6 + 12 * i + 2) != n2 && -1 != n2 || this.data.getuint16(6 + 12 * i + 4) != n3 && -1 != n3 || this.data.getuint16(6 + 12 * i + 6) != n4 && -1 != n4) continue;
            return true;
        }
        return false;
    }

    private String lookForNames(NameSelector nameSelector, int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
        return this.lookForNames(nameSelector, new int[]{n}, n2, n3);
    }

    private String lookForNames(NameSelector nameSelector, int[] nArray, int n, int n2) throws UnsupportedFontException, InvalidFontException {
        for (int i = 0; i < n; ++i) {
            int n3 = this.data.getuint16(6 + 12 * i + 6);
            for (int j = 0; j < nArray.length; ++j) {
                String string;
                if (n3 != nArray[j] || (string = Name.getCharsetName(this.data.getuint16(6 + 12 * i + 0), this.data.getuint16(6 + 12 * i + 2))) == null) continue;
                int n4 = this.data.getuint16(6 + 12 * i + 8);
                int n5 = n2 + this.data.getuint16(6 + 12 * i + 10);
                try {
                    String string2 = Name.bytesToUnicode(this.data.getBytes(n5, n4), 0, n4, string);
                    if (!nameSelector.nameFound(string2, n3, this.data.getuint16(6 + 12 * i + 0), this.data.getuint16(6 + 12 * i + 2), this.data.getuint16(6 + 12 * i + 4))) continue;
                    return string2;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    continue;
                }
                catch (CoderMalfunctionError coderMalfunctionError) {
                    continue;
                }
                catch (MalformedInputException malformedInputException) {
                    continue;
                }
                catch (UnmappableCharacterException unmappableCharacterException) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private int pickFamilyNameSelector(int n) throws InvalidFontException {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = this.data.getuint16(6 + 12 * i + 6);
            if (n3 != 16) continue;
            n2 = 16;
            break;
        }
        return n2;
    }

    String getFirstName(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint16(2);
        int n3 = this.data.getuint16(4);
        return this.lookForNames(new NameSelector(){

            public boolean nameFound(String string, int n, int n2, int n3, int n4) {
                return true;
            }
        }, n, n2, n3);
    }

    public Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        NameSetSelector nameSetSelector = new NameSetSelector();
        this.lookForNames((NameSelector)nameSetSelector, 16, n, n2);
        this.lookForNames((NameSelector)nameSetSelector, 1, n, n2);
        return nameSetSelector.getSet();
    }

    public Set getMacFXGFamilyNames(ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        Set set = null;
        int[] nArray = new int[]{18, 4};
        NameEntrySet nameEntrySet = new NameEntrySet();
        nameEntrySet.setNameIDs(nArray);
        nameEntrySet.setPlatform(1);
        nameEntrySet.setLocale(uLocale);
        this.getNamesExtended(nArray, nameEntrySet);
        set = nameEntrySet.getSet();
        if (set == null) {
            if (uLocale != null) {
                nameEntrySet.setLocale(null);
                this.getNamesExtended(nArray, nameEntrySet);
                Set set2 = nameEntrySet.getSet();
                if (!set2.isEmpty()) {
                    return null;
                }
            }
            nameEntrySet.setLocale(uLocale);
            nameEntrySet.setPlatform(3);
            this.getNamesExtended(nArray, nameEntrySet);
            set = nameEntrySet.getSet();
        }
        return set;
    }

    public Set getWindowsFXGFamilyNames(ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        int[] nArray = new int[]{1};
        NameEntrySet nameEntrySet = new NameEntrySet();
        nameEntrySet.setPlatform(3);
        nameEntrySet.setLocale(uLocale);
        this.getNamesExtended(nArray, nameEntrySet);
        return nameEntrySet.getSet();
    }

    public Set getMacPlatformNames(ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        Set set = null;
        int[] nArray = new int[]{4};
        NameEntrySet nameEntrySet = new NameEntrySet();
        nameEntrySet.setPlatform(1);
        nameEntrySet.setLocale(uLocale);
        this.getNamesExtended(nArray, nameEntrySet);
        set = nameEntrySet.getSet();
        if (set == null) {
            if (uLocale != null) {
                nameEntrySet.setLocale(null);
                this.getNamesExtended(nArray, nameEntrySet);
                Set set2 = nameEntrySet.getSet();
                if (!set2.isEmpty()) {
                    return null;
                }
            }
            nameEntrySet.setLocale(uLocale);
            nameEntrySet.setPlatform(3);
            this.getNamesExtended(nArray, nameEntrySet);
            set = nameEntrySet.getSet();
        }
        return set;
    }

    public Set getWindowsPlatformNames(ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        int[] nArray = new int[]{4};
        NameEntrySet nameEntrySet = new NameEntrySet();
        nameEntrySet.setPlatform(3);
        nameEntrySet.setLocale(uLocale);
        this.getNamesExtended(nArray, nameEntrySet);
        return nameEntrySet.getSet();
    }

    private void getNamesExtended(int[] nArray, NameEntrySet nameEntrySet) throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        this.lookForNames((NameSelector)nameEntrySet, nArray, n, n2);
    }

    public String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        CSSNameSelector cSSNameSelector = new CSSNameSelector();
        this.lookForNames((NameSelector)cSSNameSelector, 1, n, n2);
        return cSSNameSelector.getName();
    }

    public Set getPostscriptNames() throws InvalidFontException, UnsupportedFontException {
        int n = this.data.getuint16(2);
        int n2 = this.data.getuint16(4);
        NameSetSelector nameSetSelector = new NameSetSelector();
        this.lookForNames((NameSelector)nameSetSelector, 6, n, n2);
        return nameSetSelector.getSet();
    }

    public int selectFamilyNameId() throws InvalidFontException {
        return this.pickFamilyNameSelector(this.data.getuint16(2));
    }

    public void enumerateNames(NameSelector nameSelector, int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint16(2);
        int n3 = this.data.getuint16(4);
        this.lookForNames(nameSelector, n, n2, n3);
    }

    private boolean keepNameId(int n, boolean bl, int[] nArray) {
        if (n == 0 || bl && n == 7) {
            return true;
        }
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public void subsetAndStream(Subset subset, boolean bl, int[] nArray, Map map) throws UnsupportedFontException, InvalidFontException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.data.getuint16(2);
        int n5 = this.data.getuint16(4);
        for (n = 0; n < n4; ++n) {
            int n6 = this.data.getuint16(6 + 12 * n + 6);
            if (!this.keepNameId(n6, bl, nArray)) continue;
            ++n2;
            n3 += this.data.getuint16(6 + 12 * n + 8);
        }
        n = 6 + 12 * n2;
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(n + n3);
        oTByteArrayBuilder.setuint32(0, 0);
        oTByteArrayBuilder.setuint16(2, n2);
        oTByteArrayBuilder.setuint16(4, n);
        int n7 = 6;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            int n9 = this.data.getuint16(6 + 12 * i + 6);
            if (!this.keepNameId(n9, bl, nArray)) continue;
            int n10 = this.data.getuint16(6 + 12 * i + 8);
            oTByteArrayBuilder.setuint16(n7, this.data.getuint16(6 + 12 * i));
            oTByteArrayBuilder.setuint16(n7 + 2, this.data.getuint16(6 + 12 * i + 2));
            oTByteArrayBuilder.setuint16(n7 + 4, this.data.getuint16(6 + 12 * i + 4));
            oTByteArrayBuilder.setuint16(n7 + 6, n9);
            oTByteArrayBuilder.setuint16(n7 + 8, n10);
            oTByteArrayBuilder.setuint16(n7 + 10, n8);
            n7 += 12;
            try {
                oTByteArrayBuilder.replace(n + n8, this.data, n5 + this.data.getuint16(6 + 12 * i + 10), n10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidFontException("string " + i + " in name table extends beyond the end of the table");
            }
            n8 += n10;
        }
        map.put(new Integer(1851878757), oTByteArrayBuilder);
    }

    public void stream(Map map, boolean bl, int[] nArray) throws UnsupportedFontException, InvalidFontException {
        this.subsetAndStream(null, bl, nArray, map);
    }

    public String selectName(int n) throws UnsupportedEncodingException, InvalidFontException {
        String string = this.getName(3, 1, MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode(), n);
        if (string != null) {
            return string;
        }
        string = this.getName(3, 0, MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode(), n);
        if (string != null) {
            return string;
        }
        this.getName(1, 0, 0, n);
        return string;
    }

    private static class NameSetSelector
    implements NameSelector {
        private Set set = new HashSet();
        private int platformID = -1;
        private int language = -1;

        NameSetSelector() {
        }

        NameSetSelector(int n, int n2) {
            this();
            this.platformID = n;
            this.language = n2;
        }

        public boolean nameFound(String string, int n, int n2, int n3, int n4) {
            if (!(this.platformID != -1 && n2 != this.platformID || this.language != -1 && n4 != this.language)) {
                this.set.add(string);
            }
            return false;
        }

        Set getSet() {
            return this.set;
        }
    }

    static class NameEntrySet
    implements NameSelector {
        private Map set = new HashMap();
        private int platformID = -1;
        private ULocale locale = null;
        private int[] nameIDs = null;

        NameEntrySet() {
        }

        public boolean nameFound(String string, int n, int n2, int n3, int n4) {
            NameEntry nameEntry;
            Object object;
            if (this.platformID != -1 && n2 != this.platformID) {
                return false;
            }
            if (this.locale != null && !NameEntrySet.isContainedWithin(this.locale, object = Name.getLocaleForLocaleID(n2, n4))) {
                return false;
            }
            object = new NameEntry(string, n, n2, n4, n3, false);
            if (this.nameIDs != null && (nameEntry = (NameEntry)this.set.get(object)) != null) {
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MAX_VALUE;
                for (int i = 0; i < this.nameIDs.length; ++i) {
                    if (this.nameIDs[i] == object.getLanguage()) {
                        n5 = i;
                    }
                    if (this.nameIDs[i] != nameEntry.getLanguage()) continue;
                    n6 = i;
                }
                if (n6 < n5) {
                    object = nameEntry;
                } else {
                    this.set.remove(object);
                }
            }
            this.set.put(object, object);
            return false;
        }

        Set getSet() {
            if (this.set.isEmpty()) {
                return null;
            }
            return this.set.keySet();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.locale.hashCode();
            n = 31 * n + this.platformID;
            n = 31 * n + (this.set == null ? 0 : ((Object)this.set).hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof NameEntrySet)) {
                return false;
            }
            NameEntrySet nameEntrySet = (NameEntrySet)object;
            if (!this.locale.equals((Object)nameEntrySet.locale)) {
                return false;
            }
            if (this.platformID != nameEntrySet.platformID) {
                return false;
            }
            return !(this.set == null ? nameEntrySet.set != null : !((Object)this.set).equals(nameEntrySet.set));
        }

        public void setPlatform(int n) {
            this.platformID = n;
        }

        public void setLocale(ULocale uLocale) {
            this.locale = uLocale;
        }

        public void setNameIDs(int[] nArray) {
            this.nameIDs = nArray;
        }

        static boolean isContainedWithin(ULocale uLocale, ULocale uLocale2) {
            if (uLocale2 == null) {
                return true;
            }
            String string = uLocale.getLanguage();
            if (string != null && !string.equals("") && !string.equals(uLocale2.getLanguage())) {
                return false;
            }
            String string2 = uLocale.getCountry();
            if (string2 != null && !string2.equals("") && !string2.equals(uLocale2.getCountry())) {
                return false;
            }
            String string3 = uLocale.getScript();
            if (string3 != null && !string3.equals("") && !string3.equals(uLocale2.getScript())) {
                return false;
            }
            String string4 = uLocale.getVariant();
            return string4 == null || string4.equals("") || string4.equals(uLocale2.getVariant());
        }
    }

    static class NameEntry {
        private final String name;
        private final int nameID;
        private final int platformID;
        private final int language;
        private final boolean nameIdDifferentiates;

        public NameEntry(String string, int n, int n2, int n3, int n4, boolean bl) {
            this.name = string;
            this.nameID = n;
            this.platformID = n2;
            this.language = n3;
            this.nameIdDifferentiates = bl;
        }

        String getName() {
            return this.name;
        }

        int getNameID() {
            return this.nameID;
        }

        int getPlatformID() {
            return this.platformID;
        }

        int getLanguage() {
            return this.language;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.language;
            if (this.nameIdDifferentiates) {
                n = 31 * n + this.nameID;
            }
            n = 31 * n + (this.nameIdDifferentiates ? 1231 : 1237);
            n = 31 * n + this.platformID;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof NameEntry)) {
                return false;
            }
            NameEntry nameEntry = (NameEntry)object;
            if (this.language != nameEntry.language) {
                return false;
            }
            if (this.nameIdDifferentiates && this.nameID != nameEntry.nameID) {
                return false;
            }
            if (this.nameIdDifferentiates != nameEntry.nameIdDifferentiates) {
                return false;
            }
            return this.platformID == nameEntry.platformID;
        }

        public String toString() {
            return new String("[" + this.nameID + ", " + this.platformID + " ," + this.language + "] = " + this.name);
        }
    }

    private static class CSSNameSelector
    implements NameSelector {
        private String currentSelection;
        int currentRanking = selectors.length;
        private static final int[][] selectors = new int[][]{{3, 1, MicrosoftLCID.ENGLISH_UNITED_STATES.getLanguageCode()}, {3, 1, -1}, {1, 0, 0}};

        private CSSNameSelector() {
        }

        public boolean nameFound(String string, int n, int n2, int n3, int n4) throws InvalidFontException, UnsupportedFontException {
            for (int i = 0; i < selectors.length; ++i) {
                if (n2 != selectors[i][0] || n3 != selectors[i][1] || n4 != selectors[i][2] && selectors[i][2] != -1 || this.currentRanking <= i) continue;
                this.currentSelection = string;
                this.currentRanking = i;
                return false;
            }
            return false;
        }

        public String getName() {
            return this.currentSelection;
        }
    }

    static interface NameSelector {
        public boolean nameFound(String var1, int var2, int var3, int var4, int var5) throws InvalidFontException, UnsupportedFontException;
    }

    public static final class MacintoshLanguageCode {
        private static final Map LANGUAGE_MAP = new HashMap(150);
        public static final LanguageCodeEntry AFRIKAANS = new LanguageCodeEntry(141, "af", null, null);
        public static final LanguageCodeEntry ALBANIAN = new LanguageCodeEntry(36, "sq", null, null);
        public static final LanguageCodeEntry AMHARIC = new LanguageCodeEntry(85, "am", null, null);
        public static final LanguageCodeEntry ARABIC = new LanguageCodeEntry(12, "ar", null, null);
        public static final LanguageCodeEntry ARMENIAN = new LanguageCodeEntry(51, "hy", null, null);
        public static final LanguageCodeEntry ASSAMESE = new LanguageCodeEntry(68, "as", null, null);
        public static final LanguageCodeEntry AYMARA = new LanguageCodeEntry(134, "ay", null, null);
        public static final LanguageCodeEntry AZERBAIJANI_ARABIC_SCRIPT = new LanguageCodeEntry(50, "az", "Arab", null);
        public static final LanguageCodeEntry AZERBAIJANI_CYRILLIC_SCRIPT = new LanguageCodeEntry(49, "az", "Cyrl", null);
        public static final LanguageCodeEntry AZERBAIJANI_ROMAN_SCRIPT = new LanguageCodeEntry(150, "az", "Latn", null);
        public static final LanguageCodeEntry BASQUE = new LanguageCodeEntry(129, "eu", null, null);
        public static final LanguageCodeEntry BENGALI = new LanguageCodeEntry(67, "bn", null, null);
        public static final LanguageCodeEntry BRETON = new LanguageCodeEntry(142, "br", null, null);
        public static final LanguageCodeEntry BULGARIAN = new LanguageCodeEntry(44, "bg", null, null);
        public static final LanguageCodeEntry BURMESE = new LanguageCodeEntry(77, "my", null, null);
        public static final LanguageCodeEntry BYELORUSSIAN = new LanguageCodeEntry(46, "be", null, null);
        public static final LanguageCodeEntry CATALAN = new LanguageCodeEntry(130, "ca", null, null);
        public static final LanguageCodeEntry CHINESE_SIMPLIFIED = new LanguageCodeEntry(33, "zh", "Hans", null);
        public static final LanguageCodeEntry CHINESE_TRADITIONAL = new LanguageCodeEntry(19, "zh", "Hant", null);
        public static final LanguageCodeEntry CROATIAN = new LanguageCodeEntry(18, "hr", null, null);
        public static final LanguageCodeEntry CZECH = new LanguageCodeEntry(38, "cs", null, null);
        public static final LanguageCodeEntry DANISH = new LanguageCodeEntry(7, "da", null, null);
        public static final LanguageCodeEntry DUTCH = new LanguageCodeEntry(4, "nl", null, null);
        public static final LanguageCodeEntry DZONGKHA = new LanguageCodeEntry(137, "dz", null, null);
        public static final LanguageCodeEntry ENGLISH = new LanguageCodeEntry(0, "en", null, null);
        public static final LanguageCodeEntry ESPERANTO = new LanguageCodeEntry(94, "eo", null, null);
        public static final LanguageCodeEntry ESTONIAN = new LanguageCodeEntry(27, "et", null, null);
        public static final LanguageCodeEntry FAROESE = new LanguageCodeEntry(30, "fo", null, null);
        public static final LanguageCodeEntry FARSI_PERSIAN = new LanguageCodeEntry(31, "fa", null, null);
        public static final LanguageCodeEntry FINNISH = new LanguageCodeEntry(13, "fi", null, null);
        public static final LanguageCodeEntry FLEMISH = new LanguageCodeEntry(34, "nl", null, null);
        public static final LanguageCodeEntry FRENCH = new LanguageCodeEntry(1, "fr", null, null);
        public static final LanguageCodeEntry GALICIAN = new LanguageCodeEntry(140, "gl", null, null);
        public static final LanguageCodeEntry GALLA = new LanguageCodeEntry(87, "om", null, null);
        public static final LanguageCodeEntry GEORGIAN = new LanguageCodeEntry(52, "ka", null, null);
        public static final LanguageCodeEntry GERMAN = new LanguageCodeEntry(2, "de", null, null);
        public static final LanguageCodeEntry GREEK = new LanguageCodeEntry(14, "el", null, null);
        public static final LanguageCodeEntry GREEK_POLYTONIC = new LanguageCodeEntry(148, "grc", null, null);
        public static final LanguageCodeEntry GREENLANDIC = new LanguageCodeEntry(149, "kl", null, null);
        public static final LanguageCodeEntry GUARANI = new LanguageCodeEntry(133, "gn", null, null);
        public static final LanguageCodeEntry GUJARATI = new LanguageCodeEntry(69, "gu", null, null);
        public static final LanguageCodeEntry HEBREW = new LanguageCodeEntry(10, "he", null, null);
        public static final LanguageCodeEntry HINDI = new LanguageCodeEntry(21, "hi", null, null);
        public static final LanguageCodeEntry HUNGARIAN = new LanguageCodeEntry(26, "hu", null, null);
        public static final LanguageCodeEntry ICELANDIC = new LanguageCodeEntry(15, "is", null, null);
        public static final LanguageCodeEntry INDONESIAN = new LanguageCodeEntry(81, "id", null, null);
        public static final LanguageCodeEntry INUKTITUT = new LanguageCodeEntry(14, "iu", null, null);
        public static final LanguageCodeEntry IRISH_GAELIC = new LanguageCodeEntry(35, "ga", null, null);
        public static final LanguageCodeEntry IRISH_GAELIC_WITH_DOT_ABOVE = new LanguageCodeEntry(146, "ga", "Latg", null);
        public static final LanguageCodeEntry ITALIAN = new LanguageCodeEntry(3, "it", null, null);
        public static final LanguageCodeEntry JAPANESE = new LanguageCodeEntry(11, "ja", null, null);
        public static final LanguageCodeEntry JAVANESE_ROMAN_SCRIPT = new LanguageCodeEntry(138, "jv", "Latn", null);
        public static final LanguageCodeEntry KANNADA = new LanguageCodeEntry(73, "kn", null, null);
        public static final LanguageCodeEntry KASHMIRI = new LanguageCodeEntry(61, "ks", null, null);
        public static final LanguageCodeEntry KAZAKH = new LanguageCodeEntry(48, "kk", null, null);
        public static final LanguageCodeEntry KHMER = new LanguageCodeEntry(78, "km", null, null);
        public static final LanguageCodeEntry KINYARWANDA_RUANDA = new LanguageCodeEntry(90, "rw", null, null);
        public static final LanguageCodeEntry KIRGHIZ = new LanguageCodeEntry(54, "ky", null, null);
        public static final LanguageCodeEntry KOREAN = new LanguageCodeEntry(23, "ko", null, null);
        public static final LanguageCodeEntry KURDISH = new LanguageCodeEntry(60, "ku", null, null);
        public static final LanguageCodeEntry LAO = new LanguageCodeEntry(79, "lo", null, null);
        public static final LanguageCodeEntry LATIN = new LanguageCodeEntry(131, "la", null, null);
        public static final LanguageCodeEntry LATVIAN = new LanguageCodeEntry(28, "lv", null, null);
        public static final LanguageCodeEntry LITHUANIAN = new LanguageCodeEntry(24, "lt", null, null);
        public static final LanguageCodeEntry MACEDONIAN = new LanguageCodeEntry(43, "mk", null, null);
        public static final LanguageCodeEntry MALAGASY = new LanguageCodeEntry(93, "mg", null, null);
        public static final LanguageCodeEntry MALAY_ARABIC_SCRIPT = new LanguageCodeEntry(84, "ms", "Arab", null);
        public static final LanguageCodeEntry MALAY_ROMAN_SCRIPT = new LanguageCodeEntry(83, "ms", "Latn", null);
        public static final LanguageCodeEntry MALAYALAM = new LanguageCodeEntry(72, "ml", null, null);
        public static final LanguageCodeEntry MALTESE = new LanguageCodeEntry(16, "mt", null, null);
        public static final LanguageCodeEntry MANX_GAELIC = new LanguageCodeEntry(145, "gv", null, null);
        public static final LanguageCodeEntry MARATHI = new LanguageCodeEntry(66, "mr", null, null);
        public static final LanguageCodeEntry MOLDAVIAN = new LanguageCodeEntry(53, "mo", null, null);
        public static final LanguageCodeEntry MONGOLIAN_CYRILLIC_SCRIPT = new LanguageCodeEntry(58, "mn", "Cyrl", null);
        public static final LanguageCodeEntry MONGOLIAN_MONGOLIAN_SCRIPT = new LanguageCodeEntry(57, "mn", "Mong", null);
        public static final LanguageCodeEntry NEPALI = new LanguageCodeEntry(64, "ne", null, null);
        public static final LanguageCodeEntry NORWEGIAN = new LanguageCodeEntry(9, "no", null, null);
        public static final LanguageCodeEntry NYANJA_CHEWA = new LanguageCodeEntry(92, "ny", null, null);
        public static final LanguageCodeEntry ORIYA = new LanguageCodeEntry(71, "or", null, null);
        public static final LanguageCodeEntry PASHTO = new LanguageCodeEntry(59, "ps", null, null);
        public static final LanguageCodeEntry POLISH = new LanguageCodeEntry(25, "pl", null, null);
        public static final LanguageCodeEntry PORTUGUESE = new LanguageCodeEntry(8, "pt", null, null);
        public static final LanguageCodeEntry PUNJABI = new LanguageCodeEntry(70, "pa", null, null);
        public static final LanguageCodeEntry QUENCHUA = new LanguageCodeEntry(132, "qu", null, null);
        public static final LanguageCodeEntry ROMANIAN = new LanguageCodeEntry(37, "ro", null, null);
        public static final LanguageCodeEntry RUNDI = new LanguageCodeEntry(91, "rn", null, null);
        public static final LanguageCodeEntry RUSSIAN = new LanguageCodeEntry(32, "ru", null, null);
        public static final LanguageCodeEntry SAMI = new LanguageCodeEntry(29, "se", null, null);
        public static final LanguageCodeEntry SANSKRIT = new LanguageCodeEntry(65, "sa", null, null);
        public static final LanguageCodeEntry SCOTTISH_GAELIC = new LanguageCodeEntry(144, "gd", null, null);
        public static final LanguageCodeEntry SERBIAN = new LanguageCodeEntry(42, "sr", null, null);
        public static final LanguageCodeEntry SINDHI = new LanguageCodeEntry(62, "sd", null, null);
        public static final LanguageCodeEntry SINHALESE = new LanguageCodeEntry(76, "si", null, null);
        public static final LanguageCodeEntry SLOVAK = new LanguageCodeEntry(39, "sk", null, null);
        public static final LanguageCodeEntry SLOVENIAN = new LanguageCodeEntry(40, "sl", null, null);
        public static final LanguageCodeEntry SOMALI = new LanguageCodeEntry(88, "so", null, null);
        public static final LanguageCodeEntry SPANISH = new LanguageCodeEntry(6, "es", null, null);
        public static final LanguageCodeEntry SUNDANESE_ROMAN_SCRIPT = new LanguageCodeEntry(139, "su", "Latn", null);
        public static final LanguageCodeEntry SWAHILI = new LanguageCodeEntry(89, "sw", null, null);
        public static final LanguageCodeEntry SWEDISH = new LanguageCodeEntry(5, "sv", null, null);
        public static final LanguageCodeEntry TAGALONG = new LanguageCodeEntry(82, "tl", null, null);
        public static final LanguageCodeEntry TAJIKI = new LanguageCodeEntry(55, "tg", null, null);
        public static final LanguageCodeEntry TAMIL = new LanguageCodeEntry(74, "ta", null, null);
        public static final LanguageCodeEntry TATAR = new LanguageCodeEntry(135, "tt", null, null);
        public static final LanguageCodeEntry TELUGU = new LanguageCodeEntry(75, "te", null, null);
        public static final LanguageCodeEntry THAI = new LanguageCodeEntry(22, "th", null, null);
        public static final LanguageCodeEntry TIBETAN = new LanguageCodeEntry(63, "bo", null, null);
        public static final LanguageCodeEntry TIGRINYA = new LanguageCodeEntry(86, "ti", null, null);
        public static final LanguageCodeEntry TONGAN = new LanguageCodeEntry(147, "to", null, null);
        public static final LanguageCodeEntry TURKISH = new LanguageCodeEntry(17, "tr", null, null);
        public static final LanguageCodeEntry TURKMEN = new LanguageCodeEntry(56, "tk", null, null);
        public static final LanguageCodeEntry UIGHUR = new LanguageCodeEntry(136, "ug", null, null);
        public static final LanguageCodeEntry UKRAINIAN = new LanguageCodeEntry(45, "uk", null, null);
        public static final LanguageCodeEntry URDU = new LanguageCodeEntry(20, "ur", null, null);
        public static final LanguageCodeEntry UZBEK = new LanguageCodeEntry(47, "uz", null, null);
        public static final LanguageCodeEntry VIETNAMESE = new LanguageCodeEntry(80, "vi", null, null);
        public static final LanguageCodeEntry WELSH = new LanguageCodeEntry(128, "cy", null, null);
        public static final LanguageCodeEntry YIDDISH = new LanguageCodeEntry(41, "yi", null, null);

        private MacintoshLanguageCode() {
        }

        public static final LanguageCodeEntry getCodeEntry(int n) {
            return (LanguageCodeEntry)LANGUAGE_MAP.get(new Integer(n));
        }

        static {
            LANGUAGE_MAP.put(new Integer(AFRIKAANS.getLanguageCode()), AFRIKAANS);
            LANGUAGE_MAP.put(new Integer(ALBANIAN.getLanguageCode()), ALBANIAN);
            LANGUAGE_MAP.put(new Integer(AMHARIC.getLanguageCode()), AMHARIC);
            LANGUAGE_MAP.put(new Integer(ARABIC.getLanguageCode()), ARABIC);
            LANGUAGE_MAP.put(new Integer(ARMENIAN.getLanguageCode()), ARMENIAN);
            LANGUAGE_MAP.put(new Integer(ASSAMESE.getLanguageCode()), ASSAMESE);
            LANGUAGE_MAP.put(new Integer(AYMARA.getLanguageCode()), AYMARA);
            LANGUAGE_MAP.put(new Integer(AZERBAIJANI_ARABIC_SCRIPT.getLanguageCode()), AZERBAIJANI_ARABIC_SCRIPT);
            LANGUAGE_MAP.put(new Integer(AZERBAIJANI_CYRILLIC_SCRIPT.getLanguageCode()), AZERBAIJANI_CYRILLIC_SCRIPT);
            LANGUAGE_MAP.put(new Integer(AZERBAIJANI_ROMAN_SCRIPT.getLanguageCode()), AZERBAIJANI_ROMAN_SCRIPT);
            LANGUAGE_MAP.put(new Integer(BASQUE.getLanguageCode()), BASQUE);
            LANGUAGE_MAP.put(new Integer(BENGALI.getLanguageCode()), BENGALI);
            LANGUAGE_MAP.put(new Integer(BRETON.getLanguageCode()), BRETON);
            LANGUAGE_MAP.put(new Integer(BULGARIAN.getLanguageCode()), BULGARIAN);
            LANGUAGE_MAP.put(new Integer(BURMESE.getLanguageCode()), BURMESE);
            LANGUAGE_MAP.put(new Integer(BYELORUSSIAN.getLanguageCode()), BYELORUSSIAN);
            LANGUAGE_MAP.put(new Integer(CATALAN.getLanguageCode()), CATALAN);
            LANGUAGE_MAP.put(new Integer(CHINESE_SIMPLIFIED.getLanguageCode()), CHINESE_SIMPLIFIED);
            LANGUAGE_MAP.put(new Integer(CHINESE_TRADITIONAL.getLanguageCode()), CHINESE_TRADITIONAL);
            LANGUAGE_MAP.put(new Integer(CROATIAN.getLanguageCode()), CROATIAN);
            LANGUAGE_MAP.put(new Integer(CZECH.getLanguageCode()), CZECH);
            LANGUAGE_MAP.put(new Integer(DANISH.getLanguageCode()), DANISH);
            LANGUAGE_MAP.put(new Integer(DUTCH.getLanguageCode()), DUTCH);
            LANGUAGE_MAP.put(new Integer(DZONGKHA.getLanguageCode()), DZONGKHA);
            LANGUAGE_MAP.put(new Integer(ENGLISH.getLanguageCode()), ENGLISH);
            LANGUAGE_MAP.put(new Integer(ESPERANTO.getLanguageCode()), ESPERANTO);
            LANGUAGE_MAP.put(new Integer(ESTONIAN.getLanguageCode()), ESTONIAN);
            LANGUAGE_MAP.put(new Integer(FAROESE.getLanguageCode()), FAROESE);
            LANGUAGE_MAP.put(new Integer(FARSI_PERSIAN.getLanguageCode()), FARSI_PERSIAN);
            LANGUAGE_MAP.put(new Integer(FINNISH.getLanguageCode()), FINNISH);
            LANGUAGE_MAP.put(new Integer(FLEMISH.getLanguageCode()), FLEMISH);
            LANGUAGE_MAP.put(new Integer(FRENCH.getLanguageCode()), FRENCH);
            LANGUAGE_MAP.put(new Integer(GALICIAN.getLanguageCode()), GALICIAN);
            LANGUAGE_MAP.put(new Integer(GALLA.getLanguageCode()), GALLA);
            LANGUAGE_MAP.put(new Integer(GEORGIAN.getLanguageCode()), GEORGIAN);
            LANGUAGE_MAP.put(new Integer(GERMAN.getLanguageCode()), GERMAN);
            LANGUAGE_MAP.put(new Integer(GREEK.getLanguageCode()), GREEK);
            LANGUAGE_MAP.put(new Integer(GREEK_POLYTONIC.getLanguageCode()), GREEK_POLYTONIC);
            LANGUAGE_MAP.put(new Integer(GREENLANDIC.getLanguageCode()), GREENLANDIC);
            LANGUAGE_MAP.put(new Integer(GUARANI.getLanguageCode()), GUARANI);
            LANGUAGE_MAP.put(new Integer(GUJARATI.getLanguageCode()), GUJARATI);
            LANGUAGE_MAP.put(new Integer(HEBREW.getLanguageCode()), HEBREW);
            LANGUAGE_MAP.put(new Integer(HINDI.getLanguageCode()), HINDI);
            LANGUAGE_MAP.put(new Integer(HUNGARIAN.getLanguageCode()), HUNGARIAN);
            LANGUAGE_MAP.put(new Integer(ICELANDIC.getLanguageCode()), ICELANDIC);
            LANGUAGE_MAP.put(new Integer(INDONESIAN.getLanguageCode()), INDONESIAN);
            LANGUAGE_MAP.put(new Integer(INUKTITUT.getLanguageCode()), INUKTITUT);
            LANGUAGE_MAP.put(new Integer(IRISH_GAELIC.getLanguageCode()), IRISH_GAELIC);
            LANGUAGE_MAP.put(new Integer(IRISH_GAELIC_WITH_DOT_ABOVE.getLanguageCode()), IRISH_GAELIC_WITH_DOT_ABOVE);
            LANGUAGE_MAP.put(new Integer(ITALIAN.getLanguageCode()), ITALIAN);
            LANGUAGE_MAP.put(new Integer(JAPANESE.getLanguageCode()), JAPANESE);
            LANGUAGE_MAP.put(new Integer(JAVANESE_ROMAN_SCRIPT.getLanguageCode()), JAVANESE_ROMAN_SCRIPT);
            LANGUAGE_MAP.put(new Integer(KANNADA.getLanguageCode()), KANNADA);
            LANGUAGE_MAP.put(new Integer(KASHMIRI.getLanguageCode()), KASHMIRI);
            LANGUAGE_MAP.put(new Integer(KAZAKH.getLanguageCode()), KAZAKH);
            LANGUAGE_MAP.put(new Integer(KHMER.getLanguageCode()), KHMER);
            LANGUAGE_MAP.put(new Integer(KINYARWANDA_RUANDA.getLanguageCode()), KINYARWANDA_RUANDA);
            LANGUAGE_MAP.put(new Integer(KIRGHIZ.getLanguageCode()), KIRGHIZ);
            LANGUAGE_MAP.put(new Integer(KOREAN.getLanguageCode()), KOREAN);
            LANGUAGE_MAP.put(new Integer(KURDISH.getLanguageCode()), KURDISH);
            LANGUAGE_MAP.put(new Integer(LAO.getLanguageCode()), LAO);
            LANGUAGE_MAP.put(new Integer(LATIN.getLanguageCode()), LATIN);
            LANGUAGE_MAP.put(new Integer(LATVIAN.getLanguageCode()), LATVIAN);
            LANGUAGE_MAP.put(new Integer(LITHUANIAN.getLanguageCode()), LITHUANIAN);
            LANGUAGE_MAP.put(new Integer(MACEDONIAN.getLanguageCode()), MACEDONIAN);
            LANGUAGE_MAP.put(new Integer(MALAGASY.getLanguageCode()), MALAGASY);
            LANGUAGE_MAP.put(new Integer(MALAY_ARABIC_SCRIPT.getLanguageCode()), MALAY_ARABIC_SCRIPT);
            LANGUAGE_MAP.put(new Integer(MALAY_ROMAN_SCRIPT.getLanguageCode()), MALAY_ROMAN_SCRIPT);
            LANGUAGE_MAP.put(new Integer(MALAYALAM.getLanguageCode()), MALAYALAM);
            LANGUAGE_MAP.put(new Integer(MALTESE.getLanguageCode()), MALTESE);
            LANGUAGE_MAP.put(new Integer(MANX_GAELIC.getLanguageCode()), MANX_GAELIC);
            LANGUAGE_MAP.put(new Integer(MARATHI.getLanguageCode()), MARATHI);
            LANGUAGE_MAP.put(new Integer(MOLDAVIAN.getLanguageCode()), MOLDAVIAN);
            LANGUAGE_MAP.put(new Integer(MONGOLIAN_CYRILLIC_SCRIPT.getLanguageCode()), MONGOLIAN_CYRILLIC_SCRIPT);
            LANGUAGE_MAP.put(new Integer(MONGOLIAN_MONGOLIAN_SCRIPT.getLanguageCode()), MONGOLIAN_MONGOLIAN_SCRIPT);
            LANGUAGE_MAP.put(new Integer(NEPALI.getLanguageCode()), NEPALI);
            LANGUAGE_MAP.put(new Integer(NORWEGIAN.getLanguageCode()), NORWEGIAN);
            LANGUAGE_MAP.put(new Integer(NYANJA_CHEWA.getLanguageCode()), NYANJA_CHEWA);
            LANGUAGE_MAP.put(new Integer(ORIYA.getLanguageCode()), ORIYA);
            LANGUAGE_MAP.put(new Integer(PASHTO.getLanguageCode()), PASHTO);
            LANGUAGE_MAP.put(new Integer(POLISH.getLanguageCode()), POLISH);
            LANGUAGE_MAP.put(new Integer(PORTUGUESE.getLanguageCode()), PORTUGUESE);
            LANGUAGE_MAP.put(new Integer(PUNJABI.getLanguageCode()), PUNJABI);
            LANGUAGE_MAP.put(new Integer(QUENCHUA.getLanguageCode()), QUENCHUA);
            LANGUAGE_MAP.put(new Integer(ROMANIAN.getLanguageCode()), ROMANIAN);
            LANGUAGE_MAP.put(new Integer(RUNDI.getLanguageCode()), RUNDI);
            LANGUAGE_MAP.put(new Integer(RUSSIAN.getLanguageCode()), RUSSIAN);
            LANGUAGE_MAP.put(new Integer(SAMI.getLanguageCode()), SAMI);
            LANGUAGE_MAP.put(new Integer(SANSKRIT.getLanguageCode()), SANSKRIT);
            LANGUAGE_MAP.put(new Integer(SCOTTISH_GAELIC.getLanguageCode()), SCOTTISH_GAELIC);
            LANGUAGE_MAP.put(new Integer(SERBIAN.getLanguageCode()), SERBIAN);
            LANGUAGE_MAP.put(new Integer(SINDHI.getLanguageCode()), SINDHI);
            LANGUAGE_MAP.put(new Integer(SINHALESE.getLanguageCode()), SINHALESE);
            LANGUAGE_MAP.put(new Integer(SLOVAK.getLanguageCode()), SLOVAK);
            LANGUAGE_MAP.put(new Integer(SLOVENIAN.getLanguageCode()), SLOVENIAN);
            LANGUAGE_MAP.put(new Integer(SOMALI.getLanguageCode()), SOMALI);
            LANGUAGE_MAP.put(new Integer(SPANISH.getLanguageCode()), SPANISH);
            LANGUAGE_MAP.put(new Integer(SUNDANESE_ROMAN_SCRIPT.getLanguageCode()), SUNDANESE_ROMAN_SCRIPT);
            LANGUAGE_MAP.put(new Integer(SWAHILI.getLanguageCode()), SWAHILI);
            LANGUAGE_MAP.put(new Integer(SWEDISH.getLanguageCode()), SWEDISH);
            LANGUAGE_MAP.put(new Integer(TAGALONG.getLanguageCode()), TAGALONG);
            LANGUAGE_MAP.put(new Integer(TAJIKI.getLanguageCode()), TAJIKI);
            LANGUAGE_MAP.put(new Integer(TAMIL.getLanguageCode()), TAMIL);
            LANGUAGE_MAP.put(new Integer(TATAR.getLanguageCode()), TATAR);
            LANGUAGE_MAP.put(new Integer(TELUGU.getLanguageCode()), TELUGU);
            LANGUAGE_MAP.put(new Integer(THAI.getLanguageCode()), THAI);
            LANGUAGE_MAP.put(new Integer(TIBETAN.getLanguageCode()), TIBETAN);
            LANGUAGE_MAP.put(new Integer(TIGRINYA.getLanguageCode()), TIGRINYA);
            LANGUAGE_MAP.put(new Integer(TONGAN.getLanguageCode()), TONGAN);
            LANGUAGE_MAP.put(new Integer(TURKISH.getLanguageCode()), TURKISH);
            LANGUAGE_MAP.put(new Integer(TURKMEN.getLanguageCode()), TURKMEN);
            LANGUAGE_MAP.put(new Integer(UIGHUR.getLanguageCode()), UIGHUR);
            LANGUAGE_MAP.put(new Integer(UKRAINIAN.getLanguageCode()), UKRAINIAN);
            LANGUAGE_MAP.put(new Integer(URDU.getLanguageCode()), URDU);
            LANGUAGE_MAP.put(new Integer(UZBEK.getLanguageCode()), UZBEK);
            LANGUAGE_MAP.put(new Integer(VIETNAMESE.getLanguageCode()), VIETNAMESE);
            LANGUAGE_MAP.put(new Integer(WELSH.getLanguageCode()), WELSH);
            LANGUAGE_MAP.put(new Integer(YIDDISH.getLanguageCode()), YIDDISH);
        }
    }

    public static final class MacintoshEncodingId {
        public static final int ROMAN = 0;
        public static final int JAPANESE = 1;
        public static final int CHINESE_TRADITIONAL = 2;
        public static final int KOREAN = 3;
        public static final int ARABIC = 4;
        public static final int HEBREW = 5;
        public static final int GREEK = 6;
        public static final int RUSSIAN = 7;
        public static final int RSYMBOL = 8;
        public static final int DEVANAGARI = 9;
        public static final int GURMUKHI = 10;
        public static final int GUJARATI = 11;
        public static final int ORIYA = 12;
        public static final int BENGALI = 13;
        public static final int TAMIL = 14;
        public static final int TELUGU = 15;
        public static final int KANNADA = 16;
        public static final int MALAYALAM = 17;
        public static final int SINHALESE = 18;
        public static final int BURMESE = 19;
        public static final int KHMER = 20;
        public static final int THAI = 21;
        public static final int LAOTIAN = 22;
        public static final int GEORGIAN = 23;
        public static final int ARMENIAN = 24;
        public static final int CHINESE_SIMPLIFIED = 25;
        public static final int TIBETAN = 26;
        public static final int MONGOLIAN = 27;
        public static final int GEEZ = 28;
        public static final int SLAVIC = 29;
        public static final int VIETNAMESE = 30;
        public static final int SINDHI = 31;

        private MacintoshEncodingId() {
        }
    }

    public static final class MicrosoftLCID {
        private static final Map LCID_MAP = new HashMap(250);
        public static final LanguageCodeEntry AFRIKAANS_SOUTH_AFRICA = new LanguageCodeEntry(1078, "af", null, "ZA");
        public static final LanguageCodeEntry ALBANIAN_ALBANIA = new LanguageCodeEntry(1052, "sq", null, "AL");
        public static final LanguageCodeEntry ALSATIAN_FRANCE = new LanguageCodeEntry(1156, "gsw", null, "FR");
        public static final LanguageCodeEntry AMHARIC_ETHIOPIA = new LanguageCodeEntry(1118, "am", null, "ET");
        public static final LanguageCodeEntry ARABIC_ALGERIA = new LanguageCodeEntry(5121, "ar", null, "DZ");
        public static final LanguageCodeEntry ARABIC_BAHRAIN = new LanguageCodeEntry(15361, "ar", null, "BH");
        public static final LanguageCodeEntry ARABIC_EGYPT = new LanguageCodeEntry(3073, "ar", null, "EG");
        public static final LanguageCodeEntry ARABIC_IRAQ = new LanguageCodeEntry(2049, "ar", null, "IQ");
        public static final LanguageCodeEntry ARABIC_JORDAN = new LanguageCodeEntry(11265, "ar", null, "JO");
        public static final LanguageCodeEntry ARABIC_KUWAIT = new LanguageCodeEntry(13313, "ar", null, "KW");
        public static final LanguageCodeEntry ARABIC_LEBANON = new LanguageCodeEntry(12289, "ar", null, "LB");
        public static final LanguageCodeEntry ARABIC_LIBYA = new LanguageCodeEntry(4097, "ar", null, "LY");
        public static final LanguageCodeEntry ARABIC_MOROCCO = new LanguageCodeEntry(6145, "ar", null, "MA");
        public static final LanguageCodeEntry ARABIC_OMAN = new LanguageCodeEntry(8193, "ar", null, "OM");
        public static final LanguageCodeEntry ARABIC_QATAR = new LanguageCodeEntry(16385, "ar", null, "QA");
        public static final LanguageCodeEntry ARABIC_SAUDI_ARABIA = new LanguageCodeEntry(1025, "ar", null, "SA");
        public static final LanguageCodeEntry ARABIC_SYRIA = new LanguageCodeEntry(10241, "ar", null, "SY");
        public static final LanguageCodeEntry ARABIC_TUNISIA = new LanguageCodeEntry(7169, "ar", null, "TN");
        public static final LanguageCodeEntry ARABIC_UAE = new LanguageCodeEntry(14337, "ar", null, "AE");
        public static final LanguageCodeEntry ARABIC_YEMEN = new LanguageCodeEntry(9217, "ar", null, "YE");
        public static final LanguageCodeEntry ARMENIAN_ARMENIA = new LanguageCodeEntry(1067, "hy", null, "AM");
        public static final LanguageCodeEntry ASSAMESE_INDIA = new LanguageCodeEntry(1101, "as", null, "IN");
        public static final LanguageCodeEntry AZERI_CYRILLIC_AZERBAIJAN = new LanguageCodeEntry(2092, "az", "Cyrl", "AZ");
        public static final LanguageCodeEntry AZERI_LATIN_AZERBAIJAN = new LanguageCodeEntry(1068, "az", "Latn", "AZ");
        public static final LanguageCodeEntry BASHKIR_RUSSIA = new LanguageCodeEntry(1133, "ba", null, "RU");
        public static final LanguageCodeEntry BASQUE_BASQUE = new LanguageCodeEntry(1069, "eu", null, "ES");
        public static final LanguageCodeEntry BELARUSIAN_BELARUS = new LanguageCodeEntry(1059, "be", null, "BY");
        public static final LanguageCodeEntry BENGALI_BANGLADESH = new LanguageCodeEntry(2117, "bn", null, "BD");
        public static final LanguageCodeEntry BENGALI_INDIA = new LanguageCodeEntry(1093, "bn", null, "IN");
        public static final LanguageCodeEntry BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = new LanguageCodeEntry(8218, "bs", "Cyrl", "BA");
        public static final LanguageCodeEntry BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA = new LanguageCodeEntry(5146, "bs", "Latn", "BA");
        public static final LanguageCodeEntry BRETON_FRANCE = new LanguageCodeEntry(1150, "br", null, "FR");
        public static final LanguageCodeEntry BULGARIAN_BULGARIA = new LanguageCodeEntry(1026, "bg", null, "BG");
        public static final LanguageCodeEntry CATALAN_CATALAN = new LanguageCodeEntry(1027, "ca", null, "ES");
        public static final LanguageCodeEntry CHINESE_HONG_KONG = new LanguageCodeEntry(3076, "zh", null, "HK");
        public static final LanguageCodeEntry CHINESE_MACAO = new LanguageCodeEntry(5124, "zh", null, "MO");
        public static final LanguageCodeEntry CHINESE_PRC = new LanguageCodeEntry(2052, "zh", null, "CN");
        public static final LanguageCodeEntry CHINESE_SINGAPORE = new LanguageCodeEntry(4100, "zh", null, "SG");
        public static final LanguageCodeEntry CHINESE_TAIWAN = new LanguageCodeEntry(1028, "zh", null, "TW");
        public static final LanguageCodeEntry CORSICAN_FRANCE = new LanguageCodeEntry(1155, "co", null, "FR");
        public static final LanguageCodeEntry CROATIAN_CROATIA = new LanguageCodeEntry(1050, "hr", null, "HR");
        public static final LanguageCodeEntry CROATIAN_LATIN_BOSNIA_AND_HERZEGOVINA = new LanguageCodeEntry(4122, "hr", null, "BA");
        public static final LanguageCodeEntry CZECH_CZECH_REPUBLIC = new LanguageCodeEntry(1029, "cs", null, "CZ");
        public static final LanguageCodeEntry DANISH_DENMARK = new LanguageCodeEntry(1030, "da", null, "DK");
        public static final LanguageCodeEntry DARI_AFGHANISTAN = new LanguageCodeEntry(1164, "fa", null, "AF");
        public static final LanguageCodeEntry DIVEHI_MALDIVES = new LanguageCodeEntry(1125, "dv", null, "MV");
        public static final LanguageCodeEntry DUTCH_BELGIUM = new LanguageCodeEntry(2067, "nl", null, "BE");
        public static final LanguageCodeEntry DUTCH_NETHERLANDS = new LanguageCodeEntry(1043, "nl", null, "NL");
        public static final LanguageCodeEntry ENGLISH_AUSTRALIA = new LanguageCodeEntry(3081, "en", null, "AU");
        public static final LanguageCodeEntry ENGLISH_BELIZE = new LanguageCodeEntry(10249, "en", null, "BZ");
        public static final LanguageCodeEntry ENGLISH_CANADA = new LanguageCodeEntry(4105, "en", null, "CA");
        public static final LanguageCodeEntry ENGLISH_CARIBBEAN = new LanguageCodeEntry(9225, "en", null, "029");
        public static final LanguageCodeEntry ENGLISH_INDIA = new LanguageCodeEntry(16393, "en", null, "IN");
        public static final LanguageCodeEntry ENGLISH_IRELAND = new LanguageCodeEntry(6153, "en", null, "IE");
        public static final LanguageCodeEntry ENGLISH_JAMAICA = new LanguageCodeEntry(8201, "en", null, "JM");
        public static final LanguageCodeEntry ENGLISH_MALAYSIA = new LanguageCodeEntry(17417, "en", null, "MY");
        public static final LanguageCodeEntry ENGLISH_NEW_ZEALAND = new LanguageCodeEntry(5129, "en", null, "NZ");
        public static final LanguageCodeEntry ENGLISH_PHILIPPINES = new LanguageCodeEntry(13321, "en", null, "PH");
        public static final LanguageCodeEntry ENGLISH_SINGAPORE = new LanguageCodeEntry(18441, "en", null, "SG");
        public static final LanguageCodeEntry ENGLISH_SOUTH_AFRICA = new LanguageCodeEntry(7177, "en", null, "ZA");
        public static final LanguageCodeEntry ENGLISH_TRINIDAD_AND_TOBAGO = new LanguageCodeEntry(11273, "en", null, "TT");
        public static final LanguageCodeEntry ENGLISH_UNITED_KINGDOM = new LanguageCodeEntry(2057, "en", null, "GB");
        public static final LanguageCodeEntry ENGLISH_UNITED_STATES = new LanguageCodeEntry(1033, "en", null, "US");
        public static final LanguageCodeEntry ENGLISH_ZIMBABWE = new LanguageCodeEntry(12297, "en", null, "ZW");
        public static final LanguageCodeEntry ESTONIAN_ESTONIA = new LanguageCodeEntry(1061, "et", null, "EE");
        public static final LanguageCodeEntry FAROESE_FAROE_ISLANDS = new LanguageCodeEntry(1080, "fo", null, "FO");
        public static final LanguageCodeEntry FILIPINO_PHILIPPINES = new LanguageCodeEntry(1124, "fil", null, "PH");
        public static final LanguageCodeEntry FINNISH_FINLAND = new LanguageCodeEntry(1035, "fil", null, "FI");
        public static final LanguageCodeEntry FRENCH_BELGIUM = new LanguageCodeEntry(2060, "fr", null, "BE");
        public static final LanguageCodeEntry FRENCH_CANADA = new LanguageCodeEntry(3084, "fr", null, "CA");
        public static final LanguageCodeEntry FRENCH_FRANCE = new LanguageCodeEntry(1036, "fr", null, "FR");
        public static final LanguageCodeEntry FRENCH_LUXEMBOURG = new LanguageCodeEntry(5132, "fr", null, "LU");
        public static final LanguageCodeEntry FRENCH_MONOCO = new LanguageCodeEntry(6156, "fr", null, "MC");
        public static final LanguageCodeEntry FRENCH_SWITZERLAND = new LanguageCodeEntry(4108, "fr", null, "CH");
        public static final LanguageCodeEntry FRISIAN_NETHERLANDS = new LanguageCodeEntry(1122, "fy", null, "NL");
        public static final LanguageCodeEntry GALICIAN_GALICIAN = new LanguageCodeEntry(1110, "gl", null, "ES");
        public static final LanguageCodeEntry GEORGIAN_GEORGIA = new LanguageCodeEntry(1079, "ka", null, "GE");
        public static final LanguageCodeEntry GERMAN_AUSTRIA = new LanguageCodeEntry(3079, "de", null, "AT");
        public static final LanguageCodeEntry GERMAN_GERMANY = new LanguageCodeEntry(1031, "de", null, "DE");
        public static final LanguageCodeEntry GERMAN_LIECHTENSTEIN = new LanguageCodeEntry(5127, "de", null, "LI");
        public static final LanguageCodeEntry GERMAN_LUXEMBOURG = new LanguageCodeEntry(4103, "de", null, "LU");
        public static final LanguageCodeEntry GERMAN_SWITZERLAND = new LanguageCodeEntry(2055, "de", null, "CH");
        public static final LanguageCodeEntry GREEK_GREECE = new LanguageCodeEntry(1032, "el", null, "GR");
        public static final LanguageCodeEntry GREENLANDIC_GREENLAND = new LanguageCodeEntry(1135, "kl", null, "GL");
        public static final LanguageCodeEntry GUJARATI_INDIA = new LanguageCodeEntry(1095, "gu", null, "IN");
        public static final LanguageCodeEntry HAUSA_LATIN_NIGERIA = new LanguageCodeEntry(1128, "ha", null, "NG");
        public static final LanguageCodeEntry HEBREW_ISRAEL = new LanguageCodeEntry(1037, "he", null, "IL");
        public static final LanguageCodeEntry HINDI_INDIA = new LanguageCodeEntry(1081, "hi", null, "IN");
        public static final LanguageCodeEntry HUNGARIAN_HUNGARY = new LanguageCodeEntry(1038, "hu", null, "HU");
        public static final LanguageCodeEntry ICELANDIC_ICELAND = new LanguageCodeEntry(1039, "is", null, "IS");
        public static final LanguageCodeEntry IGBO_NIGERIA = new LanguageCodeEntry(1136, "ig", null, "NG");
        public static final LanguageCodeEntry INDONESIAN_INDONESIA = new LanguageCodeEntry(1057, "id", null, "ID");
        public static final LanguageCodeEntry INUKTITUT_CANADA = new LanguageCodeEntry(1117, "iu", null, "CA");
        public static final LanguageCodeEntry INUKTITUT_LATIN_CANADA = new LanguageCodeEntry(2141, "iu", "Latn", "CA");
        public static final LanguageCodeEntry IRISH_IRELAND = new LanguageCodeEntry(2108, "ga", null, "IE");
        public static final LanguageCodeEntry ISIXHOSA_SOUTH_AFRICA = new LanguageCodeEntry(1076, "xh", null, "ZA");
        public static final LanguageCodeEntry ISIZULU_SOUTH_AFRICA = new LanguageCodeEntry(1077, "zu", null, "ZA");
        public static final LanguageCodeEntry ITALIAN_ITALY = new LanguageCodeEntry(1040, "it", null, "IT");
        public static final LanguageCodeEntry ITALIAN_SWITZERLAND = new LanguageCodeEntry(2064, "it", null, "CH");
        public static final LanguageCodeEntry JAPANESE_JAPAN = new LanguageCodeEntry(1041, "ja", null, "JP");
        public static final LanguageCodeEntry KICHE_GUATEMALA = new LanguageCodeEntry(1158, "qut", null, "GT");
        public static final LanguageCodeEntry KANNADA_INDIA = new LanguageCodeEntry(1099, "kn", null, "IN");
        public static final LanguageCodeEntry KAZAKH_KAZAKHSTAN = new LanguageCodeEntry(1087, "kk", null, "KZ");
        public static final LanguageCodeEntry KHMER_CAMBODIA = new LanguageCodeEntry(1107, "km", null, "KH");
        public static final LanguageCodeEntry KINYARWANDA_RWANDA = new LanguageCodeEntry(1159, "rw", null, "RW");
        public static final LanguageCodeEntry KISWAHILI_KENYA = new LanguageCodeEntry(1089, "sw", null, "KE");
        public static final LanguageCodeEntry KONKANI_INDIA = new LanguageCodeEntry(1111, "kok", null, "IN");
        public static final LanguageCodeEntry KOREAN_KOREA = new LanguageCodeEntry(1042, "ko", null, "KR");
        public static final LanguageCodeEntry KYRGYZ_KYRGYZSTAN = new LanguageCodeEntry(1088, "ky", null, "KG");
        public static final LanguageCodeEntry LAO_LAOS = new LanguageCodeEntry(1108, "lo", null, "LA");
        public static final LanguageCodeEntry LATVIAN_LATVIA = new LanguageCodeEntry(1062, "lv", null, "LV");
        public static final LanguageCodeEntry LITHUANIAN_LITHUANIA = new LanguageCodeEntry(1063, "lt", null, "LT");
        public static final LanguageCodeEntry LOWER_SORBIAN_GERMANY = new LanguageCodeEntry(2094, "dsb", null, "DE");
        public static final LanguageCodeEntry LUXEMBOURGISH_LUXEMBOURG = new LanguageCodeEntry(1134, "lb", null, "LU");
        public static final LanguageCodeEntry MACEDONIAN_MACEDONIA = new LanguageCodeEntry(1071, "mk", null, "MK");
        public static final LanguageCodeEntry MALAY_BRUNEI = new LanguageCodeEntry(2110, "ms", null, "BN");
        public static final LanguageCodeEntry MALAY_MALAYSIA = new LanguageCodeEntry(1086, "ms", null, "MY");
        public static final LanguageCodeEntry MALAYALAM_INDIA = new LanguageCodeEntry(1100, "ml", null, "IN");
        public static final LanguageCodeEntry MALTESE_MALTA = new LanguageCodeEntry(1082, "mt", null, "MT");
        public static final LanguageCodeEntry MAORI_NEW_ZEALAND = new LanguageCodeEntry(1153, "mi", null, "NZ");
        public static final LanguageCodeEntry MAPUDUNGUN_CHILE = new LanguageCodeEntry(1146, "arn", null, "CL");
        public static final LanguageCodeEntry MARATHI_INDIA = new LanguageCodeEntry(1102, "mr", null, "IN");
        public static final LanguageCodeEntry MOHAWK_MOHAWK = new LanguageCodeEntry(1148, "moh", null, "CA");
        public static final LanguageCodeEntry MONGOLIAN_CYRILLIC_MONGOLIA = new LanguageCodeEntry(1104, "mn", null, "MN");
        public static final LanguageCodeEntry MONGOLIAN_TRADITIONAL_PRC = new LanguageCodeEntry(2128, "mn", null, "CN");
        public static final LanguageCodeEntry NEPALI_NEPAL = new LanguageCodeEntry(1121, "ne", null, "NP");
        public static final LanguageCodeEntry NORWEGIAN_BOKMAL_NORWAY = new LanguageCodeEntry(1044, "nb", null, "NO");
        public static final LanguageCodeEntry NORWEGIAN_NYNORSK_NORWAY = new LanguageCodeEntry(2068, "nn", null, "NO");
        public static final LanguageCodeEntry OCCITAN_FRANCE = new LanguageCodeEntry(1154, "oc", null, "FR");
        public static final LanguageCodeEntry ORIYA_INDIA = new LanguageCodeEntry(1096, "or", null, "IN");
        public static final LanguageCodeEntry PASHTO_AFGHANISTAN = new LanguageCodeEntry(1123, "ps", null, "AF");
        public static final LanguageCodeEntry POLISH_POLAND = new LanguageCodeEntry(1045, "pl", null, "PL");
        public static final LanguageCodeEntry PORTUGUESE_BRAZIL = new LanguageCodeEntry(1046, "pt", null, "BR");
        public static final LanguageCodeEntry PORTUGUESE_PORTUGAL = new LanguageCodeEntry(2070, "pt", null, "PT");
        public static final LanguageCodeEntry PUNJABI_INDIA = new LanguageCodeEntry(1094, "pa", null, "IN");
        public static final LanguageCodeEntry QUECHUA_BOLIVIA = new LanguageCodeEntry(1131, "qu", null, "BO");
        public static final LanguageCodeEntry QUECHUA_ECUADOR = new LanguageCodeEntry(2155, "qu", null, "EC");
        public static final LanguageCodeEntry QUECHUA_PERU = new LanguageCodeEntry(3179, "qu", null, "PE");
        public static final LanguageCodeEntry ROMANIAN_ROMANIA = new LanguageCodeEntry(1048, "ro", null, "RO");
        public static final LanguageCodeEntry ROMANSH_SWITZERLAND = new LanguageCodeEntry(1047, "rm", null, "CH");
        public static final LanguageCodeEntry RUSSIAN_RUSSIA = new LanguageCodeEntry(1049, "ru", null, "RU");
        public static final LanguageCodeEntry SAMI_INARI_FINLAND = new LanguageCodeEntry(9275, "smn", null, "FI");
        public static final LanguageCodeEntry SAMI_LULE_NORWAY = new LanguageCodeEntry(4155, "smj", null, "NO");
        public static final LanguageCodeEntry SAMI_LULE_SWEDEN = new LanguageCodeEntry(5179, "smj", null, "SE");
        public static final LanguageCodeEntry SAMI_NORTHERN_FINLAND = new LanguageCodeEntry(3131, "se", null, "FI");
        public static final LanguageCodeEntry SAMI_NORTHERN_NORWAY = new LanguageCodeEntry(1083, "se", null, "NO");
        public static final LanguageCodeEntry SAMI_NORTHERN_SWEDEN = new LanguageCodeEntry(2107, "se", null, "SE");
        public static final LanguageCodeEntry SAMI_SKOLT_FINLAND = new LanguageCodeEntry(8251, "sms", null, "FI");
        public static final LanguageCodeEntry SAMI_SOUTHERN_NORWAY = new LanguageCodeEntry(6203, "sma", null, "NO");
        public static final LanguageCodeEntry SAMI_SOUTHERN_SWEDEN = new LanguageCodeEntry(7227, "sma", null, "SE");
        public static final LanguageCodeEntry SANSKRIT_INDIA = new LanguageCodeEntry(1103, "sa", null, "IN");
        public static final LanguageCodeEntry SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA = new LanguageCodeEntry(7194, "sr", "Cyrl", "BA");
        public static final LanguageCodeEntry SERBIAN_CYRILLIC_SERBIA = new LanguageCodeEntry(3098, "sr", "Cyrl", "RS");
        public static final LanguageCodeEntry SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA = new LanguageCodeEntry(6170, "sr", "Latn", "BA");
        public static final LanguageCodeEntry SERBIAN_LATIN_SERBIA = new LanguageCodeEntry(2074, "sr", "Latn", "RS");
        public static final LanguageCodeEntry SESOTHO_SA_LEBOA_SOUTH_AFRICA = new LanguageCodeEntry(1132, "nso", null, "ZA");
        public static final LanguageCodeEntry SETSWANA_SOUTH_AFRICA = new LanguageCodeEntry(1074, "tn", null, "ZA");
        public static final LanguageCodeEntry SINHALA_SRI_LANKA = new LanguageCodeEntry(1115, "si", null, "LK");
        public static final LanguageCodeEntry SLOVAK_SLOVAKIA = new LanguageCodeEntry(1051, "sk", null, "SK");
        public static final LanguageCodeEntry SLOVENIAN_SLOVENIA = new LanguageCodeEntry(1060, "sl", null, "SI");
        public static final LanguageCodeEntry SPANISH_ARGENTINA = new LanguageCodeEntry(11274, "es", null, "AR");
        public static final LanguageCodeEntry SPANISH_BOLIVIA = new LanguageCodeEntry(16394, "es", null, "BO");
        public static final LanguageCodeEntry SPANISH_CHILE = new LanguageCodeEntry(13322, "es", null, "CL");
        public static final LanguageCodeEntry SPANISH_COLOMBIA = new LanguageCodeEntry(9226, "es", null, "CO");
        public static final LanguageCodeEntry SPANISH_COSTA_RICA = new LanguageCodeEntry(5130, "es", null, "CR");
        public static final LanguageCodeEntry SPANISH_DOMINICAN_REPUBLIC = new LanguageCodeEntry(7178, "es", null, "DO");
        public static final LanguageCodeEntry SPANISH_ECUADOR = new LanguageCodeEntry(12298, "es", null, "EC");
        public static final LanguageCodeEntry SPANISH_EL_SALVADOR = new LanguageCodeEntry(17418, "es", null, "SV");
        public static final LanguageCodeEntry SPANISH_GUATEMALA = new LanguageCodeEntry(4106, "es", null, "GT");
        public static final LanguageCodeEntry SPANISH_HONDURAS = new LanguageCodeEntry(18442, "es", null, "HN");
        public static final LanguageCodeEntry SPANISH_MEXICO = new LanguageCodeEntry(2058, "es", null, "MX");
        public static final LanguageCodeEntry SPANISH_NICARAGUA = new LanguageCodeEntry(19466, "es", null, "NI");
        public static final LanguageCodeEntry SPANISH_PANAMA = new LanguageCodeEntry(6154, "es", null, "PA");
        public static final LanguageCodeEntry SPANISH_PARAGUAY = new LanguageCodeEntry(15370, "es", null, "PY");
        public static final LanguageCodeEntry SPANISH_PERU = new LanguageCodeEntry(10250, "es", null, "PE");
        public static final LanguageCodeEntry SPANISH_PUERTO_RICO = new LanguageCodeEntry(20490, "es", null, "PR");
        public static final LanguageCodeEntry SPANISH_SPAIN = new LanguageCodeEntry(3082, "es", null, "ES");
        public static final LanguageCodeEntry SPANISH_SPAIN_TRADITIONAL = new LanguageCodeEntry(1034, "es", null, "ES", "TRADITIONAL");
        public static final LanguageCodeEntry SPANISH_UNITED_STATES = new LanguageCodeEntry(21514, "es", null, "US");
        public static final LanguageCodeEntry SPANISH_URUGUAY = new LanguageCodeEntry(14346, "es", null, "UY");
        public static final LanguageCodeEntry SPANISH_VENEZUELA = new LanguageCodeEntry(8202, "es", null, "VE");
        public static final LanguageCodeEntry SWEDISH_FINLAND = new LanguageCodeEntry(2077, "sv", null, "FI");
        public static final LanguageCodeEntry SWEDISH_SWEDEN = new LanguageCodeEntry(1053, "sv", null, "SE");
        public static final LanguageCodeEntry SYRIAC_SYRIA = new LanguageCodeEntry(1114, "syr", null, "SY");
        public static final LanguageCodeEntry TAJIK_CYRILLIC_TAJIKISTAN = new LanguageCodeEntry(1064, "tg", "Cyrl", "TJ");
        public static final LanguageCodeEntry TAMAZIGHT_LATIN_ALGERIA = new LanguageCodeEntry(2143, "ber", "Latn", "DZ");
        public static final LanguageCodeEntry TAMIL_INDIA = new LanguageCodeEntry(1097, "ta", null, "IN");
        public static final LanguageCodeEntry TATAR_RUSSIA = new LanguageCodeEntry(1092, "tt", null, "RU");
        public static final LanguageCodeEntry TELUGU_INDIA = new LanguageCodeEntry(1098, "te", null, "IN");
        public static final LanguageCodeEntry THAI_THAILAND = new LanguageCodeEntry(1054, "th", null, "TH");
        public static final LanguageCodeEntry TIBETAN_PRC = new LanguageCodeEntry(1105, "bo", null, "CN");
        public static final LanguageCodeEntry TURKISH_TURKEY = new LanguageCodeEntry(1055, "tr", null, "TR");
        public static final LanguageCodeEntry TURKMEN_TURKMENISTAN = new LanguageCodeEntry(1090, "tk", null, "TM");
        public static final LanguageCodeEntry UIGHUR_PRC = new LanguageCodeEntry(1152, "ug", null, "CN");
        public static final LanguageCodeEntry UKRAINIAN_UKRAINE = new LanguageCodeEntry(1058, "uk", null, "UA");
        public static final LanguageCodeEntry UPPER_SORBIAN_GERMANY = new LanguageCodeEntry(1070, "wen", null, "DE");
        public static final LanguageCodeEntry URDU_PAKISTAN = new LanguageCodeEntry(1056, "ur", null, "PK");
        public static final LanguageCodeEntry UZBEK_CYRILLIC_UZBEKISTAN = new LanguageCodeEntry(2115, "uz", "Cyrl", "UZ");
        public static final LanguageCodeEntry UZBEK_LATIN_UZBEKISTAN = new LanguageCodeEntry(1091, "uz", "Latn", "UZ");
        public static final LanguageCodeEntry VIETNAMESE_VIETNAM = new LanguageCodeEntry(1066, "vi", null, "VN");
        public static final LanguageCodeEntry WELSH_UNITED_KINGDOM = new LanguageCodeEntry(1106, "cy", null, "GB");
        public static final LanguageCodeEntry WOLOF_SENEGAL = new LanguageCodeEntry(1096, "wo", null, "SN");
        public static final LanguageCodeEntry YAKUT_RUSSIA = new LanguageCodeEntry(1157, "sah", null, "RU");

        private MicrosoftLCID() {
        }

        public static final LanguageCodeEntry getCodeEntry(int n) {
            return (LanguageCodeEntry)LCID_MAP.get(new Integer(n));
        }

        static {
            LCID_MAP.put(new Integer(AFRIKAANS_SOUTH_AFRICA.getLanguageCode()), AFRIKAANS_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(ALBANIAN_ALBANIA.getLanguageCode()), ALBANIAN_ALBANIA);
            LCID_MAP.put(new Integer(ALSATIAN_FRANCE.getLanguageCode()), ALSATIAN_FRANCE);
            LCID_MAP.put(new Integer(AMHARIC_ETHIOPIA.getLanguageCode()), AMHARIC_ETHIOPIA);
            LCID_MAP.put(new Integer(ARABIC_ALGERIA.getLanguageCode()), ARABIC_ALGERIA);
            LCID_MAP.put(new Integer(ARABIC_BAHRAIN.getLanguageCode()), ARABIC_BAHRAIN);
            LCID_MAP.put(new Integer(ARABIC_EGYPT.getLanguageCode()), ARABIC_EGYPT);
            LCID_MAP.put(new Integer(ARABIC_IRAQ.getLanguageCode()), ARABIC_IRAQ);
            LCID_MAP.put(new Integer(ARABIC_JORDAN.getLanguageCode()), ARABIC_JORDAN);
            LCID_MAP.put(new Integer(ARABIC_KUWAIT.getLanguageCode()), ARABIC_KUWAIT);
            LCID_MAP.put(new Integer(ARABIC_LEBANON.getLanguageCode()), ARABIC_LEBANON);
            LCID_MAP.put(new Integer(ARABIC_LIBYA.getLanguageCode()), ARABIC_LIBYA);
            LCID_MAP.put(new Integer(ARABIC_MOROCCO.getLanguageCode()), ARABIC_MOROCCO);
            LCID_MAP.put(new Integer(ARABIC_OMAN.getLanguageCode()), ARABIC_OMAN);
            LCID_MAP.put(new Integer(ARABIC_QATAR.getLanguageCode()), ARABIC_QATAR);
            LCID_MAP.put(new Integer(ARABIC_SAUDI_ARABIA.getLanguageCode()), ARABIC_SAUDI_ARABIA);
            LCID_MAP.put(new Integer(ARABIC_SYRIA.getLanguageCode()), ARABIC_SYRIA);
            LCID_MAP.put(new Integer(ARABIC_TUNISIA.getLanguageCode()), ARABIC_TUNISIA);
            LCID_MAP.put(new Integer(ARABIC_UAE.getLanguageCode()), ARABIC_UAE);
            LCID_MAP.put(new Integer(ARABIC_YEMEN.getLanguageCode()), ARABIC_YEMEN);
            LCID_MAP.put(new Integer(ARMENIAN_ARMENIA.getLanguageCode()), ARMENIAN_ARMENIA);
            LCID_MAP.put(new Integer(ASSAMESE_INDIA.getLanguageCode()), ASSAMESE_INDIA);
            LCID_MAP.put(new Integer(AZERI_CYRILLIC_AZERBAIJAN.getLanguageCode()), AZERI_CYRILLIC_AZERBAIJAN);
            LCID_MAP.put(new Integer(AZERI_LATIN_AZERBAIJAN.getLanguageCode()), AZERI_LATIN_AZERBAIJAN);
            LCID_MAP.put(new Integer(BASHKIR_RUSSIA.getLanguageCode()), BASHKIR_RUSSIA);
            LCID_MAP.put(new Integer(BASQUE_BASQUE.getLanguageCode()), BASQUE_BASQUE);
            LCID_MAP.put(new Integer(BELARUSIAN_BELARUS.getLanguageCode()), BELARUSIAN_BELARUS);
            LCID_MAP.put(new Integer(BENGALI_BANGLADESH.getLanguageCode()), BENGALI_BANGLADESH);
            LCID_MAP.put(new Integer(BENGALI_INDIA.getLanguageCode()), BENGALI_INDIA);
            LCID_MAP.put(new Integer(BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA.getLanguageCode()), BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA);
            LCID_MAP.put(new Integer(BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA.getLanguageCode()), BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA);
            LCID_MAP.put(new Integer(BRETON_FRANCE.getLanguageCode()), BRETON_FRANCE);
            LCID_MAP.put(new Integer(BULGARIAN_BULGARIA.getLanguageCode()), BULGARIAN_BULGARIA);
            LCID_MAP.put(new Integer(CATALAN_CATALAN.getLanguageCode()), CATALAN_CATALAN);
            LCID_MAP.put(new Integer(CHINESE_HONG_KONG.getLanguageCode()), CHINESE_HONG_KONG);
            LCID_MAP.put(new Integer(CHINESE_MACAO.getLanguageCode()), CHINESE_MACAO);
            LCID_MAP.put(new Integer(CHINESE_PRC.getLanguageCode()), CHINESE_PRC);
            LCID_MAP.put(new Integer(CHINESE_SINGAPORE.getLanguageCode()), CHINESE_SINGAPORE);
            LCID_MAP.put(new Integer(CHINESE_TAIWAN.getLanguageCode()), CHINESE_TAIWAN);
            LCID_MAP.put(new Integer(CORSICAN_FRANCE.getLanguageCode()), CORSICAN_FRANCE);
            LCID_MAP.put(new Integer(CROATIAN_CROATIA.getLanguageCode()), CROATIAN_CROATIA);
            LCID_MAP.put(new Integer(CROATIAN_LATIN_BOSNIA_AND_HERZEGOVINA.getLanguageCode()), CROATIAN_LATIN_BOSNIA_AND_HERZEGOVINA);
            LCID_MAP.put(new Integer(CZECH_CZECH_REPUBLIC.getLanguageCode()), CZECH_CZECH_REPUBLIC);
            LCID_MAP.put(new Integer(DANISH_DENMARK.getLanguageCode()), DANISH_DENMARK);
            LCID_MAP.put(new Integer(DARI_AFGHANISTAN.getLanguageCode()), DARI_AFGHANISTAN);
            LCID_MAP.put(new Integer(DIVEHI_MALDIVES.getLanguageCode()), DIVEHI_MALDIVES);
            LCID_MAP.put(new Integer(DUTCH_BELGIUM.getLanguageCode()), DUTCH_BELGIUM);
            LCID_MAP.put(new Integer(DUTCH_NETHERLANDS.getLanguageCode()), DUTCH_NETHERLANDS);
            LCID_MAP.put(new Integer(ENGLISH_AUSTRALIA.getLanguageCode()), ENGLISH_AUSTRALIA);
            LCID_MAP.put(new Integer(ENGLISH_BELIZE.getLanguageCode()), ENGLISH_BELIZE);
            LCID_MAP.put(new Integer(ENGLISH_CANADA.getLanguageCode()), ENGLISH_CANADA);
            LCID_MAP.put(new Integer(ENGLISH_CARIBBEAN.getLanguageCode()), ENGLISH_CARIBBEAN);
            LCID_MAP.put(new Integer(ENGLISH_INDIA.getLanguageCode()), ENGLISH_INDIA);
            LCID_MAP.put(new Integer(ENGLISH_IRELAND.getLanguageCode()), ENGLISH_IRELAND);
            LCID_MAP.put(new Integer(ENGLISH_JAMAICA.getLanguageCode()), ENGLISH_JAMAICA);
            LCID_MAP.put(new Integer(ENGLISH_MALAYSIA.getLanguageCode()), ENGLISH_MALAYSIA);
            LCID_MAP.put(new Integer(ENGLISH_NEW_ZEALAND.getLanguageCode()), ENGLISH_NEW_ZEALAND);
            LCID_MAP.put(new Integer(ENGLISH_PHILIPPINES.getLanguageCode()), ENGLISH_PHILIPPINES);
            LCID_MAP.put(new Integer(ENGLISH_SINGAPORE.getLanguageCode()), ENGLISH_SINGAPORE);
            LCID_MAP.put(new Integer(ENGLISH_SOUTH_AFRICA.getLanguageCode()), ENGLISH_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(ENGLISH_TRINIDAD_AND_TOBAGO.getLanguageCode()), ENGLISH_TRINIDAD_AND_TOBAGO);
            LCID_MAP.put(new Integer(ENGLISH_UNITED_KINGDOM.getLanguageCode()), ENGLISH_UNITED_KINGDOM);
            LCID_MAP.put(new Integer(ENGLISH_UNITED_STATES.getLanguageCode()), ENGLISH_UNITED_STATES);
            LCID_MAP.put(new Integer(ENGLISH_ZIMBABWE.getLanguageCode()), ENGLISH_ZIMBABWE);
            LCID_MAP.put(new Integer(ESTONIAN_ESTONIA.getLanguageCode()), ESTONIAN_ESTONIA);
            LCID_MAP.put(new Integer(FAROESE_FAROE_ISLANDS.getLanguageCode()), FAROESE_FAROE_ISLANDS);
            LCID_MAP.put(new Integer(FILIPINO_PHILIPPINES.getLanguageCode()), FILIPINO_PHILIPPINES);
            LCID_MAP.put(new Integer(FINNISH_FINLAND.getLanguageCode()), FINNISH_FINLAND);
            LCID_MAP.put(new Integer(FRENCH_BELGIUM.getLanguageCode()), FRENCH_BELGIUM);
            LCID_MAP.put(new Integer(FRENCH_CANADA.getLanguageCode()), FRENCH_CANADA);
            LCID_MAP.put(new Integer(FRENCH_FRANCE.getLanguageCode()), FRENCH_FRANCE);
            LCID_MAP.put(new Integer(FRENCH_LUXEMBOURG.getLanguageCode()), FRENCH_LUXEMBOURG);
            LCID_MAP.put(new Integer(FRENCH_MONOCO.getLanguageCode()), FRENCH_MONOCO);
            LCID_MAP.put(new Integer(FRENCH_SWITZERLAND.getLanguageCode()), FRENCH_SWITZERLAND);
            LCID_MAP.put(new Integer(FRISIAN_NETHERLANDS.getLanguageCode()), FRISIAN_NETHERLANDS);
            LCID_MAP.put(new Integer(GALICIAN_GALICIAN.getLanguageCode()), GALICIAN_GALICIAN);
            LCID_MAP.put(new Integer(GEORGIAN_GEORGIA.getLanguageCode()), GEORGIAN_GEORGIA);
            LCID_MAP.put(new Integer(GERMAN_AUSTRIA.getLanguageCode()), GERMAN_AUSTRIA);
            LCID_MAP.put(new Integer(GERMAN_GERMANY.getLanguageCode()), GERMAN_GERMANY);
            LCID_MAP.put(new Integer(GERMAN_LIECHTENSTEIN.getLanguageCode()), GERMAN_LIECHTENSTEIN);
            LCID_MAP.put(new Integer(GERMAN_LUXEMBOURG.getLanguageCode()), GERMAN_LUXEMBOURG);
            LCID_MAP.put(new Integer(GERMAN_SWITZERLAND.getLanguageCode()), GERMAN_SWITZERLAND);
            LCID_MAP.put(new Integer(GREEK_GREECE.getLanguageCode()), GREEK_GREECE);
            LCID_MAP.put(new Integer(GREENLANDIC_GREENLAND.getLanguageCode()), GREENLANDIC_GREENLAND);
            LCID_MAP.put(new Integer(GUJARATI_INDIA.getLanguageCode()), GUJARATI_INDIA);
            LCID_MAP.put(new Integer(HAUSA_LATIN_NIGERIA.getLanguageCode()), HAUSA_LATIN_NIGERIA);
            LCID_MAP.put(new Integer(HEBREW_ISRAEL.getLanguageCode()), HEBREW_ISRAEL);
            LCID_MAP.put(new Integer(HINDI_INDIA.getLanguageCode()), HINDI_INDIA);
            LCID_MAP.put(new Integer(HUNGARIAN_HUNGARY.getLanguageCode()), HUNGARIAN_HUNGARY);
            LCID_MAP.put(new Integer(ICELANDIC_ICELAND.getLanguageCode()), ICELANDIC_ICELAND);
            LCID_MAP.put(new Integer(IGBO_NIGERIA.getLanguageCode()), IGBO_NIGERIA);
            LCID_MAP.put(new Integer(INDONESIAN_INDONESIA.getLanguageCode()), INDONESIAN_INDONESIA);
            LCID_MAP.put(new Integer(INUKTITUT_CANADA.getLanguageCode()), INUKTITUT_CANADA);
            LCID_MAP.put(new Integer(INUKTITUT_LATIN_CANADA.getLanguageCode()), INUKTITUT_LATIN_CANADA);
            LCID_MAP.put(new Integer(IRISH_IRELAND.getLanguageCode()), IRISH_IRELAND);
            LCID_MAP.put(new Integer(ISIXHOSA_SOUTH_AFRICA.getLanguageCode()), ISIXHOSA_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(ISIZULU_SOUTH_AFRICA.getLanguageCode()), ISIZULU_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(ITALIAN_ITALY.getLanguageCode()), ITALIAN_ITALY);
            LCID_MAP.put(new Integer(ITALIAN_SWITZERLAND.getLanguageCode()), ITALIAN_SWITZERLAND);
            LCID_MAP.put(new Integer(JAPANESE_JAPAN.getLanguageCode()), JAPANESE_JAPAN);
            LCID_MAP.put(new Integer(KICHE_GUATEMALA.getLanguageCode()), KICHE_GUATEMALA);
            LCID_MAP.put(new Integer(KANNADA_INDIA.getLanguageCode()), KANNADA_INDIA);
            LCID_MAP.put(new Integer(KAZAKH_KAZAKHSTAN.getLanguageCode()), KAZAKH_KAZAKHSTAN);
            LCID_MAP.put(new Integer(KHMER_CAMBODIA.getLanguageCode()), KHMER_CAMBODIA);
            LCID_MAP.put(new Integer(KINYARWANDA_RWANDA.getLanguageCode()), KINYARWANDA_RWANDA);
            LCID_MAP.put(new Integer(KISWAHILI_KENYA.getLanguageCode()), KISWAHILI_KENYA);
            LCID_MAP.put(new Integer(KONKANI_INDIA.getLanguageCode()), KONKANI_INDIA);
            LCID_MAP.put(new Integer(KOREAN_KOREA.getLanguageCode()), KOREAN_KOREA);
            LCID_MAP.put(new Integer(KYRGYZ_KYRGYZSTAN.getLanguageCode()), KYRGYZ_KYRGYZSTAN);
            LCID_MAP.put(new Integer(LAO_LAOS.getLanguageCode()), LAO_LAOS);
            LCID_MAP.put(new Integer(LATVIAN_LATVIA.getLanguageCode()), LATVIAN_LATVIA);
            LCID_MAP.put(new Integer(LITHUANIAN_LITHUANIA.getLanguageCode()), LITHUANIAN_LITHUANIA);
            LCID_MAP.put(new Integer(LOWER_SORBIAN_GERMANY.getLanguageCode()), LOWER_SORBIAN_GERMANY);
            LCID_MAP.put(new Integer(LUXEMBOURGISH_LUXEMBOURG.getLanguageCode()), LUXEMBOURGISH_LUXEMBOURG);
            LCID_MAP.put(new Integer(MACEDONIAN_MACEDONIA.getLanguageCode()), MACEDONIAN_MACEDONIA);
            LCID_MAP.put(new Integer(MALAY_BRUNEI.getLanguageCode()), MALAY_BRUNEI);
            LCID_MAP.put(new Integer(MALAY_MALAYSIA.getLanguageCode()), MALAY_MALAYSIA);
            LCID_MAP.put(new Integer(MALAYALAM_INDIA.getLanguageCode()), MALAYALAM_INDIA);
            LCID_MAP.put(new Integer(MALTESE_MALTA.getLanguageCode()), MALTESE_MALTA);
            LCID_MAP.put(new Integer(MAORI_NEW_ZEALAND.getLanguageCode()), MAORI_NEW_ZEALAND);
            LCID_MAP.put(new Integer(MAPUDUNGUN_CHILE.getLanguageCode()), MAPUDUNGUN_CHILE);
            LCID_MAP.put(new Integer(MARATHI_INDIA.getLanguageCode()), MARATHI_INDIA);
            LCID_MAP.put(new Integer(MOHAWK_MOHAWK.getLanguageCode()), MOHAWK_MOHAWK);
            LCID_MAP.put(new Integer(MONGOLIAN_CYRILLIC_MONGOLIA.getLanguageCode()), MONGOLIAN_CYRILLIC_MONGOLIA);
            LCID_MAP.put(new Integer(MONGOLIAN_TRADITIONAL_PRC.getLanguageCode()), MONGOLIAN_TRADITIONAL_PRC);
            LCID_MAP.put(new Integer(NEPALI_NEPAL.getLanguageCode()), NEPALI_NEPAL);
            LCID_MAP.put(new Integer(NORWEGIAN_BOKMAL_NORWAY.getLanguageCode()), NORWEGIAN_BOKMAL_NORWAY);
            LCID_MAP.put(new Integer(NORWEGIAN_NYNORSK_NORWAY.getLanguageCode()), NORWEGIAN_NYNORSK_NORWAY);
            LCID_MAP.put(new Integer(OCCITAN_FRANCE.getLanguageCode()), OCCITAN_FRANCE);
            LCID_MAP.put(new Integer(ORIYA_INDIA.getLanguageCode()), ORIYA_INDIA);
            LCID_MAP.put(new Integer(PASHTO_AFGHANISTAN.getLanguageCode()), PASHTO_AFGHANISTAN);
            LCID_MAP.put(new Integer(POLISH_POLAND.getLanguageCode()), POLISH_POLAND);
            LCID_MAP.put(new Integer(PORTUGUESE_BRAZIL.getLanguageCode()), PORTUGUESE_BRAZIL);
            LCID_MAP.put(new Integer(PORTUGUESE_PORTUGAL.getLanguageCode()), PORTUGUESE_PORTUGAL);
            LCID_MAP.put(new Integer(PUNJABI_INDIA.getLanguageCode()), PUNJABI_INDIA);
            LCID_MAP.put(new Integer(QUECHUA_BOLIVIA.getLanguageCode()), QUECHUA_BOLIVIA);
            LCID_MAP.put(new Integer(QUECHUA_ECUADOR.getLanguageCode()), QUECHUA_ECUADOR);
            LCID_MAP.put(new Integer(QUECHUA_PERU.getLanguageCode()), QUECHUA_PERU);
            LCID_MAP.put(new Integer(ROMANIAN_ROMANIA.getLanguageCode()), ROMANIAN_ROMANIA);
            LCID_MAP.put(new Integer(ROMANSH_SWITZERLAND.getLanguageCode()), ROMANSH_SWITZERLAND);
            LCID_MAP.put(new Integer(RUSSIAN_RUSSIA.getLanguageCode()), RUSSIAN_RUSSIA);
            LCID_MAP.put(new Integer(SAMI_INARI_FINLAND.getLanguageCode()), SAMI_INARI_FINLAND);
            LCID_MAP.put(new Integer(SAMI_LULE_NORWAY.getLanguageCode()), SAMI_LULE_NORWAY);
            LCID_MAP.put(new Integer(SAMI_LULE_SWEDEN.getLanguageCode()), SAMI_LULE_SWEDEN);
            LCID_MAP.put(new Integer(SAMI_NORTHERN_FINLAND.getLanguageCode()), SAMI_NORTHERN_FINLAND);
            LCID_MAP.put(new Integer(SAMI_NORTHERN_NORWAY.getLanguageCode()), SAMI_NORTHERN_NORWAY);
            LCID_MAP.put(new Integer(SAMI_NORTHERN_SWEDEN.getLanguageCode()), SAMI_NORTHERN_SWEDEN);
            LCID_MAP.put(new Integer(SAMI_SKOLT_FINLAND.getLanguageCode()), SAMI_SKOLT_FINLAND);
            LCID_MAP.put(new Integer(SAMI_SOUTHERN_NORWAY.getLanguageCode()), SAMI_SOUTHERN_NORWAY);
            LCID_MAP.put(new Integer(SAMI_SOUTHERN_SWEDEN.getLanguageCode()), SAMI_SOUTHERN_SWEDEN);
            LCID_MAP.put(new Integer(SANSKRIT_INDIA.getLanguageCode()), SANSKRIT_INDIA);
            LCID_MAP.put(new Integer(SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA.getLanguageCode()), SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA);
            LCID_MAP.put(new Integer(SERBIAN_CYRILLIC_SERBIA.getLanguageCode()), SERBIAN_CYRILLIC_SERBIA);
            LCID_MAP.put(new Integer(SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA.getLanguageCode()), SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA);
            LCID_MAP.put(new Integer(SERBIAN_LATIN_SERBIA.getLanguageCode()), SERBIAN_LATIN_SERBIA);
            LCID_MAP.put(new Integer(SESOTHO_SA_LEBOA_SOUTH_AFRICA.getLanguageCode()), SESOTHO_SA_LEBOA_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(SETSWANA_SOUTH_AFRICA.getLanguageCode()), SETSWANA_SOUTH_AFRICA);
            LCID_MAP.put(new Integer(SINHALA_SRI_LANKA.getLanguageCode()), SINHALA_SRI_LANKA);
            LCID_MAP.put(new Integer(SLOVAK_SLOVAKIA.getLanguageCode()), SLOVAK_SLOVAKIA);
            LCID_MAP.put(new Integer(SLOVENIAN_SLOVENIA.getLanguageCode()), SLOVENIAN_SLOVENIA);
            LCID_MAP.put(new Integer(SPANISH_ARGENTINA.getLanguageCode()), SPANISH_ARGENTINA);
            LCID_MAP.put(new Integer(SPANISH_BOLIVIA.getLanguageCode()), SPANISH_BOLIVIA);
            LCID_MAP.put(new Integer(SPANISH_CHILE.getLanguageCode()), SPANISH_CHILE);
            LCID_MAP.put(new Integer(SPANISH_COLOMBIA.getLanguageCode()), SPANISH_COLOMBIA);
            LCID_MAP.put(new Integer(SPANISH_COSTA_RICA.getLanguageCode()), SPANISH_COSTA_RICA);
            LCID_MAP.put(new Integer(SPANISH_DOMINICAN_REPUBLIC.getLanguageCode()), SPANISH_DOMINICAN_REPUBLIC);
            LCID_MAP.put(new Integer(SPANISH_ECUADOR.getLanguageCode()), SPANISH_ECUADOR);
            LCID_MAP.put(new Integer(SPANISH_EL_SALVADOR.getLanguageCode()), SPANISH_EL_SALVADOR);
            LCID_MAP.put(new Integer(SPANISH_GUATEMALA.getLanguageCode()), SPANISH_GUATEMALA);
            LCID_MAP.put(new Integer(SPANISH_HONDURAS.getLanguageCode()), SPANISH_HONDURAS);
            LCID_MAP.put(new Integer(SPANISH_MEXICO.getLanguageCode()), SPANISH_MEXICO);
            LCID_MAP.put(new Integer(SPANISH_NICARAGUA.getLanguageCode()), SPANISH_NICARAGUA);
            LCID_MAP.put(new Integer(SPANISH_PANAMA.getLanguageCode()), SPANISH_PANAMA);
            LCID_MAP.put(new Integer(SPANISH_PARAGUAY.getLanguageCode()), SPANISH_PARAGUAY);
            LCID_MAP.put(new Integer(SPANISH_PERU.getLanguageCode()), SPANISH_PERU);
            LCID_MAP.put(new Integer(SPANISH_PUERTO_RICO.getLanguageCode()), SPANISH_PUERTO_RICO);
            LCID_MAP.put(new Integer(SPANISH_SPAIN.getLanguageCode()), SPANISH_SPAIN);
            LCID_MAP.put(new Integer(SPANISH_SPAIN_TRADITIONAL.getLanguageCode()), SPANISH_SPAIN_TRADITIONAL);
            LCID_MAP.put(new Integer(SPANISH_UNITED_STATES.getLanguageCode()), SPANISH_UNITED_STATES);
            LCID_MAP.put(new Integer(SPANISH_URUGUAY.getLanguageCode()), SPANISH_URUGUAY);
            LCID_MAP.put(new Integer(SPANISH_VENEZUELA.getLanguageCode()), SPANISH_VENEZUELA);
            LCID_MAP.put(new Integer(SWEDISH_FINLAND.getLanguageCode()), SWEDISH_FINLAND);
            LCID_MAP.put(new Integer(SWEDISH_SWEDEN.getLanguageCode()), SWEDISH_SWEDEN);
            LCID_MAP.put(new Integer(SYRIAC_SYRIA.getLanguageCode()), SYRIAC_SYRIA);
            LCID_MAP.put(new Integer(TAJIK_CYRILLIC_TAJIKISTAN.getLanguageCode()), TAJIK_CYRILLIC_TAJIKISTAN);
            LCID_MAP.put(new Integer(TAMAZIGHT_LATIN_ALGERIA.getLanguageCode()), TAMAZIGHT_LATIN_ALGERIA);
            LCID_MAP.put(new Integer(TAMIL_INDIA.getLanguageCode()), TAMIL_INDIA);
            LCID_MAP.put(new Integer(TATAR_RUSSIA.getLanguageCode()), TATAR_RUSSIA);
            LCID_MAP.put(new Integer(TELUGU_INDIA.getLanguageCode()), TELUGU_INDIA);
            LCID_MAP.put(new Integer(THAI_THAILAND.getLanguageCode()), THAI_THAILAND);
            LCID_MAP.put(new Integer(TIBETAN_PRC.getLanguageCode()), TIBETAN_PRC);
            LCID_MAP.put(new Integer(TURKISH_TURKEY.getLanguageCode()), TURKISH_TURKEY);
            LCID_MAP.put(new Integer(TURKMEN_TURKMENISTAN.getLanguageCode()), TURKMEN_TURKMENISTAN);
            LCID_MAP.put(new Integer(UIGHUR_PRC.getLanguageCode()), UIGHUR_PRC);
            LCID_MAP.put(new Integer(UKRAINIAN_UKRAINE.getLanguageCode()), UKRAINIAN_UKRAINE);
            LCID_MAP.put(new Integer(UPPER_SORBIAN_GERMANY.getLanguageCode()), UPPER_SORBIAN_GERMANY);
            LCID_MAP.put(new Integer(URDU_PAKISTAN.getLanguageCode()), URDU_PAKISTAN);
            LCID_MAP.put(new Integer(UZBEK_CYRILLIC_UZBEKISTAN.getLanguageCode()), UZBEK_CYRILLIC_UZBEKISTAN);
            LCID_MAP.put(new Integer(UZBEK_LATIN_UZBEKISTAN.getLanguageCode()), UZBEK_LATIN_UZBEKISTAN);
            LCID_MAP.put(new Integer(VIETNAMESE_VIETNAM.getLanguageCode()), VIETNAMESE_VIETNAM);
            LCID_MAP.put(new Integer(WELSH_UNITED_KINGDOM.getLanguageCode()), WELSH_UNITED_KINGDOM);
            LCID_MAP.put(new Integer(WOLOF_SENEGAL.getLanguageCode()), WOLOF_SENEGAL);
            LCID_MAP.put(new Integer(YAKUT_RUSSIA.getLanguageCode()), YAKUT_RUSSIA);
        }
    }

    public static final class LanguageCodeEntry {
        private final int languageCode;
        private final String language;
        private final String script;
        private final String region;
        private final String variant;

        LanguageCodeEntry(int n, String string, String string2, String string3) {
            this(n, string, string2, string3, null);
        }

        public LanguageCodeEntry(int n, String string, String string2, String string3, String string4) {
            this.languageCode = n;
            this.language = string;
            this.script = string2;
            this.region = string3;
            this.variant = string4;
        }

        public int getLanguageCode() {
            return this.languageCode;
        }

        public String getLocaleString() {
            return new String(this.language + (this.script == null ? "" : "_" + this.script) + (this.region == null ? "" : "_" + this.region) + (this.variant == null ? "" : "_" + this.variant));
        }

        public ULocale getLocale() {
            return new ULocale(this.getLocaleString());
        }
    }

    public static final class MicrosoftEncodingId {
        public static final int SYMBOL = 0;
        public static final int UTF16_BE_BMP_ONLY = 1;
        public static final int SHIFT_JIS = 2;
        public static final int PRC = 3;
        public static final int BIG5 = 4;
        public static final int WANSUNG = 5;
        public static final int JOHAB = 6;
        public static final int UTF16_BE_FULL = 10;

        private MicrosoftEncodingId() {
        }
    }

    public static final class PlatformId {
        public static final int UNICODE = 0;
        public static final int MACINTOSH = 1;
        public static final int MICROSOFT = 3;

        private PlatformId() {
        }

        public static final int getPlatformId(Platform platform) {
            if (platform == Platform.MAC_OSX) {
                return 1;
            }
            if (platform == Platform.WINDOWS) {
                return 3;
            }
            return -1;
        }

        public static final Platform getPlatform(int n) {
            switch (n) {
                case 1: {
                    return Platform.MAC_OSX;
                }
                case 3: {
                    return Platform.WINDOWS;
                }
            }
            return Platform.UNKNOWN;
        }
    }

    public static class PredefinedNames {
        public static final int COPYRIGHT_NOTICE = 0;
        public static final int FONT_FAMILY = 1;
        public static final int FONT_SUBFAMILY = 2;
        public static final int UNIQUE_FONT_IDENTIFIER = 3;
        public static final int FULL_FONT_NAME = 4;
        public static final int VERSION_STRING = 5;
        public static final int POSTSCRIPT_NAME = 6;
        public static final int TRADEMARK = 7;
        public static final int MANUFACTURER = 8;
        public static final int DESIGNER = 9;
        public static final int DESCRIPTION = 10;
        public static final int VENDOR_URL = 11;
        public static final int DESIGNER_URL = 12;
        public static final int LICENSE_DESCRIPTION = 13;
        public static final int LICENSE_URL = 14;
        public static final int PREFERRED_FAMILY = 16;
        public static final int PREFERRED_SUBFAMILY = 17;
        public static final int COMPATIBLE_FULL_NAME = 18;
        public static final int SAMPLE_TEXT = 19;
        public static final int POSTSCRIPT_CID_NAME = 20;

        private PredefinedNames() {
        }
    }
}

