/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.internal.io.ExtendedDataInputStream;
import com.adobe.internal.mac.resource.BasicResourceHandler;
import com.adobe.internal.mac.resource.ResourceParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FONDResourceHandler
extends BasicResourceHandler {
    private static final byte[] FOND = new byte[]{70, 79, 78, 68};
    private static final long ASSOCIATION_TABLE_OFFSET = 52L;
    private Set<Association> associations = new LinkedHashSet<Association>();

    public FONDResourceHandler() {
        super(FOND);
    }

    public void handleResource(ResourceParser.ResourceEntry resourceEntry, long l, InputStream inputStream) {
        try {
            ExtendedDataInputStream extendedDataInputStream = new ExtendedDataInputStream(inputStream);
            extendedDataInputStream.skipFully(52L);
            int n = extendedDataInputStream.readUnsignedShort();
            for (int i = 0; i <= n; ++i) {
                int n2 = extendedDataInputStream.readUnsignedShort();
                int n3 = extendedDataInputStream.readUnsignedShort();
                int n4 = extendedDataInputStream.readUnsignedShort();
                Association association = new Association(resourceEntry.getID(), n4, resourceEntry.getName(), resourceEntry.getScriptCode(), n2, n3);
                this.associations.add(association);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<Association> getAssociations() {
        return this.associations;
    }

    public static class Association {
        private static final int STYLE_BOLD = 1;
        private static final int STYLE_ITALIC = 2;
        private String name;
        private int size;
        private int style;
        private int fontID;
        private int script;
        private int fondID;

        private Association(int n, int n2, String string, int n3, int n4, int n5) {
            this.fondID = n;
            this.size = n4;
            this.style = n5;
            this.fontID = n2;
            this.name = string;
            this.script = n3;
        }

        public int getFondID() {
            return this.fondID;
        }

        public int getSize() {
            return this.size;
        }

        public int getStyle() {
            return this.style;
        }

        public boolean isBold() {
            return (this.style & 1) == 1;
        }

        public boolean isItalic() {
            return (this.style & 2) == 2;
        }

        public int getFontID() {
            return this.fontID;
        }

        public String getName() {
            return this.name;
        }

        public int getScriptCode() {
            return this.script;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fondID = " + this.fondID);
            stringBuffer.append("fontID = " + this.fontID);
            stringBuffer.append(", name = " + this.name);
            stringBuffer.append(", size = " + this.size);
            stringBuffer.append(", style = " + this.style);
            stringBuffer.append(" (bold = " + this.isBold());
            stringBuffer.append(", italic = " + this.isItalic() + ")");
            return stringBuffer.toString();
        }
    }
}

