/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.OutlineConsumer2BaseImpl;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.Math2;

public final class TTScan
implements ScanConverter {
    private ScanLines hScanLines;
    private ScanLines vScanLines;
    private int scanType = 2;
    private CrossBuilder crossBuilder = new CrossBuilder();
    private ScalerDebugger outlineDebugger;

    private int scanlineAbove(int n) {
        return F26Dot6.roundHalfUp(n);
    }

    private int scanlineBelow(int n) {
        return F26Dot6.roundHalfDown(n) - 64;
    }

    public TTScan() {
        this.crossBuilder.setFlatness(1.0);
    }

    public void setScanType(int n) {
        this.scanType = n;
    }

    public OutlineConsumer2 getOutlineConsumer2() {
        return this.crossBuilder;
    }

    public void getBitmap(BitmapConsumer bitmapConsumer) {
        if (this.crossBuilder.zeroDimension) {
            this.scanType &= 0xFFFFFFFE;
        }
        if (!this.checkCrosses()) {
            return;
        }
        Bitmap bitmap = new Bitmap(F26Dot6.toInt(this.crossBuilder.xmin), F26Dot6.toInt(this.crossBuilder.xmax), F26Dot6.toInt(this.crossBuilder.ymin), F26Dot6.toInt(this.crossBuilder.ymax));
        this.buildInitialRuns(bitmap);
        if (this.isFixing(this.scanType)) {
            this.fixHDropouts(bitmap);
            this.fixVDropouts(bitmap);
        }
        bitmap.emitBitmap(bitmapConsumer);
    }

    private boolean checkCrosses() {
        ScanLine scanLine;
        int n;
        if (this.hScanLines.scanLines != null) {
            for (n = 0; n < this.hScanLines.scanLines.length; ++n) {
                scanLine = this.hScanLines.scanLines[n];
                if (scanLine == null || scanLine.onCrosses != null && scanLine.offCrosses != null && scanLine.onCrosses.values != null && scanLine.offCrosses.values != null && scanLine.onCrosses.values.length == scanLine.offCrosses.values.length) continue;
                System.err.println("****************** h crosses not paired!");
                return false;
            }
        }
        if (this.vScanLines.scanLines != null) {
            for (n = 0; n < this.vScanLines.scanLines.length; ++n) {
                scanLine = this.vScanLines.scanLines[n];
                if (scanLine == null || scanLine.onCrosses != null && scanLine.offCrosses != null && scanLine.onCrosses.values != null && scanLine.offCrosses.values != null && scanLine.onCrosses.values.length == scanLine.offCrosses.values.length) continue;
                System.err.println("****************** v crosses not paired!");
                return false;
            }
        }
        return true;
    }

    private void buildInitialRuns(Bitmap bitmap) {
        if (this.hScanLines.scanLines == null) {
            return;
        }
        for (int i = 0; i < this.hScanLines.scanLines.length; ++i) {
            ScanLine scanLine = this.hScanLines.scanLines[i];
            if (scanLine == null) continue;
            int n = this.hScanLines.firstScanLineCoordI + i;
            for (int j = 0; j < scanLine.onCrosses.values.length; ++j) {
                int n2 = scanLine.onCrosses.values[j];
                int n3 = scanLine.offCrosses.values[j];
                if (n2 > n3) {
                    int n4 = n2;
                    n2 = n3;
                    n3 = n4;
                }
                bitmap.paintBlack(F26Dot6.toInt(F26Dot6.roundHalfDown(n2)), F26Dot6.toInt(F26Dot6.roundHalfUp(n3)), n);
            }
        }
    }

    private void fixHDropouts(Bitmap bitmap) {
        if (this.hScanLines.scanLines == null) {
            return;
        }
        for (int i = 0; i < this.hScanLines.scanLines.length; ++i) {
            ScanLine scanLine = this.hScanLines.scanLines[i];
            if (scanLine == null) continue;
            int n = this.hScanLines.firstScanLineCoordI + i;
            for (int j = 0; j < scanLine.onCrosses.values.length; ++j) {
                int n2;
                int n3;
                int n4 = scanLine.onCrosses.values[j];
                int n5 = scanLine.offCrosses.values[j];
                if (n4 > n5) {
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                if ((n3 = F26Dot6.toInt(this.scanlineAbove(n4))) <= F26Dot6.toInt(this.scanlineBelow(n5)) || bitmap.isBlack(n3 - 1, n) || bitmap.isBlack(n3, n)) continue;
                if (this.isExcludingStubs(this.scanType)) {
                    n2 = 0;
                    n2 += this.vScanLines.countCrosses(n3 - 1, n + 1);
                    n2 += this.hScanLines.countCrosses(n + 1, n3);
                    if ((n2 += this.vScanLines.countCrosses(n3, n + 1)) < 2) continue;
                    n2 = 0;
                    n2 += this.vScanLines.countCrosses(n3 - 1, n);
                    n2 += this.hScanLines.countCrosses(n - 1, n3);
                    if ((n2 += this.vScanLines.countCrosses(n3, n)) < 2) continue;
                }
                if ((n2 = this.isSmart(this.scanType) ? F26Dot6.toInt(F26Dot6.floor((scanLine.onCrosses.values[j] + scanLine.offCrosses.values[j]) / 2)) : n3 - 1) < F26Dot6.toInt(this.crossBuilder.xmin)) {
                    ++n2;
                }
                if (F26Dot6.toInt(this.crossBuilder.xmax) < n2) {
                    --n2;
                }
                bitmap.paintBlack(n2, n);
            }
        }
    }

    private void fixVDropouts(Bitmap bitmap) {
        if (this.vScanLines.scanLines == null) {
            return;
        }
        for (int i = 0; i < this.vScanLines.scanLines.length; ++i) {
            ScanLine scanLine = this.vScanLines.scanLines[i];
            if (scanLine == null) continue;
            int n = this.vScanLines.firstScanLineCoordI + i;
            for (int j = scanLine.onCrosses.values.length - 1; j >= 0; --j) {
                int n2;
                int n3;
                int n4 = scanLine.onCrosses.values[j];
                int n5 = scanLine.offCrosses.values[j];
                if (n4 > n5) {
                    n3 = n4;
                    n4 = n5;
                    n5 = n3;
                }
                if ((n3 = F26Dot6.toInt(this.scanlineAbove(n4))) <= F26Dot6.toInt(this.scanlineBelow(n5)) || bitmap.isBlack(n, n3 - 1) || bitmap.isBlack(n, n3)) continue;
                if (this.isExcludingStubs(this.scanType)) {
                    n2 = 0;
                    n2 += this.hScanLines.countCrosses(n3 - 1, n);
                    n2 += this.vScanLines.countCrosses(n - 1, n3);
                    if ((n2 += this.hScanLines.countCrosses(n3, n)) < 2) continue;
                    n2 = 0;
                    n2 += this.hScanLines.countCrosses(n3 - 1, n + 1);
                    n2 += this.vScanLines.countCrosses(n + 1, n3);
                    if ((n2 += this.hScanLines.countCrosses(n3, n + 1)) < 2) continue;
                }
                if ((n2 = this.isSmart(this.scanType) ? F26Dot6.toInt(F26Dot6.floor((scanLine.onCrosses.values[j] + scanLine.offCrosses.values[j]) / 2)) : n3 - 1) < F26Dot6.toInt(this.crossBuilder.ymin)) {
                    ++n2;
                }
                if (F26Dot6.toInt(this.crossBuilder.ymax) < n2) {
                    --n2;
                }
                bitmap.paintBlack(n, n2);
            }
        }
    }

    private boolean isFixing(int n) {
        return n == 0 || n == 1 || n == 4 || n == 5;
    }

    private boolean isSmart(int n) {
        return n == 4 || n == 5;
    }

    private boolean isExcludingStubs(int n) {
        return n == 1 || n == 5;
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.outlineDebugger = scalerDebugger;
    }

    private static class Bitmap {
        boolean[][] pixels;
        int blX;
        int blY;
        int width;

        public Bitmap(int n, int n2, int n3, int n4) {
            if (n == Integer.MAX_VALUE) {
                this.pixels = null;
                return;
            }
            this.blX = n;
            this.blY = n3;
            this.pixels = new boolean[n2 - n + 1][];
            this.width = n4 - n3 + 1;
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = new boolean[this.width];
            }
        }

        public boolean isBlack(int n, int n2) {
            int n3 = n - this.blX;
            int n4 = n2 - this.blY;
            if (n3 < 0 || this.pixels.length <= n3 || n4 < 0 || this.width <= n4) {
                return false;
            }
            return this.pixels[n3][n4];
        }

        public void paintBlack(int n, int n2) {
            this.pixels[n - this.blX][n2 - this.blY] = true;
        }

        protected void paintBlack(int n, int n2, int n3) {
            for (int i = n; i < n2; ++i) {
                this.paintBlack(i, n3);
            }
        }

        protected void emitBitmap(BitmapConsumer bitmapConsumer) {
            if (this.pixels == null) {
                return;
            }
            for (int i = 0; i < this.pixels.length; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    if (!this.pixels[i][j]) continue;
                    bitmapConsumer.addRun(this.blX + i, this.blX + i + 1, this.blY + j);
                }
            }
        }
    }

    private class CrossBuilder
    extends OutlineConsumer2BaseImpl {
        int xmin;
        int ymin;
        int xmax;
        int ymax;
        boolean zeroDimension;
        Direction currentDir;
        Direction firstSegmentDir;
        int firstSegmentX;
        int firstSegmentY;
        private double THRESHOLD = 127.0;
        private double epsilon;
        int depth = 0;
        final int[] zShiftTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3};

        public void setFlatness(double d) {
            this.epsilon = Math.max(1.220703125E-4, 1.5 * d / 4.0);
        }

        public void startOutline() {
            this.xmin = Integer.MAX_VALUE;
            this.ymin = Integer.MAX_VALUE;
            this.xmax = Integer.MIN_VALUE;
            this.ymax = Integer.MIN_VALUE;
            TTScan.this.hScanLines = new ScanLines(true);
            TTScan.this.vScanLines = new ScanLines(false);
        }

        public void startContour() {
            this.currentDir = Direction.NONE;
        }

        public void line(int n, int n2, int n3, int n4) {
            this.xmin = F26Dot6.min(n, F26Dot6.min(n3, this.xmin));
            this.ymin = F26Dot6.min(n2, F26Dot6.min(n4, this.ymin));
            this.xmax = F26Dot6.max(n, F26Dot6.max(n3, this.xmax));
            this.ymax = F26Dot6.max(n2, F26Dot6.max(n4, this.ymax));
            Direction direction = Direction.ofSegment(n, n2, n3, n4);
            if (direction == Direction.NO_MOVE) {
                return;
            }
            this.doLine(direction, n, n2, n3, n4);
            if (this.currentDir == Direction.NONE) {
                this.firstSegmentX = n;
                this.firstSegmentY = n2;
                this.firstSegmentDir = direction;
            } else {
                this.endPointH(this.currentDir, n, n2, direction);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, n, n2, direction);
                }
            }
            this.currentDir = direction;
        }

        private void doLine(Direction direction, int n, int n2, int n3, int n4) {
            block15: {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                long l;
                block14: {
                    int n17;
                    int n18;
                    int n19;
                    if (!direction.isDown) {
                        n19 = 1;
                        l = 0L;
                        n18 = TTScan.this.scanlineAbove(n2) + 32;
                        n16 = n18 - n2;
                        n15 = F26Dot6.toInt(n18);
                        n14 = F26Dot6.toInt(TTScan.this.scanlineBelow(n4)) - n15 + 1;
                        n13 = 1;
                        n12 = 0;
                        n11 = n4 - n2;
                    } else {
                        n19 = 4;
                        l = 1L;
                        n18 = TTScan.this.scanlineBelow(n2) + 32;
                        n16 = n2 - n18;
                        n15 = F26Dot6.toInt(n18);
                        n14 = n15 - F26Dot6.toInt(TTScan.this.scanlineAbove(n4)) + 1;
                        n13 = -1;
                        n12 = 1;
                        n11 = n2 - n4;
                    }
                    if (n4 == n2) {
                        if (!TTScan.this.isFixing(TTScan.this.scanType)) {
                            return;
                        }
                        n15 = F26Dot6.toInt(TTScan.this.scanlineAbove(n3 < n ? n2 - 1 : n2));
                        n14 = 0;
                    }
                    if (!direction.isLeft) {
                        n17 = TTScan.this.scanlineAbove(n) + 32;
                        n10 = n17 - n;
                        n9 = F26Dot6.toInt(n17);
                        n8 = F26Dot6.toInt(TTScan.this.scanlineBelow(n3)) - n9 + 1;
                        n7 = 1;
                        n6 = 0;
                        n5 = n3 - n;
                    } else {
                        l = 1L - l;
                        n19 = n19 == 1 ? 2 : 3;
                        n17 = TTScan.this.scanlineBelow(n) + 32;
                        n10 = n - n17;
                        n9 = F26Dot6.toInt(n17);
                        n8 = n9 - F26Dot6.toInt(TTScan.this.scanlineAbove(n3)) + 1;
                        n7 = -1;
                        n6 = 1;
                        n5 = n - n3;
                    }
                    if (n3 == n) {
                        n9 = F26Dot6.toInt(TTScan.this.scanlineAbove(n4 > n2 ? n - 1 : n));
                        n8 = 0;
                    }
                    if (n2 != n4) break block14;
                    if (!TTScan.this.isFixing(TTScan.this.scanType)) break block15;
                    for (int i = 0; i < n8; ++i) {
                        TTScan.this.vScanLines.addCross(F26Dot6.fromInt(n15), n9, direction.isLeft);
                        n9 += n7;
                    }
                    break block15;
                }
                if (n == n3) {
                    for (int i = 0; i < n14; ++i) {
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(n9), n15, direction.isUp);
                        n15 += n13;
                    }
                } else {
                    l += (long)n5 * (long)n16 - (long)n11 * (long)n10;
                    long l2 = n5 << 6;
                    long l3 = -n11 << 6;
                    for (int i = 0; i < n8 + n14; ++i) {
                        if (l > 0L) {
                            if (TTScan.this.isFixing(TTScan.this.scanType)) {
                                TTScan.this.vScanLines.addCross(F26Dot6.fromInt(n15 + n12), n9, direction.isLeft);
                            }
                            n9 += n7;
                            l += l3;
                            continue;
                        }
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(n9 + n6), n15, direction.isUp);
                        n15 += n13;
                        l += l2;
                    }
                }
            }
        }

        public void quadraticCurve(int n, int n2, int n3, int n4, int n5, int n6) {
            this.depth = 0;
            this.doQuadraticCurve(n, n2, n3, n4, n5, n6);
        }

        public void doQuadraticCurve(int n, int n2, int n3, int n4, int n5, int n6) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            ++this.depth;
            if (this.depth > 100) {
                System.err.println("dpeth!");
            }
            if (!(n2 <= n4 && n4 <= n6 || n6 <= n4 && n4 <= n2)) {
                int n29 = n4 - n2;
                int n30 = n29 - (n6 - n4);
                int n31 = n + F26Dot6.multiplyDivide(n3 - n, n29, n30);
                int n32 = n3 + F26Dot6.multiplyDivide(n5 - n3, n29, n30);
                int n33 = n31 + F26Dot6.multiplyDivide(n32 - n31, n29, n30);
                int n34 = n2 + F26Dot6.multiplyDivide(n4 - n2, n29, n30);
                this.doQuadraticCurve(n, n2, n31, n34, n33, n34);
                this.doQuadraticCurve(n33, n34, n32, n34, n5, n6);
                return;
            }
            if (!(n <= n3 && n3 <= n5 || n5 <= n3 && n3 <= n)) {
                int n35 = n3 - n;
                int n36 = n35 - (n5 - n3);
                int n37 = n2 + F26Dot6.multiplyDivide(n4 - n2, n35, n36);
                int n38 = n4 + F26Dot6.multiplyDivide(n6 - n4, n35, n36);
                int n39 = n37 + F26Dot6.multiplyDivide(n38 - n37, n35, n36);
                int n40 = n + F26Dot6.multiplyDivide(n3 - n, n35, n36);
                this.doQuadraticCurve(n, n2, n40, n37, n40, n39);
                this.doQuadraticCurve(n40, n39, n40, n38, n5, n6);
                return;
            }
            if (Math.abs(n5 - n) > 3200 || Math.abs(n6 - n2) > 3200) {
                int n41 = n + n3 >> 1;
                int n42 = n2 + n4 >> 1;
                int n43 = n3 + n5 >> 1;
                int n44 = n4 + n6 >> 1;
                int n45 = n41 + n43 >> 1;
                int n46 = n42 + n44 >> 1;
                this.doQuadraticCurve(n, n2, n41, n42, n45, n46);
                this.doQuadraticCurve(n45, n46, n43, n44, n5, n6);
                return;
            }
            Direction direction = Direction.ofSegment(n, n2, n5, n6);
            if (direction == Direction.NO_MOVE) {
                return;
            }
            this.xmin = F26Dot6.min(n, F26Dot6.min(n5, this.xmin));
            this.ymin = F26Dot6.min(n2, F26Dot6.min(n6, this.ymin));
            this.xmax = F26Dot6.max(n, F26Dot6.max(n5, this.xmax));
            this.ymax = F26Dot6.max(n2, F26Dot6.max(n6, this.ymax));
            if (direction.isUp) {
                n28 = 0;
                n27 = TTScan.this.scanlineAbove(n2) + 32;
                n26 = n27 - n2;
                n25 = F26Dot6.toInt(n27);
                n24 = F26Dot6.toInt(TTScan.this.scanlineBelow(n6) + 32) + 1;
                n23 = 1;
                n22 = 0;
                n21 = n4 - n2;
                n20 = n6 - n2;
            } else {
                n28 = 1;
                n27 = TTScan.this.scanlineBelow(n2) + 32;
                n26 = n2 - n27;
                n25 = F26Dot6.toInt(n27);
                n24 = F26Dot6.toInt(TTScan.this.scanlineAbove(n6) + 32) - 1;
                n23 = -1;
                n22 = 1;
                n21 = n2 - n4;
                n20 = n2 - n6;
            }
            if (direction.isRight) {
                n27 = TTScan.this.scanlineAbove(n) + 32;
                n19 = n27 - n;
                n18 = F26Dot6.toInt(n27);
                n17 = F26Dot6.toInt(TTScan.this.scanlineBelow(n5) + 32) + 1;
                n16 = 1;
                n15 = 0;
                n14 = n3 - n;
                n13 = n5 - n;
            } else {
                n28 = 1 - n28;
                n27 = TTScan.this.scanlineBelow(n) + 32;
                n19 = n - n27;
                n18 = F26Dot6.toInt(n27);
                n17 = F26Dot6.toInt(TTScan.this.scanlineAbove(n5) + 32) - 1;
                n16 = -1;
                n15 = 1;
                n14 = n - n3;
                n13 = n - n5;
            }
            n27 = 2 * (n14 * n20 - n21 * n13);
            if (n27 == 0) {
                this.line(n, n2, n5, n6);
                return;
            }
            int n47 = Math2.powerOf2(n27);
            int n48 = Math2.powerOf2(n13 > n20 ? n13 : n20);
            int n49 = this.zShiftTable[n47 + n48];
            int n50 = 6 - n49;
            if (n49 > 0) {
                n12 = 1 << n49 - 1;
                n14 = n14 + n12 >> n49;
                n21 = n21 + n12 >> n49;
                n13 = n13 + n12 >> n49;
                n20 = n20 + n12 >> n49;
                n19 = n19 + n12 >> n49;
                n26 = n26 + n12 >> n49;
                n27 = 2 * (n14 * n20 - n21 * n13);
            }
            n12 = n13 - n14 * 2;
            int n51 = n20 - n21 * 2;
            int n52 = n51 * n51;
            int n53 = -n12 * n51;
            int n54 = n12 * n12;
            int n55 = n21 * n27;
            int n56 = -n14 * n27;
            int n57 = 1 << n50;
            if (n48 <= 7) {
                n28 += (n52 * n19 + (n53 << 1) * n26 + (n55 << 1)) * n19 + (n54 * n26 + (n56 << 1)) * n26;
                n11 = n52 * ((n19 << 1) + n57) + (n53 << 1) * n26 + (n55 << 1) << n50;
                n10 = n54 * ((n26 << 1) + n57) + (n53 << 1) * n19 + (n56 << 1) << n50;
                n9 = n52 << (n50 << 1);
                n8 = n53 << 1 << (n50 << 1);
                n7 = n54 << (n50 << 1);
            } else {
                n28 += ((n52 >> 1) * n19 + n53 * n26 + n55 >> n50) * n19 + ((n54 >> 1) * n26 + n56 >> n50) * n26;
                n11 = n52 * (n19 + (n57 >> 1)) + n53 * n26 + n55;
                n10 = n54 * (n26 + (n57 >> 1)) + n53 * n19 + n56;
                n9 = n52 << n50 - 1;
                n8 = n53 << n50;
                n7 = n54 << n50 - 1;
            }
            int n58 = 2 * n9;
            int n59 = 2 * n7;
            if (n27 > 0) {
                while (n18 != n17 && n25 != n24) {
                    if (n28 < 0 || n10 > n7) {
                        if (TTScan.this.isFixing(TTScan.this.scanType)) {
                            TTScan.this.vScanLines.addCross(F26Dot6.fromInt(n25 + n22), n18, direction.isLeft);
                        }
                        n18 += n16;
                        n28 += n11;
                        n11 += n58;
                        n10 += n8;
                        continue;
                    }
                    TTScan.this.hScanLines.addCross(F26Dot6.fromInt(n18 + n15), n25, direction.isUp);
                    n25 += n23;
                    n28 += n10;
                    n10 += n59;
                    n11 += n8;
                }
            } else {
                while (n18 != n17 && n25 != n24) {
                    if (n28 < 0 || n11 > n9) {
                        TTScan.this.hScanLines.addCross(F26Dot6.fromInt(n18 + n15), n25, direction.isUp);
                        n25 += n23;
                        n28 += n10;
                        n10 += n59;
                        n11 += n8;
                        continue;
                    }
                    if (TTScan.this.isFixing(TTScan.this.scanType)) {
                        TTScan.this.vScanLines.addCross(F26Dot6.fromInt(n25 + n22), n18, direction.isLeft);
                    }
                    n18 += n16;
                    n28 += n11;
                    n11 += n58;
                    n10 += n8;
                }
            }
            while (n18 != n17) {
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    TTScan.this.vScanLines.addCross(F26Dot6.fromInt(n25 + n22), n18, direction.isLeft);
                }
                n18 += n16;
            }
            while (n25 != n24) {
                TTScan.this.hScanLines.addCross(F26Dot6.fromInt(n18 + n15), n25, direction.isUp);
                n25 += n23;
            }
            if (this.currentDir == Direction.NONE) {
                this.firstSegmentX = n;
                this.firstSegmentY = n2;
                this.firstSegmentDir = direction;
            } else {
                this.endPointH(this.currentDir, n, n2, direction);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, n, n2, direction);
                }
            }
            this.currentDir = direction;
        }

        public void cubicCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            if ((d <= d3 && d3 <= d5 && d5 <= d7 || d7 <= d5 && d5 <= d3 && d3 <= d) && Math.abs(d7 - d) < this.THRESHOLD && Math.abs(d7 - d - 3.0 * (d3 - d)) <= this.epsilon && Math.abs(d7 - d - 3.0 * (d7 - d5)) <= this.epsilon && (d2 <= d4 && d4 <= d6 && d6 <= d8 || d8 <= d6 && d6 <= d4 && d4 <= d2) && Math.abs(d8 - d2) < this.THRESHOLD && Math.abs(d8 - d2 - 3.0 * (d4 - d2)) <= this.epsilon && Math.abs(d8 - d2 - 3.0 * (d8 - d6)) <= this.epsilon) {
                this.line(d, d2, d7, d8);
            } else {
                double d9 = (d3 + d) / 2.0;
                double d10 = (d4 + d2) / 2.0;
                double d11 = (d5 + d3) / 2.0;
                double d12 = (d6 + d4) / 2.0;
                double d13 = (d7 + d5) / 2.0;
                double d14 = (d8 + d6) / 2.0;
                double d15 = (d11 + d9) / 2.0;
                double d16 = (d12 + d10) / 2.0;
                double d17 = (d13 + d11) / 2.0;
                double d18 = (d14 + d12) / 2.0;
                double d19 = (d15 + d17) / 2.0;
                double d20 = (d16 + d18) / 2.0;
                this.cubicCurve(d, d2, d9, d10, d15, d16, d19, d20);
                this.cubicCurve(d19, d20, d17, d18, d13, d14, d7, d8);
            }
        }

        public void endContour() {
            if (this.currentDir != Direction.NONE) {
                this.endPointH(this.currentDir, this.firstSegmentX, this.firstSegmentY, this.firstSegmentDir);
                if (TTScan.this.isFixing(TTScan.this.scanType)) {
                    this.endPointV(this.currentDir, this.firstSegmentX, this.firstSegmentY, this.firstSegmentDir);
                }
                this.currentDir = Direction.NONE;
            }
        }

        public void endOutline() {
            this.xmin = F26Dot6.roundHalfDown(this.xmin);
            this.ymin = F26Dot6.roundHalfDown(this.ymin);
            this.xmax = F26Dot6.roundHalfUp(this.xmax);
            this.ymax = F26Dot6.roundHalfUp(this.ymax);
            this.zeroDimension = this.xmin == this.xmax || this.ymin == this.ymax;
        }

        void endPointH(Direction direction, int n, int n2, Direction direction2) {
            int n3 = F26Dot6.toInt(F26Dot6.floor(n2));
            if (F26Dot6.fromInt(n3) + 32 != n2) {
                return;
            }
            if (direction2.isUp) {
                if (direction.isUp) {
                    TTScan.this.hScanLines.addCross(n, n3, true);
                } else if (direction.isDown) {
                    TTScan.this.hScanLines.addCross(n, n3, true);
                    TTScan.this.hScanLines.addCross(n, n3, false);
                } else if (direction.isLeft) {
                    TTScan.this.hScanLines.addCross(n, n3, true);
                }
            } else if (direction2.isDown) {
                if (direction.isUp) {
                    TTScan.this.hScanLines.addCross(n, n3, true);
                    TTScan.this.hScanLines.addCross(n, n3, false);
                } else if (direction.isDown) {
                    TTScan.this.hScanLines.addCross(n, n3, false);
                } else if (direction.isRight) {
                    TTScan.this.hScanLines.addCross(n, n3, false);
                }
            } else if (direction.isUp) {
                if (direction2.isRight) {
                    TTScan.this.hScanLines.addCross(n, n3, true);
                }
            } else if (direction.isDown) {
                if (direction2.isLeft) {
                    TTScan.this.hScanLines.addCross(n, n3, false);
                }
            } else if (direction.isRight && direction2.isLeft) {
                TTScan.this.hScanLines.addCross(n, n3, false);
            } else if (direction.isLeft && direction2.isRight) {
                TTScan.this.hScanLines.addCross(n, n3, true);
            }
        }

        void endPointV(Direction direction, int n, int n2, Direction direction2) {
            int n3 = F26Dot6.toInt(F26Dot6.floor(n));
            if (F26Dot6.fromInt(n3) + 32 != n) {
                return;
            }
            if (direction2.isLeft) {
                if (direction.isLeft) {
                    TTScan.this.vScanLines.addCross(n2, n3, true);
                } else if (direction.isRight) {
                    TTScan.this.vScanLines.addCross(n2, n3, true);
                    TTScan.this.vScanLines.addCross(n2, n3, false);
                } else if (direction.isDown) {
                    TTScan.this.vScanLines.addCross(n2, n3, true);
                }
            } else if (direction2.isRight) {
                if (direction.isLeft) {
                    TTScan.this.vScanLines.addCross(n2, n3, true);
                    TTScan.this.vScanLines.addCross(n2, n3, false);
                } else if (direction.isRight) {
                    TTScan.this.vScanLines.addCross(n2, n3, false);
                } else if (direction.isUp) {
                    TTScan.this.vScanLines.addCross(n2, n3, false);
                }
            } else if (direction.isLeft) {
                if (direction2.isUp) {
                    TTScan.this.vScanLines.addCross(n2, n3, true);
                }
            } else if (direction.isRight) {
                if (direction2.isDown) {
                    TTScan.this.vScanLines.addCross(n2, n3, false);
                }
            } else if (direction.isUp && direction2.isDown) {
                TTScan.this.vScanLines.addCross(n2, n3, false);
            } else if (direction.isDown && direction2.isUp) {
                TTScan.this.vScanLines.addCross(n2, n3, true);
            }
        }

        private int getY(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            return 0;
        }

        private int getX(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            return 0;
        }
    }

    private class ScanLines {
        public int firstScanLineCoordI = Integer.MAX_VALUE;
        public ScanLine[] scanLines = null;
        public final boolean horizontal;

        public ScanLines(boolean bl) {
            this.horizontal = bl;
        }

        public void addCross(int n, int n2, boolean bl) {
            Object object;
            if (this.scanLines == null) {
                this.scanLines = new ScanLine[1];
                this.firstScanLineCoordI = n2;
            } else if (n2 < this.firstScanLineCoordI) {
                object = new ScanLine[this.firstScanLineCoordI - n2 + this.scanLines.length];
                System.arraycopy(this.scanLines, 0, object, this.firstScanLineCoordI - n2, this.scanLines.length);
                this.scanLines = object;
                this.firstScanLineCoordI = n2;
            } else if (this.firstScanLineCoordI + this.scanLines.length - 1 < n2) {
                object = new ScanLine[n2 - this.firstScanLineCoordI + 1];
                System.arraycopy(this.scanLines, 0, object, 0, this.scanLines.length);
                this.scanLines = object;
            }
            object = this.scanLines[n2 - this.firstScanLineCoordI];
            if (object == null) {
                this.scanLines[n2 - this.firstScanLineCoordI] = object = new ScanLine();
            }
            ((ScanLine)object).addCross(n, bl);
        }

        public int countCrosses(int n, int n2) {
            if (n < this.firstScanLineCoordI || this.firstScanLineCoordI + this.scanLines.length <= n) {
                return 0;
            }
            ScanLine scanLine = this.scanLines[n - this.firstScanLineCoordI];
            if (scanLine == null) {
                return 0;
            }
            int n3 = 0;
            int n4 = F26Dot6.fromInt(n2);
            for (int i = 0; i < scanLine.onCrosses.values.length; ++i) {
                if (n4 - 32 <= scanLine.onCrosses.values[i] && scanLine.onCrosses.values[i] < n4 + 32) {
                    ++n3;
                }
                if (n4 - 32 > scanLine.offCrosses.values[i] || scanLine.offCrosses.values[i] >= n4 + 32) continue;
                ++n3;
            }
            return n3;
        }
    }

    private static class ScanLine {
        F26Dot6List onCrosses = new F26Dot6List();
        F26Dot6List offCrosses = new F26Dot6List();

        private ScanLine() {
        }

        public void addCross(int n, boolean bl) {
            if (bl) {
                this.onCrosses.add(n);
            } else {
                this.offCrosses.add(n);
            }
        }
    }

    private static class F26Dot6List {
        int[] values;

        private F26Dot6List() {
        }

        public void add(int n) {
            if (this.values == null) {
                this.values = new int[]{n};
            } else {
                int[] nArray = new int[this.values.length + 1];
                boolean bl = false;
                int n2 = 0;
                for (int i = 0; i < this.values.length; ++i) {
                    if (!bl && n < this.values[i]) {
                        nArray[n2++] = n;
                        bl = true;
                    }
                    nArray[n2++] = this.values[i];
                }
                if (!bl) {
                    nArray[n2++] = n;
                }
                this.values = nArray;
            }
        }
    }

    private static class Direction {
        public final boolean isUp;
        public final boolean isDown;
        public final boolean isLeft;
        public final boolean isRight;
        public final String name;
        static final Direction E = new Direction("E", false, false, false, true);
        static final Direction NE = new Direction("NE", true, false, false, true);
        static final Direction N = new Direction("N", true, false, false, false);
        static final Direction NW = new Direction("NW", true, false, true, false);
        static final Direction W = new Direction("W", false, false, true, false);
        static final Direction SW = new Direction("SW", false, true, true, false);
        static final Direction S = new Direction("S", false, true, false, false);
        static final Direction SE = new Direction("SE", false, true, false, true);
        static final Direction NONE = new Direction("NONE", false, false, false, false);
        static final Direction NO_MOVE = new Direction("NO_MOVE", false, false, false, false);

        private Direction(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string;
            this.isUp = bl;
            this.isDown = bl2;
            this.isLeft = bl3;
            this.isRight = bl4;
        }

        public static Direction ofSegment(double d, double d2, double d3, double d4) {
            if (d < d3) {
                if (d2 < d4) {
                    return NE;
                }
                if (d2 == d4) {
                    return E;
                }
                return SE;
            }
            if (d == d3) {
                if (d2 < d4) {
                    return N;
                }
                if (d2 == d4) {
                    return NO_MOVE;
                }
                return S;
            }
            if (d2 < d4) {
                return NW;
            }
            if (d2 == d4) {
                return W;
            }
            return SW;
        }
    }
}

