/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.GposSubsetter;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OpticalSizeData;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public final class Gpos
extends LookupTable {
    protected Gpos(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    protected int getScriptListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 4);
    }

    protected int getFeatureListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 6);
    }

    protected int getLookupListOffset() throws InvalidFontException {
        return this.data.getOffset(0, 8);
    }

    protected LookupTable.LookupResult applyLookupSubtable(int n, int n2, int n3, AttributedRun attributedRun, int n4, int n5, int n6, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        switch (n) {
            case 1: {
                return this.applySinglePos(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 2: {
                return this.applyPairPos(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 3: {
                return this.applyCursiveAttachment(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 4: {
                return this.applyMarkToBase(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 5: {
                return this.applyMarkToLigature(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 6: {
                return this.applyMarkToMark(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 7: {
                return this.applyContextualSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 8: {
                return this.applyChainingContextualSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
            case 9: {
                return this.applyExtensionSubtable(n2, n3, attributedRun, n4, n5, n6, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("Invalid GPOS lookup type (" + n + ")");
    }

    protected int getValueRecordSize(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 += 2;
        }
        if ((n & 2) != 0) {
            n2 += 2;
        }
        if ((n & 4) != 0) {
            n2 += 2;
        }
        if ((n & 8) != 0) {
            n2 += 2;
        }
        if ((n & 0x10) != 0) {
            n2 += 2;
        }
        if ((n & 0x20) != 0) {
            n2 += 2;
        }
        if ((n & 0x40) != 0) {
            n2 += 2;
        }
        if ((n & 0x80) != 0) {
            n2 += 2;
        }
        return n2;
    }

    protected void applyValueRecord(AttributedRun attributedRun, int n, int n2, int n3) throws InvalidFontException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if ((n3 & 1) != 0) {
            n4 = this.data.getint16(n2);
            n2 += 2;
        }
        if ((n3 & 2) != 0) {
            n5 = this.data.getint16(n2);
            n2 += 2;
        }
        if ((n3 & 4) != 0) {
            n6 = this.data.getint16(n2);
            n2 += 2;
        }
        if ((n3 & 8) != 0) {
            n7 = this.data.getint16(n2);
            n2 += 2;
        }
        attributedRun.adjustPlacementAndAdvance(n, n4, n5, n6, n7);
    }

    protected LookupTable.LookupResult applySinglePos(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applySinglePosFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 2: {
                return this.applySinglePosFormat2(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS single pos format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applySinglePosFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        if (this.getCoverageIndex(attributedRun.elementAt(n7), n6) == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n7)) {
            return lookupNotApplied;
        }
        int n8 = this.data.getuint16(n2 + 4);
        this.applyValueRecord(attributedRun, n7, n2 + 6, n8);
        return new LookupTable.LookupResult(true, n7 + 1, 0);
    }

    protected LookupTable.LookupResult applySinglePosFormat2(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n7)) {
            return lookupNotApplied;
        }
        int n9 = this.data.getuint16(n2 + 4);
        int n10 = n2 + 8 + this.getValueRecordSize(n9) * n8;
        this.applyValueRecord(attributedRun, n7, n10, n9);
        return new LookupTable.LookupResult(true, n7 + 1, 0);
    }

    protected LookupTable.LookupResult applyPairPos(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyPairPosFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
            case 2: {
                return this.applyPairPosFormat2(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS pair pos format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyPairPosFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        int n8 = this.getCoverageIndex(attributedRun.elementAt(n7), n6);
        if (n8 == -1) {
            return lookupNotApplied;
        }
        int n9 = n7++;
        while (n7 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n7))) {
            ++n7;
        }
        if (n4 <= n7 || !oTSelector.isApplied(attributedRun, n9, n7)) {
            return lookupNotApplied;
        }
        int n10 = this.data.getuint16(n2 + 4);
        int n11 = this.data.getuint16(n2 + 6);
        int n12 = this.getValueRecordSize(n10);
        int n13 = this.getValueRecordSize(n11);
        int n14 = 2 + n12 + n13;
        int n15 = this.data.getOffset(n2, 10 + 2 * n8);
        int n16 = this.data.getuint16(n15);
        for (int i = 0; i < n16; ++i) {
            int n17 = n15 + 2 + n14 * i;
            int n18 = this.data.getuint16(n17);
            if (n18 != attributedRun.elementAt(n7)) continue;
            if (n10 != 0) {
                this.applyValueRecord(attributedRun, n9, n17 + 2, n10);
            }
            if (n11 != 0) {
                this.applyValueRecord(attributedRun, n7, n17 + 2 + n12, n11);
            }
            if (n11 == 0) {
                return new LookupTable.LookupResult(true, n7, 0);
            }
            return new LookupTable.LookupResult(true, n7 + 1, 0);
        }
        return lookupNotApplied;
    }

    protected LookupTable.LookupResult applyPairPosFormat2(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getOffset(n2, 2);
        int n7 = n5;
        if (this.getCoverageIndex(attributedRun.elementAt(n7), n6) == -1) {
            return lookupNotApplied;
        }
        int n8 = n7++;
        while (n7 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n7))) {
            ++n7;
        }
        if (n4 <= n7 || !oTSelector.isApplied(attributedRun, n8, n7)) {
            return lookupNotApplied;
        }
        int n9 = this.getClassIndex(attributedRun.elementAt(n8), this.data.getOffset(n2, 8));
        int n10 = this.getClassIndex(attributedRun.elementAt(n7), this.data.getOffset(n2, 10));
        int n11 = this.data.getuint16(n2 + 14);
        int n12 = this.data.getuint16(n2 + 4);
        int n13 = this.data.getuint16(n2 + 6);
        int n14 = this.getValueRecordSize(n12);
        int n15 = this.getValueRecordSize(n13);
        int n16 = n14 + n15;
        int n17 = n16 * n11;
        int n18 = n2 + 16 + n9 * n17 + n10 * n16;
        if (n12 != 0) {
            this.applyValueRecord(attributedRun, n8, n18, n12);
        }
        if (n13 != 0) {
            this.applyValueRecord(attributedRun, n7, n18 + n14, n13);
        }
        if (n13 == 0) {
            return new LookupTable.LookupResult(true, n7, 0);
        }
        return new LookupTable.LookupResult(true, n7 + 1, 0);
    }

    protected LookupTable.LookupResult applyCursiveAttachment(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyCursiveAttachmentFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS cursive attachment format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyCursiveAttachmentFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getOffset(n2, 2);
        int n8 = n5;
        int n9 = this.getCoverageIndex(attributedRun.elementAt(n8), n7);
        if (n9 == -1) {
            return lookupNotApplied;
        }
        for (n6 = n5 + 1; n6 < n4 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n6)); ++n6) {
        }
        if (n4 <= n6 || !oTSelector.isApplied(attributedRun, n8, n6)) {
            return lookupNotApplied;
        }
        int n10 = this.getCoverageIndex(attributedRun.elementAt(n6), n7);
        if (n10 == -1) {
            return lookupNotApplied;
        }
        int n11 = this.data.getOffset(n2, 6 + n9 * 4 + 2);
        int n12 = this.data.getOffset(n2, 6 + n10 * 4);
        if (n11 == 0 || n12 == 0) {
            return lookupNotApplied;
        }
        this.mergeAnchors(attributedRun, n8, n11, n6, n12);
        return new LookupTable.LookupResult(true, n8 + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToBase(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyMarkToBaseFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS mark to base format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyMarkToBaseFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getOffset(n2, 2);
        int n8 = this.data.getOffset(n2, 4);
        int n9 = n5;
        if (this.getCoverageIndex(attributedRun.elementAt(n9), n7) == -1) {
            return lookupNotApplied;
        }
        for (n6 = n5 - 1; n3 <= n6 && (this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n6)) || gdef != null && gdef.getGlyphClass(attributedRun.elementAt(n6)) == 3); --n6) {
        }
        if (n6 < n3 || this.getCoverageIndex(attributedRun.elementAt(n6), n8) == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n6, n9)) {
            return lookupNotApplied;
        }
        int n10 = this.data.getuint16(n2 + 6);
        int n11 = this.getCoverageIndex(attributedRun.elementAt(n9), n7);
        int n12 = this.data.getOffset(n2, 8);
        int n13 = this.data.getuint16(n12 + 2 + 4 * n11);
        int n14 = this.data.getOffset(n12, 2 + 4 * n11 + 2);
        int n15 = this.getCoverageIndex(attributedRun.elementAt(n6), n8);
        int n16 = this.data.getOffset(n2, 10);
        int n17 = this.data.getOffset(n16, 2 + 2 * (n10 * n15 + n13));
        this.mergeAnchors(attributedRun, n6, n17, n9, n14);
        return new LookupTable.LookupResult(true, n9 + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToLigature(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyMarkToLigatureFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS mark to ligature format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyMarkToLigatureFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6;
        int n7 = this.data.getOffset(n2, 2);
        int n8 = this.data.getOffset(n2, 4);
        int n9 = n5;
        if (this.getCoverageIndex(attributedRun.elementAt(n9), n7) == -1) {
            return lookupNotApplied;
        }
        for (n6 = n5 - 1; n3 <= n6 && (this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n6)) || gdef != null && gdef.getGlyphClass(attributedRun.elementAt(n6)) == 3); --n6) {
        }
        if (n6 < n3 || this.getCoverageIndex(attributedRun.elementAt(n6), n8) == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n6, n9)) {
            return lookupNotApplied;
        }
        int n10 = this.data.getuint16(n2 + 6);
        int n11 = this.getCoverageIndex(attributedRun.elementAt(n9), n7);
        int n12 = this.data.getOffset(n2, 8);
        int n13 = this.data.getuint16(n12 + 2 + 4 * n11);
        int n14 = this.data.getOffset(n12, 2 + 4 * n11 + 2);
        int n15 = this.getCoverageIndex(attributedRun.elementAt(n6), n8);
        int n16 = this.data.getOffset(n2, 10);
        int n17 = this.data.getOffset(n16, 2 + 2 * n15);
        Integer n18 = (Integer)attributedRun.getElementStyle(n9, Gsub.ligatureComponentAttribute);
        int n19 = n18 == null ? 0 : n18;
        int n20 = this.data.getOffset(n17, 2 + 2 * (n10 * n19 + n13));
        this.mergeAnchors(attributedRun, n6, n20, n9, n14);
        return new LookupTable.LookupResult(true, n9 + 1, 0);
    }

    protected LookupTable.LookupResult applyMarkToMark(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        int n6 = this.data.getuint16(n2);
        switch (n6) {
            case 1: {
                return this.applyMarkToMarkFormat1(n, n2, attributedRun, n3, n4, n5, oTSelector, gdef);
            }
        }
        throw new InvalidFontException("invalid GPOS cursive attachment format (" + n6 + ")");
    }

    protected LookupTable.LookupResult applyMarkToMarkFormat1(int n, int n2, AttributedRun attributedRun, int n3, int n4, int n5, OTSelector oTSelector, Gdef gdef) throws InvalidFontException {
        Integer n6;
        int n7;
        int n8 = this.data.getOffset(n2, 2);
        int n9 = this.data.getOffset(n2, 4);
        int n10 = n5;
        if (this.getCoverageIndex(attributedRun.elementAt(n10), n8) == -1) {
            return lookupNotApplied;
        }
        for (n7 = n5 - 1; n3 <= n7 && this.lookupFlagCovers(n, gdef, attributedRun.elementAt(n7)); --n7) {
        }
        if (n7 < n3 || this.getCoverageIndex(attributedRun.elementAt(n7), n9) == -1) {
            return lookupNotApplied;
        }
        if (!oTSelector.isApplied(attributedRun, n7, n10)) {
            return lookupNotApplied;
        }
        Integer n11 = (Integer)attributedRun.getElementStyle(n10, Gsub.ligatureComponentAttribute);
        if ((n11 == null ? 0 : n11) != ((n6 = (Integer)attributedRun.getElementStyle(n7, Gsub.ligatureComponentAttribute)) == null ? 0 : n6)) {
            return lookupNotApplied;
        }
        int n12 = this.data.getuint16(n2 + 6);
        int n13 = this.getCoverageIndex(attributedRun.elementAt(n10), n8);
        int n14 = this.data.getOffset(n2, 8);
        int n15 = this.data.getuint16(n14 + 2 + 4 * n13);
        int n16 = this.data.getOffset(n14, 2 + 4 * n13 + 2);
        int n17 = this.getCoverageIndex(attributedRun.elementAt(n7), n9);
        int n18 = this.data.getOffset(n2, 10);
        int n19 = this.data.getOffset(n18, 2 + 2 * (n12 * n17 + n15));
        this.mergeAnchors(attributedRun, n7, n19, n10, n16);
        return new LookupTable.LookupResult(true, n10 + 1, 0);
    }

    protected void mergeAnchors(AttributedRun attributedRun, int n, int n2, int n3, int n4) throws InvalidFontException {
        int n5 = this.data.getint16(n2 + 2);
        int n6 = this.data.getint16(n2 + 4);
        int n7 = this.data.getint16(n4 + 2);
        int n8 = this.data.getint16(n4 + 4);
        double d = (double)n5 + attributedRun.getElementXPlacement(n) - (double)n7 - attributedRun.getElementXPlacement(n3);
        double d2 = (double)n6 + attributedRun.getElementYPlacement(n) - (double)n8 - attributedRun.getElementYPlacement(n3);
        if ((Integer)attributedRun.getElementStyle(n, ElementAttribute.bidiLevel) % 2 == 0) {
            for (int i = n; i < n3; ++i) {
                d -= attributedRun.getElementXAdvance(i);
                d2 -= attributedRun.getElementYAdvance(i);
            }
        } else {
            for (int i = n + 1; i <= n3; ++i) {
                d += attributedRun.getElementXAdvance(i);
                d2 += attributedRun.getElementYAdvance(i);
            }
        }
        attributedRun.adjustPlacementAndAdvance(n3, d, d2, 0.0, 0.0);
    }

    public OpticalSizeData getOpticalSizeData(boolean bl) throws InvalidFontException {
        int n = this.getFeatureListOffset();
        int n2 = this.data.getuint16(n);
        for (int i = 0; i < n2; ++i) {
            if (this.data.getint32(n + 2 + 6 * i) != Tag.feature_size) continue;
            int n3 = this.data.getOffset(n, 2 + 6 * i + 4);
            int n4 = this.data.getOffset(0, n3);
            n4 = bl ? (n4 += n) : (n4 += n3);
            return new OpticalSizeData(this.data.getuint16(n4), this.data.getuint16(n4 + 2), this.data.getuint16(n4 + 4), this.data.getuint16(n4 + 6), this.data.getuint16(n4 + 8));
        }
        return null;
    }

    void subsetAndStream(Subset subset, TreeMap treeMap, Map map, int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        GposSubsetter gposSubsetter = new GposSubsetter(this, n, bl);
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = gposSubsetter.subsetAndStream(treeMap, subset);
        map.put(new Integer(1196445523), oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1196445523), oTByteArrayBuilder);
    }
}

