/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.FormattingException;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.ZapfDingbatsEncoding;
import java.util.Iterator;

public final class PDF16PlainTextFormatter {
    private final FallbackFontSet fallbackFontSet;
    public static final InterElementAttribute newComb = new InterElementAttribute("newComb");

    private PDF16PlainTextFormatter(FallbackFontSet fallbackFontSet) {
        this.fallbackFontSet = fallbackFontSet;
    }

    public static PDF16PlainTextFormatter getFormatterInstance(FallbackFontSet fallbackFontSet) {
        return new PDF16PlainTextFormatter(fallbackFontSet);
    }

    public int preFormat(AttributedRun attributedRun, int n, int n2) throws FontException, FormattingException {
        n2 = InFontFormatter.preFormat(attributedRun, n, n2);
        return n2;
    }

    public int format(AttributedRun attributedRun, int n, int n2, boolean bl) throws FontException, FormattingException {
        return this.format(attributedRun, n, n2, bl, true);
    }

    public int format(AttributedRun attributedRun, int n, int n2, boolean bl, boolean bl2) throws FontException, FormattingException {
        int n3;
        int n4;
        ULocale uLocale;
        if (n >= n2) {
            return n2;
        }
        Font font = (Font)attributedRun.getElementStyle(n, ElementAttribute.font);
        if (font != null) {
            uLocale = font.getPostscriptFontDescription();
            for (int i = 0; i < ((PostscriptFontDescription[])uLocale).length; ++i) {
                if (!"AdobePiStd".equals(uLocale[i].getPSName())) continue;
                ZapfDingbatsEncoding.remap(attributedRun, n, n2);
                break;
            }
        }
        n2 = InFontFormatter.firstPass(attributedRun, n, n2);
        uLocale = (ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale);
        if (font == null) {
            Iterator iterator = this.fallbackFontSet.getFallbackFonts(uLocale);
            font = iterator.hasNext() ? (Font)iterator.next() : Base14.courierRegular;
        }
        FontData fontData = ((FontImpl)font).getFontData();
        Font font2 = null;
        try {
            for (n3 = n; n3 < n2; n3 += n4) {
                font2 = font;
                n4 = InFontFormatter.canRenderWithFont(fontData, attributedRun, n3, n2);
                if (n4 == 0) {
                    Iterator iterator = this.fallbackFontSet.getFallbackFonts(uLocale);
                    while (n4 == 0 && iterator.hasNext()) {
                        font2 = (Font)iterator.next();
                        n4 = InFontFormatter.canRenderWithFont(((FontImpl)font2).getFontData(), attributedRun, n3, n2);
                    }
                }
                if (n4 == 0) {
                    font2 = font;
                    n4 = InFontFormatter.canRenderWithNotdef(attributedRun, n3, n2);
                }
                attributedRun.setElementStyle(n3, n3 + n4, ElementAttribute.font, font2);
            }
        }
        catch (FontException fontException) {
            fontException.initFont(font2);
            throw fontException;
        }
        if (bl) {
            attributedRun.setInterElementStyleBefore(n, newComb, Boolean.TRUE);
            n3 = n;
            n4 = n + 1;
            while (n4 < n2) {
                if (!CharUtil.isCombining(attributedRun.elementAt(n4))) {
                    attributedRun.setInterElementStyleBefore(n4, newComb, Boolean.TRUE);
                    int n5 = InFontFormatter.format(attributedRun, n3, n4, bl2);
                    n2 += n5 - n4;
                    n3 = n5;
                    n4 = n5 + 1;
                    continue;
                }
                attributedRun.setInterElementStyleBefore(n4, newComb, Boolean.FALSE);
                ++n4;
            }
            return InFontFormatter.format(attributedRun, n3, n2, bl2);
        }
        return InFontFormatter.format(attributedRun, n, n2, bl2);
    }
}

