/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Head
extends Table {
    protected Head(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        if (fontByteArray.getSize() < 46) {
            throw new InvalidFontException("'head' table must be at least 46 bytes");
        }
        int n = this.getTableMajorVersion();
        if (n != 1) {
            throw new UnsupportedFontException("'head' tables with major version " + n + " are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    protected long checksum() throws InvalidFontException {
        return this.checksum(12, this.data.getSize(), this.checksum(0, 8, 0L));
    }

    public boolean isConverted() throws InvalidFontException {
        return (this.data.getuint16(16) & 0x1000) != 0;
    }

    public int getUnitsPerEm() throws InvalidFontException {
        return this.data.getuint16(18);
    }

    public int getIndexToLocFormat() throws InvalidFontException {
        return this.data.getint16(50);
    }

    public boolean isItalic() throws InvalidFontException {
        return (this.data.getuint16(44) & 2) != 0;
    }

    public int getXMin() throws InvalidFontException {
        return this.data.getint16(36);
    }

    public int getYMin() throws InvalidFontException {
        return this.data.getint16(38);
    }

    public int getXMax() throws InvalidFontException {
        return this.data.getint16(40);
    }

    public int getYMax() throws InvalidFontException {
        return this.data.getint16(42);
    }

    public Rect getFontBBox() throws InvalidFontException {
        return new Rect(this.getXMin(), this.getYMin(), this.getXMax(), this.getYMax());
    }

    public OTByteArray.OTByteArrayBuilder subsetAndStream(Subset subset, Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        oTByteArrayBuilder.setint16(50, 1);
        map.put(new Integer(1751474532), oTByteArrayBuilder);
        return oTByteArrayBuilder;
    }

    public OTByteArray.OTByteArrayBuilder stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1751474532), oTByteArrayBuilder);
        return oTByteArrayBuilder;
    }

    static final void clearChecksumAdjust(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder) {
        oTByteArrayBuilder.setuint32(8, 0);
    }

    static final void setChecksumAdjust(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, long l) {
        oTByteArrayBuilder.setuint32(8, (int)l);
    }
}

