/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F32Dot0Vector;

public final class TTPoint
implements Cloneable {
    public boolean onCurve;
    public F32Dot0Vector unscaled = new F32Dot0Vector();
    public F26Dot6Vector original;
    public F26Dot6Vector unhinted;
    public F26Dot6Vector hinted;
    public boolean touchedX;
    public boolean touchedY;

    public TTPoint(int n, int n2, boolean bl) {
        this.unscaled.x = n;
        this.unscaled.y = n2;
        this.original = new F26Dot6Vector();
        this.unhinted = new F26Dot6Vector();
        this.hinted = new F26Dot6Vector();
        this.touchedX = false;
        this.touchedY = false;
        this.onCurve = bl;
    }

    public void scale(int n, Matrix matrix) {
        double d = (double)this.unscaled.x / (double)n;
        double d2 = (double)this.unscaled.y / (double)n;
        this.unhinted.x = F26Dot6.fromDouble(matrix.applyToXYGetX(d, d2));
        this.unhinted.y = F26Dot6.fromDouble(matrix.applyToXYGetY(d, d2));
        this.original.x = this.unhinted.x;
        this.original.y = this.unhinted.y;
        this.hinted.x = this.unhinted.x;
        this.hinted.y = this.unhinted.y;
        this.touchedX = false;
        this.touchedY = false;
    }

    public boolean touched(boolean bl) {
        if (bl) {
            return this.touchedX;
        }
        return this.touchedY;
    }

    public Object clone() {
        TTPoint tTPoint = new TTPoint(this.unscaled.x, this.unscaled.y, this.onCurve);
        tTPoint.original.x = this.original.x;
        tTPoint.original.y = this.original.y;
        tTPoint.hinted.x = this.hinted.x;
        tTPoint.hinted.y = this.hinted.y;
        tTPoint.unhinted.x = this.unhinted.x;
        tTPoint.unhinted.y = this.unhinted.y;
        tTPoint.touchedX = this.touchedX;
        tTPoint.touchedY = this.touchedY;
        return tTPoint;
    }

    public String toString() {
        return "u=" + this.unscaled + " o=" + this.unhinted + " c=" + this.hinted + " on=" + this.onCurve + " t=" + (this.touchedX ? "Y" : "N") + (this.touchedY ? "Y" : "N");
    }
}

