/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;

class GdefSubsetter
extends LayoutTableSubsetter
implements LayoutTable.CoverageConsumer {
    private Subset subset;
    private int numLigGlyphs;
    private int origLCLOffset;
    private int[] keepLigGlyph;

    GdefSubsetter(Gdef gdef) {
        super(gdef, OTByteArray.getOTByteArrayBuilderInstance(12));
    }

    OTByteArray.OTByteArrayBuilder subsetAndStream(Subset subset, int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = 12;
        this.builder.setuint32(0, 65536);
        int n3 = this.origTable.data.getOffset(0, 4);
        if (n3 == 0) {
            this.builder.setuint16(4, 0);
        } else {
            this.builder.setuint16(4, n2);
            n2 += this.writeClassDef(n3, n2, subset, n);
        }
        this.builder.setuint16(6, 0);
        n3 = this.origTable.data.getOffset(0, 8);
        if (n3 == 0) {
            this.builder.setuint16(8, 0);
        } else {
            this.builder.setuint16(8, n2);
            n2 += this.writeLigCaretList(n3, n2, subset);
        }
        n3 = this.origTable.data.getOffset(0, 10);
        if (n3 <= 10) {
            this.builder.setuint16(10, 0);
        } else {
            this.builder.setuint16(10, n2);
            this.writeClassDef(n3, n2, subset, n);
        }
        return this.builder;
    }

    public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        if (this.subset.getExistingSubsetGid(n) != -1) {
            int n3 = this.origTable.data.getOffset(this.origLCLOffset, 4 + 2 * n2);
            int n4 = this.origTable.data.getuint16(n3);
            for (int i = 0; i < n4; ++i) {
                int n5 = this.origTable.data.getOffset(n3, 2 + 2 * i);
                int n6 = this.origTable.data.getuint16(n5);
                if (n6 != 2) continue;
                return true;
            }
            this.keepLigGlyph[this.subset.getExistingSubsetGid((int)n)] = n2;
            ++this.numLigGlyphs;
        }
        return true;
    }

    int writeLigCaretList(int n, int n2, Subset subset) throws InvalidFontException, UnsupportedFontException {
        this.numLigGlyphs = 0;
        this.subset = subset;
        this.origLCLOffset = n;
        this.keepLigGlyph = new int[subset.getNumGlyphs()];
        Arrays.fill(this.keepLigGlyph, -1);
        int n3 = this.origTable.data.getOffset(n, 0);
        this.origTable.iterateCoverage(n3, null, this);
        int n4 = 4 + 2 * this.numLigGlyphs;
        this.builder.ensureCapacity(n2 + n4);
        this.builder.setuint16(n2, n4);
        n4 += this.writeCoverage(this.origTable.data.getOffset(n, 0), n2 + n4);
        this.builder.setuint16(n2 + 2, this.numLigGlyphs);
        int n5 = 0;
        for (int i = 0; i < this.keepLigGlyph.length; ++i) {
            if (this.keepLigGlyph[i] == -1) continue;
            int n6 = this.keepLigGlyph[i];
            this.builder.setuint16(n2 + 4 + 2 * n5, n4);
            n4 += this.writeLigGlyph(this.origTable.data.getOffset(n, 4 + 2 * n6), n2 + n4);
            ++n5;
        }
        return n4;
    }

    int writeCoverage(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        LayoutTableSubsetter.CoverageGenerator coverageGenerator = LayoutTableSubsetter.CoverageGenerator.newInstance(this.origTable, n, this.subset);
        OTByteArray oTByteArray = coverageGenerator.generateCoverage().toOTByteArray();
        return this.writeByteArrayAtOffset(n2, oTByteArray);
    }

    int writeLigGlyph(int n, int n2) throws InvalidFontException {
        int n3 = this.origTable.data.getuint16(n);
        int n4 = 2 + 2 * n3;
        this.builder.ensureCapacity(n2 + n4);
        this.builder.setuint16(n2, n3);
        for (int i = 0; i < n3; ++i) {
            this.builder.setuint16(n2 + 2 + 2 * i, n4);
            n4 += this.writeCaretValue(this.origTable.data.getOffset(n, 2 + 2 * i), n2 + n4);
        }
        return n4;
    }

    int writeCaretValue(int n, int n2) throws InvalidFontException {
        this.builder.ensureCapacity(n2 + 4);
        this.builder.setuint16(n2, 1);
        this.builder.setint16(n2 + 2, this.origTable.data.getint16(n + 2));
        return 4;
    }

    int writeClassDef(int n, int n2, Subset subset, int n3) throws InvalidFontException, UnsupportedFontException {
        LayoutTableSubsetter.ClassDefGenerator classDefGenerator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, n, subset, n3);
        OTByteArray oTByteArray = classDefGenerator.generateClass().toOTByteArray();
        return this.writeByteArrayAtOffset(n2, oTByteArray);
    }
}

