/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class TransitiveHull
implements VerifierFactoryObserver {
    private int indent = 0;

    private TransitiveHull() {
    }

    public void update(String classname) {
        System.gc();
        for (int i2 = 0; i2 < this.indent; ++i2) {
            System.out.print(" ");
        }
        System.out.println(classname);
        ++this.indent;
        Verifier v2 = VerifierFactory.getVerifier(classname);
        VerificationResult vr = v2.doPass1();
        if (vr != VerificationResult.VR_OK) {
            System.out.println("Pass 1:\n" + vr);
        }
        if ((vr = v2.doPass2()) != VerificationResult.VR_OK) {
            System.out.println("Pass 2:\n" + vr);
        }
        if (vr == VerificationResult.VR_OK) {
            try {
                JavaClass jc = Repository.lookupClass(v2.getClassName());
                for (int i3 = 0; i3 < jc.getMethods().length; ++i3) {
                    vr = v2.doPass3a(i3);
                    if (vr != VerificationResult.VR_OK) {
                        System.out.println(v2.getClassName() + ", Pass 3a, method " + i3 + " ['" + jc.getMethods()[i3] + "']:\n" + vr);
                    }
                    if ((vr = v2.doPass3b(i3)) == VerificationResult.VR_OK) continue;
                    System.out.println(v2.getClassName() + ", Pass 3b, method " + i3 + " ['" + jc.getMethods()[i3] + "']:\n" + vr);
                }
            }
            catch (ClassNotFoundException e2) {
                System.err.println("Could not find class " + v2.getClassName() + " in Repository");
            }
        }
        --this.indent;
    }

    public static void main(String[] args) {
        int dotclasspos;
        if (args.length != 1) {
            System.out.println("Need exactly one argument: The root class to verify.");
            System.exit(1);
        }
        if ((dotclasspos = args[0].lastIndexOf(".class")) != -1) {
            args[0] = args[0].substring(0, dotclasspos);
        }
        args[0] = args[0].replace('/', '.');
        TransitiveHull th = new TransitiveHull();
        VerifierFactory.attach(th);
        VerifierFactory.getVerifier(args[0]);
        VerifierFactory.detach(th);
    }
}

