/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.util.ByteSequence;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackProducer {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short opcode, int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super(opcode, defaultTarget);
        this.targets = targets;
        for (int i2 = 0; i2 < targets.length; ++i2) {
            Select.notifyTarget(null, targets[i2], this);
        }
        this.match = match;
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    protected int updatePosition(int offset, int max_offset) {
        this.position += offset;
        short old_length = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - old_length;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        for (int i2 = 0; i2 < this.padding; ++i2) {
            out.writeByte(0);
        }
        this.index = this.getTargetOffset();
        out.writeInt(this.index);
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        for (int i2 = 0; i2 < this.padding; ++i2) {
            bytes.readByte();
        }
        this.index = bytes.readInt();
    }

    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer(super.toString(verbose));
        if (verbose) {
            for (int i2 = 0; i2 < this.match_length; ++i2) {
                String s2 = "null";
                if (this.targets[i2] != null) {
                    s2 = this.targets[i2].getInstruction().toString();
                }
                buf.append("(").append(this.match[i2]).append(", ").append(s2).append(" = {").append(this.indices[i2]).append("})");
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(int i2, InstructionHandle target) {
        Select.notifyTarget(this.targets[i2], target, this);
        this.targets[i2] = target;
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.target == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != old_ih) continue;
            targeted = true;
            this.setTarget(i2, new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    public boolean containsTarget(InstructionHandle ih) {
        if (this.target == ih) {
            return true;
        }
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != ih) continue;
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        Select copy = (Select)super.clone();
        copy.match = (int[])this.match.clone();
        copy.indices = (int[])this.indices.clone();
        copy.targets = (InstructionHandle[])this.targets.clone();
        return copy;
    }

    void dispose() {
        super.dispose();
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            this.targets[i2].removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }
}

