/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;

public class ConstantPoolGen
implements Serializable {
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private Map string_table = new HashMap();
    private Map class_table = new HashMap();
    private Map utf8_table = new HashMap();
    private Map n_a_t_table = new HashMap();
    private Map cp_table = new HashMap();

    public ConstantPoolGen(Constant[] cs) {
        if (cs.length > this.size) {
            this.size = cs.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(cs, 0, this.constants, 0, cs.length);
        if (cs.length > 0) {
            this.index = cs.length;
        }
        for (int i2 = 1; i2 < this.index; ++i2) {
            String key;
            ConstantUtf8 u8;
            Constant s2;
            Constant c2 = this.constants[i2];
            if (c2 instanceof ConstantString) {
                s2 = (ConstantString)c2;
                u8 = (ConstantUtf8)this.constants[((ConstantString)s2).getStringIndex()];
                key = u8.getBytes();
                if (this.string_table.containsKey(key)) continue;
                this.string_table.put(key, new Index(i2));
                continue;
            }
            if (c2 instanceof ConstantClass) {
                s2 = (ConstantClass)c2;
                u8 = (ConstantUtf8)this.constants[((ConstantClass)s2).getNameIndex()];
                key = u8.getBytes();
                if (this.class_table.containsKey(key)) continue;
                this.class_table.put(key, new Index(i2));
                continue;
            }
            if (c2 instanceof ConstantNameAndType) {
                ConstantNameAndType n2 = (ConstantNameAndType)c2;
                u8 = (ConstantUtf8)this.constants[n2.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)this.constants[n2.getSignatureIndex()];
                String key2 = u8.getBytes() + NAT_DELIM + u8_2.getBytes();
                if (this.n_a_t_table.containsKey(key2)) continue;
                this.n_a_t_table.put(key2, new Index(i2));
                continue;
            }
            if (c2 instanceof ConstantUtf8) {
                ConstantUtf8 u2 = (ConstantUtf8)c2;
                String key3 = u2.getBytes();
                if (this.utf8_table.containsKey(key3)) continue;
                this.utf8_table.put(key3, new Index(i2));
                continue;
            }
            if (!(c2 instanceof ConstantCP)) continue;
            ConstantCP m2 = (ConstantCP)c2;
            ConstantClass clazz = (ConstantClass)this.constants[m2.getClassIndex()];
            ConstantNameAndType n3 = (ConstantNameAndType)this.constants[m2.getNameAndTypeIndex()];
            ConstantUtf8 u82 = (ConstantUtf8)this.constants[clazz.getNameIndex()];
            String class_name = u82.getBytes().replace('/', '.');
            u82 = (ConstantUtf8)this.constants[n3.getNameIndex()];
            String method_name = u82.getBytes();
            u82 = (ConstantUtf8)this.constants[n3.getSignatureIndex()];
            String signature = u82.getBytes();
            String delim = METHODREF_DELIM;
            if (c2 instanceof ConstantInterfaceMethodref) {
                delim = IMETHODREF_DELIM;
            } else if (c2 instanceof ConstantFieldref) {
                delim = FIELDREF_DELIM;
            }
            String key4 = class_name + delim + method_name + delim + signature;
            if (this.cp_table.containsKey(key4)) continue;
            this.cp_table.put(key4, new Index(i2));
        }
    }

    public ConstantPoolGen(ConstantPool cp) {
        this(cp.getConstantPool());
    }

    public ConstantPoolGen() {
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] cs = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(cs, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String str) {
        Index index = (Index)this.string_table.get(str);
        return index != null ? index.index : -1;
    }

    public int addString(String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        int utf8 = this.addUtf8(str);
        this.adjustSize();
        ConstantString s2 = new ConstantString(utf8);
        ret = this.index;
        this.constants[this.index++] = s2;
        if (!this.string_table.containsKey(str)) {
            this.string_table.put(str, new Index(ret));
        }
        return ret;
    }

    public int lookupClass(String str) {
        Index index = (Index)this.class_table.get(str.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private int addClass_(String clazz) {
        int ret = this.lookupClass(clazz);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c2 = new ConstantClass(this.addUtf8(clazz));
        ret = this.index;
        this.constants[this.index++] = c2;
        if (!this.class_table.containsKey(clazz)) {
            this.class_table.put(clazz, new Index(ret));
        }
        return ret;
    }

    public int addClass(String str) {
        return this.addClass_(str.replace('.', '/'));
    }

    public int addClass(ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public int addArrayClass(ArrayType type) {
        return this.addClass_(type.getSignature());
    }

    public int lookupInteger(int n2) {
        for (int i2 = 1; i2 < this.index; ++i2) {
            ConstantInteger c2;
            if (!(this.constants[i2] instanceof ConstantInteger) || (c2 = (ConstantInteger)this.constants[i2]).getBytes() != n2) continue;
            return i2;
        }
        return -1;
    }

    public int addInteger(int n2) {
        int ret = this.lookupInteger(n2);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantInteger(n2);
        return ret;
    }

    public int lookupFloat(float n2) {
        int bits = Float.floatToIntBits(n2);
        for (int i2 = 1; i2 < this.index; ++i2) {
            ConstantFloat c2;
            if (!(this.constants[i2] instanceof ConstantFloat) || Float.floatToIntBits((c2 = (ConstantFloat)this.constants[i2]).getBytes()) != bits) continue;
            return i2;
        }
        return -1;
    }

    public int addFloat(float n2) {
        int ret = this.lookupFloat(n2);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantFloat(n2);
        return ret;
    }

    public int lookupUtf8(String n2) {
        Index index = (Index)this.utf8_table.get(n2);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String n2) {
        int ret = this.lookupUtf8(n2);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantUtf8(n2);
        if (!this.utf8_table.containsKey(n2)) {
            this.utf8_table.put(n2, new Index(ret));
        }
        return ret;
    }

    public int lookupLong(long n2) {
        for (int i2 = 1; i2 < this.index; ++i2) {
            ConstantLong c2;
            if (!(this.constants[i2] instanceof ConstantLong) || (c2 = (ConstantLong)this.constants[i2]).getBytes() != n2) continue;
            return i2;
        }
        return -1;
    }

    public int addLong(long n2) {
        int ret = this.lookupLong(n2);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantLong(n2);
        this.index += 2;
        return ret;
    }

    public int lookupDouble(double n2) {
        long bits = Double.doubleToLongBits(n2);
        for (int i2 = 1; i2 < this.index; ++i2) {
            ConstantDouble c2;
            if (!(this.constants[i2] instanceof ConstantDouble) || Double.doubleToLongBits((c2 = (ConstantDouble)this.constants[i2]).getBytes()) != bits) continue;
            return i2;
        }
        return -1;
    }

    public int addDouble(double n2) {
        int ret = this.lookupDouble(n2);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantDouble(n2);
        this.index += 2;
        return ret;
    }

    public int lookupNameAndType(String name, String signature) {
        Index _index = (Index)this.n_a_t_table.get(name + NAT_DELIM + signature);
        return _index != null ? _index.index : -1;
    }

    public int addNameAndType(String name, String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantNameAndType(name_index, signature_index);
        String key = name + NAT_DELIM + signature;
        if (!this.n_a_t_table.containsKey(key)) {
            this.n_a_t_table.put(key, new Index(ret));
        }
        return ret;
    }

    public int lookupMethodref(String class_name, String method_name, String signature) {
        Index index = (Index)this.cp_table.get(class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen method) {
        return this.lookupMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.index;
        this.constants[this.index++] = new ConstantMethodref(class_index, name_and_type_index);
        String key = class_name + METHODREF_DELIM + method_name + METHODREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    public int addMethodref(MethodGen method) {
        return this.addMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupInterfaceMethodref(String class_name, String method_name, String signature) {
        Index index = (Index)this.cp_table.get(class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen method) {
        return this.lookupInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int addInterfaceMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        String key = class_name + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    public int addInterfaceMethodref(MethodGen method) {
        return this.addInterfaceMethodref(method.getClassName(), method.getName(), method.getSignature());
    }

    public int lookupFieldref(String class_name, String field_name, String signature) {
        Index index = (Index)this.cp_table.get(class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String class_name, String field_name, String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantFieldref(class_index, name_and_type_index);
        String key = class_name + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature;
        if (!this.cp_table.containsKey(key)) {
            this.cp_table.put(key, new Index(ret));
        }
        return ret;
    }

    public Constant getConstant(int i2) {
        return this.constants[i2];
    }

    public void setConstant(int i2, Constant c2) {
        this.constants[i2] = c2;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.index];
        System.arraycopy(this.constants, 0, cs, 0, this.index);
        return new ConstantPool(cs);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 1; i2 < this.index; ++i2) {
            buf.append(i2).append(")").append(this.constants[i2]).append("\n");
        }
        return buf.toString();
    }

    public int addConstant(Constant c2, ConstantPoolGen cp) {
        Constant[] constants = cp.getConstantPool().getConstantPool();
        switch (c2.getTag()) {
            case 8: {
                ConstantString s2 = (ConstantString)c2;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s2.getStringIndex()];
                return this.addString(u8.getBytes());
            }
            case 7: {
                ConstantClass s3 = (ConstantClass)c2;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s3.getNameIndex()];
                return this.addClass(u8.getBytes());
            }
            case 12: {
                ConstantNameAndType n2 = (ConstantNameAndType)c2;
                ConstantUtf8 u8 = (ConstantUtf8)constants[n2.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)constants[n2.getSignatureIndex()];
                return this.addNameAndType(u8.getBytes(), u8_2.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)c2).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)c2).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)c2).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)c2).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)c2).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP m2 = (ConstantCP)c2;
                ConstantClass clazz = (ConstantClass)constants[m2.getClassIndex()];
                ConstantNameAndType n3 = (ConstantNameAndType)constants[m2.getNameAndTypeIndex()];
                ConstantUtf8 u8 = (ConstantUtf8)constants[clazz.getNameIndex()];
                String class_name = u8.getBytes().replace('/', '.');
                u8 = (ConstantUtf8)constants[n3.getNameIndex()];
                String name = u8.getBytes();
                u8 = (ConstantUtf8)constants[n3.getSignatureIndex()];
                String signature = u8.getBytes();
                switch (c2.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(class_name, name, signature);
                    }
                    case 10: {
                        return this.addMethodref(class_name, name, signature);
                    }
                    case 9: {
                        return this.addFieldref(class_name, name, signature);
                    }
                }
                throw new RuntimeException("Unknown constant type " + c2);
            }
        }
        throw new RuntimeException("Unknown constant type " + c2);
    }

    private static class Index
    implements Serializable {
        int index;

        Index(int i2) {
            this.index = i2;
        }
    }
}

