/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.AnalysisUsage;
import llvm.BasicBlock;
import llvm.Function;
import llvm.FunctionPass;
import llvm.Module;
import llvm.SCEV;
import llvm.SolverResult;
import llvm.Value;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class PointerTracking
extends FunctionPass {
    private long swigCPtr;

    protected PointerTracking(long l2, boolean bl2) {
        super(llvmJNI.SWIGPointerTrackingUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(PointerTracking pointerTracking) {
        return pointerTracking == null ? 0L : pointerTracking.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_PointerTracking(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static void setID(char c2) {
        llvmJNI.PointerTracking_ID_set(c2);
    }

    public static char getID() {
        return llvmJNI.PointerTracking_ID_get();
    }

    public PointerTracking() {
        this(llvmJNI.new_PointerTracking(), true);
    }

    public boolean doInitialization(Module module) {
        return llvmJNI.PointerTracking_doInitialization(this.swigCPtr, this, Module.getCPtr(module), module);
    }

    public SCEV getAllocationElementCount(Value value) {
        long l2 = llvmJNI.PointerTracking_getAllocationElementCount(this.swigCPtr, this, Value.getCPtr(value), value);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAllocationSizeInBytes(Value value) {
        long l2 = llvmJNI.PointerTracking_getAllocationSizeInBytes(this.swigCPtr, this, Value.getCPtr(value), value);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public void getPointerOffset(Value value, Value value2, SCEV sCEV, SCEV sCEV2) {
        llvmJNI.PointerTracking_getPointerOffset(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
    }

    public SolverResult checkLimits(SCEV sCEV, SCEV sCEV2, BasicBlock basicBlock) {
        return SolverResult.swigToEnum(llvmJNI.PointerTracking_checkLimits(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, BasicBlock.getCPtr(basicBlock), basicBlock));
    }

    public boolean runOnFunction(Function function) {
        return llvmJNI.PointerTracking_runOnFunction(this.swigCPtr, this, Function.getCPtr(function), function);
    }

    public void getAnalysisUsage(AnalysisUsage analysisUsage) {
        llvmJNI.PointerTracking_getAnalysisUsage(this.swigCPtr, this, AnalysisUsage.getCPtr(analysisUsage), analysisUsage);
    }

    public void print(raw_ostream raw_ostream2, Module module) {
        llvmJNI.PointerTracking_print__SWIG_0(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2, Module.getCPtr(module), module);
    }

    public void print(raw_ostream raw_ostream2) {
        llvmJNI.PointerTracking_print__SWIG_1(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2);
    }
}

