/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Instruction;
import llvm.LLVMContext;
import llvm.MDNode;
import llvm.SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator;
import llvm.Twine;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;

public class IRBuilderBase {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected IRBuilderBase(long l2, boolean bl2) {
        this.swigCMemOwn = bl2;
        this.swigCPtr = l2;
    }

    protected static long getCPtr(IRBuilderBase iRBuilderBase) {
        return iRBuilderBase == null ? 0L : iRBuilderBase.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_IRBuilderBase(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IRBuilderBase(LLVMContext lLVMContext) {
        this(llvmJNI.new_IRBuilderBase(LLVMContext.getCPtr(lLVMContext), lLVMContext), true);
    }

    public void ClearInsertionPoint() {
        llvmJNI.IRBuilderBase_ClearInsertionPoint(this.swigCPtr, this);
    }

    public BasicBlock GetInsertBlock() {
        long l2 = llvmJNI.IRBuilderBase_GetInsertBlock(this.swigCPtr, this);
        return l2 == 0L ? null : new BasicBlock(l2, false);
    }

    public SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator GetInsertPoint() {
        return new SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator(llvmJNI.IRBuilderBase_GetInsertPoint(this.swigCPtr, this), true);
    }

    public void SetInsertPoint(BasicBlock basicBlock) {
        llvmJNI.IRBuilderBase_SetInsertPoint__SWIG_0(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock);
    }

    public void SetInsertPoint(BasicBlock basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator) {
        llvmJNI.IRBuilderBase_SetInsertPoint__SWIG_1(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, SWIGTYPE_p_llvm__BasicBlock__InstListType__iterator.getCPtr(sWIGTYPE_p_llvm__BasicBlock__InstListType__iterator));
    }

    public void SetCurrentDebugLocation(MDNode mDNode) {
        llvmJNI.IRBuilderBase_SetCurrentDebugLocation(this.swigCPtr, this, MDNode.getCPtr(mDNode), mDNode);
    }

    public MDNode getCurrentDebugLocation() {
        long l2 = llvmJNI.IRBuilderBase_getCurrentDebugLocation(this.swigCPtr, this);
        return l2 == 0L ? null : new MDNode(l2, false);
    }

    public void SetInstDebugLocation(Instruction instruction) {
        llvmJNI.IRBuilderBase_SetInstDebugLocation(this.swigCPtr, this, Instruction.getCPtr(instruction), instruction);
    }

    public Value CreateGlobalString(String string, Twine twine) {
        long l2 = llvmJNI.IRBuilderBase_CreateGlobalString__SWIG_0(this.swigCPtr, this, string, Twine.getCPtr(twine), twine);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateGlobalString(String string) {
        long l2 = llvmJNI.IRBuilderBase_CreateGlobalString__SWIG_1(this.swigCPtr, this, string);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Value CreateGlobalString() {
        long l2 = llvmJNI.IRBuilderBase_CreateGlobalString__SWIG_2(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public Type getInt1Ty() {
        long l2 = llvmJNI.IRBuilderBase_getInt1Ty(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getInt8Ty() {
        long l2 = llvmJNI.IRBuilderBase_getInt8Ty(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getInt16Ty() {
        long l2 = llvmJNI.IRBuilderBase_getInt16Ty(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getInt32Ty() {
        long l2 = llvmJNI.IRBuilderBase_getInt32Ty(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getInt64Ty() {
        long l2 = llvmJNI.IRBuilderBase_getInt64Ty(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getFloatTy() {
        long l2 = llvmJNI.IRBuilderBase_getFloatTy(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getDoubleTy() {
        long l2 = llvmJNI.IRBuilderBase_getDoubleTy(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getVoidTy() {
        long l2 = llvmJNI.IRBuilderBase_getVoidTy(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getInt8PtrTy() {
        long l2 = llvmJNI.IRBuilderBase_getInt8PtrTy(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public Type getCurrentFunctionReturnType() {
        long l2 = llvmJNI.IRBuilderBase_getCurrentFunctionReturnType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }
}

