/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JA_KeyData;
import com.rsa.jsafe.JCMPInteger;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidArithmeticException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.aa;
import com.rsa.jsafe.ab;
import com.rsa.jsafe.ac;
import com.rsa.jsafe.bk;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public final class JA_DH
extends JSAFE_Object
implements aa,
ab,
Cloneable,
Serializable {
    private int a;
    private Class b;
    private SecureRandom c;
    private byte[] d;
    private String e;
    private JCMPInteger f;
    private JCMPInteger g;
    private int h;
    private JCMPInteger i;
    private JCMPInteger j;
    private JCMPInteger k;

    public JA_DH() {
    }

    public JA_DH(int[] nArray) throws JSAFE_InvalidParameterException {
        this();
        this.a(nArray);
    }

    public void a(int[] nArray) throws JSAFE_InvalidParameterException {
        if (nArray != null && nArray.length != 0) {
            throw new JSAFE_InvalidParameterException("Invalid instantiation parameters. Expected no parameters.");
        }
    }

    public String d() {
        return "DH";
    }

    public int f() {
        return this.a;
    }

    public int[] c() {
        return new int[0];
    }

    public boolean a(byte[] byArray, int n2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        try {
            return bk.a(this, byArray, n2);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_UnimplementedException(jSAFE_Exception.getMessage());
        }
    }

    public byte[] e() throws JSAFE_UnimplementedException {
        return bk.a(this.f, this.g, this.h);
    }

    private void l() {
        if (this.b == null) {
            this.b = ac.a();
        }
    }

    public void a(Class clazz) throws JSAFE_InvalidArithmeticException {
        try {
            JCMPInteger jCMPInteger = (JCMPInteger)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidArithmeticException("Incorrect arithmetic class.");
        }
        this.b = clazz;
    }

    void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, boolean bl2, byte[] byArray3, int n7, int n8) throws JSAFE_InvalidParameterException {
        this.p();
        try {
            this.l();
            this.f = (JCMPInteger)this.b.newInstance();
            this.g = (JCMPInteger)this.b.newInstance();
            this.f.setValue(byArray, n2, n3);
            this.g.setValue(byArray2, n4, n5);
            int n9 = this.f.getBitLength();
            if (n9 < 256 || n9 > 2048) {
                throw new JSAFE_InvalidParameterException("Invalid DH prime size. Should be between 256 and 2048 bits.");
            }
            if (this.g.compareTo(this.f) >= 0) {
                throw new JSAFE_InvalidParameterException("Invalid DH base size.");
            }
            this.h = n9 - 1;
            if (n6 != -1) {
                this.h = n6;
            } else if (bl2) {
                this.h = 0;
                int n10 = 0;
                int n11 = 0;
                while (n10 < n8) {
                    this.h <<= n11;
                    this.h |= byArray3[n10 + n7] & 0xFF;
                    ++n10;
                    n11 += 8;
                }
            }
            if (this.h >= n9 || this.h < 160) {
                throw new JSAFE_InvalidParameterException("Invalid DH max exponent length. Should be no less than 160 but less than " + n9);
            }
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (InstantiationException instantiationException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSAFE_InvalidParameterException("Bad arithmetic class.");
        }
        this.m();
    }

    public void a(SecureRandom secureRandom) {
        if (secureRandom != null) {
            this.c = secureRandom;
        }
    }

    public void a(JSAFE_Parameters jSAFE_Parameters) throws JSAFE_InvalidParameterException {
        try {
            byte[][] byArray = jSAFE_Parameters.getParameterData("DHParameters");
            if (byArray == null || byArray.length != 3) {
                throw new JSAFE_InvalidParameterException("Invalid DH parameters.");
            }
            this.a(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new JSAFE_InvalidParameterException("Invalid DH parameters.");
        }
    }

    public boolean a(JSAFE_PublicKey jSAFE_PublicKey) {
        byte[][] byArray = JA_KeyData.a(jSAFE_PublicKey, "DHPublicKey");
        if (byArray == null || byArray.length != 4) {
            return false;
        }
        try {
            this.a(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        return true;
    }

    public boolean a(JSAFE_PrivateKey jSAFE_PrivateKey) {
        byte[][] byArray = JA_KeyData.a(jSAFE_PrivateKey, "DHPrivateKey");
        if (byArray == null || byArray.length != 4) {
            return false;
        }
        try {
            this.a(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length, -1, true, byArray[2], 0, byArray[2].length);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return false;
        }
        return true;
    }

    private void m() {
        if (this.f == null) {
            return;
        }
        int n2 = this.f.getBitLength();
        this.a = (n2 + 7) / 8;
    }

    public byte[][] g() {
        if (this.f == null || this.g == null) {
            return new byte[0][];
        }
        int n2 = 4;
        if (this.h <= 0xFFFFFF) {
            --n2;
            if (this.h <= 65535) {
                --n2;
                if (this.h <= 255) {
                    --n2;
                }
            }
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = this.f.toOctetString();
            byArray2 = this.g.toOctetString();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            byArray = null;
            byArray2 = null;
        }
        byte[] byArray3 = new byte[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        while (n3 >= 0) {
            byArray3[n3] = (byte)(this.h >>> n4 & 0xFF);
            --n3;
            n4 += 8;
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    public void a(byte[] byArray, int n2, int n3) {
        try {
            this.k = (JCMPInteger)this.b.newInstance();
            this.k.setValue(byArray, n2, n3);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.k = null;
        }
        catch (InstantiationException instantiationException) {
            this.k = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.k = null;
        }
    }

    public void b(JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_InvalidKeyException {
        byte[][] byArray = JA_KeyData.a(jSAFE_PublicKey, "DHPublicValue");
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid DH public key.");
        }
        this.a(byArray[0], 0, byArray[0].length);
    }

    public void b(byte[] byArray, int n2, int n3) {
        if (this.j != null) {
            this.j.clearSensitiveData();
        }
        try {
            this.j = (JCMPInteger)this.b.newInstance();
            this.j.setValue(byArray, n2, n3);
            this.j.obfuscate();
        }
        catch (InstantiationException instantiationException) {
            this.j = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.j = null;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.j = null;
        }
    }

    public void b(JSAFE_PrivateKey jSAFE_PrivateKey) throws JSAFE_InvalidKeyException {
        byte[][] byArray = JA_KeyData.a(jSAFE_PrivateKey, "DHPrivateValue");
        if (byArray == null || byArray.length != 1) {
            throw new JSAFE_InvalidKeyException("Invalid DH private key.");
        }
        this.b(byArray[0], 0, byArray[0].length);
        this.overwrite(byArray[0]);
    }

    public void h() {
        int n2 = this.h;
        if (n2 < 160) {
            n2 = this.f.getBitLength() - 1;
        }
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        this.c.nextBytes(byArray);
        int n4 = n3 * 8 - n2;
        int n5 = -1;
        for (int i2 = 0; i2 < n4; ++i2) {
            n5 = (byte)((n5 & 0xFF) >>> 1);
            byArray[0] = (byte)(byArray[0] & n5);
        }
        this.b(byArray, 0, byArray.length);
        this.overwrite(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int b(byte[] byArray, int n2) {
        if (this.j == null) {
            return 0;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this.j.toOctetString();
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            int n3 = byArray2.length;
            return n3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            int n4 = 0;
            return n4;
        }
        finally {
            if (byArray2 != null) {
                this.overwrite(byArray2);
            }
        }
    }

    public void i() {
        try {
            this.i = (JCMPInteger)this.b.newInstance();
            this.g.modExp(this.j, this.f, this.i);
        }
        catch (InstantiationException instantiationException) {
            this.j = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.j = null;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            this.i = null;
        }
    }

    public int c(byte[] byArray, int n2) {
        if (this.i == null) {
            return 0;
        }
        int n3 = this.f.getBitLength();
        n3 = (n3 + 7) / 8;
        try {
            byte[] byArray2 = this.i.toFixedLenOctetString(n3);
            int n4 = 0;
            while (n4 < byArray2.length) {
                byArray[n2] = byArray2[n4];
                ++n4;
                ++n2;
            }
            return byArray2.length;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int d(byte[] byArray, int n2) {
        JCMPInteger jCMPInteger = null;
        byte[] byArray2 = null;
        try {
            try {
                jCMPInteger = (JCMPInteger)this.b.newInstance();
                this.k.modExp(this.j, this.f, jCMPInteger);
                int n3 = this.f.getBitLength();
                n3 = (n3 + 7) / 8;
                byArray2 = jCMPInteger.toFixedLenOctetString(n3);
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                int n4 = byArray2.length;
                Object var8_13 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger == null) return n4;
                jCMPInteger.clearSensitiveData();
                return n4;
            }
            catch (InstantiationException instantiationException) {
                int n5 = 0;
                Object var8_14 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger == null) return n5;
                jCMPInteger.clearSensitiveData();
                return n5;
            }
            catch (IllegalAccessException illegalAccessException) {
                int n6 = 0;
                Object var8_15 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger == null) return n6;
                jCMPInteger.clearSensitiveData();
                return n6;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                int n7 = 0;
                Object var8_16 = null;
                if (byArray2 != null) {
                    this.overwrite(byArray2);
                }
                if (jCMPInteger == null) return n7;
                jCMPInteger.clearSensitiveData();
                return n7;
            }
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            if (byArray2 != null) {
                this.overwrite(byArray2);
            }
            if (jCMPInteger == null) throw throwable;
            jCMPInteger.clearSensitiveData();
            throw throwable;
        }
    }

    public void j() {
    }

    public void k() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JSAFE_SecureRandom jSAFE_SecureRandom = this.n();
        objectOutputStream.defaultWriteObject();
        this.a(jSAFE_SecureRandom);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        this.o();
    }

    private JSAFE_SecureRandom n() {
        if (this.j != null) {
            this.j.deobfuscate();
        }
        if (this.c == null) {
            return null;
        }
        if (!(this.c instanceof JSAFE_SecureRandom)) {
            return null;
        }
        JSAFE_SecureRandom jSAFE_SecureRandom = (JSAFE_SecureRandom)this.c;
        if (jSAFE_SecureRandom.getDevice().compareTo("Java") != 0) {
            return null;
        }
        this.e = jSAFE_SecureRandom.getAlgorithm();
        this.d = jSAFE_SecureRandom.d();
        JSAFE_SecureRandom jSAFE_SecureRandom2 = (JSAFE_SecureRandom)this.c;
        this.c = null;
        return jSAFE_SecureRandom2;
    }

    private void a(JSAFE_SecureRandom jSAFE_SecureRandom) {
        if (this.j != null) {
            this.j.obfuscate();
        }
        if (this.d == null) {
            return;
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            this.d[i2] = 0;
        }
        this.d = null;
        this.e = null;
        this.c = jSAFE_SecureRandom;
    }

    private void o() {
        if (this.j != null) {
            this.j.obfuscate();
        }
        if (this.d == null) {
            return;
        }
        this.c = JSAFE_SecureRandom.a(this.e, this.d);
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            this.d[i2] = 0;
        }
        this.d = null;
        this.e = null;
    }

    public Object clone() throws CloneNotSupportedException {
        JA_DH jA_DH = new JA_DH();
        jA_DH.b = this.b;
        jA_DH.c = this.c;
        jA_DH.a = this.a;
        if (this.f != null) {
            jA_DH.f = (JCMPInteger)this.f.clone();
        }
        if (this.g != null) {
            jA_DH.g = (JCMPInteger)this.g.clone();
        }
        jA_DH.h = this.h;
        if (this.i != null) {
            jA_DH.i = (JCMPInteger)this.i.clone();
        }
        if (this.j != null) {
            jA_DH.j = (JCMPInteger)this.j.clone();
        }
        if (this.k != null) {
            jA_DH.k = (JCMPInteger)this.k.clone();
        }
        return jA_DH;
    }

    private void p() {
        if (this.f != null) {
            this.f.clearSensitiveData();
        }
        if (this.g != null) {
            this.g.clearSensitiveData();
        }
        this.h = 0;
        this.g = null;
        this.f = null;
    }

    private void q() {
        if (this.i != null) {
            this.i.clearSensitiveData();
        }
        if (this.j != null) {
            this.j.clearSensitiveData();
        }
        if (this.k != null) {
            this.k.clearSensitiveData();
        }
        this.k = null;
        this.j = null;
        this.i = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.p();
        this.q();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

