/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public abstract class ASN1Container {
    public boolean dataPresent;
    public byte[] data;
    public int dataOffset;
    public int dataLen;
    protected int a = -1;
    protected int b;
    protected int c;
    protected int d = -1;
    protected int e;
    protected int f;
    protected int g;
    protected int h = 0;
    protected int i;
    boolean j;
    boolean k;
    protected boolean l = false;
    protected int m;
    static final int n = 65535;
    static final int o = 65536;
    static final int p = 131072;
    static final int q = 262144;
    protected static final int r = 0x100000;
    protected static final int s = 0x200000;
    static final int t = 0x400000;
    protected static final int u = 0x1000000;
    protected static final int v = 0x2000000;
    static final int w = 0x10000000;
    static final int x = 0x20000000;
    protected int y = 0;
    protected boolean z = false;
    protected int aa = 0;

    protected ASN1Container() {
    }

    protected ASN1Container(int n2, int n3) {
        this(n2, true, 0, n3);
    }

    protected ASN1Container(int n2, int n3, int n4) {
        this(n2, true, 0, n3, n4);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4) {
        this(n2, bl2, n3, n4, 0);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4, int n5) {
        if (n2 >= 0) {
            this.h = n2;
        }
        this.dataPresent = bl2;
        this.i = n3;
        this.e = n4;
        this.aa = n5;
        this.f = 0;
        if ((n4 & 0x2000) != 0) {
            this.j = true;
        }
    }

    public void setExtendedTag(int n2) throws ASN_Exception {
        if (this.d != -1) {
            throw new ASN_Exception("Extended tag already set.");
        }
        if (n2 < 0 || n2 > 0x1FFFFFF) {
            throw new ASN_Exception("Invalid extended tag value.");
        }
        if (n2 < 31) {
            this.h |= n2;
            return;
        }
        this.d = n2;
    }

    protected void c() {
        if ((this.m & 0x2000000) != 0) {
            this.m &= 0xFDFFFFFF;
            this.m |= 0x20000;
        }
        if ((this.h & 0x20000) != 0) {
            this.i = 0;
        }
        this.c = this.e >>> 8;
        int n2 = this.h & 0xE00000;
        if (n2 == 0) {
            return;
        }
        n2 >>>= 16;
        if (this.j) {
            n2 |= 0x20;
        }
        if (this.d == -1) {
            n2 |= this.h & 0xFF;
        } else {
            n2 |= 0x1F;
            int n3 = this.d;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                int n6 = (n3 & 0x7F) << n5;
                if (n5 != 0) {
                    n6 |= 128 << n5;
                }
                n4 |= n6;
                if ((n3 >>>= 7) == 0) break;
                n5 += 8;
            }
            n2 <<= n5 + 8;
            n2 |= n4;
        }
        if ((this.h & 0x200000) != 0) {
            this.a = n2;
        } else {
            this.c = n2;
        }
    }

    public boolean isComplete() {
        return (this.m & 0x2000000) != 0;
    }

    public boolean checkTag() {
        return (this.m & 0x100000) != 0;
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws ASN_Exception {
        if (bl2) {
            if ((this.m & 0x2000000) != 0) {
                this.m ^= 0x2000000;
            }
        } else {
            if ((this.h & 0x4000000) == 0) {
                throw new ASN_Exception("This type is not allowed to accept new data.");
            }
            if ((this.m & 0x2000000) != 0) {
                throw new ASN_Exception("The container cannot accept new data, already encoded.");
            }
        }
        if ((this.m & 0x40000) != 0 && byArray != null) {
            throw new ASN_Exception("The container cannot accept new data any more.");
        }
        this.data = byArray;
        this.m |= 0x20000;
        if (byArray == null) {
            if (!bl3 || (this.h & 0x4000000) == 0) {
                throw new ASN_Exception("Cannot add null newData unless dataComplete is true.");
            }
            this.dataOffset = 0;
            this.dataLen = 0;
            this.m ^= 0x20000;
            this.m |= 0x40000;
            return;
        }
        if (byArray == null) {
            throw new ASN_Exception("ASN1Container.addData: encoding should not be null.");
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: offset is out of range.");
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: len is out of range.");
        }
        this.dataOffset = n2;
        this.dataLen = n3;
        this.dataPresent = true;
        if (bl3) {
            this.m |= 0x40000;
        }
    }

    public void noMoreData() throws ASN_Exception {
        this.m |= 0x40000;
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.c();
        this.m |= 0x40000;
        if (!this.dataPresent) {
            return this.a(false, null, 0);
        }
        if (this.k) {
            return this.dataLen;
        }
        this.g = this.dataLen;
        int n3 = ASN1Lengths.getTagLen(this.c) + this.g + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.a == -1) {
            return n3;
        }
        this.b = n3;
        return ASN1Lengths.getTagLen(this.a) + this.b + ASN1Lengths.getLengthLen(n3);
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        this.m = 0x2000000;
        if (!this.dataPresent) {
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if (this.a != -1) {
            n3 += ASN1Lengths.writeTag(byArray, n3, this.a);
            n3 += ASN1Lengths.writeLength(byArray, n3, this.b);
        }
        n3 += ASN1Lengths.writeTag(byArray, n3, this.c);
        n3 += ASN1Lengths.writeLength(byArray, n3, this.g);
        if (this.data != null) {
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.derEncode: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        return n3 - n4;
    }

    protected int a(boolean bl2, byte[] byArray, int n2) throws ASN_Exception {
        if ((this.h & 0x10000) != 0 && this.i == 5) {
            if (bl2) {
                byArray[n2] = 5;
                byArray[n2 + 1] = 0;
            }
            return 2;
        }
        if ((this.h & 0xF0000) != 0) {
            return 0;
        }
        int n3 = 2;
        if (this.a != -1) {
            if (bl2) {
                byArray[n2] = (byte)this.a;
                byArray[n2 + 1] = 2;
            }
            n3 += 2;
            n2 += 2;
        }
        if (bl2) {
            byArray[n2] = (byte)this.c;
            byArray[n2 + 1] = 0;
        }
        return n3;
    }

    void b(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.c();
        this.g = this.dataLen;
        if ((this.h & 0x4000000) != 0 && (this.m & 0x40000) == 0) {
            this.c |= 0x20;
            this.g = -1;
        } else {
            this.m |= 0x40000;
        }
        this.m |= 0x10000;
    }

    int b(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        if (this.m == 0) {
            throw new ASN_Exception("Cannot continue BER encoding without new data.");
        }
        if ((this.m & 0x2000000) != 0) {
            return 0;
        }
        if (!this.dataPresent) {
            this.m = 0x2000000;
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if ((this.m & 0x10000) != 0) {
            n3 += this.a(byArray, n3);
        }
        if ((this.m & 0x20000) != 0) {
            n3 += this.c(aSN1ContainerArray, n2, byArray, n3);
        }
        if ((this.m & 0x40000) != 0) {
            n3 += this.b(byArray, n3);
        }
        return n3 - n4;
    }

    protected int a(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.a != -1) {
            n2 += ASN1Lengths.writeTag(byArray, n2, this.a);
            byArray[n2++] = -128;
        }
        n2 += ASN1Lengths.writeTag(byArray, n2, this.c);
        if (this.g == -1) {
            byArray[n2++] = -128;
        } else {
            n2 += ASN1Lengths.writeLength(byArray, n2, this.g);
        }
        this.m ^= 0x10000;
        return n2 - n3;
    }

    protected int c(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4 = n3;
        if (this.data != null && this.dataLen != 0) {
            if (this.g == -1) {
                if (this.e == 7680 || this.e == 5632 || this.e == 4608 || this.e == 4864 || this.e == 5120 || this.e == 7168) {
                    this.f = this.e;
                    this.e = 1024;
                }
                byArray[n3++] = (byte)(this.e >>> 8);
                n3 += ASN1Lengths.writeLength(byArray, n3, this.dataLen);
            }
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.writeDataBER: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        this.m ^= 0x20000;
        return n3 - n4;
    }

    protected int b(byte[] byArray, int n2) {
        this.m = 0x2000000;
        int n3 = n2;
        if (this.g == -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.a != -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.f != 0) {
            this.e = this.f;
            this.c = this.e >>> 8;
        }
        return n2 - n3;
    }

    void d() {
        this.a();
        this.c();
        this.m = 0x100000;
        if (this.a != -1) {
            this.m |= 0x200000;
        }
        this.dataPresent = true;
    }

    void a() {
        this.b = 0;
        this.g = 0;
        this.clearSensitiveData();
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5;
        block3: {
            this.clearSensitiveData();
            n5 = n3;
            this.y = n4 - n3;
            if ((this.m & 0x100000) != 0) {
                int n6 = this.b(aSN1Template, n2, byArray, n3, this.y);
                if ((this.m & 0x1000000) != 0 || (this.m & 0x2000000) != 0) {
                    return n6;
                }
                this.m |= 0x400000;
                n3 += n6;
                this.y -= n6;
            }
            if (this.y < 1 && this.g != 0) break block3;
            do {
                n3 += this.a(aSN1Template, n2, byArray, n3);
            } while ((this.m & 0x1000000) == 0 && (this.m & 0x2000000) == 0 && this.y >= 1);
        }
        return n3 - n5;
    }

    protected int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4;
        int n5 = n3;
        if (this.g > 0) {
            n4 = this.g;
            if (this.y < this.g) {
                n4 = this.y;
            }
            if (this.z) {
                this.a(byArray, n3, n4);
            } else {
                if (this.aa != 0 && this.aa >= n4) {
                    this.data = new byte[this.aa];
                    System.arraycopy(byArray, n3, this.data, 0, n4);
                    this.dataOffset = 0;
                } else {
                    this.data = byArray;
                    this.dataOffset = n3;
                }
                this.dataLen = n4;
            }
            this.g -= n4;
            n3 += n4;
            if (this.g > 0) {
                this.m |= 0x1000000;
                return n3 - n5;
            }
            this.y -= n4;
        }
        n4 = this.a(aSN1Template, byArray, n3, this.y);
        n3 += n4;
        this.y -= n4;
        if ((this.m & 0x1000000) != 0 || (this.m & 0x2000000) != 0) {
            return n3 - n5;
        }
        this.m |= 0x100000;
        n4 = this.b(aSN1Template, n2, byArray, n3, this.y);
        n3 += n4;
        if ((this.m & 0x1000000) != 0) {
            return n3 - n5;
        }
        this.y -= n4;
        if (this.y < 1) {
            this.m |= 0x1000000;
        }
        this.z = true;
        return n3 - n5;
    }

    protected int a(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = this.m & 0xFFFF;
        if (n4 == 0) {
            this.m = 0x2000000;
            return 0;
        }
        if (n3 < 1) {
            return 0;
        }
        int n5 = n2;
        int n6 = this.b(aSN1Template, byArray, n2, n3);
        n2 += n6;
        if ((this.m & 0x1000000) != 0) {
            return n2 - n5;
        }
        n3 -= n6;
        if (aSN1Template.c[0] == 0) {
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Improper ending to indefinite length.");
            }
            this.m -= 2;
            aSN1Template.e = 0;
            if ((n4 -= 2) == 0) {
                this.m = 0x2000000;
                if (this.f != 0) {
                    this.e = this.f;
                    this.c = this.e >>> 8;
                }
                return n2 - n5;
            }
            n2 += this.a(aSN1Template, byArray, n2, n3);
            return n2 - n5;
        }
        if (this.b == -1 && n4 == 2) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        return n2 - n5;
    }

    protected void a(byte[] byArray, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        if (this.data == null && this.aa != 0) {
            this.data = new byte[this.aa];
        }
        if (this.data != null && this.data.length > this.dataLen + n3) {
            System.arraycopy(byArray, n2, this.data, this.dataLen, n3);
            this.dataLen += n3;
            return;
        }
        byte[] byArray2 = new byte[this.dataLen + n3];
        if (this.data != null) {
            System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
        }
        System.arraycopy(byArray, n2, byArray2, this.dataLen, n3);
        if (this.l) {
            this.clearSensitiveData();
        }
        this.data = byArray2;
        this.dataOffset = 0;
        this.dataLen = byArray2.length;
        this.l = true;
    }

    protected int b(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5 = n3;
        int n6 = this.b(aSN1Template, byArray, n3, n4);
        if ((this.m & 0x1000000) != 0) {
            return n6;
        }
        n3 += n6;
        n4 -= n6;
        if ((this.m & 0x200000) != 0) {
            if (!this.a(aSN1Template, this.a)) {
                this.b(aSN1Template, n2);
                return n3 - n5;
            }
            this.m ^= 0x200000;
            this.b = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.b == -1) {
                this.m += 2;
            }
            aSN1Template.e = 0;
            n6 = this.b(aSN1Template, byArray, n3, n4);
            n3 += n6;
            n4 -= n6;
            if ((this.m & 0x1000000) != 0) {
                return n3 - n5;
            }
        }
        if (this.a(aSN1Template, this.c)) {
            this.g = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.g == -1) {
                if ((aSN1Template.c[0] & 0x20) == 0) {
                    throw new ASN_Exception("Invalid indefinite length octet.");
                }
                this.m += 2;
            }
            this.m ^= 0x100000;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        int n7 = 32;
        n7 <<= (aSN1Template.d - 1) * 8;
        if ((this.h & 0x4000000) != 0 && this.a(aSN1Template, n7 |= this.c)) {
            this.g = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.g != -1) {
                throw new ASN_Exception("Primitive promoted to constructed must be indefinite length.");
            }
            this.m ^= 0x100000;
            this.m += 2;
            if (this.e == 7680 || this.e == 5632 || this.e == 4608 || this.e == 4864 || this.e == 5120 || this.e == 7168) {
                this.f = this.e;
                this.e = 1024;
            }
            this.c = this.e >>> 8;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        if (this.a != -1) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        if ((this.h & 0x4000000) != 0 && n4 > 1 && byArray[n5] == 0 && byArray[n5 + 1] == 0) {
            this.m = 0x2000000;
            if (this.f != 0) {
                this.e = this.f;
                this.c = this.e >>> 8;
            }
            n3 = n5 + 2;
            return n3 - n5;
        }
        this.b(aSN1Template, n2);
        return n3 - n5;
    }

    protected int b(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        this.m |= 0x1000000;
        int n4 = n2;
        int n5 = this.a(aSN1Template);
        while (n5 > 0 && n3 >= 1) {
            aSN1Template.c[aSN1Template.e] = byArray[n2];
            --n3;
            ++aSN1Template.e;
            ++n2;
            if (--n5 >= 1) continue;
            n5 = this.a(aSN1Template);
        }
        if (n5 < 1) {
            this.m ^= 0x1000000;
        }
        return n2 - n4;
    }

    protected int a(ASN1Template aSN1Template) throws ASN_Exception {
        int n2;
        if (aSN1Template.e == 0) {
            return 1;
        }
        aSN1Template.d = 1;
        if ((aSN1Template.c[0] & 0x1F) == 31) {
            for (n2 = 1; n2 < aSN1Template.e && (aSN1Template.c[n2] & 0x80) != 0; ++n2) {
            }
            if (n2 >= aSN1Template.e) {
                return 1;
            }
            aSN1Template.d = ++n2;
        }
        if (n2 >= aSN1Template.e) {
            return 1;
        }
        int n3 = n2;
        return (n3 += ASN1Lengths.determineLengthLen(aSN1Template.c, n2)) - aSN1Template.e;
    }

    protected boolean a(ASN1Template aSN1Template, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < aSN1Template.d; ++i2) {
            n3 = n3 << 8 | aSN1Template.c[i2] & 0xFF;
        }
        return n3 == n2;
    }

    protected void b(ASN1Template aSN1Template, int n2) throws ASN_Exception {
        if ((this.m & 0x400000) != 0) {
            throw new ASN_Exception("Invalid encoding: expected tag or data not there.");
        }
        if ((this.h & 0x10000) != 0 && aSN1Template.e > 0 && aSN1Template.c[0] == 5) {
            this.dataPresent = false;
            this.i = 5;
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Length after NULL not zero.");
            }
            this.m |= 0x2000000;
            aSN1Template.e = 0;
            return;
        }
        if ((this.h & 0xF0000) == 0) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.dataPresent = false;
        this.m |= 0x2000000;
    }

    boolean a(int n2, ASN1Container[] aSN1ContainerArray, int n3) throws ASN_Exception {
        if ((this.m & 0x2000000) != 0) {
            return false;
        }
        if (n2 == 5 && (this.h & 0x10000) != 0) {
            return true;
        }
        if (this.a != -1) {
            return n2 == this.a;
        }
        if (n2 == this.c) {
            return true;
        }
        return (this.h & 0x4000000) != 0 && n2 == (this.c | 0x20);
    }

    protected boolean a(ASN1Container aSN1Container) {
        return false;
    }

    protected ASN1Container b() {
        return null;
    }

    public void clearSensitiveData() {
        if (this.data != null && this.l) {
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                this.data[i2] = 0;
            }
        }
        this.data = null;
        this.dataOffset = 0;
        this.dataLen = 0;
        this.l = false;
    }
}

