/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.DescriptorValidator;
import com.adobe.air.validator.PlatformExtensionDescriptorValidator;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IosExtensionDescriptorValidator31
extends PlatformExtensionDescriptorValidator {
    private static final Pattern versionPattern = Pattern.compile("\\d+(\\.\\d+(\\.\\d+)?)?");
    private final DescriptorValidator.ElementInfo ROOT_ELEMENT_INFO;
    private String _sdkVersion;
    private String _copyright;
    private ArrayList<String> _linkerOptions = new ArrayList();

    public IosExtensionDescriptorValidator31() {
        this.ROOT_ELEMENT_INFO = this.createElementInfoTree();
    }

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = new DescriptorValidator.ElementInfo("platform", 1, 1);
        root.addChild(new DescriptorValidator.ElementInfo("description", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("copyright", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("linkerOptions", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("sdkVersion", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("linkerOptions");
        temp.addChild(new DescriptorValidator.ElementInfo("option", 0, -1));
        return root;
    }

    @Override
    protected DescriptorValidator.ElementInfo getRootElementInfo() {
        return this.ROOT_ELEMENT_INFO;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        if (elementPath.equals("platform.linkerOptions.option")) {
            return this._linkerOptions.add(value);
        }
        if (elementPath.equals("platform.copyright")) {
            this._copyright = value;
        }
        if (elementPath.equals("platform.sdkVersion")) {
            if (versionPattern.matcher(value).matches()) {
                this._sdkVersion = value;
            } else {
                this.dispatchError(105, new String[]{elementPath});
            }
        }
        return true;
    }

    @Override
    protected boolean validateAttribute(String attributePath, String value) throws SAXException {
        return false;
    }

    public String copyright() {
        return this._copyright;
    }

    @Override
    protected void finalizeValidation() throws SAXException {
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/extension/3.1";
    }

    public String sdkVersion() {
        return this._sdkVersion;
    }

    public ArrayList<String> linkerOptions() {
        return this._linkerOptions;
    }
}

