/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.apk.RClassCreator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.generic.ConstantPoolGen;

public class ResourceBytecodeGenerator {
    public static File generateFromRFile(File theRFile, File outputDirectory) throws IOException {
        File resourceJarFile = null;
        try {
            FileReader f2 = new FileReader(theRFile);
            Scanner scanner = new Scanner(f2);
            Pattern rscClassPattern = Pattern.compile("^\\s*public\\s*static\\s*final\\s*class\\s*(\\S*)");
            Pattern rscIdPattern = Pattern.compile("^\\s*public\\s*static\\s*final\\s*int\\s*(\\S*?)=0x(\\S*?);");
            Pattern packagePattern = Pattern.compile("^\\s*package\\s*(\\S*?);");
            String packageName = null;
            RClassCreator classCreator = null;
            RClassCreator outerClassCreator = null;
            LinkedList<RClassCreator> classCreators = new LinkedList<RClassCreator>();
            ConstantPoolGen constantPool = new ConstantPoolGen();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Matcher packageMatcher = packagePattern.matcher(line);
                Matcher rscClassMatcher = rscClassPattern.matcher(line);
                Matcher rscIdMatcher = rscIdPattern.matcher(line);
                if (packageMatcher.find()) {
                    packageName = packageMatcher.group(1);
                    outerClassCreator = classCreator = new RClassCreator(packageName, "R", constantPool);
                    classCreators.add(classCreator);
                    continue;
                }
                if (rscClassMatcher.find()) {
                    String currentResourceType = rscClassMatcher.group(1);
                    String innerClassName = String.format("R$%s", currentResourceType);
                    classCreator = new RClassCreator(packageName, innerClassName, constantPool, outerClassCreator);
                    classCreators.add(classCreator);
                    continue;
                }
                if (!rscIdMatcher.find()) continue;
                String resourceName = rscIdMatcher.group(1);
                String resourceIdInHex = rscIdMatcher.group(2);
                int resourceId = Integer.parseInt(resourceIdInHex, 16);
                classCreator.appendResourceId(resourceName, resourceId);
            }
            if (classCreators.size() > 0) {
                resourceJarFile = new File(outputDirectory, "resources.jar");
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                JarOutputStream targetJar = new JarOutputStream(new FileOutputStream(resourceJarFile));
                for (RClassCreator item : classCreators) {
                    String classFilePath = item.getClassFilePath().replace("\\", "/");
                    JarEntry entry = new JarEntry(classFilePath);
                    entry.setTime(new Date().getTime());
                    targetJar.putNextEntry(entry);
                    item.create(targetJar);
                    targetJar.closeEntry();
                }
                targetJar.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return resourceJarFile;
    }
}

