/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppManifestHandler
extends DefaultHandler {
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String BROADCAST_STICKY_PERMISSION = "android.permission.BROADCAST_STICKY";
    private FileOutputStream m_outputFileStream;
    private PrintStream m_printStream;
    private String m_NamespacePrefix;
    private String m_NamespaceUri;
    private File m_outputFile;
    private String m_packageName;
    private String m_applicationVersionCode;
    private boolean m_hasCaptiveRuntime;
    private boolean m_sawInternetPermission = false;
    private boolean m_sawBroadcastStickyPermission = false;

    public static String createAppSpecificManifestXml(String inputFile, String packageName, int applicationVersionCode, Listener listener, String descriptorFileName, boolean hasCaptiveRuntime) {
        String outputFilePath = inputFile + "AppSpecific";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            AppManifestHandler outputHandler = new AppManifestHandler(new File(outputFilePath), packageName, applicationVersionCode, hasCaptiveRuntime);
            parser.parse(new File(inputFile), (DefaultHandler)outputHandler);
            return outputFilePath;
        }
        catch (Exception ex) {
            listener.message(new Message(100, "ERROR", descriptorFileName, -1, -1, null));
            return null;
        }
    }

    private String getPermissionString(String permission) {
        return "<uses-permission android:name=\"" + permission + "\" />";
    }

    public AppManifestHandler(File outputFile, String packageName, int applicationVersionCode, boolean hasCaptiveRuntime) {
        this.m_outputFile = outputFile;
        this.m_packageName = packageName;
        this.m_applicationVersionCode = String.valueOf(applicationVersionCode);
        this.m_hasCaptiveRuntime = hasCaptiveRuntime;
    }

    public void startDocument() throws SAXException {
        try {
            this.m_outputFileStream = new FileOutputStream(this.m_outputFile);
            this.m_printStream = new PrintStream(this.m_outputFileStream);
            this.m_printStream.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_NamespacePrefix = prefix;
        this.m_NamespaceUri = uri;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attrs) throws SAXException {
        this.m_printStream.print("<" + rawName + " ");
        if (rawName.equals("manifest")) {
            this.m_printStream.println("xmlns:" + this.m_NamespacePrefix + "=\"" + this.m_NamespaceUri + "\"");
        }
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            String name = attrs.getLocalName(i2);
            String value = attrs.getValue(i2);
            if (!attrs.getURI(i2).equals("")) {
                this.m_printStream.print("android:");
            }
            if (rawName.equals("uses-permission") && name.equals("name")) {
                if (value.equals(INTERNET_PERMISSION)) {
                    this.m_sawInternetPermission = true;
                }
                if (value.equals(BROADCAST_STICKY_PERMISSION)) {
                    this.m_sawBroadcastStickyPermission = true;
                }
            }
            this.m_printStream.print(name + "=\"");
            if (name.equals("package")) {
                this.m_printStream.print(this.m_packageName);
            } else if (name.equals("versionCode")) {
                this.m_printStream.print(this.m_applicationVersionCode);
            } else {
                this.m_printStream.print(value);
            }
            this.m_printStream.println("\"");
        }
        this.m_printStream.println(">");
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (rawName.equals("manifest") && this.m_hasCaptiveRuntime) {
            if (!this.m_sawInternetPermission) {
                this.m_printStream.println(this.getPermissionString(INTERNET_PERMISSION));
            }
            if (!this.m_sawBroadcastStickyPermission) {
                this.m_printStream.println(this.getPermissionString(BROADCAST_STICKY_PERMISSION));
            }
        }
        this.m_printStream.println("</" + rawName + ">");
    }

    public void endDocument() throws SAXException {
        this.m_printStream.close();
        try {
            this.m_outputFileStream.close();
        }
        catch (Exception e2) {
            throw new SAXException(e2.getMessage());
        }
    }
}

