/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import adobe.abc.APIVersions;
import com.adobe.air.Descriptor;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.air.validator.ExtensionDescriptorValidator;
import com.adobe.air.validator.ExtensionDescriptorValidator25;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescriptor
extends Descriptor {
    public static final String NAMESPACE_2_5 = "http://ns.adobe.com/air/extension/2.5";
    public static final String NAMESPACE_3_1 = "http://ns.adobe.com/air/extension/3.1";
    private static final String[] NAMESPACES = new String[]{"http://ns.adobe.com/air/extension/2.5", "http://ns.adobe.com/air/extension/3.1"};
    private static final Map<String, String> NAMESPACE_CLASSNAMES;
    private static final Map<String, Integer> NAMESPACE_APIVERSIONS;

    public ExtensionDescriptor(File descriptorFile) throws DescriptorValidationException {
        super(descriptorFile, true);
    }

    public ExtensionDescriptor(File descriptorFile, boolean validate) throws DescriptorValidationException {
        super(descriptorFile, validate);
    }

    public ExtensionDescriptor(InputStream in, boolean validate, String name) throws DescriptorValidationException {
        super(in, validate, name);
    }

    public String id() {
        return ((ExtensionDescriptorValidator25)this._validator).id();
    }

    public boolean supportsPlatform(String platform) {
        return this.platforms().containsKey(platform);
    }

    public String getNativeLibrary(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).nativeLibrary : null;
    }

    public String getInitializer(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).initializer : null;
    }

    public String getFinalizer(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).finalizer : null;
    }

    public String versionNumber() {
        return ((ExtensionDescriptorValidator25)this._validator).versionNumber();
    }

    public String copyright() {
        return ((ExtensionDescriptorValidator25)this._validator).copyright();
    }

    public int maxSWFVersion() {
        return ((ExtensionDescriptorValidator)this._validator).getMaximumSWFVersion();
    }

    public int getAPIVersionForExtensionNS() {
        Integer uriVersion = NAMESPACE_APIVERSIONS.get(this.getNamespaceURI());
        if (uriVersion == null) {
            throw new IllegalArgumentException("Invalid namespaceURI");
        }
        return uriVersion;
    }

    public String getNamespaceURI() {
        return this._document.getDocumentElement().getNamespaceURI();
    }

    public int namespaceCompare(String compareTo) {
        int appDescInx = Arrays.binarySearch(NAMESPACES, this._document.getDocumentElement().getNamespaceURI());
        int compareInx = Arrays.binarySearch(NAMESPACES, compareTo);
        return appDescInx - compareInx;
    }

    @Override
    protected String getValidatorClassNameFromNamespaceUri(String namespaceUri) {
        return NAMESPACE_CLASSNAMES.get(namespaceUri);
    }

    public Map<String, Platform> platforms() {
        return ((ExtensionDescriptorValidator25)this._validator).platforms();
    }

    public Map<String, Platform> applicationDeployedPlatforms() {
        return ((ExtensionDescriptorValidator25)this._validator).applicationDeployedPlatforms();
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(NAMESPACE_2_5, "com.adobe.air.validator.ExtensionDescriptorValidator25");
        tempMap.put(NAMESPACE_3_1, "com.adobe.air.validator.ExtensionDescriptorValidator31");
        NAMESPACE_CLASSNAMES = Collections.unmodifiableMap(tempMap);
        HashMap<String, Integer> versionsTempMap = new HashMap<String, Integer>();
        versionsTempMap.put(NAMESPACE_2_5, APIVersions.kApiVersion_AIR_2_5);
        versionsTempMap.put(NAMESPACE_3_1, APIVersions.kApiVersion_AIR_3_1);
        NAMESPACE_APIVERSIONS = Collections.unmodifiableMap(versionsTempMap);
    }

    public static class Platform {
        public String name = "";
        public String deploymentModel;
        public String nativeLibrary;
        public String initializer;
        public String finalizer;
    }
}

