/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.BuiltinDomain;
import adobe.abc.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

class TamarinSlotLayout {
    protected final Type m_type;
    protected final TamarinSlotLayout m_base;
    private final SlotStorageTypeAndLocalStructIndex[] m_slotIdToSSTAndLocalStructIndex;
    private final int m_nNonPointer4ByteSlots;
    private final int m_nNonPointer8ByteSlots;

    public TamarinSlotLayout(TamarinSlotLayout baseSlotLayout, Type t2) {
        int nBaseSlotCount;
        this.m_type = t2;
        this.m_base = baseSlotLayout;
        if (t2.slotCount == 0) {
            this.m_slotIdToSSTAndLocalStructIndex = null;
            this.m_nNonPointer4ByteSlots = 0;
            this.m_nNonPointer8ByteSlots = 0;
            return;
        }
        assert (this.m_base != null ? this.m_base.m_type == t2.base : t2.base == null);
        int n2 = nBaseSlotCount = t2.base != null ? t2.base.slotCount : 0;
        assert (nBaseSlotCount >= 0);
        assert (t2.slotCount >= nBaseSlotCount);
        this.m_slotIdToSSTAndLocalStructIndex = new SlotStorageTypeAndLocalStructIndex[t2.slotCount - nBaseSlotCount];
        final HashMap<SlotStorageTypeAndBinding, Integer> slotToABCIndex = new HashMap<SlotStorageTypeAndBinding, Integer>();
        Binding[] slotIdToSlot = new Binding[t2.slotCount - nBaseSlotCount];
        int slotABCIndex = 0;
        for (Binding b3 : t2.defs.values()) {
            if (!b3.isSlot()) continue;
            slotToABCIndex.put(new SlotStorageTypeAndBinding(b3), slotABCIndex);
            ++slotABCIndex;
            assert (b3.slot > nBaseSlotCount);
            assert (slotIdToSlot.length >= b3.slot - nBaseSlotCount);
            slotIdToSlot[b3.slot - 1 - nBaseSlotCount] = b3;
        }
        int slotId = nBaseSlotCount + 1;
        for (Binding b4 : slotIdToSlot) {
            if (b4 == null) {
                slotToABCIndex.put(SlotStorageTypeAndBinding.anonSlot(slotId), slotABCIndex);
                ++slotABCIndex;
            }
            ++slotId;
        }
        Comparator<SlotStorageTypeAndBinding> slotComparator = new Comparator<SlotStorageTypeAndBinding>(){

            @Override
            public int compare(SlotStorageTypeAndBinding a, SlotStorageTypeAndBinding b3) {
                int result = a.compareTo(b3);
                if (result != 0) {
                    return result;
                }
                return (Integer)slotToABCIndex.get(a) - (Integer)slotToABCIndex.get(b3);
            }
        };
        SlotStorageTypeAndBinding[] sortedBindings = new SlotStorageTypeAndBinding[]{};
        sortedBindings = slotToABCIndex.keySet().toArray(sortedBindings);
        Arrays.sort(sortedBindings, slotComparator);
        int localStructIndex = 0;
        int nNonPointer4ByteSlots = 0;
        int nNonPointer8ByteSlots = 0;
        int nPointerSlots = 0;
        for (SlotStorageTypeAndBinding sstAndB : sortedBindings) {
            assert (sstAndB.slotId() > nBaseSlotCount);
            assert (sstAndB.slotId() <= this.m_type.slotCount);
            assert (slotIdToSlot.length >= sstAndB.slotId() - nBaseSlotCount);
            if (sstAndB.sst().isNonPointer4ByteSlot()) {
                ++nNonPointer4ByteSlots;
            } else if (sstAndB.sst().isNonPointer8ByteSlot()) {
                ++nNonPointer8ByteSlots;
            } else {
                assert (sstAndB.sst().isPointerSlot());
                ++nPointerSlots;
            }
            this.m_slotIdToSSTAndLocalStructIndex[sstAndB.slotId() - 1 - nBaseSlotCount] = new SlotStorageTypeAndLocalStructIndex(sstAndB.sst(), localStructIndex);
            ++localStructIndex;
        }
        assert (nNonPointer4ByteSlots + nNonPointer8ByteSlots + nPointerSlots == t2.slotCount - nBaseSlotCount);
        this.m_nNonPointer4ByteSlots = nNonPointer4ByteSlots;
        this.m_nNonPointer8ByteSlots = nNonPointer8ByteSlots;
    }

    private static SlotStorageType sst(Binding b3) {
        assert (b3.isSlot());
        return TamarinSlotLayout.sst(b3.type.getType());
    }

    private static SlotStorageType sst(Type t2) {
        BuiltinDomain bd2 = BuiltinDomain.instance();
        assert (bd2.NULL() != t2);
        assert (bd2.VOID() != t2);
        if (t2.isAtom()) {
            return SlotStorageType.Atom;
        }
        assert (bd2.ANY() != t2);
        assert (bd2.OBJECT() != t2);
        if (bd2.BOOLEAN() == t2) {
            return SlotStorageType.Boolean;
        }
        if (bd2.INT() == t2) {
            return SlotStorageType.Int;
        }
        if (bd2.UINT() == t2) {
            return SlotStorageType.UInt;
        }
        if (bd2.NUMBER() == t2) {
            return SlotStorageType.Number;
        }
        if (bd2.STRING() == t2) {
            return SlotStorageType.String;
        }
        if (bd2.NAMESPACE() == t2) {
            return SlotStorageType.Namespace;
        }
        return SlotStorageType.ScriptObjectPointer;
    }

    protected SlotStorageTypeAndLocalStructIndex sstAndLocalStructIndex(int slotId) {
        assert (slotId <= this.m_type.slotCount);
        int nBaseSlots = this.m_type.base != null ? this.m_type.base.slotCount : 0;
        return this.m_slotIdToSSTAndLocalStructIndex[slotId - 1 - nBaseSlots];
    }

    protected int nNonPointer4ByteSlots() {
        return this.m_nNonPointer4ByteSlots;
    }

    protected int nNonPointer8ByteSlots() {
        return this.m_nNonPointer8ByteSlots;
    }

    protected SlotStorageTypeAndLocalStructIndex[] slotsSortedByStructIndex() {
        if (this.m_slotIdToSSTAndLocalStructIndex == null) {
            return null;
        }
        SlotStorageTypeAndLocalStructIndex[] result = new SlotStorageTypeAndLocalStructIndex[this.m_slotIdToSSTAndLocalStructIndex.length];
        System.arraycopy(this.m_slotIdToSSTAndLocalStructIndex, 0, result, 0, this.m_slotIdToSSTAndLocalStructIndex.length);
        Comparator<SlotStorageTypeAndLocalStructIndex> slotComparator = new Comparator<SlotStorageTypeAndLocalStructIndex>(){

            @Override
            public int compare(SlotStorageTypeAndLocalStructIndex a, SlotStorageTypeAndLocalStructIndex b3) {
                return a.structIndex - b3.structIndex;
            }
        };
        Arrays.sort(result, slotComparator);
        return result;
    }

    private static final class SlotStorageTypeAndBinding {
        private final SlotStorageType m_sst;
        private final int m_slotId;
        private final Binding m_b;

        private SlotStorageTypeAndBinding(SlotStorageType sst, Binding b3, int slotId) {
            this.m_sst = sst;
            this.m_b = b3;
            this.m_slotId = slotId;
        }

        public SlotStorageTypeAndBinding(Binding b3) {
            this(TamarinSlotLayout.sst(b3), b3, b3.slot);
        }

        public static SlotStorageTypeAndBinding anonSlot(int slotId) {
            return new SlotStorageTypeAndBinding(SlotStorageType.Atom, null, slotId);
        }

        public SlotStorageType sst() {
            return this.m_sst;
        }

        public int slotId() {
            return this.m_slotId;
        }

        public int compareTo(SlotStorageTypeAndBinding o2) {
            int result = this.m_sst.compareTo(o2.m_sst);
            if (result != 0) {
                return result;
            }
            if (this.m_b == o2.m_b) {
                return 0;
            }
            if (this.m_b == null) {
                assert (o2.m_b != null);
                return 1;
            }
            if (o2.m_b == null) {
                assert (this.m_b != null);
                return -1;
            }
            return 0;
        }
    }

    protected static final class SlotStorageTypeAndLocalStructIndex {
        public final SlotStorageType sst;
        public final int structIndex;

        public SlotStorageTypeAndLocalStructIndex(SlotStorageType sst, int structIndex) {
            this.sst = sst;
            this.structIndex = structIndex;
        }
    }

    public static final class SlotStorageType {
        public static SlotStorageType Number = new SlotStorageType("Number");
        public static SlotStorageType Int = new SlotStorageType("Int");
        public static SlotStorageType UInt = new SlotStorageType("UInt");
        public static SlotStorageType Boolean = new SlotStorageType("Boolean");
        public static SlotStorageType ScriptObjectPointer = new SlotStorageType("ScriptObjectPointer");
        public static SlotStorageType Atom = new SlotStorageType("Atom");
        public static SlotStorageType Namespace = new SlotStorageType("Namespace");
        public static SlotStorageType String = new SlotStorageType("String");
        private final String m_s;

        private SlotStorageType(String s2) {
            this.m_s = s2;
        }

        public int compareTo(SlotStorageType other) {
            return this.sortIndex() - other.sortIndex();
        }

        private int sortIndex() {
            if (this == Number) {
                return 2;
            }
            if (this == Int || this == UInt || this == Boolean) {
                return 0;
            }
            assert (this == ScriptObjectPointer || this == Atom || this == Namespace || this == String);
            assert (this.isPointerSlot());
            return 1;
        }

        public boolean isNonPointer4ByteSlot() {
            return this == Int || this == UInt || this == Boolean;
        }

        public boolean isNonPointer8ByteSlot() {
            return this == Number;
        }

        public boolean isPointerSlot() {
            return !this.isNonPointer4ByteSlot() && !this.isNonPointer8ByteSlot();
        }

        public boolean isAtomSlot() {
            return this == Atom;
        }

        public String toString() {
            return this.m_s;
        }
    }
}

