/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Block;
import adobe.abc.Domain;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Handler;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method
implements Comparable<Method> {
    GlobalOptimizer.InputAbc abc;
    public final int id;
    boolean hasExceptions;
    int emit_id;
    public Edge entry;
    Typeref[] params;
    public Object[] values;
    int optional_count;
    Typeref returns;
    Name name;
    String debugName;
    Name[] paramNames;
    int flags;
    Type cx;
    private int blockId;
    private int exprId;
    int edgeId;
    Kind kind;
    int iid;
    int max_stack;
    int local_count;
    int max_scope;
    int code_len;
    private final int m_serialNumber;
    private static int s_nextSerialNumber = 0;
    Typeref activation;
    public Handler[] handlers = OptimizerConstants.nohandlers;
    Map<Expr, Typeref> verifier_types = null;
    Map<Expr, Integer> fixedLocals = new HashMap<Expr, Integer>();

    Method(int id, GlobalOptimizer.InputAbc abc) {
        this.id = id;
        this.abc = abc;
        this.m_serialNumber = s_nextSerialNumber++;
        this.iid = -1;
    }

    public boolean needsRest() {
        return (this.flags & 4) != 0;
    }

    public boolean needsArguments() {
        return (this.flags & 1) != 0;
    }

    public void setNeedsArguments() {
        this.flags |= 1;
    }

    public boolean hasParamNames() {
        return (this.flags & 0x80) != 0;
    }

    public boolean hasOptional() {
        return (this.flags & 8) != 0;
    }

    public boolean isNative() {
        return (this.flags & 0x20) != 0;
    }

    public boolean setsDxns() {
        return (this.flags & 0x40) != 0;
    }

    public boolean needActivation() {
        return (this.flags & 2) != 0;
    }

    public boolean isGet() {
        return this.kind == Kind.GET;
    }

    public boolean isSet() {
        return this.kind == Kind.SET;
    }

    @Override
    public int compareTo(Method m2) {
        if (this.kind == Kind.GENERATED_INIT && m2.kind == Kind.GENERATED_INIT) {
            return this.m_serialNumber - m2.m_serialNumber;
        }
        if (this.kind == Kind.GENERATED_INIT) {
            return 1;
        }
        if (m2.kind == Kind.GENERATED_INIT) {
            return -1;
        }
        assert (this.id >= 0);
        assert (m2.id >= 0);
        assert (this.abc == m2.abc);
        return this.id - m2.id;
    }

    public String toString() {
        return this.kind + " " + String.valueOf(this.getName());
    }

    public Name getParameterName(int idx) {
        if (this.paramNames != null) {
            return this.paramNames[idx];
        }
        if (0 == idx) {
            return this.abc.domain().createNameWithPublicNamespace("this");
        }
        return this.abc.domain().createNameWithPublicNamespace("arg" + idx);
    }

    public Name getName() {
        return this.name;
    }

    public Typeref[] getParams() {
        return this.params;
    }

    public Typeref getReturnType() {
        return this.returns;
    }

    public Algorithms.Deque<Block> depthFirstCfg() {
        return Algorithms.dfs(this.entry.to);
    }

    public int getNextBlockId() {
        return this.blockId++;
    }

    public int getNextExprId() {
        return this.exprId++;
    }

    public List<Name> getAllNames() {
        return Arrays.asList(this.abc.names);
    }

    public final Domain domain() {
        return this.abc.domain();
    }

    public static class Kind {
        public static Kind INIT = new Kind("init");
        public static Kind GENERATED_INIT = new Kind("generated init");
        public static Kind FUNCTION = new Kind("function");
        public static Kind GET = new Kind("get");
        public static Kind SET = new Kind("set");
        private final String m_s;

        private Kind(String s2) {
            this.m_s = s2;
        }

        public String toString() {
            return this.m_s;
        }
    }
}

