/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.LLVMEmitter;
import adobe.abc.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import llvm.CompositeType;
import llvm.ConstantArray;
import llvm.ConstantExpr;
import llvm.ConstantStruct;
import llvm.DerivedType;
import llvm.GlobalValue;
import llvm.GlobalVariable;
import llvm.PointerType;
import llvm.SequentialType;
import llvm.StructType;
import llvm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LLVMTypeExtractor
implements Iterable<Pair<String, Pair<PointerType, Type>>> {
    private int m_currType;
    private final int m_nTypes;
    private final StructType m_typesStructTy;
    private final ConstantStruct m_typesStructValue;

    LLVMTypeExtractor(GlobalVariable typesGlobal) {
        this.m_typesStructValue = ConstantStruct.dyn_cast(typesGlobal.getInitializer());
        this.m_typesStructTy = this.m_typesStructValue.getType();
        this.m_nTypes = (int)(this.m_typesStructValue.getNumOperands() / 2L);
        this.m_currType = 0;
    }

    @Override
    public Iterator<Pair<String, Pair<PointerType, Type>>> iterator() {
        return new Iterator<Pair<String, Pair<PointerType, Type>>>(){

            @Override
            public boolean hasNext() {
                return LLVMTypeExtractor.this.m_currType < LLVMTypeExtractor.this.m_nTypes;
            }

            @Override
            public Pair<String, Pair<PointerType, Type>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int memberIndex = LLVMTypeExtractor.this.m_currType * 2;
                ++LLVMTypeExtractor.this.m_currType;
                ConstantExpr typeNameGetElementPtr = ConstantExpr.dyn_cast(LLVMTypeExtractor.this.m_typesStructValue.getOperand(memberIndex));
                GlobalVariable typeNameArrayGlobal = GlobalVariable.dyn_cast(GlobalValue.dyn_cast(typeNameGetElementPtr.getOperand(0L)));
                ConstantArray constMemberNameArray = ConstantArray.dyn_cast(typeNameArrayGlobal.getInitializer());
                String typeName = String.valueOf(constMemberNameArray.getAsString());
                PointerType ptrType = PointerType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(LLVMTypeExtractor.this.m_typesStructTy.getElementType(memberIndex + 1)))));
                if (ptrType == null) {
                    throw new Error(typeName + " is not a PointerType");
                }
                Type pointeeType = ptrType.getElementType();
                return new Pair<String, Pair<PointerType, Type>>(typeName, new Pair<PointerType, Type>(ptrType, pointeeType));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Map<String, Pair<PointerType, Type>> extractToMap(LLVMEmitter.Module m2, String globalName) {
        HashMap<String, Pair<PointerType, Type>> result = new HashMap<String, Pair<PointerType, Type>>();
        GlobalVariable abcTypesGlobal = m2.getGlobal(globalName, true);
        if (abcTypesGlobal == null) {
            return null;
        }
        LLVMTypeExtractor typeExtractor = new LLVMTypeExtractor(abcTypesGlobal);
        for (Pair<String, Pair<PointerType, Type>> pt : typeExtractor) {
            result.put((String)pt.fst, (Pair<PointerType, Type>)pt.snd);
        }
        abcTypesGlobal.eraseFromParent();
        return result;
    }
}

